package gnu.jel;

/**
 * String manipulation library for JEL.
 * <P> This class merely provides static wrappers for methods of
 * <TT>java.lang.String</TT> class. Use this as a static library to get
 * string manipulation functions within JEL compiled expressions.
 * see java.lang.String for descriptions of corresponding methods.
 * @see java.lang.String
 */
public class StringLib {
  public static int length(String arg) 
    { return arg.length(); };

  public static char charAt(String arg, int index) 
    {return arg.charAt(index);};

  public static boolean equals(String arg, Object anObject) 
    {return arg.equals(anObject);}

  public static int compareTo(String arg, String anotherString) 
    {return arg.compareTo(anotherString);};

  public static boolean regionMatches(String one, int toffset, 
				      String other, int ooffset, int len)
    {return one.regionMatches(toffset,other,ooffset,len);};
  
  public static boolean regionMatches(boolean ignorecase, String one,
				      int toffset, String other, 
				      int ooffset, int len)
    {return one.regionMatches(ignorecase,toffset,other,ooffset,len);};
  
  public static boolean startsWith(String arg, String prefix, int toffset)
    {return arg.startsWith(prefix,toffset);};

  public static boolean startsWith(String arg, String prefix)
    {return arg.startsWith(prefix);};
  
  public static boolean endsWith(String arg, String suffix) 
    {return arg.endsWith(suffix);};
  
  public static int indexOf(String arg, int ch)
    {return arg.indexOf(ch);};
  
  public static int indexOf(String arg, int ch, int fromIndex) 
    {return arg.indexOf(ch,fromIndex);};

  public static int lastIndexOf(String arg, int ch)
    {return arg.lastIndexOf(ch);};
  
  public static int lastIndexOf(String arg, int ch, int fromIndex) 
    {return arg.lastIndexOf(ch,fromIndex);};

  public static int indexOf(String arg, String other)
    {return arg.indexOf(other);};
  
  public static int indexOf(String arg, String other, int fromIndex)
    {return arg.indexOf(other,fromIndex);};
  
  public static int lastIndexOf(String arg, String other)
    {return arg.lastIndexOf(other);};
  
  public static int lastIndexOf(String arg, String other, int fromIndex)
    {return arg.lastIndexOf(other,fromIndex);};

  public static String substring(String arg, int beginIndex)
    {return arg.substring(beginIndex);};

  public static String substring(String arg, int beginIndex, int endIndex )
    {return arg.substring(beginIndex,endIndex);};
  
  public static String concat(String arg, String str)
    {return arg.concat(str);};

  public static String replace(String arg, char oldChar, char newChar)
    {return arg.replace(oldChar,newChar);};
  
  public static String toLowerCase(String arg) 
    {return arg.toLowerCase();};

  public static String toUpperCase(String arg) 
    {return arg.toUpperCase();};

  public static String trim(String arg)
    {return arg.trim();};

  public static String intern(String arg)
    {return arg.intern();};
  
  public static String valueOf(Object obj)
    {return String.valueOf(obj);};

  public static String valueOf(boolean b)
    {return String.valueOf(b);};
  
  public static String valueOf(char c)
    {return String.valueOf(c);};

  public static String valueOf(int i)
    {return String.valueOf(i);};

  public static String valueOf(long l)
    {return String.valueOf(l);};
  
  public static String valueOf(float f)
    {return String.valueOf(f);};

  public static String valueOf(double d)
    {return String.valueOf(d);};
  
};


