/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*- 
 * $Id: Method.java,v 1.1 2000/02/11 22:08:18 metlov Exp $
 *
 * This file is part of the Java Expressions Library (JEL).
 *   For more information about JEL visit :
 *    http://galaxy.fzu.cz/JEL/
 *
 * (c) 1998 -- 2000 by Konstantin Metlov(metlov@fzu.cz);
 *
 * JEL is Distributed under the terms of GNU General Public License.
 *    This code comes with ABSOLUTELY NO WARRANTY.
 *  For license details see COPYING file in this directory.
 */

package gnu.jel.reflect;

import gnu.jel.debug.Debug;

/**
 * Represents a method of already compiled class.
 */
public class Method extends LocalMethod {
  Class declClass;
  java.lang.reflect.Method m;
  
  /**
   * Constructs a new Method object.
   * @param m is corresponding <TT>java.lang.reflect.Method</TT> object.
   */   
  public Method(java.lang.reflect.Method m) {
	super(m.getModifiers(),m.getReturnType(),m.getName(),
	      m.getParameterTypes(),m.getExceptionTypes());
    this.m=m;
    this.declClass=m.getDeclaringClass();
  };

  /**
   * Constructs a new Method object for a constructor.
   * @param m is corresponding <TT>java.lang.reflect.Method</TT> object.
   */
  public Method(java.lang.reflect.Constructor c) {
	super(c.getModifiers(),Void.TYPE,"<init>",
	      c.getParameterTypes(),c.getExceptionTypes());
    this.modifiers=(modifiers & 0x0000FFFF) | 0x00030000;
    this.declClass=c.getDeclaringClass();
  };

  public Class getDeclaringClass() {
	return declClass;
  };

  public Object eval(Object obj,Object[] params) throws Exception {
	return m.invoke(obj,params);
  };

};






