/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ClassFile;
import gnu.jel.CompilationException;
import gnu.jel.DVResolver;
import gnu.jel.TypesStack;
import gnu.jel.debug.Debug;
import gnu.jel.debug.Tester;
import gnu.jel.reflect.Field;
import gnu.jel.reflect.LocalField;
import gnu.jel.reflect.Member;
import gnu.jel.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Library {
    private Hashtable names;
    private Hashtable dynIDs;
    private Hashtable stateless;
    private Hashtable dotClasses;
    private boolean noDotSecurity = false;
    public DVResolver resolver;
    public Hashtable cnmap;

    public Library(Class[] classArray, Class[] classArray2) {
        this(classArray, classArray2, null);
    }

    public Library(Class[] classArray, Class[] classArray2, Class[] classArray3) {
        this(classArray, classArray2, classArray3, null);
    }

    public Library(Class[] classArray, Class[] classArray2, Class[] classArray3, DVResolver dVResolver) {
        this(classArray, classArray2, classArray3, dVResolver, null);
    }

    public Library(Class[] classArray, Class[] classArray2, Class[] classArray3, DVResolver dVResolver, Hashtable hashtable) {
        this.cnmap = hashtable;
        this.resolver = dVResolver;
        if (classArray3 == null) {
            this.dotClasses = null;
        } else {
            this.noDotSecurity = classArray3.length == 0;
            this.dotClasses = new Hashtable();
            Class[] classArray4 = new Class[1];
            int n = 0;
            while (n < classArray3.length) {
                this.rehashDotClass(classArray3[n]);
                ++n;
            }
        }
        this.names = new Hashtable();
        this.dynIDs = new Hashtable();
        this.stateless = new Hashtable();
        if (classArray != null) {
            Library.rehash(classArray, this.names, null, this.stateless);
        }
        if (classArray2 != null) {
            Library.rehash(classArray2, this.names, this.dynIDs, null);
        }
    }

    private void rehashDotClass(Class clazz) {
        Hashtable hashtable = new Hashtable();
        Class[] classArray = new Class[]{clazz};
        Library.rehash(classArray, hashtable, new Hashtable(), null);
        this.dotClasses.put(clazz, hashtable);
    }

    private static void rehash(Class[] classArray, Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3) {
        int n = 0;
        while (n < classArray.length) {
            Integer n2 = new Integer(n);
            java.lang.reflect.Method[] methodArray = classArray[n].getMethods();
            java.lang.reflect.Field[] fieldArray = classArray[n].getFields();
            int n3 = methodArray.length;
            int n4 = n3 + fieldArray.length;
            int n5 = 0;
            while (n5 < n4) {
                LocalField localField;
                LocalField localField2 = localField = n5 < n3 ? new Method(methodArray[n5]) : new Field(fieldArray[n5 - n3]);
                if ((localField.getModifiers() & 8) > 0) {
                    if (hashtable3 != null && Library.rehash(hashtable, localField)) {
                        hashtable3.put(localField, Boolean.TRUE);
                    }
                } else if (hashtable2 != null && Library.rehash(hashtable, localField)) {
                    hashtable2.put(localField, n2);
                }
                ++n5;
            }
            ++n;
        }
    }

    private static boolean rehash(Hashtable hashtable, Member member) {
        Hashtable hashtable2;
        String string = member.getName();
        String string2 = ClassFile.getSignature(member);
        if (member instanceof Field) {
            string2 = "()" + string2;
        }
        if ((hashtable2 = (Hashtable)hashtable.get(string)) == null) {
            Hashtable<String, Member> hashtable3 = new Hashtable<String, Member>();
            hashtable3.put(string2, member);
            hashtable.put(string, hashtable3);
            return true;
        }
        Object v = hashtable2.get(string2);
        if (v == null) {
            hashtable2.put(string2, member);
            return true;
        }
        return false;
    }

    public void markStateDependent(String string, Class[] classArray) throws CompilationException {
        Member member = this.getMember(string, classArray);
        Object v = this.stateless.remove(member);
    }

    public boolean isStateless(Member member) {
        return this.stateless.containsKey(member);
    }

    public Class getClassByName(String string) {
        if (this.cnmap == null) {
            return null;
        }
        return (Class)this.cnmap.get(string);
    }

    public Member getMember(String string, Class[] classArray) throws CompilationException {
        return Library.getMember(this.names, null, string, classArray);
    }

    public Member getMember(Class clazz, String string, Class[] classArray) throws CompilationException {
        if (this.dotClasses == null) {
            throw new CompilationException(-1, 11, null);
        }
        if (!this.noDotSecurity && !this.dotClasses.containsKey(clazz)) {
            Object[] objectArray = new Object[]{clazz};
            throw new CompilationException(-1, 12, objectArray);
        }
        Hashtable hashtable = (Hashtable)this.dotClasses.get(clazz);
        if (hashtable == null) {
            this.rehashDotClass(clazz);
            hashtable = (Hashtable)this.dotClasses.get(clazz);
        }
        return Library.getMember(hashtable, clazz, string, classArray);
    }

    private static Member getMember(Hashtable hashtable, Class clazz, String string, Class[] classArray) throws CompilationException {
        Object object;
        Object[] objectArray;
        Hashtable hashtable2 = (Hashtable)hashtable.get(string);
        if (hashtable2 == null) {
            Object[] objectArray2 = new Object[]{string, clazz};
            throw new CompilationException(-1, clazz == null ? 5 : 6, objectArray2);
        }
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration enumeration = hashtable2.elements();
        while (enumeration.hasMoreElements()) {
            objectArray = (Member)enumeration.nextElement();
            object = objectArray.getParameterTypes();
            boolean bl = false;
            if (classArray != null) {
                if (((Class[])object).length == classArray.length) {
                    bl = true;
                    int n = 0;
                    while (n < ((Object)object).length && bl) {
                        bl = TypesStack.isWidening(classArray[n], (Class)object[n]);
                        ++n;
                    }
                }
            } else {
                boolean bl2 = bl = ((Class[])object).length == 0;
            }
            if (!bl) continue;
            vector.addElement(objectArray);
        }
        if (vector.size() == 0) {
            objectArray = new Object[]{string, Library.describe(string, classArray), clazz};
            throw new CompilationException(-1, clazz == null ? 7 : 8, objectArray);
        }
        if (vector.size() == 1) {
            return (Member)vector.firstElement();
        }
        objectArray = vector.elements();
        object = (Member)objectArray.nextElement();
        Class[] classArray2 = object.getParameterTypes();
        while (objectArray.hasMoreElements()) {
            Member member = (Member)objectArray.nextElement();
            Class[] classArray3 = member.getParameterTypes();
            boolean bl = true;
            boolean bl3 = true;
            int n = 0;
            while (n < classArray3.length) {
                bl = bl && TypesStack.isWidening(classArray3[n], classArray2[n]);
                bl3 = bl3 && TypesStack.isWidening(classArray2[n], classArray3[n]);
                ++n;
            }
            if (bl && !bl3) {
                object = member;
                classArray2 = classArray3;
            }
            if (bl ^ bl3) continue;
            Object[] objectArray3 = new Object[]{Library.describe(string, classArray2), Library.describe(string, classArray3), Library.describe(string, classArray), clazz};
            throw new CompilationException(-1, clazz == null ? 9 : 10, objectArray3);
        }
        return object;
    }

    protected static String describe(String string, Class[] classArray) {
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append('(');
        if (classArray != null) {
            int n = 0;
            while (n < classArray.length) {
                if (n != 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(classArray[n].toString());
                ++n;
            }
        }
        stringBuffer.append(')');
        string2 = stringBuffer.toString();
        return string2;
    }

    public int getDynamicMethodClassID(Member member) {
        Integer n = (Integer)this.dynIDs.get(member);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Tester tester = new Tester(System.out);
        Library.test(tester);
        tester.summarize();
    }

    public static void test(Tester tester) {
        Class[] classArray;
        Object object;
        Class[] classArray2;
        Object object2;
        Library library = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.lang.Math");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.println("It is IMPOSSIBLE :)");
        }
        tester.startTest("Creating the library of java.lang.Math");
        try {
            object2 = new Class[]{clazz};
            classArray2 = new Library((Class[])object2, null);
            library = classArray2;
            tester.testOK();
        }
        catch (Throwable throwable) {
            Debug.reportThrowable(throwable);
            tester.testFail();
        }
        tester.startTest("Attempt of invocation round(double)");
        try {
            object2 = new Class[]{Double.TYPE};
            classArray2 = library.getMember("round", (Class[])object2);
            if (classArray2 != null && classArray2.equals(new Method(clazz.getMethod("round", (Class<?>)object2)))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            Debug.reportThrowable(throwable);
            tester.testFail();
        }
        tester.startTest("Attempt of invocation round(float)");
        try {
            object2 = new Class[]{Float.TYPE};
            classArray2 = library.getMember("round", (Class[])object2);
            if (classArray2 != null && classArray2.equals(new Method(clazz.getMethod("round", (Class<?>)object2)))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            Debug.reportThrowable(throwable);
            tester.testFail();
        }
        tester.startTest("Attempt of invocation round(int) best is round(float)");
        try {
            object2 = new Class[]{Integer.TYPE};
            classArray2 = library.getMember("round", (Class[])object2);
            object = new Class[]{Float.TYPE};
            if (classArray2 != null && classArray2.equals(new Method(clazz.getMethod("round", (Class<?>)object)))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            Debug.reportThrowable(throwable);
            tester.testFail();
        }
        tester.startTest("Attempt of invocation abs(int) best is abs(int)");
        try {
            object2 = new Class[]{Integer.TYPE};
            classArray2 = library.getMember("abs", (Class[])object2);
            object = new Class[]{Integer.TYPE};
            if (classArray2 != null && classArray2.equals(new Method(clazz.getMethod("abs", (Class<?>)object)))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            Debug.reportThrowable(throwable);
            tester.testFail();
        }
        tester.startTest("Attempt of invocation abs(byte) best is abs(int)");
        try {
            object2 = new Class[]{Byte.TYPE};
            classArray2 = library.getMember("abs", (Class[])object2);
            object = new Class[]{Integer.TYPE};
            if (classArray2 != null && classArray2.equals(new Method(clazz.getMethod("abs", (Class<?>)object)))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            Debug.reportThrowable(throwable);
            tester.testFail();
        }
        tester.startTest("Attempt of invocation abs(char) best is abs(int)");
        try {
            object2 = new Class[]{Character.TYPE};
            classArray2 = library.getMember("abs", (Class[])object2);
            object = new Class[]{Integer.TYPE};
            if (classArray2 != null && classArray2.equals(new Method(clazz.getMethod("abs", (Class<?>)object)))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            Debug.reportThrowable(throwable);
            tester.testFail();
        }
        tester.startTest("Attempt of invocation min(int,float) best is min(float,float)");
        try {
            object2 = new Class[]{Integer.TYPE, Float.TYPE};
            classArray2 = library.getMember("min", (Class[])object2);
            object = new Class[]{Float.TYPE, Float.TYPE};
            if (classArray2 != null && classArray2.equals(new Method(clazz.getMethod("min", (Class<?>)object)))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            Debug.reportThrowable(throwable);
            tester.testFail();
        }
        tester.startTest("Attempt of access to the field PI");
        try {
            object2 = new Class[]{};
            classArray2 = library.getMember("PI", (Class[])object2);
            if (classArray2 != null && classArray2.getName().equals("PI")) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            Debug.reportThrowable(throwable);
            tester.testFail();
        }
        tester.startTest("Checking assignment of state dependence ");
        try {
            library.markStateDependent("random", null);
            if (!library.isStateless(library.getMember("random", null))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            Debug.reportThrowable(throwable);
            tester.testFail();
        }
        tester.startTest("Creating a library with dot operations allowed ");
        object2 = null;
        try {
            classArray2 = new Class[1];
            object = new Class[1];
            classArray = new Class[2];
            classArray2[0] = Class.forName("java.lang.Math");
            object[0] = Class.forName("java.util.Random");
            classArray[0] = Class.forName("java.util.Hashtable");
            classArray[1] = Class.forName("java.util.Vector");
            object2 = new Library(classArray2, (Class[])object, classArray);
            tester.testOK();
        }
        catch (Throwable throwable) {
            Debug.reportThrowable(throwable);
            tester.testFail();
        }
        tester.startTest("Resolving size() on Hashtable");
        try {
            classArray2 = new Class[]{};
            object = Class.forName("java.util.Hashtable");
            classArray = object2.getMember((Class)object, "size", classArray2);
            if (classArray != null && classArray.equals(new Method(((Class)object).getMethod("size", classArray2)))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            Debug.reportThrowable(throwable);
            tester.testFail();
        }
        tester.startTest("Resolving size() on Vector");
        try {
            classArray2 = new Class[]{};
            object = Class.forName("java.util.Vector");
            classArray = object2.getMember((Class)object, "size", classArray2);
            if (classArray != null && classArray.equals(new Method(((Class)object).getMethod("size", classArray2)))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            Debug.reportThrowable(throwable);
            tester.testFail();
        }
        tester.startTest("Ensuring size() is not leaked to global context.");
        try {
            classArray2 = new Class[]{};
            try {
                object = object2.getMember("size", classArray2);
                tester.testFail();
            }
            catch (CompilationException compilationException) {
                tester.testOK();
            }
        }
        catch (Throwable throwable) {
            Debug.reportThrowable(throwable);
            tester.testFail();
        }
    }
}

