/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.IntegerStack;
import gnu.jel.LocalField;
import gnu.jel.LocalMethod;
import gnu.jel.PatchableByteArrayOutputStream;
import gnu.jel.TableKeeper;
import gnu.jel.TypesStack;
import gnu.jel.debug.Debug;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class ClassFile
implements Cloneable {
    private int poolEntries = 1;
    private ByteArrayOutputStream constPoolData;
    private DataOutputStream constPool;
    private Hashtable Items = new Hashtable();
    private Hashtable UTFs = new Hashtable();
    int nMethods = 0;
    int nMethodsPatch;
    protected PatchableByteArrayOutputStream textData;
    private DataOutputStream text;
    private boolean isInterface;
    private int startCodeAttr = 0;
    private int startCode = 0;
    private static final byte[] prologue;
    protected LocalMethod currMethod = null;
    int[] paramsVars = null;
    protected TypesStack typesStk = new TypesStack();
    protected int currJump = 0;
    protected boolean invert_next_jump = false;
    private IntegerStack jumps = new IntegerStack();
    private IntegerStack jumps0 = new IntegerStack();
    private IntegerStack jumps1 = new IntegerStack();
    private IntegerStack blocks0 = new IntegerStack();
    private IntegerStack blocks1 = new IntegerStack();
    private IntegerStack branchStack = new IntegerStack();
    public static final Class[] specialClasses;
    public static final Member[] specialMethods;
    private static final int[] load_ints;
    private static final int[] load_long_ints;

    public ClassFile(int modifiers, String name, Class superClass, Class[] interfaces, LocalField[] fields) {
        this.constPoolData = new ByteArrayOutputStream();
        this.constPool = new DataOutputStream(this.constPoolData);
        this.textData = new PatchableByteArrayOutputStream();
        this.text = new DataOutputStream(this.textData);
        try {
            Debug.assert(name.indexOf(46) == -1);
            this.getUTFIndex(name);
            Debug.assert((modifiers & 0xFFFFF9EE) == 0);
            this.isInterface = (modifiers & 0x200) > 0;
            this.text.writeShort(modifiers | 0x20);
            Debug.assert(this.poolEntries == 2);
            ++this.poolEntries;
            this.constPool.write(7);
            this.constPool.writeShort(1);
            this.text.writeShort(2);
            this.text.writeShort(this.getIndex(superClass, 9));
            int nInterfaces = interfaces == null ? 0 : interfaces.length;
            this.text.writeShort(nInterfaces);
            int i = 0;
            while (i < nInterfaces) {
                Debug.assert(interfaces[i].isInterface());
                this.text.writeShort(this.getIndex(interfaces[i], 9));
                ++i;
            }
            int nFields = fields == null ? 0 : fields.length;
            this.text.writeShort(nFields);
            int i2 = 0;
            while (i2 < nFields) {
                LocalField cLF = fields[i2];
                Debug.assert(!(cLF instanceof LocalMethod));
                this.text.writeShort(cLF.getModifiers());
                this.text.writeShort(this.getUTFIndex(cLF.getName()));
                this.text.writeShort(this.getUTFIndex(TypesStack.getSignature(cLF.getType())));
                this.text.writeShort(0);
                ++i2;
            }
            this.nMethodsPatch = this.textData.size();
            this.text.writeShort(0);
        }
        catch (IOException exc) {
            // empty catch block
        }
    }

    public Object clone() {
        ClassFile res = null;
        try {
            res = (ClassFile)super.clone();
            res.Items = (Hashtable)res.Items.clone();
            res.UTFs = (Hashtable)res.UTFs.clone();
            res.paramsVars = (int[])res.paramsVars.clone();
            res.typesStk = (TypesStack)res.typesStk.clone();
            res.jumps = (IntegerStack)res.jumps.clone();
            res.jumps0 = (IntegerStack)res.jumps0.clone();
            res.jumps1 = (IntegerStack)res.jumps1.clone();
            res.blocks0 = (IntegerStack)res.blocks0.clone();
            res.blocks1 = (IntegerStack)res.blocks1.clone();
            res.branchStack = (IntegerStack)res.branchStack.clone();
            res.constPoolData = new ByteArrayOutputStream();
            this.constPool.flush();
            this.constPoolData.writeTo(res.constPoolData);
            res.constPool = new DataOutputStream(res.constPoolData);
            res.textData = new PatchableByteArrayOutputStream();
            this.text.flush();
            this.textData.writeTo(res.textData);
            res.text = new DataOutputStream(res.textData);
        }
        catch (IOException exc) {
            Debug.reportThrowable(exc);
        }
        catch (CloneNotSupportedException exc) {
            Debug.reportThrowable(exc);
        }
        return res;
    }

    public void newMethod(LocalMethod m, Class[] vars) {
        Debug.assert(this.typesStk.size() == 0);
        Debug.assert(this.jumps0.size() == 0);
        Debug.assert(this.jumps1.size() == 0);
        Debug.assert(this.blocks0.size() == 0);
        Debug.assert(this.blocks1.size() == 0);
        Debug.assert(this.currJump == 0);
        try {
            this.finishMethod();
            ++this.nMethods;
            int mdfrs = m.getModifiers();
            if (this.isInterface) {
                mdfrs |= 0x400;
            }
            boolean isAbstract = (mdfrs & 0x400) > 0;
            this.text.writeShort(mdfrs);
            this.text.writeShort(this.getUTFIndex(m.getName()));
            this.text.writeShort(this.getUTFIndex(TypesStack.getSignature(m)));
            int temp = 0;
            Class[] exceptions = m.getExceptionTypes();
            if (exceptions != null) {
                ++temp;
            }
            if (!isAbstract) {
                ++temp;
            }
            this.text.writeShort(temp);
            if (exceptions != null) {
                temp = exceptions.length;
                this.text.writeShort(this.getUTFIndex("Exceptions"));
                this.text.writeInt((temp + 1) * 2);
                this.text.writeShort(temp);
                int i = 0;
                while (i < temp) {
                    this.text.writeShort(this.getIndex(exceptions[i], 9));
                    ++i;
                }
            }
            if (!isAbstract) {
                this.startCodeAttr = this.textData.size();
                this.text.writeShort(this.getUTFIndex("Code"));
                this.text.writeInt(0);
                this.text.writeShort(0);
                Class[] params = m.getParameterTypes();
                int parlen = params == null ? 0 : params.length;
                int varlen = vars == null ? 0 : vars.length;
                int this_num = (mdfrs & 8) == 0 ? 1 : 0;
                int nLocalVars = parlen + varlen + this_num;
                this.paramsVars = new int[nLocalVars];
                int localsSize = 0;
                int i = 0;
                while (i < this.paramsVars.length) {
                    int j = i - this_num;
                    int typeID = i < this_num ? 8 : TypesStack.typeID(j < parlen ? params[j] : vars[j - parlen]);
                    this.paramsVars[i] = localsSize;
                    localsSize += TypesStack.stkoccup[TypesStack.baseType[typeID]];
                    ++i;
                }
                this.text.writeShort(localsSize);
                this.text.writeInt(0);
                this.startCode = this.textData.size();
            }
            this.typesStk.resetStats();
            if (!isAbstract) {
                this.currMethod = m;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void finishMethod() throws IOException {
        if (this.currMethod != null) {
            int codeEnd = this.textData.size();
            this.text.writeShort(0);
            this.text.writeShort(0);
            int currPos = this.textData.size();
            this.textData.patchInt(this.startCodeAttr + 2, currPos - this.startCodeAttr - 6);
            this.textData.patch(this.startCodeAttr + 6, this.typesStk.getMaxOccupation());
            this.textData.patch(this.startCode - 2, codeEnd - this.startCode);
            this.currMethod = null;
        }
    }

    public byte[] getImage() {
        ByteArrayOutputStream image = new ByteArrayOutputStream();
        try {
            this.finishMethod();
            this.text.writeShort(0);
            this.textData.patch(this.nMethodsPatch, this.nMethods);
            image.write(prologue);
            image.write(this.poolEntries >>> 8 & 0xFF);
            image.write(this.poolEntries >>> 0 & 0xFF);
            this.constPoolData.writeTo(image);
            this.textData.writeTo(image);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return image.toByteArray();
    }

    private static final int invert_jump_bytecode(int jmp) {
        Debug.assert(jmp >= 153 && jmp <= 166, "Attempt to invert non jump bytecode (" + jmp + ")");
        return (jmp - 1 ^ 1) + 1;
    }

    protected void labels_block() {
        this.blocks0.push(this.jumps0.size());
        this.blocks1.push(this.jumps1.size());
    }

    protected void labels_unblock() {
        this.blocks0.pop_throw();
        this.blocks1.pop_throw();
    }

    protected void labels_unblock_not() {
        this.ensure_jump();
        IntegerStack.swap(this.jumps1, this.blocks1.pop(), this.jumps0, this.blocks0.pop());
        this.invert_next_jump = !this.invert_next_jump;
    }

    protected final void ensure_jump() {
        if (this.currJump != 0) {
            return;
        }
        Class a1 = this.typesStk.pop();
        Debug.assert(a1 == Boolean.TYPE, "Only booleans can generate jumps in ensurejump()");
        this.currJump = 157;
    }

    protected final void ensure_value() {
        if (this.currJump == 0) {
            boolean noPendingJumps;
            int blocked0 = 0;
            if (this.blocks0.size() > 0) {
                blocked0 = this.blocks0.peek();
            }
            int blocked1 = 0;
            if (this.blocks1.size() > 0) {
                blocked1 = this.blocks1.peek();
            }
            boolean bl = noPendingJumps = this.jumps0.size() == blocked0 && this.jumps1.size() == blocked1;
            if (noPendingJumps) {
                return;
            }
        }
        this.branch_true();
        this.codeLDC(Boolean.TRUE, 0);
        this.branch_false();
        this.codeLDC(Boolean.FALSE, 0);
        this.branch_end();
    }

    private final void mkLabel(IntegerStack jumps) {
        int currpos = this.textData.size();
        jumps.push(currpos);
        this.codeI(0);
    }

    private final void landLabel(IntegerStack jumps) {
        int currpos = this.textData.size();
        int addrpos = jumps.pop();
        this.textData.patch(addrpos, currpos - addrpos + 1);
    }

    private final void landLabels(IntegerStack jumps, IntegerStack blocks) {
        int blocked_at = 0;
        if (blocks.size() > 0) {
            blocked_at = blocks.peek();
        }
        while (jumps.size() > blocked_at) {
            this.landLabel(jumps);
        }
    }

    public void branch_true() {
        this.ensure_jump();
        if (!this.invert_next_jump) {
            this.currJump = ClassFile.invert_jump_bytecode(this.currJump);
        }
        this.invert_next_jump = false;
        this.code(this.currJump);
        this.currJump = 0;
        this.mkLabel(this.jumps0);
        this.landLabels(this.jumps1, this.blocks1);
        this.blocks0.push(this.jumps0.size());
        this.branchStack.push(this.typesStk.size());
    }

    public void branch_false() {
        this.ensure_value();
        this.blocks0.pop_throw();
        int beforeStk = this.branchStack.pop();
        this.branchStack.push(this.typesStk.currWords);
        while (beforeStk < this.typesStk.size()) {
            this.typesStk.pop();
        }
        this.code(167L);
        this.mkLabel(this.jumps);
        this.landLabels(this.jumps0, this.blocks0);
    }

    public void branch_end() {
        this.ensure_value();
        Debug.assert(this.branchStack.pop() == this.typesStk.currWords, "Stack mismatch when compiling conditional");
        this.landLabel(this.jumps);
    }

    protected void logical_param(boolean and) {
        IntegerStack b1;
        IntegerStack b0;
        IntegerStack j1;
        IntegerStack j0;
        if (and) {
            j0 = this.jumps0;
            j1 = this.jumps1;
            b0 = this.blocks0;
            b1 = this.blocks1;
        } else {
            j0 = this.jumps1;
            j1 = this.jumps0;
            b0 = this.blocks1;
            b1 = this.blocks0;
        }
        this.ensure_jump();
        if (this.invert_next_jump ^ and) {
            this.currJump = ClassFile.invert_jump_bytecode(this.currJump);
        }
        this.invert_next_jump = false;
        this.code(this.currJump);
        this.currJump = 0;
        this.mkLabel(j0);
        this.landLabels(j1, b1);
        b0.push(j0.size());
    }

    protected void logical_end(boolean and) {
        if (and) {
            this.blocks0.pop_throw();
        } else {
            this.blocks1.pop_throw();
        }
    }

    public final void codeB(long op) {
        try {
            while (op != 0L) {
                char opc = (char)(op & 0xFFL);
                Debug.assert(opc != '\u00ff');
                this.text.write(opc);
                op >>>= 8;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final void codeM(Member m) {
        int modifiers = m.getModifiers();
        if (TypesStack.isField(m)) {
            if ((modifiers & 8) > 0) {
                this.code(178L);
            } else {
                this.code(180L);
            }
            this.codeI(this.getIndex(m, 12));
        } else {
            boolean inInterface = false;
            int cfID = 10;
            if (m instanceof Constructor) {
                this.code(183L);
                ++cfID;
            } else if ((modifiers & 8) > 0) {
                this.code(184L);
            } else {
                Class<?> dClass = m.getDeclaringClass();
                inInterface = dClass != null && dClass.isInterface();
                if (inInterface) {
                    this.code(185L);
                } else {
                    this.code(182L);
                }
            }
            this.codeI(this.getIndex(m, cfID));
            if (inInterface) {
                this.codeI(1 + ((Method)m).getParameterTypes().length << 8);
            }
        }
    }

    public final void code(long op) {
        try {
            while (op != 0L) {
                char opc = (char)(op & 0xFFL);
                Debug.assert(opc != '\u00ff');
                switch (opc - 249) {
                    case 0: {
                        this.ensure_jump();
                        break;
                    }
                    case 1: {
                        this.ensure_value();
                        break;
                    }
                    case 2: {
                        this.labels_block();
                        break;
                    }
                    case 3: {
                        this.labels_unblock_not();
                        break;
                    }
                    case 4: {
                        this.codeI(this.getIndex(specialClasses[(int)((op >>>= 8) & 0xFFL)], 9));
                        break;
                    }
                    case 5: {
                        this.codeM(specialMethods[(int)((op >>>= 8) & 0xFFL)]);
                        break;
                    }
                    default: {
                        Debug.assert(opc != '\u00ff');
                        this.text.write(opc);
                    }
                }
                op >>>= 8;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final void codeLDC(Object o, int primitiveID) {
        boolean tsb_store;
        block30: {
            Debug.assert(primitiveID >= 0 && primitiveID < 8 || primitiveID == 8 && o == null || primitiveID == 10 && o instanceof StringBuffer || primitiveID == 11 && o instanceof String);
            int short_opcodes = 0;
            tsb_store = false;
            int iv = -1;
            switch (primitiveID) {
                case 0: {
                    iv = (Boolean)o != false ? 1 : 0;
                }
                case 2: {
                    if (iv < 0) {
                        iv = ((Character)o).charValue();
                    }
                }
                case 1: 
                case 3: 
                case 4: {
                    if (iv < 0) {
                        iv = ((Number)o).intValue();
                    }
                    if (iv >= -1 && iv <= 5) {
                        short_opcodes = iv + 3;
                        break;
                    }
                    if (iv < -128 || iv > 127) break;
                    short_opcodes = 0x10 | (iv & 0xFF) << 8;
                    break;
                }
                case 5: {
                    long lv = (Long)o;
                    if (lv < -1L || lv > 5L) break;
                    short_opcodes = load_long_ints[(int)lv + 1];
                    break;
                }
                case 6: {
                    float fv = ((Float)o).floatValue();
                    if (fv == 0.0f) {
                        short_opcodes = 11;
                        break;
                    }
                    if (fv == 1.0f) {
                        short_opcodes = 12;
                        break;
                    }
                    if (fv != 2.0f) break;
                    short_opcodes = 13;
                    break;
                }
                case 7: {
                    double dv = (Double)o;
                    if (dv == 0.0) {
                        short_opcodes = 14;
                        break;
                    }
                    if (dv != 1.0) break;
                    short_opcodes = 15;
                    break;
                }
                case 8: {
                    if (o != null) break;
                    short_opcodes = 1;
                    break;
                }
                case 10: {
                    tsb_store = true;
                }
                case 11: {
                    short_opcodes = 0;
                    primitiveID = 8;
                    break;
                }
                default: {
                    Debug.assert(false, "Loading of object constants is not supported by the Java class files.");
                }
            }
            if (short_opcodes == 0) {
                try {
                    int cpindex;
                    boolean dword_const;
                    boolean bl = dword_const = primitiveID == 5 || primitiveID == 7;
                    if (tsb_store) {
                        this.code(2191928458683L);
                        this.typesStk.pushID(10);
                        cpindex = this.getIndex(o.toString(), primitiveID);
                    } else {
                        cpindex = this.getIndex(o, primitiveID);
                    }
                    Debug.assert(cpindex >= 0 && cpindex <= 65535);
                    if (!dword_const && cpindex <= 255) {
                        this.text.write(18);
                        this.text.write(cpindex);
                        break block30;
                    }
                    int opc = 19;
                    if (dword_const) {
                        ++opc;
                    }
                    this.text.write(opc);
                    this.text.writeShort(cpindex);
                }
                catch (IOException e) {}
            } else {
                this.codeB(short_opcodes);
            }
        }
        if (primitiveID != 8) {
            this.typesStk.pushID(primitiveID);
        } else if (o == null) {
            this.typesStk.push(null);
        } else {
            this.typesStk.pushID(11);
            if (tsb_store) {
                this.code(2302L);
                this.typesStk.pop();
            }
        }
    }

    public final void codeI(int ind) {
        Debug.assert(ind >= 0 && ind <= 65535);
        try {
            this.text.writeShort(ind);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int getUTFIndex(String str) {
        Integer index = (Integer)this.UTFs.get(str);
        if (index == null) {
            index = new Integer(this.poolEntries++);
            try {
                this.constPool.write(1);
                this.constPool.writeUTF(str);
            }
            catch (IOException e) {
                Debug.reportThrowable(e);
            }
            this.UTFs.put(str, index);
        }
        return index;
    }

    private int typeID(Object item) {
        int id = TypesStack.typeIDObject(item);
        if (id < 8) {
            return id;
        }
        if (item instanceof String) {
            return 8;
        }
        if (item instanceof Class) {
            return 9;
        }
        if (item instanceof Member) {
            return 10;
        }
        return -1;
    }

    private final int getIndex(Object item) {
        return this.getIndex(item, this.typeID(item));
    }

    public int getIndex(Object item, int typeid) {
        Integer index = (Integer)this.Items.get(item);
        if (index == null) {
            int newIndex = -1;
            try {
                int ival = -1;
                switch (typeid) {
                    case 0: {
                        ival = (Boolean)item != false ? 1 : 0;
                    }
                    case 2: {
                        if (ival < 0) {
                            ival = ((Character)item).charValue();
                        }
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        if (ival < 0) {
                            ival = ((Number)item).intValue();
                        }
                        newIndex = this.poolEntries++;
                        this.constPool.write(3);
                        this.constPool.writeInt(ival);
                        break;
                    }
                    case 5: {
                        newIndex = this.poolEntries;
                        this.constPool.write(5);
                        this.constPool.writeLong((Long)item);
                        this.poolEntries += 2;
                        break;
                    }
                    case 6: {
                        newIndex = this.poolEntries++;
                        this.constPool.write(4);
                        this.constPool.writeFloat(((Float)item).floatValue());
                        break;
                    }
                    case 7: {
                        newIndex = this.poolEntries;
                        this.constPool.write(6);
                        this.constPool.writeDouble((Double)item);
                        this.poolEntries += 2;
                        break;
                    }
                    case 8: {
                        int UTFIndex = this.getUTFIndex((String)item);
                        newIndex = this.poolEntries++;
                        this.constPool.write(8);
                        this.constPool.writeShort(UTFIndex);
                        break;
                    }
                    case 9: {
                        String histNameStr = TypesStack.toHistoricalForm(((Class)item).getName());
                        int UTFIndex = this.getUTFIndex(histNameStr);
                        newIndex = this.poolEntries++;
                        this.constPool.write(7);
                        this.constPool.writeShort(UTFIndex);
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        Member member = (Member)item;
                        Class<?> dClass = member.getDeclaringClass();
                        int entryType = TypesStack.isField(member) ? 9 : (dClass != null && dClass.isInterface() ? 11 : 10);
                        newIndex = this.writeMemberRef(member, entryType);
                        break;
                    }
                    default: {
                        Debug.println("Can't place an item of type \"" + item.getClass().getName() + "\" to the constant pool.");
                        break;
                    }
                }
            }
            catch (IOException e) {
                Debug.reportThrowable(e);
            }
            index = new Integer(newIndex);
            this.Items.put(item, index);
        }
        return index;
    }

    private int writeMemberRef(Member member, int entry) throws IOException {
        Debug.assert(entry == 10 || entry == 9 || entry == 11);
        int name_ind = this.getUTFIndex(member instanceof Constructor ? "<init>" : member.getName());
        int sign_ind = this.getUTFIndex(TypesStack.getSignature(member));
        Class<?> dClass = member.getDeclaringClass();
        int cls_ind = dClass == null ? 2 : this.getIndex(dClass, 9);
        int nat_ind = this.poolEntries++;
        this.constPool.write(12);
        this.constPool.writeShort(name_ind);
        this.constPool.writeShort(sign_ind);
        int index = this.poolEntries++;
        this.constPool.write(entry);
        this.constPool.writeShort(cls_ind);
        this.constPool.writeShort(nat_ind);
        return index;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block10: {
            ClassFile.prologue = new byte[]{-54, -2, -70, -66, 0, 3, 0, 45};
            Debug.assert(TypesStack.specialTypes.length == 29, "You changed special types in TypesStack please update specialClasses array in ClassFile.");
            specialClassesAdd = (Class[])TableKeeper.getTable("specialClassesAdd");
            ClassFile.specialClasses = new Class[TypesStack.specialTypes.length + specialClassesAdd.length];
            System.arraycopy(TypesStack.specialTypes, 0, ClassFile.specialClasses, 0, TypesStack.specialTypes.length);
            System.arraycopy(specialClassesAdd, 0, ClassFile.specialClasses, TypesStack.specialTypes.length, specialClassesAdd.length);
            specialMds = (char[][])TableKeeper.getTable("specialMds");
            specialMdsN = (String[])TableKeeper.getTable("specialMdsN");
            ClassFile.specialMethods = new Member[specialMds.length];
            definingClass = null;
            name = null;
            params = null;
            i = 0;
            try {
                i = 0;
                while (i < specialMds.length) {
                    defClassID = specialMds[i][0] % 100;
                    definingClass = ClassFile.specialClasses[defClassID];
                    name = specialMdsN[specialMds[i][1]];
                    params = new Class[specialMds[i].length - 2];
                    j = 0;
                    while (j < params.length) {
                        params[j] = ClassFile.specialClasses[specialMds[i][2 + j]];
                        ++j;
                    }
                    switch (specialMds[i][0] / 100) {
                        case 0: {
                            ClassFile.specialMethods[i] = definingClass.getMethod(name, params);
                            break;
                        }
                        case 1: {
                            ClassFile.specialMethods[i] = definingClass.getConstructor(params);
                            break;
                        }
                        case 2: {
                            Debug.assert(params.length == 0);
                            ClassFile.specialMethods[i] = definingClass.getField(name);
                            break;
                        }
                        default: {
                            throw new Exception("JEL: Wrong class ID modifier.");
                        }
                    }
                    ++i;
                }
                break block10;
            }
            catch (Exception exc) {
                Debug.println("JEL: Problem with special method [" + i + "] " + name + " in " + definingClass);
                j = 0;
                ** while (j < params.length)
            }
lbl-1000:
            // 1 sources

            {
                Debug.println("parameter[" + j + "]=" + params[j]);
                ++j;
                continue;
            }
lbl49:
            // 1 sources

            Debug.reportThrowable(exc);
        }
        ClassFile.load_ints = new int[]{2, 3, 4, 5, 6, 7, 8};
        ClassFile.load_long_ints = new int[]{34050, 9, 10, 34053, 34054, 34055, 34056};
    }
}

