m4_define([COMM],[EM($*)])
@example
(let (p1 p2 str form type variable T var start stop step-size step-size-2
         this_start this_stop this_step this_step_size file line p-prior
         beg0 end0)
  COMM(;;(checkpoint "2"))
  (save-excursion
    COMM(;;(setq parse-sexp-ignore-comments t))
    (goto-char (point-min))
    (setq *superfor* 0)
    (while (re-search-forward "\\<superfor\\>" nil t)
      (setq beg0 (match-beginning 0))
      (setq end0 (match-end 0))
      COMM(;;(checkpoint "sitting for 1 seconds..."))
      (font-lock-fontify-buffer)
      COMM(;;(sit-for 1))
      (when (save-excursion
              (save-match-data
                (re-search-forward "(" (point-at-eol) t)
                (forward-char -1)
                (re-search-forward "\\<var\\>" nil t)
                (not (warn--inside-comment-or-string))))
        COMM(;;(error "Smelly cat"))
        (setq *current-buffer* (current-buffer))
        COMM(;;(switch-to-buffer *current-buffer*))
        (setq p1 beg0)
        (assert (save-match-data
                  (looking-at "[ \t\r\n]*(")))
        (setq p2 (save-excursion
                   (forward-sexp 1)
                   (point)))
        (setq str (buffer-substring-no-properties end0 p2))
        COMM(;;(checkpoint "str=%s" str))
        (setq form (read-str str))
        COMM(;;(checkpoint "form=%s" form))
        COMM(;;(debug "form"))
        (assert (consp form))
        COMM(;;(error "Rolling Stones plays Cuba"))
        (delete-region p1 p2)
        (incf *superfor*)
        (setq this (format "superfor_%d_" *superfor*))
        (when (not (eq (nth 0 form) 'var))
          (warn--log-message "Error 35: Keyword var missing")
          (when (and (not (eq (nth 0 form) 'char))
                     (not (eq (nth 0 form) 'short))
                     (not (eq (nth 0 form) 'int))
                     (not (eq (nth 0 form) 'long))
                     (not (eq (nth 0 form) 'float))
                     (not (eq (nth 0 form) 'double)))
            (warn--log-message (concat
                                "Error 37:#1 argument type to superfor macro must be"
                                " one of char/short/int/long/float/double"))))
        (when (eq (nth 0 form) 'var)
          (if (and (not (eq (nth 1 form) 'char))
                   (not (eq (nth 1 form) 'short))
                   (not (eq (nth 1 form) 'int))
                   (not (eq (nth 1 form) 'long))
                   (not (eq (nth 1 form) 'float))
                   (not (eq (nth 1 form) 'double)))
              (warn--log-message (concat
                                  "Error 37:#2 argument type to superfor macro must be"
                                  " one of char/short/int/long/float/double")))
          (progn
            (setq type (nth 1 form))
            (setq T (prin1-to-string type))
            (setq variable (nth 2 form))
            (setq variable-equals (prin1-to-string (nth 2 form)))
            (if (string-match "=" variable-equals)
                (progn
                  (setq variable (read-str (substring variable-equals 0 (match-beginning 0))))
                  (setq start    (read-str (substring variable-equals (match-end 0))))
                  (if (eq (nth 3 form) 'to)
                      (setq to 'to)
                    (if (eq (nth 3 form) 'downto)
                        (setq to 'downto)
                      (assert "The Bug")))
                  (setq stop     (nth 4 form))
                  (if (eq (nth 5 form) 'step)
                      (setq step-size (nth 6 form))
                    COMM(;;(setq step-size 1))
                    ))
              (assert (or (eq (nth 3 form) '=)))
              COMM(;;(debug "Joaquin Rodrigo"))
              (setq start (nth 4 form))
              (if (eq (nth 5 form) 'to)
                  (setq to 'to)
                (if (eq (nth 5 form) 'downto)
                    (setq to 'downto)
                  (assert "Planet of New Orleans")))
              (setq stop (nth 6 form))
              (if (eq (nth 7 form) 'step)
                  (progn
                    (setq step-size (nth 8 form))
                    COMM(;;(assert (numberp (nth 8 form))))
                    )
                COMM(;;(setq step-size 1))
                )
              ))
          (d-quote
           (debug "Rocket Queen")
           (setq type "")
           (setq T "double")
           (setq variable (nth 0 form))
           (assert (eq (nth 1 form) '=))
           (setq start (nth 2 form))
           (if (eq (nth 3 form) 'to)
               (setq to 'to)
             (if (eq (nth 3 form) 'downto)
                 (setq to 'downto)
               (debug "My Michelle")))
           (setq stop (nth 4 form))
           (if (eq (nth 5 form) 'step)
               (setq step-size (nth 6 form))))
          (setq var         (prin1-to-string variable))
          (setq start       (prin1-to-string start))
          (setq stop        (prin1-to-string stop))
          (setq step-size-2 (prin1-to-string step-size))
          (setq start       (warn--splat-quest start))
          (setq stop        (warn--splat-quest stop))
          (setq step-size-2 (warn--splat-quest step-size-2))
           -----------------------------------------------------
          (setq this_start     (concat this "start"))
          (setq this_stop      (concat this "stop"))
          (setq this_step      (concat this "step"))
          (setq this_step_size (concat this "step_size"))
          COMM(;;(debug "My Parties"))
          (insert (concat (concat "var " T " " this_start " = " start ";")
                          (concat "var " T " " this_stop  " = " stop  ";")
                          (if step-size
                              (concat "var " T " " this_step " = " step-size-2 ";"
                                      "var " T " " this_step_size " = "
                                      (if (eq to 'to) (concat "Math.abs(" this_step ")") (if (eq to 'downto) (concat "-Math.abs(" this_step ")") (debug "Heavy Fuel"))) ";\n")
                            (concat "var " T " " this_step_size " = " (if (eq to 'to) "1" (if (eq to 'downto) "-1" (debug "Ticket to Heaven"))))) ";\n"))
          (setq line 0)
          (setq p-prior
                (save-excursion
                  (beginning-of-line)
                  (setq str (concat "^[ \t]*//+ " *pp-namespace* " #location[0-9]"
                                    " (\\(" *drive-spec* "[-a-zA-Z0-9_./]+\\):\\([0-9]+\\))"))
                  (if (or (looking-at str) (re-search-backward str nil t))
                      (progn
                        COMM(;;(debug "Antonio Vivaldi"))
                        (setq file (buffer-substring-no-properties           (match-beginning 1)
                                                                             (match-end 1)))
                        (assert (stringp file))
                        (setq line (read-str (buffer-substring-no-properties (match-beginning 3)
                                                                             (match-end 3))))
                        (assert (integerp line))
                        (point)
                        )
                    (setq file (concat default-directory *stump* ".jtw"))
                    (setq line 1)
                    (goto-char (point-min))
                    (forward-line 2)
                    (point)
                    )))
          (setq line (+ line (count-lines p-prior (point))))
          (decf line)
          (decf line)
          (insert (format "// %s (setq file-stack '%s)\n" *list-namespace* (prin1-to-string file-stack)))
          (insert (format "// %s #location3 (%s:%d)\n" *pp-namespace* file line))
          (insert (concat "for (var " T " " var " = " this_start ";"
                          " ((" this_step_size " > 0) ? " var " <= "
                          this_stop " : " var " >= " this_stop "); "
                          var " += " this_step_size ")"))
          COMM(;;(debug "Yehudi Menuhin"))
          )))))
)
@end example
