
;;; d-bbasic.el --- A Blitz BASIC major mode.

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-bbasic.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: Blitz BASIC major mode
;; Version: 1.2

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(defvar bbasic-mode-syntax-table
  (make-syntax-table emacs-lisp-mode-syntax-table)
  )
(defvar bbasic-mode-mode-map
  (make-keymap))

(setq auto-mode-alist (cons '("\\.bb2$" . bbasic-mode) auto-mode-alist))

(defun bbasic-mode ()
  (interactive)
  (progn
    (fundamental-mode)
    (font-lock-mode 0)
    (kill-all-local-variables)
    (setq major-mode 'bbasic-mode)
    (setq mode-name "Blitz Basic")

    (set-syntax-table bbasic-mode-syntax-table)
    (use-local-map bbasic-mode-mode-map)

    (set (make-local-variable 'font-lock-keywords-case-fold-search) t)

    (setq bbasic-mode-font-lock-keywords
          '(
            ("\\<\\(If\\|Then\\|Else\\|EndIf\\|Repeat\\|Until\\|For\\|Step\\|Next\\|Gosub\\|Goto\\|DEFTYPE\\|NEWTYPE\\|End NEWTYPE\\|Dim\\|To\\|\\|While\\|Wend\\|Read\\|Restore\\|LoadSound\\|LoadPalette\\|LoadShapes\\|LoadSprites\\|LoadMedModule\\|StartMedModule\\|Filter\\|On\\|Off\\|VWait\\|Poke\\.[a-z]\\|Peek\\.[a-z]\\|CustomCop\\|Slice\\|Show\\|Use\\|BitMap\\|Palette\\|RGB\\|Colour\\|Locate\\|NPrint\\|Cls\\|True\\|False\\|Select\\|Case\\|Default\\|End\\|Return\\|Blit\\|BlitMode\\|EraseMode\\|CookieMode\\|VPos\\|Joyb\\|AND\\|OR\\|NOT\\|Boxf\\|ShowSprite\\|Rnd\\|Scroll\\|Plot\\|Sound\\|Line\\|Point\\|Circle\\|QLimit\\|CopLoc\\|GetReg\\|MOVE\\.[a-z]\\|SUBQ\\.[a-z]\\|DBRA\\|PAL\\|NTSC\\|NoCli\\|PlayMed\\|StopMed\\|SetMedVolume\\|SetInt\\|Used\\|Int\\|Red\\|Green\\|Blue\\|FreeSlices\\|AMIGA\\|BLITZ\\|Free\\|WBenchToFront_\\|WBStartup\\|LoadView_\\|BitPlanesBitMap\\|LoadBitMap\\|Eof\\|Asc\\|DefaultInput\\|Sin\\|Cos\\|Pi\\|Addr\\|Print\\|BitChg\\|BlitzKeys\\|BitMapOutput\\|ReadFile\\|FileInput\\|MOD\\|Macro\\)\\>"
             (0 'font-lock-keyword-face nil))

            ("[&|]"
             (0 'font-lock-keyword-face nil))

            ("#[a-zA-Z_]*"
             (0 'fg:white nil))

            ("\\<Data[a-z.$]?"
             (0 'font-lock-keyword-face nil))

            ("AvailMem_\\|ASR\\|ASL\\|Mki\\$\\|RawStatus\\|Inkey[$]\\|ShapeWidth\\|ShapeHeight\\|LoadView_\\|OpenWorkBench_\\|CloseWorkBench_"
             (0 'font-lock-keyword-face nil))

            ("\\<\\(SetErr\\|End SetErr\\)\\>"
             (0 'font-lock-keyword-face t))

;;            ("\\([^a-zA-Z_]\\|^\\)\\([A-Z][a-zA-Z_]*\\)\\([^a-zA-Z_]\\|$\\)"
;;             (2 'font-lock-keyword-face t))

            ("\\<\\(CNIF\\|CELSE\\|CEND\\)\\>"
             (0 'fg:yellow t))

            ("^[.]?[a-zA-Z_0-9]+[ \t]*$"
             (0 'fg:green nil))

            ("\\.[bwl]"
             (0 'font-lock-type-face t))

            ))

    (make-local-variable 'font-lock-defaults)
    (setq font-lock-defaults '(bbasic-mode-font-lock-keywords nil))

    (font-lock-mode 3)


    ))

(provide 'd-bbasic)
;;; d-bbasic.el ends here
