/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.Interpreter;
import gnu.expr.Special;
import gnu.kawa.functions.Convert;
import gnu.kawa.functions.DisplayFormat;
import gnu.kawa.functions.IsEq;
import gnu.kawa.functions.IsEqual;
import gnu.kawa.functions.IsEqv;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.kawa.lispexpr.LispInterpreter;
import gnu.kawa.lispexpr.LispReader;
import gnu.kawa.lispexpr.ReaderParens;
import gnu.kawa.lispexpr.ScmRead;
import gnu.kawa.reflect.InstanceOf;
import gnu.kawa.reflect.Invoke;
import gnu.lists.FormatToConsumer;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.Named;
import gnu.mapping.WrappedException;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import kawa.lang.AutoloadProcedure;
import kawa.lang.AutoloadSyntax;
import kawa.lang.Eval;
import kawa.lang.Lambda;
import kawa.lang.Quote;
import kawa.lang.Syntax;
import kawa.repl;
import kawa.standard.ScmEnv;
import kawa.standard.and_or;
import kawa.standard.begin;
import kawa.standard.define;
import kawa.standard.define_alias;
import kawa.standard.define_autoload;
import kawa.standard.define_class;
import kawa.standard.define_member_alias;
import kawa.standard.define_syntax;
import kawa.standard.define_unit;
import kawa.standard.define_variable;
import kawa.standard.let_syntax;
import kawa.standard.map;
import kawa.standard.not;
import kawa.standard.object;
import kawa.standard.prim_method;
import kawa.standard.readchar;
import kawa.standard.require;
import kawa.standard.syntax_case;
import kawa.standard.syntax_rules;

public class Scheme
extends LispInterpreter {
    public static Environment nullEnvironment;
    static Environment r4Environment;
    static Environment r5Environment;
    protected static Environment kawaEnvironment;
    public static LangPrimType booleanType;
    static Scheme instance;
    public static InstanceOf instanceOf;
    public static not not;
    public static map map;
    public static map forEach;
    public static IsEq isEq;
    public static IsEqv isEqv;
    public static IsEqual isEqual;
    static int scheme_counter;
    public static final DisplayFormat writeFormat;
    public static final DisplayFormat displayFormat;
    static Hashtable types;

    protected void define_proc(Named named) {
        this.define(named.getName(), named);
    }

    protected void define_proc(String string, Named named) {
        if (named.getName() == null) {
            named.setName(string);
        }
        this.define(string, named);
    }

    protected void define_proc(String string, String string2) {
        this.define(string, new AutoloadProcedure(string, string2, this.environ));
    }

    protected void define_syntax(String string, Syntax syntax2) {
        if (syntax2.getName() == null) {
            syntax2.setName(string);
        }
        this.define(string, syntax2);
    }

    protected void define_syntax(String string, String string2) {
        this.define(string, new AutoloadSyntax(string, string2, this.environ));
    }

    public static Scheme getInstance() {
        if (kawaEnvironment == null) {
            new Scheme();
        }
        return instance;
    }

    public static synchronized Environment builtin() {
        if (kawaEnvironment == null) {
            new Scheme();
        }
        return kawaEnvironment;
    }

    public void initScheme() {
        nullEnvironment = new Environment();
        nullEnvironment.setName("null-environment");
        this.environ = nullEnvironment;
        Lambda lambda2 = new Lambda();
        lambda2.setKeywords(Special.optional, Special.rest, Special.key);
        this.define_syntax("lambda", lambda2);
        this.define("quote", new Quote());
        this.define_syntax("define", new define(lambda2, false));
        this.define_syntax("define-private", new define(lambda2, true));
        this.define_syntax("define-constant", new define(lambda2, false, true));
        this.define_syntax("define-autoload", new define_autoload(false));
        this.define_syntax("define-autoloads-from-file", new define_autoload(true));
        this.define_syntax("if", "kawa.standard.ifp");
        this.define_syntax("set!", "kawa.standard.set_b");
        this.define_syntax("cond", "kawa.lib.std_syntax");
        this.define_syntax("case", "kawa.lib.std_syntax");
        this.define_syntax("and", "kawa.lib.std_syntax");
        this.define("or", new and_or(false, this));
        this.define_field("%let", "kawa.standard.let", "let");
        this.define_syntax("let", "kawa.lib.std_syntax");
        this.define_syntax("%let-decl", "kawa.lib.std_syntax");
        this.define_syntax("%let-init", "kawa.lib.std_syntax");
        this.define_syntax("let*", "kawa.lib.std_syntax");
        this.define_syntax("letrec", "kawa.standard.letrec");
        this.define("begin", new begin());
        this.define_syntax("do", "kawa.lib.std_syntax");
        this.define_syntax("delay", "kawa.lib.std_syntax");
        this.define_proc("%make-promise", "kawa.lib.std_syntax");
        this.define_syntax("quasiquote", "kawa.standard.quasiquote");
        this.define("define-syntax", new define_syntax());
        this.define("syntax-rules", new syntax_rules());
        this.define("syntax-case", new syntax_case());
        this.define("let-syntax", new let_syntax(false));
        this.define("letrec-syntax", new let_syntax(true));
        r4Environment = new Environment(nullEnvironment);
        r4Environment.setName("r4rs-environment");
        this.environ = r4Environment;
        this.define_field("not", "kawa.standard.Scheme");
        this.define_proc("boolean?", "kawa.lib.misc");
        this.define_field("eq?", "kawa.standard.Scheme", "isEq");
        this.define_field("eqv?", "kawa.standard.Scheme", "isEqv");
        this.define_field("equal?", "kawa.standard.Scheme", "isEqual");
        this.define_proc("pair?", "kawa.lib.lists");
        this.define_field("cons", "kawa.lib.lists");
        this.define_field("car", "kawa.lib.lists");
        this.define_field("cdr", "kawa.lib.lists");
        this.define_proc("set-car!", "kawa.lib.lists");
        this.define_proc("set-cdr!", "kawa.lib.lists");
        this.define_proc("caar", "kawa.standard.cxr");
        this.define_proc("cadr", "kawa.standard.cxr");
        this.define_proc("cdar", "kawa.standard.cxr");
        this.define_proc("cddr", "kawa.standard.cxr");
        this.define_proc("caaar", "kawa.standard.cxr");
        this.define_proc("caadr", "kawa.standard.cxr");
        this.define_proc("cadar", "kawa.standard.cxr");
        this.define_proc("caddr", "kawa.standard.cxr");
        this.define_proc("cdaar", "kawa.standard.cxr");
        this.define_proc("cdadr", "kawa.standard.cxr");
        this.define_proc("cddar", "kawa.standard.cxr");
        this.define_proc("cdddr", "kawa.standard.cxr");
        this.define_proc("caaaar", "kawa.standard.cxr");
        this.define_proc("caaadr", "kawa.standard.cxr");
        this.define_proc("caadar", "kawa.standard.cxr");
        this.define_proc("caaddr", "kawa.standard.cxr");
        this.define_proc("cadaar", "kawa.standard.cxr");
        this.define_proc("cadadr", "kawa.standard.cxr");
        this.define_proc("caddar", "kawa.standard.cxr");
        this.define_proc("cadddr", "kawa.standard.cxr");
        this.define_proc("cdaaar", "kawa.standard.cxr");
        this.define_proc("cdaadr", "kawa.standard.cxr");
        this.define_proc("cdadar", "kawa.standard.cxr");
        this.define_proc("cdaddr", "kawa.standard.cxr");
        this.define_proc("cddaar", "kawa.standard.cxr");
        this.define_proc("cddadr", "kawa.standard.cxr");
        this.define_proc("cdddar", "kawa.standard.cxr");
        this.define_proc("cddddr", "kawa.standard.cxr");
        this.define_proc("null?", "kawa.lib.lists");
        this.define_field("list?", "kawa.lib.lists");
        this.define_field("list", "gnu.kawa.functions.MakeList");
        this.define_proc("length", "kawa.lib.lists");
        this.define_proc("append", "kawa.standard.append");
        this.define_proc("reverse", "kawa.lib.lists");
        this.define_proc("reverse!", "kawa.lib.lists");
        this.define_field("list-tail", "kawa.lib.lists");
        this.define_field("list-ref", "kawa.lib.lists");
        this.define_field("memq", "kawa.lib.lists");
        this.define_field("memv", "kawa.lib.lists");
        this.define_field("member", "kawa.lib.lists");
        this.define_field("assq", "kawa.lib.lists");
        this.define_field("assv", "kawa.lib.lists");
        this.define_field("assoc", "kawa.lib.lists");
        this.define_proc("symbol?", "kawa.lib.misc");
        this.define_proc("symbol->string", "kawa.lib.misc");
        this.define_proc("string->symbol", "kawa.lib.misc");
        this.define_proc("number?", "kawa.lib.numbers");
        this.define_proc("quantity?", "kawa.lib.numbers");
        this.define_proc("complex?", "kawa.lib.numbers");
        this.define_proc("real?", "kawa.lib.numbers");
        this.define_proc("rational?", "kawa.lib.numbers");
        this.define_proc("integer?", "kawa.standard.integer_p");
        this.define_field("exact?", "kawa.lib.numbers");
        this.define_field("inexact?", "kawa.lib.numbers");
        this.define_field("=", "gnu.kawa.functions.NumberCompare", "$Eq");
        this.define_field("<", "gnu.kawa.functions.NumberCompare", "$Ls");
        this.define_field(">", "gnu.kawa.functions.NumberCompare", "$Gr");
        this.define_field("<=", "gnu.kawa.functions.NumberCompare", "$Ls$Eq");
        this.define_field(">=", "gnu.kawa.functions.NumberCompare", "$Gr$Eq");
        this.define_proc("zero?", "kawa.lib.numbers");
        this.define_proc("positive?", "kawa.standard.positive_p");
        this.define_proc("negative?", "kawa.lib.numbers");
        this.define_proc("odd?", "kawa.lib.numbers");
        this.define_proc("even?", "kawa.lib.numbers");
        this.define_proc("max", "kawa.standard.max");
        this.define_proc("min", "kawa.standard.min");
        this.define_field("+", "gnu.kawa.functions.AddOp", "$Pl");
        this.define_field("-", "gnu.kawa.functions.AddOp", "$Mn");
        this.define_field("*", "gnu.kawa.functions.MultiplyOp", "$St");
        this.define_field("/", "gnu.kawa.functions.DivideOp", "$Sl");
        this.define_proc("abs", "kawa.lib.numbers");
        this.define_proc("quotient", "kawa.lib.numbers");
        this.define_proc("remainder", "kawa.lib.numbers");
        this.define_proc("modulo", "kawa.standard.modulo");
        this.define_proc("gcd", "kawa.standard.gcd");
        this.define_proc("lcm", "kawa.standard.lcm");
        this.define_proc("numerator", "kawa.lib.numbers");
        this.define_proc("denominator", "kawa.lib.numbers");
        this.define_proc("floor", "kawa.lib.numbers");
        this.define_proc("ceiling", "kawa.lib.numbers");
        this.define_proc("truncate", "kawa.lib.numbers");
        this.define_proc("round", "kawa.lib.numbers");
        this.define_proc("rationalize", "kawa.standard.rationalize");
        this.define_proc("exp", "kawa.lib.numbers");
        this.define_proc("log", "kawa.lib.numbers");
        this.define_proc("sin", "kawa.lib.numbers");
        this.define_proc("cos", "kawa.lib.numbers");
        this.define_proc("tan", "kawa.lib.numbers");
        this.define_proc("asin", "kawa.lib.numbers");
        this.define_proc("acos", "kawa.lib.numbers");
        this.define_proc("atan", "kawa.standard.atan");
        this.define_proc("sqrt", "kawa.standard.sqrt");
        this.define_field("expt", "kawa.standard.expt");
        this.define_proc("make-rectangular", "kawa.lib.numbers");
        this.define_proc("make-polar", "kawa.lib.numbers");
        this.define_proc("real-part", "kawa.lib.numbers");
        this.define_proc("imag-part", "kawa.lib.numbers");
        this.define_proc("magnitude", "kawa.lib.numbers");
        this.define_proc("angle", "kawa.lib.numbers");
        this.define_proc("exact->inexact", "kawa.standard.exact2inexact");
        this.define_proc("inexact->exact", "kawa.standard.inexact2exact");
        this.define_proc("number->string", "kawa.lib.numbers");
        this.define_proc("string->number", "kawa.standard.string2number");
        this.define_proc("char?", "kawa.lib.characters");
        this.define_proc("char=?", "kawa.lib.characters");
        this.define_proc("char<?", "kawa.lib.characters");
        this.define_proc("char>?", "kawa.lib.characters");
        this.define_proc("char<=?", "kawa.lib.characters");
        this.define_proc("char>=?", "kawa.lib.characters");
        this.define_proc("char-ci=?", "kawa.lib.characters");
        this.define_proc("char-ci<?", "kawa.lib.characters");
        this.define_proc("char-ci>?", "kawa.lib.characters");
        this.define_proc("char-ci<=?", "kawa.lib.characters");
        this.define_proc("char-ci>=?", "kawa.lib.characters");
        this.define_proc("char-alphabetic?", "kawa.lib.characters");
        this.define_proc("char-numeric?", "kawa.lib.characters");
        this.define_proc("char-whitespace?", "kawa.lib.characters");
        this.define_proc("char-upper-case?", "kawa.lib.characters");
        this.define_proc("char-lower-case?", "kawa.lib.characters");
        this.define_proc("char->integer", "kawa.lib.characters");
        this.define_proc("integer->char", "kawa.lib.characters");
        this.define_proc("char-upcase", "kawa.lib.characters");
        this.define_proc("char-downcase", "kawa.lib.characters");
        this.define_proc("string?", "kawa.lib.strings");
        this.define_proc("make-string", "kawa.lib.strings");
        this.define_proc("string", "kawa.standard.string_v");
        this.define_proc("string-length", "kawa.lib.strings");
        this.define_proc("string-ref", "kawa.lib.strings");
        this.define_proc("string-set!", "kawa.lib.strings");
        this.define_field("string=?", "kawa.lib.strings");
        this.define_field("string-ci=?", "kawa.lib.strings");
        this.define_field("string<?", "kawa.lib.strings");
        this.define_field("string>?", "kawa.lib.strings");
        this.define_field("string<=?", "kawa.lib.strings");
        this.define_field("string>=?", "kawa.lib.strings");
        this.define_field("string-ci<?", "kawa.lib.strings");
        this.define_field("string-ci>?", "kawa.lib.strings");
        this.define_field("string-ci<=?", "kawa.lib.strings");
        this.define_field("string-ci>=?", "kawa.lib.strings");
        this.define_proc("substring", "kawa.lib.strings");
        this.define_proc("string-append", "kawa.standard.string_append");
        this.define_field("string->list", "kawa.lib.strings");
        this.define_field("list->string", "kawa.lib.strings");
        this.define_proc("string-copy", "kawa.lib.strings");
        this.define_proc("string-fill!", "kawa.lib.strings");
        this.define_proc("vector?", "kawa.lib.vectors");
        this.define_proc("make-vector", "kawa.lib.vectors");
        this.define_proc("vector", "kawa.lib.vectors");
        this.define_proc("vector-length", "kawa.lib.vectors");
        this.define_field("vector-ref", "kawa.lib.vectors");
        this.define_proc("vector-set!", "kawa.lib.vectors");
        this.define_proc("list->vector", "kawa.lib.vectors");
        this.define_field("vector->list", "kawa.lib.vectors");
        this.define_proc("vector-fill!", "kawa.lib.vectors");
        this.define_field("vector-append", "kawa.standard.vector_append", "vectorAppend");
        this.define_proc("values-append", "gnu.kawa.functions.AppendValues");
        this.define_proc("procedure?", "kawa.lib.misc");
        this.define_field("apply", "gnu.kawa.functions.Apply", "apply");
        this.define_field("map", "kawa.standard.Scheme", "map");
        this.define_field("for-each", "kawa.standard.Scheme", "forEach");
        this.define_proc("call-with-current-continuation", "kawa.standard.callcc");
        this.define_proc("call/cc", "kawa.standard.callcc");
        this.define_proc("force", "kawa.standard.force");
        this.define_proc("call-with-input-file", "kawa.standard.call_with_input_file");
        this.define_proc("call-with-output-file", "kawa.standard.call_with_output_file");
        this.define_proc("input-port?", "kawa.lib.ports");
        this.define_proc("output-port?", "kawa.lib.ports");
        this.define_proc("current-input-port", "kawa.lib.ports");
        this.define_proc("current-output-port", "kawa.lib.ports");
        this.define_proc("with-input-from-file", "kawa.standard.with_input_from_file");
        this.define_proc("with-output-to-file", "kawa.standard.with_output_to_file");
        this.define_proc("open-input-file", "kawa.standard.open_input_file");
        this.define_proc("open-output-file", "kawa.standard.open_output_file");
        this.define_proc("close-input-port", "kawa.lib.ports");
        this.define_proc("close-output-port", "kawa.lib.ports");
        this.define_proc("read", "kawa.standard.read");
        this.define_proc("read-line", "kawa.standard.read_line");
        this.define_proc(new readchar(false));
        this.define_proc(new readchar(true));
        this.define_proc("eof-object?", "kawa.lib.ports");
        this.define_proc("char-ready?", "kawa.standard.char_ready_p");
        this.define_field("write", "kawa.standard.Scheme", "writeFormat");
        this.define_field("display", "kawa.standard.Scheme", "displayFormat");
        this.define_field("print-as-xml", "gnu.xquery.lang.XQuery", "writeFormat");
        this.define_proc("write-char", "kawa.lib.ports");
        this.define_proc("newline", "kawa.lib.ports");
        this.define_field("load", "kawa.standard.load", "load");
        this.define_field("load-relative", "kawa.standard.load", "loadRelative");
        this.define_proc("transcript-off", "kawa.lib.ports");
        this.define_proc("transcript-on", "kawa.lib.ports");
        this.define_proc("call-with-input-string", "kawa.lib.ports");
        this.define_proc("open-input-string", "kawa.lib.ports");
        this.define_proc("open-output-string", "kawa.lib.ports");
        this.define_proc("get-output-string", "kawa.lib.ports");
        this.define_proc("call-with-output-string", "kawa.standard.call_with_output_string");
        this.define_proc("force-output", "kawa.lib.ports");
        this.define_field("port-line", "kawa.lib.ports");
        this.define_field("set-port-line!", "kawa.lib.ports");
        this.define_field("port-column", "kawa.lib.ports");
        this.define_field("current-error-port", "kawa.lib.ports");
        this.define_proc("input-port-line-number", "kawa.lib.ports");
        this.define_proc("set-input-port-line-number!", "kawa.lib.ports");
        this.define_proc("input-port-column-number", "kawa.lib.ports");
        this.define_proc("input-port-read-state", "kawa.lib.ports");
        this.define_proc("default-prompter", "kawa.lib.ports");
        this.define_field("input-port-prompter", "kawa.lib.ports");
        this.define_proc("set-input-port-prompter!", "kawa.lib.ports");
        this.define_field("base-uri", "kawa.lib.misc");
        this.define_syntax("%syntax-error", "kawa.standard.syntax_error");
        r5Environment = new Environment(r4Environment);
        r5Environment.setName("r5rs-environment");
        this.environ = r5Environment;
        this.define_proc("values", "kawa.lib.misc");
        this.define_proc("call-with-values", "kawa.standard.call_with_values");
        this.define_field("let-values", "kawa.lib.syntax");
        this.define_field("let*-values", "kawa.lib.syntax");
        this.define_field("receive", "kawa.lib.syntax");
        this.define_proc("eval", "kawa.lang.Eval");
        this.define_proc("repl", new repl(this));
        this.define_proc("scheme-report-environment", "kawa.standard.scheme_env");
        this.define_proc("null-environment", "kawa.lib.misc");
        this.define_proc("interaction-environment", "kawa.lib.misc");
        this.define_proc("dynamic-wind", "kawa.lib.syntax");
        this.environ = kawaEnvironment = new Environment(r5Environment);
        this.define_proc("exit", "kawa.lib.thread");
        this.define_field("arithmetic-shift", "kawa.lib.numbers");
        this.define_field("ash", "kawa.lib.numbers");
        this.define_proc("logand", "kawa.standard.logand");
        this.define_proc("logior", "kawa.standard.logior");
        this.define_proc("logxor", "kawa.standard.logxor");
        this.define_proc("lognot", "kawa.lib.numbers");
        this.define_proc("logop", "kawa.lib.numbers");
        this.define_proc("logbit?", "kawa.lib.numbers");
        this.define_proc("logtest", "kawa.lib.numbers");
        this.define_proc("logcount", "kawa.lib.numbers");
        this.define_proc("bit-extract", "kawa.lib.numbers");
        this.define_proc("integer-length", "kawa.lib.numbers");
        this.define_proc("string-upcase!", "kawa.lib.strings");
        this.define_proc("string-downcase!", "kawa.lib.strings");
        this.define_proc("string-capitalize!", "kawa.lib.strings");
        this.define_proc("string-upcase", "kawa.lib.strings");
        this.define_proc("string-downcase", "kawa.lib.strings");
        this.define_proc("string-capitalize", "kawa.lib.strings");
        this.define_syntax("primitive-virtual-method", new prim_method(182));
        this.define_syntax("primitive-static-method", new prim_method(184));
        this.define_syntax("primitive-interface-method", new prim_method(185));
        this.define_syntax("primitive-constructor", new prim_method(183));
        this.define_syntax("primitive-op1", new prim_method());
        this.define_syntax("primitive-get-field", "kawa.lib.reflection");
        this.define_syntax("primitive-set-field", "kawa.lib.reflection");
        this.define_syntax("primitive-get-static", "kawa.lib.reflection");
        this.define_syntax("primitive-set-static", "kawa.lib.reflection");
        this.define_syntax("primitive-array-new", "kawa.lib.reflection");
        this.define_syntax("primitive-array-get", "kawa.lib.reflection");
        this.define_syntax("primitive-array-set", "kawa.lib.reflection");
        this.define_syntax("primitive-array-length", "kawa.lib.reflection");
        this.define_proc("subtype?", "kawa.lib.reflection");
        this.define_field("primitive-throw", "kawa.standard.prim_throw", "primitiveThrow");
        this.define_syntax("try-finally", "kawa.standard.try_finally");
        this.define_syntax("try-catch", "kawa.standard.try_catch");
        this.define_proc("throw", "kawa.standard.throw_name");
        this.define_proc("catch", "kawa.lib.syntax");
        this.define_proc("error", "kawa.lib.misc");
        this.define_proc("as", Convert.as);
        this.define_field("instance?", "kawa.standard.Scheme", "instanceOf");
        this.define_syntax("synchronized", "kawa.standard.synchronizd");
        object object2 = new object(lambda2);
        this.define_syntax("object", object2);
        this.define_syntax("define-class", new define_class(object2, false));
        this.define_syntax("define-simple-class", new define_class(object2, true));
        this.define_syntax("this", "kawa.standard.thisRef");
        this.define_proc("make", Invoke.make);
        this.define_field("slot-ref", "gnu.kawa.reflect.SlotGet", "field");
        this.define_field("slot-set!", "gnu.kawa.reflect.SlotSet", "setField$Ex");
        this.define_field("field", "gnu.kawa.reflect.SlotGet");
        this.define_proc("class-methods", "gnu.kawa.reflect.ClassMethods");
        this.define_field("static-field", "gnu.kawa.reflect.SlotGet", "staticField");
        this.define_proc("invoke", Invoke.invoke);
        this.define_field("invoke-static", "gnu.kawa.reflect.Invoke", "invokeStatic");
        this.define_proc("file-exists?", "kawa.lib.files");
        this.define_proc("file-directory?", "kawa.lib.files");
        this.define_proc("file-readable?", "kawa.lib.files");
        this.define_proc("file-writable?", "kawa.lib.files");
        this.define_proc("delete-file", "kawa.lib.files");
        this.define_proc("system-tmpdir", "kawa.lib.files");
        this.define_proc("make-temporary-file", "kawa.lib.files");
        this.define_proc("rename-file", "kawa.lib.files");
        this.define_proc("copy-file", "kawa.lib.files");
        this.define_proc("create-directory", "kawa.lib.files");
        this.define_proc("->pathname", "kawa.lib.files");
        this.define("port-char-encoding", Boolean.TRUE);
        this.define("symbol-read-case", "P");
        this.define_proc("system", "kawa.lib.system");
        this.define_proc("make-process", "kawa.lib.system");
        this.define_proc("tokenize-string-to-string-array", "kawa.lib.system");
        this.define_proc("tokenize-string-using-shell", "kawa.lib.system");
        if ("/".equals(System.getProperty("file.separator"))) {
            this.define("command-parse", this.lookup("tokenize-string-using-shell"));
        } else {
            this.define("command-parse", this.lookup("tokenize-string-to-string-array"));
        }
        this.define_proc("record-accessor", "kawa.lib.reflection");
        this.define_proc("record-modifier", "kawa.lib.reflection");
        this.define_proc("record-predicate", "kawa.lib.reflection");
        this.define_proc("record-constructor", "kawa.lib.reflection");
        this.define_proc("make-record-type", "kawa.lib.reflection");
        this.define_proc("record-type-descriptor", "kawa.lib.reflection");
        this.define_proc("record-type-name", "kawa.lib.reflection");
        this.define_proc("record-type-field-names", "kawa.lib.reflection");
        this.define_proc("record?", "kawa.lib.reflection");
        this.define_syntax("define-record-type", "gnu.kawa.slib.DefineRecordType");
        this.define_syntax("when", "kawa.lib.syntax");
        this.define_syntax("unless", "kawa.lib.syntax");
        this.define_syntax("fluid-let", "kawa.standard.fluid_let");
        this.define_syntax("constant-fold", "kawa.standard.constant_fold");
        this.define_proc("compile-file", "kawa.lang.CompileFile");
        this.define_proc("load-compiled", "kawa.lang.loadcompiled");
        this.define_proc("environment-bound?", "kawa.lib.misc");
        this.define_proc("scheme-implementation-version", "kawa.lib.misc");
        this.define_proc("scheme-window", "kawa.lib.windows");
        this.define_syntax("define-procedure", "kawa.lib.syntax");
        this.define_field("make-procedure", "gnu.kawa.functions.MakeProcedure", "makeProcedure");
        this.define_field("procedure-property", "kawa.lib.misc");
        this.define_proc("set-procedure-property!", "kawa.lib.misc");
        this.define_proc("quantity->number", "kawa.standard.quantity2number");
        this.define_proc("quantity->unit", "kawa.standard.quantity2unit");
        this.define_proc("make-quantity", "kawa.standard.make_quantity");
        this.define_syntax("define-unit", new define_unit(false));
        this.define_syntax("define-namespace", "gnu.kawa.xml.DefineNamespace");
        this.define_syntax("define-base-unit", new define_unit(true));
        this.define_proc("gentemp", "kawa.lib.syntax");
        this.define_syntax("defmacro", "kawa.lib.syntax");
        this.define_field("setter", "gnu.kawa.functions.Setter", "setter");
        this.define_syntax("future", "kawa.lib.thread");
        this.define_proc("%make-future", "kawa.standard.make_future");
        this.define_proc("sleep", "kawa.standard.sleep");
        this.define_syntax("trace", "kawa.lib.trace");
        this.define_syntax("untrace", "kawa.lib.trace");
        this.define_field("format", "gnu.kawa.functions.Format");
        this.define_field("parse-format", "gnu.kawa.functions.ParseFormat", "parseFormat");
        this.define_field("make-element", "gnu.xquery.util.MakeElement", "makeElement");
        this.define_field("make-attribute", "gnu.xquery.util.MakeAttribute", "makeAttribute");
        this.define_field("map-values", "gnu.kawa.functions.ValuesMap", "valuesMap");
        this.define_field("children", "gnu.xquery.util.Children", "children");
        this.define_field("attributes", "gnu.kawa.xml.Attributes");
        this.define_field("unescaped-data", "gnu.kawa.xml.MakeUnescapedData", "unescapedData");
        this.define_proc("keyword?", "kawa.lib.keywords");
        this.define_proc("keyword->string", "kawa.lib.keywords");
        this.define_proc("string->keyword", "kawa.lib.keywords");
        this.define_syntax("location", "kawa.standard.location");
        this.define("define-alias", new define_alias());
        this.define("define-variable", new define_variable());
        this.define("define-member-alias", new define_member_alias());
        this.define("require", new require());
        this.define_syntax("module-name", "kawa.standard.module_name");
        this.define_syntax("module-extends", "kawa.standard.module_extends");
        this.define_syntax("module-implements", "kawa.standard.module_implements");
        this.define_syntax("module-static", "kawa.standard.module_static");
        this.define_syntax("module-export", "kawa.standard.export");
        this.define_field("array?", "kawa.lib.arrays");
        this.define_field("array-rank", "kawa.lib.arrays");
        this.define_field("make-array", "kawa.lib.arrays");
        this.define_field("array", "kawa.lib.arrays");
        this.define_field("array-start", "kawa.lib.arrays");
        this.define_field("array-end", "kawa.lib.arrays");
        this.define_field("shape", "kawa.lib.arrays");
        this.define_field("array-ref", "gnu.kawa.functions.ArrayRef", "arrayRef");
        this.define_field("array-set!", "gnu.kawa.functions.ArraySet", "arraySet");
        this.define_field("share-array", "kawa.lib.arrays");
        this.define_proc("s8vector?", "kawa.lib.uniform");
        this.define_proc("make-s8vector", "kawa.lib.uniform");
        this.define_proc("s8vector", "kawa.lib.uniform");
        this.define_proc("s8vector-length", "kawa.lib.uniform");
        this.define_proc("s8vector-ref", "kawa.lib.uniform");
        this.define_proc("s8vector-set!", "kawa.lib.uniform");
        this.define_proc("s8vector->list", "kawa.lib.uniform");
        this.define_proc("list->s8vector", "kawa.lib.uniform");
        this.define_proc("u8vector?", "kawa.lib.uniform");
        this.define_proc("make-u8vector", "kawa.lib.uniform");
        this.define_proc("u8vector", "kawa.lib.uniform");
        this.define_proc("u8vector-length", "kawa.lib.uniform");
        this.define_proc("u8vector-ref", "kawa.lib.uniform");
        this.define_proc("u8vector-set!", "kawa.lib.uniform");
        this.define_proc("u8vector->list", "kawa.lib.uniform");
        this.define_proc("list->u8vector", "kawa.lib.uniform");
        this.define_proc("s16vector?", "kawa.lib.uniform");
        this.define_proc("make-s16vector", "kawa.lib.uniform");
        this.define_proc("s16vector", "kawa.lib.uniform");
        this.define_proc("s16vector-length", "kawa.lib.uniform");
        this.define_proc("s16vector-ref", "kawa.lib.uniform");
        this.define_proc("s16vector-set!", "kawa.lib.uniform");
        this.define_proc("s16vector->list", "kawa.lib.uniform");
        this.define_proc("list->s16vector", "kawa.lib.uniform");
        this.define_proc("u16vector?", "kawa.lib.uniform");
        this.define_proc("make-u16vector", "kawa.lib.uniform");
        this.define_proc("u16vector", "kawa.lib.uniform");
        this.define_proc("u16vector-length", "kawa.lib.uniform");
        this.define_proc("u16vector-ref", "kawa.lib.uniform");
        this.define_proc("u16vector-set!", "kawa.lib.uniform");
        this.define_proc("u16vector->list", "kawa.lib.uniform");
        this.define_proc("list->u16vector", "kawa.lib.uniform");
        this.define_proc("s32vector?", "kawa.lib.uniform");
        this.define_proc("make-s32vector", "kawa.lib.uniform");
        this.define_proc("s32vector", "kawa.lib.uniform");
        this.define_proc("s32vector-length", "kawa.lib.uniform");
        this.define_proc("s32vector-ref", "kawa.lib.uniform");
        this.define_proc("s32vector-set!", "kawa.lib.uniform");
        this.define_proc("s32vector->list", "kawa.lib.uniform");
        this.define_proc("list->s32vector", "kawa.lib.uniform");
        this.define_proc("u32vector?", "kawa.lib.uniform");
        this.define_proc("make-u32vector", "kawa.lib.uniform");
        this.define_proc("u32vector", "kawa.lib.uniform");
        this.define_proc("u32vector-length", "kawa.lib.uniform");
        this.define_proc("u32vector-ref", "kawa.lib.uniform");
        this.define_proc("u32vector-set!", "kawa.lib.uniform");
        this.define_proc("u32vector->list", "kawa.lib.uniform");
        this.define_proc("list->u32vector", "kawa.lib.uniform");
        this.define_proc("s64vector?", "kawa.lib.uniform");
        this.define_proc("make-s64vector", "kawa.lib.uniform");
        this.define_proc("s64vector", "kawa.lib.uniform");
        this.define_proc("s64vector-length", "kawa.lib.uniform");
        this.define_proc("s64vector-ref", "kawa.lib.uniform");
        this.define_proc("s64vector-set!", "kawa.lib.uniform");
        this.define_proc("s64vector->list", "kawa.lib.uniform");
        this.define_proc("list->s64vector", "kawa.lib.uniform");
        this.define_proc("u64vector?", "kawa.lib.uniform");
        this.define_proc("make-u64vector", "kawa.lib.uniform");
        this.define_proc("u64vector", "kawa.lib.uniform");
        this.define_proc("u64vector-length", "kawa.lib.uniform");
        this.define_proc("u64vector-ref", "kawa.lib.uniform");
        this.define_proc("u64vector-set!", "kawa.lib.uniform");
        this.define_proc("u64vector->list", "kawa.lib.uniform");
        this.define_proc("list->u64vector", "kawa.lib.uniform");
        this.define_proc("f32vector?", "kawa.lib.uniform");
        this.define_proc("make-f32vector", "kawa.lib.uniform");
        this.define_proc("f32vector", "kawa.lib.uniform");
        this.define_proc("f32vector-length", "kawa.lib.uniform");
        this.define_proc("f32vector-ref", "kawa.lib.uniform");
        this.define_proc("f32vector-set!", "kawa.lib.uniform");
        this.define_proc("f32vector->list", "kawa.lib.uniform");
        this.define_proc("list->f32vector", "kawa.lib.uniform");
        this.define_proc("f64vector?", "kawa.lib.uniform");
        this.define_proc("make-f64vector", "kawa.lib.uniform");
        this.define_proc("f64vector", "kawa.lib.uniform");
        this.define_proc("f64vector-length", "kawa.lib.uniform");
        this.define_proc("f64vector-ref", "kawa.lib.uniform");
        this.define_proc("f64vector-set!", "kawa.lib.uniform");
        this.define_proc("f64vector->list", "kawa.lib.uniform");
        this.define_proc("list->f64vector", "kawa.lib.uniform");
        this.define_syntax("cut", "gnu.kawa.slib.cut");
        this.define_syntax("cute", "gnu.kawa.slib.cut");
        this.define_proc("emacs", "gnu.jemacs.buffer.emacs");
        this.define_proc("node", "gnu.kawa.xml.MakeTreeNode");
        this.define_syntax("%if-feature", "kawa.standard.IfFeature");
        this.define_syntax("cond-expand", "kawa.lib.syntax");
    }

    public Scheme() {
        if (Interpreter.defaultInterpreter == null) {
            Interpreter.defaultInterpreter = this;
        }
        this.environ = this.getNewEnvironment();
        if (instance == null) {
            instance = this;
            instanceOf = new InstanceOf(this, "instance?");
            not = new not(this, "not");
            map = new map(true);
            forEach = new map(false);
            isEq = new IsEq(this, "eq?");
            isEqv = new IsEqv(this, "eqv?");
            isEqual = new IsEqual(this, "equal?");
        }
    }

    public Scheme(Environment environment) {
        this.environ = environment;
    }

    public String getName() {
        return "Scheme";
    }

    public Environment getNewEnvironment() {
        if (kawaEnvironment == null) {
            this.initScheme();
        }
        ScmEnv scmEnv = new ScmEnv(kawaEnvironment);
        scmEnv.setName("interaction-environment." + ++scheme_counter);
        try {
            Class<?> clazz = Class.forName("gnu.kawa.xml.NamespaceEnv");
            Class[] classArray = new Class[]{Class.forName("gnu.mapping.Environment")};
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            Object[] objectArray = new Environment[]{scmEnv};
            scmEnv.addExtra((Environment)constructor.newInstance(objectArray));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return scmEnv;
    }

    public static Object eval(String string, Environment environment) {
        return Scheme.eval(new CharArrayInPort(string), environment);
    }

    public static Object eval(InPort inPort, Environment environment) {
        SourceMessages sourceMessages = new SourceMessages();
        try {
            LispReader lispReader = (LispReader)Interpreter.getInterpreter().getLexer(inPort, sourceMessages);
            Object object2 = ReaderParens.readList(lispReader, 0, 1, -1);
            if (sourceMessages.seenErrors()) {
                throw new SyntaxException(sourceMessages);
            }
            return Eval.evalBody(object2, environment, sourceMessages);
        }
        catch (SyntaxException syntaxException) {
            throw new RuntimeException("eval: errors while compiling:\n" + syntaxException.getMessages().toString(20));
        }
        catch (IOException iOException) {
            throw new RuntimeException("eval: I/O exception: " + iOException.toString());
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new WrappedException(throwable);
        }
    }

    public static Object eval(Object object2, Environment environment) {
        try {
            return Eval.eval(object2, environment);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new WrappedException(throwable);
        }
    }

    public Object read(InPort inPort) throws IOException, SyntaxException {
        return ScmRead.readObject(inPort);
    }

    public Lexer getLexer(InPort inPort, SourceMessages sourceMessages) {
        return new ScmRead(inPort, sourceMessages);
    }

    public FormatToConsumer getFormat(boolean bl) {
        return bl ? writeFormat : displayFormat;
    }

    public int getNamespaceOf(Declaration declaration) {
        return 3;
    }

    public static Type getTypeValue(Expression expression) {
        return Scheme.getInstance().getTypeFor(expression);
    }

    public static Type getNamedType(String string) {
        Type type;
        if (types == null) {
            booleanType = new LangPrimType(Type.boolean_type, Scheme.getInstance());
            types = new Hashtable();
            types.put("void", LangPrimType.voidType);
            types.put("int", LangPrimType.intType);
            types.put("char", LangPrimType.charType);
            types.put("boolean", booleanType);
            types.put("byte", LangPrimType.byteType);
            types.put("short", LangPrimType.shortType);
            types.put("long", LangPrimType.longType);
            types.put("float", LangPrimType.floatType);
            types.put("double", LangPrimType.doubleType);
            types.put("never-returns", Type.neverReturnsType);
            types.put("Object", Type.pointer_type);
            types.put("java.lang.Object", Type.pointer_type);
            types.put("String", Type.tostring_type);
            types.put("object", Type.pointer_type);
            types.put("number", ClassType.make("gnu.math.Numeric"));
            types.put("quantity", ClassType.make("gnu.math.Quantity"));
            types.put("complex", ClassType.make("gnu.math.Complex"));
            types.put("real", ClassType.make("gnu.math.RealNum"));
            types.put("rational", ClassType.make("gnu.math.RatNum"));
            types.put("integer", ClassType.make("gnu.math.IntNum"));
            types.put("symbol", ClassType.make("java.lang.String"));
            types.put("keyword", ClassType.make("gnu.expr.Keyword"));
            types.put("list", ClassType.make("gnu.lists.LList"));
            types.put("pair", ClassType.make("gnu.lists.Pair"));
            types.put("pair-with-position", ClassType.make("gnu.lists.PairWithPosition"));
            types.put("string", ClassType.make("gnu.lists.FString"));
            types.put("abstract-string", ClassType.make("gnu.lists.CharSeq"));
            types.put("character", ClassType.make("gnu.text.Char"));
            types.put("vector", ClassType.make("gnu.lists.FVector"));
            types.put("function", ClassType.make("gnu.mapping.Procedure"));
            types.put("procedure", ClassType.make("gnu.mapping.Procedure"));
            types.put("input-port", ClassType.make("gnu.mapping.InPort"));
            types.put("output-port", ClassType.make("gnu.mapping.OutPort"));
            types.put("string-output-port", ClassType.make("gnu.mapping.CharArrayOutPort"));
            types.put("record", ClassType.make("kawa.lang.Record"));
            types.put("type", ClassType.make("gnu.bytecode.Type"));
            types.put("class-type", ClassType.make("gnu.bytecode.ClassType"));
            types.put("s8vector", ClassType.make("gnu.lists.S8Vector"));
            types.put("u8vector", ClassType.make("gnu.lists.U8Vector"));
            types.put("s16vector", ClassType.make("gnu.lists.S16Vector"));
            types.put("u16vector", ClassType.make("gnu.lists.U16Vector"));
            types.put("s32vector", ClassType.make("gnu.lists.S32Vector"));
            types.put("u32vector", ClassType.make("gnu.lists.U32Vector"));
            types.put("s64vector", ClassType.make("gnu.lists.S64Vector"));
            types.put("u64vector", ClassType.make("gnu.lists.U64Vector"));
            types.put("f32vector", ClassType.make("gnu.lists.F32Vector"));
            types.put("f64vector", ClassType.make("gnu.lists.F64Vector"));
            types.put("document", ClassType.make("gnu.lists.TreeList"));
            types.put("readtable", ClassType.make("gnu.kawa.lispexpr.ReadTable"));
        }
        if ((type = (Type)types.get(string)) == null && (string.startsWith("elisp:") || string.startsWith("clisp:"))) {
            int n = string.indexOf(58);
            Class clazz = Scheme.getNamedType(string.substring(n + 1)).getReflectClass();
            String string2 = string.substring(0, n);
            Interpreter interpreter = Interpreter.getInstance(string2);
            if (interpreter == null) {
                throw new RuntimeException("unknown type '" + string + "' - unknown language '" + string2 + '\'');
            }
            type = interpreter.getTypeFor(clazz);
            if (type != null) {
                types.put(string, type);
            }
        }
        return type;
    }

    public Type getTypeFor(Class clazz) {
        String string = clazz.getName();
        if (clazz.isPrimitive()) {
            return Scheme.getNamedType(string);
        }
        if ("java.lang.String".equals(string)) {
            return Type.tostring_type;
        }
        return Type.make(clazz);
    }

    public static Type string2Type(String string) {
        Type type;
        if (string.endsWith("[]")) {
            type = Scheme.string2Type(string.substring(0, string.length() - 2));
            if (type != null) {
                type = ArrayType.make(type);
            }
        } else {
            type = Scheme.getNamedType(string);
        }
        if (type != null) {
            return type;
        }
        type = Interpreter.string2Type(string);
        if (type != null) {
            types.put(string, type);
        }
        return type;
    }

    public Type getTypeFor(String string) {
        return Scheme.string2Type(string);
    }

    public static Type exp2Type(Expression expression) {
        return Scheme.getInstance().getTypeFor(expression);
    }

    public static void registerEnvironment() {
        Scheme scheme = new Scheme();
        Interpreter.defaultInterpreter = scheme;
        Environment.setCurrent(scheme.getEnvironment());
    }

    static {
        scheme_counter = 0;
        writeFormat = new DisplayFormat(true, 'S');
        displayFormat = new DisplayFormat(false, 'S');
    }
}

