/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml;

import gnu.mapping.Symbol;
import gnu.xml.NamespaceBinding;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class XName
extends Symbol
implements Externalizable {
    NamespaceBinding namespaceNodes;

    public XName() {
    }

    public XName(Symbol symbol, NamespaceBinding namespaceNodes) {
        super(symbol.getNamespace(), symbol.getName());
        this.namespaceNodes = namespaceNodes;
    }

    public final NamespaceBinding getNamespaceNodes() {
        return this.namespaceNodes;
    }

    public final void setNamespaceNodes(NamespaceBinding nodes) {
        this.namespaceNodes = nodes;
    }

    String lookupNamespaceURI(String prefix) {
        NamespaceBinding ns = this.namespaceNodes;
        while (ns != null) {
            if (prefix == ns.prefix) {
                return ns.uri;
            }
            ns = ns.next;
        }
        return null;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.namespaceNodes);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.namespaceNodes = (NamespaceBinding)in.readObject();
    }

    public static boolean isNameStart(int ch) {
        return ch >= 65536 || Character.isLetter((char)ch) || ch == 95;
    }

    public static boolean isNamePart(int ch) {
        return ch >= 65536 || Character.isUnicodeIdentifierPart((char)ch) || ch == 45 || ch == 46;
    }

    public static boolean isName(String value) {
        return XName.isName(value, false);
    }

    public static boolean isName(String value, boolean prohibitColon) {
        int len = value.length();
        if (len == 0) {
            return false;
        }
        int i = 0;
        while (i < len) {
            int ch;
            boolean first = i == 0;
            if ((ch = value.charAt(i++)) >= 55296 && ch < 56320 && i < len) {
                ch = (ch - 55296) * 1024 + (value.charAt(i++) - 56320) + 65536;
            }
            if (!first ? XName.isNamePart(ch) : XName.isNameStart(ch)) continue;
            return false;
        }
        return true;
    }
}

