/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.io;

import gnu.kawa.io.InPort;
import gnu.kawa.io.OutPort;
import gnu.kawa.io.Path;
import gnu.mapping.Procedure;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class TtyInPort
extends InPort {
    protected OutPort tie;
    protected Procedure prompter;
    protected boolean promptEmitted;

    public Procedure getPrompter() {
        return this.prompter;
    }

    public void setPrompter(Procedure prompter) {
        this.prompter = prompter;
    }

    public TtyInPort(InputStream in, Path name, OutPort tie) {
        super(in, name);
        this.setConvertCR(true);
        this.tie = tie;
    }

    public TtyInPort(Reader in, Path name, OutPort tie) {
        super(in, name);
        this.setConvertCR(true);
        this.tie = tie;
    }

    @Override
    protected int fill(int len) throws IOException {
        int count = this.in.read(this.buffer, this.pos, len);
        if (this.tie != null && count > 0) {
            this.tie.echo(this.buffer, this.pos, count);
        }
        return count;
    }

    public void emitPrompt(String prompt) throws IOException {
        this.tie.print(prompt);
        this.tie.flush();
        this.tie.clearBuffer();
    }

    @Override
    public void lineStart(boolean revisited) throws IOException {
        if (!revisited) {
            if (this.tie != null) {
                this.tie.freshLine();
            }
            if (this.prompter != null) {
                try {
                    String string2;
                    Object prompt = this.prompter.apply1(this);
                    if (prompt != null && (string2 = prompt.toString()) != null && string2.length() > 0) {
                        this.emitPrompt(string2);
                        this.promptEmitted = true;
                    }
                }
                catch (Throwable ex) {
                    throw new IOException("Error when evaluating prompt:" + ex);
                }
            }
        }
    }

    @Override
    public int read() throws IOException {
        int ch;
        if (this.tie != null) {
            this.tie.flush();
        }
        if ((ch = super.read()) < 0 && this.promptEmitted & this.tie != null) {
            this.tie.println();
        }
        this.promptEmitted = false;
        return ch;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int count;
        if (this.tie != null) {
            this.tie.flush();
        }
        if ((count = super.read(cbuf, off, len)) < 0 && this.promptEmitted & this.tie != null) {
            this.tie.println();
        }
        this.promptEmitted = false;
        return count;
    }
}

