/*
 * Copyright (c) 1984,1985,1989,1994,1995,1996,1999  Mark Nudelman
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice in the documentation and/or other materials provided with 
 *    the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR 
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN 
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Silly little program to generate the help.c source file
 * from the less.hlp text file.
 * help.c just contains a char array whose contents are 
 * the contents of less.hlp.
 */

#include <stdio.h>

	int
main(argc, argv)
	int argc;
	char *argv[];
{
	int ch;
	int prevch;

	printf("/* This file was generated by mkhelp from less.hlp */\n");
	printf("#include \"less.h\"\n");
	printf("constant char helpdata[] = {\n");
	ch = 0;
	while (prevch = ch, (ch = getchar()) != EOF)
	{
		switch (ch)
		{
		case '\'':
			printf("'\\'',");
			break;
		case '\\':
			printf("'\\\\',");
			break;
		case '\b':
			printf("'\\b',");
			break;
		case '\t':
			printf("'\\t',");
			break;
		case '\n':
			if (prevch != '\r') 
				printf("'\\n',\n");
			break;
		case '\r':
			if (prevch != '\n') 
				printf("'\\n',\n");
			break;
		default:
			if (ch >= ' ' && ch < 0x7f)
				printf("'%c',", ch);
			else
				printf("0x%02x,", ch);
			break;
		}
	}
	/* Add an extra null char to avoid having a trailing comma. */
	printf(" 0 };\n");
	printf("constant int size_helpdata = sizeof(helpdata) - 1;\n");
	return (0);
}
