/* Copyright (C) 1997, 1999, 2000, 2001, 2002 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

#include <atomicity.h>
#include <stdlib.h>
#include <set-hooks.h>
#include <libc-internal.h>

#ifdef USE_IN_LIBIO
# include "../libio/libioP.h"
#endif

DEFINE_HOOK (__libc_subfreeres, (void));

void
__libc_freeres (void)
{
  /* This function might be called from different places.  So better
     protect for multiple executions since these are fatal.  */
  static long int already_called;

  if (compare_and_swap (&already_called, 0, 1))
    {
#ifdef USE_IN_LIBIO
      _IO_cleanup ();
#endif

      RUN_HOOK (__libc_subfreeres, ());
    }
}
libc_hidden_def (__libc_freeres)
