/* Support for single-thread optimizations.  Statically linked version.
   Copyright (C) 2020-2022 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <https://www.gnu.org/licenses/>.  */

#include <sys/single_threaded.h>

/* In dynamically linked programs, this variable is initialized in
   __libc_early_init (as false for inner libcs).  */
#ifdef SHARED
char __libc_single_threaded;
#else
char __libc_single_threaded = 1;
#endif
libc_hidden_data_def_alias (__libc_single_threaded,
			    __libc_single_threaded_internal)
