/**
 * GNU LibreJS - A browser add-on to block nonfree nontrivial JavaScript.
 * *
 * Copyright (C) 2014 Loic J. Duros
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see  <http://www.gnu.org/licenses/>.
 *
 */

const {Cc,Ci} = require('chrome');
var parser = Cc["@mozilla.org/xmlextras/domparser;1"]
    .createInstance(Ci.nsIDOMParser);

var WebLabelFinder = require('html_script_finder/web_labels/js_web_labels')
    .WebLabelFinder;

exports.testSearchForJsLinkEmpty = function (assert) {
    var finder = new WebLabelFinder();
    var doc = parser.parseFromString('<html></html>', 'text/html');
    finder.init(doc, 'http://www.rootstrikers.org', function() {});
    assert.strictEqual(finder.searchForJsLink(), false);
};

exports.testSearchForJsLinkJsLicense = function (assert) {
    var finder = new WebLabelFinder();
    var doc = parser.parseFromString(
        '<html><body>' +
            '<a href="lic.html" rel="jslicense">JavaScript License Info</a>' +
            '</body></html>', 'text/html');
    finder.init(doc, 'http://www.rootstrikers.org', function() {});

    assert.strictEqual(
        finder.searchForJsLink(),
        'http://www.rootstrikers.org/lic.html#librejs=true'
    );
};

exports.testSearchForJsLinkDataJsLicense = function (assert) {
    var finder = new WebLabelFinder();
    var doc = parser.parseFromString(
        '<html><body>' +
            '<a href="lic.html" data-jslicense="1">JavaScript License</a>' +
            '</body></html>', 'text/html');
    finder.init(doc, 'http://www.rootstrikers.org', function() {});

    assert.strictEqual(
        finder.searchForJsLink(),
        'http://www.rootstrikers.org/lic.html#librejs=true'
    );
};

require('sdk/test').run(exports);
