'use strict';


var NIL  = require('../common').NIL;
var Type = require('../type');


var _toString = Object.prototype.toString;


function resolveYamlPairs(object /*, explicit*/) {
  var index, length, pair, keys, result;

  result = new Array(object.length);

  for (index = 0, length = object.length; index < length; index += 1) {
    pair = object[index];

    if ('[object Object]' !== _toString.call(pair)) {
      return NIL;
    }

    keys = Object.keys(pair);

    if (1 !== keys.length) {
      return NIL;
    }

    result[index] = [ keys[0], pair[keys[0]] ];
  }

  return result;
}


module.exports = new Type('tag:yaml.org,2002:pairs', {
  loader: {
    kind: 'array',
    resolver: resolveYamlPairs
  }
});
