/* -*-c-*- -------------- mixgtk_config.c :
 * Implementation of the functions declared in mixgtk_config.h
 * ------------------------------------------------------------------
 *  Last change: Time-stamp: "2001-04-29 14:53:06 jao"
 * ------------------------------------------------------------------
 * Copyright (C) 2001 Free Software Foundation, Inc.
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 */

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include "mixgtk.h"
#include "mixgtk_config.h"

#define CONFIG_FILENAME  "config"
#define COMMENT_PREFIX '#'
#define AUTOSAVE_FLAG "Autosave"

static GHashTable *items_;
static gchar *config_ = NULL;
static gboolean autosave_ = FALSE;

/* load configuration */
gboolean
mixgtk_config_load (void)
{
  const gchar *autosave;
  FILE *f;
  gchar *mixdir = g_strdup_printf ("%s/%s", g_get_home_dir (), MIXGTK_FILES_DIR);
  int k = mkdir (mixdir, S_IRWXU | S_IRWXG | S_IRWXO);
  if (!k) g_message ("Configuration directory %s created\n", mixdir);
  config_ = g_strdup_printf ("%s/%s", mixdir, CONFIG_FILENAME);
  items_ = g_hash_table_new (g_str_hash, g_str_equal);
  f = fopen (config_, "r");
  if (f != NULL)
    {
      enum {LEN = 256};
      gchar buffer[LEN];
      gchar *line = buffer;
      while (!feof (f))
	{
	  line = fgets (line, LEN, f);
	  if (line) line = g_strstrip (line);
	  if (line && line[0] != COMMENT_PREFIX)
	    {
	      gchar **vals = g_strsplit (line, "=", 2);
	      g_hash_table_insert (items_,
				   (gpointer)g_strdup (g_strstrip (vals[0])),
				   (gpointer)g_strdup (g_strstrip (vals[1])));
	      g_strfreev (vals);
	    }
	}
      fclose (f);
    }
      
  autosave = mixgtk_config_get (AUTOSAVE_FLAG);
  autosave_ = autosave && !g_strcasecmp (autosave, "True");
  g_free (mixdir);
  return TRUE;
}

/* autosave state */
gboolean
mixgtk_config_is_autosave (void)
{
  return autosave_;
}

void
mixgtk_config_set_autosave (gboolean autosave)
{
  if (autosave != autosave_)
    {
      mixgtk_config_update (AUTOSAVE_FLAG, autosave? "True" : "False");
      autosave_ = autosave;
    }
}

/* update config item */
void
mixgtk_config_update (const gchar *key, const gchar *value)
{
  gpointer tmp = NULL;
  
  g_return_if_fail (key != NULL);
  g_return_if_fail (value != NULL);
  
  tmp = g_hash_table_lookup (items_, key);
  if (tmp)
    {
      g_free (tmp);
      tmp = (gpointer)key;
    }
  else
    {
      tmp = (gpointer)g_strdup (key);
    }
  
  g_hash_table_insert (items_, tmp, g_strdup (value));
}

/* get config item */
const gchar *
mixgtk_config_get (const gchar *key)
{
  return (const gchar*)g_hash_table_lookup (items_, key);
}


/* save configuration */
static void
save_ (gpointer key, gpointer value, gpointer file)
{
  fprintf ((FILE *)file, "%s=%s\n", (char *)key, (char *)value);
}

void
mixgtk_config_save (void)
{
  FILE *f = fopen (config_, "w");
  if (!f)
    {
      g_warning ("Unable to open config file %s (%s)",
		 config_, g_strerror (errno));
      return;
    }
  g_hash_table_foreach (items_, save_, (gpointer)f);
  fclose (f);
}

  

