/* -*-comment-start: "//";comment-end:""-*-
 * GNU Mes --- Maxwell Equations of Software
 * Copyright © 2017 Jan (janneke) Nieuwenhuizen <janneke@gnu.org>
 *
 * This file is part of GNU Mes.
 *
 * GNU Mes is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * GNU Mes is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Mes.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <libmes.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char *env[] = {"foo", "bar", "baz", 0};

int
test (char **e)
{
  int i = 0;

  puts ("\n");
  puts ("a[i] = i-1\n");
  int a[3];
  for (int i=0; i < 3; i++) a[i] = i-1;
  for (int i=0; i < 3; i++) if (a[i] != i-1) return 1;

  puts ("env [");
  puts (itoa ((int)env));
  puts ("]\n");

  puts ("e [");
  puts (itoa ((int)e));
  puts ("]\n");

  puts ("env [0] == \"foo\"\n");
  if (strcmp (env[0], "foo")) return 2;

  puts ("env [1] == \"bar\"\n");
  if (strcmp (env[1], "bar")) return 3;

  puts ("t: **p in *env[]\n");

  char **pp = env;
  while (*pp)
    {
      puts ("pp [");
      puts (itoa ((int)pp));
      puts ("]: ");
      if (*pp) puts (*pp);
      puts ("\n");
      pp++;
      i++;
    }
  if (i != 3) return i;

  pp = env;
  puts ("t: *pp++ == \"foo\"\n");
  if (strcmp (*pp++, "foo")) return 4;

  puts ("t: *pp++ == \"bar\"\n");
  if (strcmp (*pp++, "bar")) return 5;

  char *buf = "hello";
  puts ("t: buf[0]\n");
  if (buf[0] != 'h') return 6;

  puts ("t: buf + 1\n");
  if (*(buf+1) != 'e') return 7;

  char **p = &buf;
  puts ("t: **p\n");
  if (**p != 'h') return 8;

  puts ("t: *(p + 1)\n");
  if (*(*p + 1) != 'e') return 9;

  puts ("t: getenv ()");
  if (!getenv ("PATH")) return 10;

  puts ("t: setenv ()");
  if (setenv ("61-array", "yes", 1)) return 11;

  puts ("t: getenv2 ()");
  if (strcmp (getenv ("61-array"), "yes")) return 12;

  return 0;
}

int
main (int argc, char *argv[])
{
  return test (env);
}
