/*  Motti -- a strategy game
    Copyright (C) 1999 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/
#include <config.h>

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <getopt.h>

#ifdef HAVE_LIBX11
#include "xinit.h"
#include "xwin.h"
#include "xevent.h"
#endif /* have_libx11 */
#ifdef HAVE_LIBNCURSES
#include "curses_if.h"
#endif /* have_libncurses */
#include "wrappers.h"

static void
help_msg ()
{
  puts ("Usage: motti map-file [OPTIONS]\n");
#ifdef HAVE_LIBX11
  puts ("  -d, --display display	set display for X");
  puts ("  -g, --geometry geometry	set geometry");
# ifdef HAVE_LIBNCURSES
  puts ("  -n, --no-windows		prohibit the use of X");
# endif /* have_libncurses */
#endif /* have_libx11 */
  puts ("  -m, --mono			do not use color");
  puts ("      --help			display this help and exit");
  puts ("      --version		output version information and exit");
  puts ("Report bugs to bug-motti@gnu.org");
  exit (0);
}

static void
version_msg ()
{
  puts (VERSION_STR);
  puts ("Copyright (C) 1999 Free Software Foundation, Inc.");
  puts ("Motti comes with NO WARRANTY,");
  puts ("to the extent permitted by law.");
  puts ("You may redistribute copies of motti");
  puts ("under the terms of the GNU General Public License.");
  puts ("For more information about these matters,");
  puts ("see the files named COPYING.");
  exit (0);
}

int
main (argc, argv)
     int argc;
     char *argv[];
{
  char *status_msg, *display_name = (char *) NULL;
  char def_map_name[] = "map";
#if defined HAVE_LIBX11 && defined HAVE_LIBNCURSES
  int use_x = 1;
#endif
  int color = 1;

  while (1)
    {
      int c;
      const struct option long_options[] =
      {
#ifdef HAVE_LIBX11
	{"display", 1, 0, 'd'},
	{"geometry", 1, 0, 'g'},
# ifdef HAVE_LIBNCURSES
	{"no-windows", 0, 0, 'n'},
# endif /* have_libncurses */
#endif /* have_libx11 */
	{"mono", 0, 0, 'm'},
	{"help", 0, 0, 1000},
	{"version", 0, 0, 1001}
      };

      /* TODO: a replacement for getopt_long for systems, which don't
	 have it.  */
      /* No need to ifdef this, since undefined letters fall through
	 to case default.  */
      c = getopt_long (argc, argv, "d:g:nm",
		       long_options, (int *) NULL);
      if (c == -1)
	break;

      switch (c)
	{
#ifdef HAVE_LIBX11
	case 'd':
	  display_name = optarg;
	  break;
	case 'g':
	  db_val_tab.geom_str = optarg;
	  break;
# ifdef HAVE_LIBNCURSES
	case 'n':
	  use_x = 0;
	  break;
# endif /* have_libncurses */
#endif /* have_libx11 */
	case 'm':
	  color = 0;
	  break;
	case 1000:
	default:
	  help_msg ();
	case 1001:
	  version_msg ();
	}
    }
  if (optind < argc)
    {
      status_msg = (char *) load_map (argv[optind]);
      if (status_msg)
	die (status_msg);
    }
  else
    die ("no map file specified");

  srand (time ((time_t *) NULL));

  puts (VERSION_STR);
  puts ("Copyright 1999 Free Software Foundation, Inc.");
  puts ("This is free software with ABSOLUTELY NO WARRANTY.");
  puts ("For details read file 'COPYING'.");

#ifdef HAVE_LIBX11
# ifdef HAVE_LIBNCURSES
  if (use_x)
    {
# endif /* have_libncurses */
      if (open_display (display_name))
	{
	  atexit (kill_x);
	  create_DB ();
	  if (color)
	    color = alloc_colors ();
	  if (!color)
	    die ("no color");
	  open_windows (argc, argv);
	  //create_cursors ();
	  event_loop ();
	}
      else
	{
	  die (alloc_err_str (ERR_NOX, display_name));
	}
# ifdef HAVE_LIBNCURSES
    }
# endif /* HAVE_LIBNCURSES */
#endif /* have_libx11 */
  /* Use text mode.  */
#ifdef HAVE_LIBNCURSES
  text_mode (color);
#endif /* have_libncurses */
  return 0;
}
