/*  Motti -- a strategy game
    Copyright (C) 1999 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/
#ifndef _XINIT_H

#define _XINIT_H

#include "map.h"

enum misc_colors {
  capital_col, cross_col,
  fg_col, bg_col,
  map_bg_col,
  but_fg, but_bg,
  cross_left, turn_win_border,
  last_col_num
};

enum mouse_action {
  mark, sel, act, last_place, attack, defend, guerilla, reset, no_act
};

struct db_vals {
  char *geom_str;
  short but_width, but_height;
  short turnwin_width, turnwin_height;
  char *cross_left_font;
  short map_square_size;
  short x_margin, y_margin;
  enum mouse_action mouse[5];
  short sel_width;
};

extern struct db_vals db_val_tab;
extern Coord turnwin_num_base[];

extern int open_display (char *);
extern void create_DB (void);
extern int alloc_colors (void);
extern void open_windows (int, char **);
extern void create_cursors (void);
extern void kill_x (void);

#endif /* xinit.h  */
