/*  Motti -- a strategy game
    Copyright (C) 1999-2014 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "LoginService.h"
#include "JSONParser.h"
#include <iostream>
#include <sstream>
#include <fstream>
#include <map>
#include <string>
#include <vector>
#include "ConfigCentral.h"

LoginService::LoginService()
{

}

LoginService::~LoginService()
{

}
void mkdirer(std::string path);
std::vector<std::string> tokenize(std::string line){
      std::vector<std::string> list;
      std::string actual=line;
      while(actual.find(";")!=std::string::npos)
      {
	  list.push_back(actual.substr(0,actual.find(";")));
	  actual=actual.substr(actual.find(";")+1);
      }
      return list;
}

void saveUser(std::string logi,std::string pass,std::string user,std::string rem,std::string remres,std::string email){
    mkdirer(ConfigCentral::getGamePath());
    std::ifstream ifs ((ConfigCentral::getGamePath()+"/login.csv").c_str(), std::ifstream::in);
    
    //search for existing login
    for( std::string line; std::getline( ifs, line ); )
    {
      std::vector<std::string> list=tokenize( line);
      if (list[0]==logi)
      {
	ifs.close();
	throw std::string("Login existing in the db :"+logi);
      }
    }
    ifs.close();
    
    std::ofstream ofs ((ConfigCentral::getGamePath()+"/login.csv").c_str(),std::ofstream::in | std::ofstream::out | std::ofstream::app);
    ofs <<logi<<";"<<pass<<";"<<user<<";"<<rem<<";"<<remres<<";"<<email<<std::endl;
    ofs.close();
}

void LoginService::registration(std::string json){
  std::istringstream  ssJson(json);
  json_parser::Parser parser(&ssJson);
  try{
    json_parser::Value *val = parser.jValue();
    
    json_parser::Object* my_object = dynamic_cast<json_parser::Object*>(val);
    if (my_object==NULL)
      return;
    json_parser::Value *login=getValue(my_object,"login");
    json_parser::Value *password=getValue(my_object,"password");
    json_parser::Value *username=getValue(my_object,"username");
    json_parser::Value *rememberPhrase=getValue(my_object,"rememberPhrase");
    json_parser::Value *rememberResult=getValue(my_object,"rememberResult");
    json_parser::Value *email=getValue(my_object,"email");
    saveUser(login->cleanStr(),password->cleanStr(),username->cleanStr(),rememberPhrase->cleanStr(),rememberResult->cleanStr(),email->cleanStr());
    
  } catch (json_parser::ParseError e) {
    std::cerr << "Oops, the json you gave me does not contain JSON data:" << std::endl;
    std::cerr << e.what() << std::endl;
  }
}

void LoginService::regeneratePassword(std::string json){
  std::istringstream  ssJson(json);
  json_parser::Parser parser(&ssJson);
  json_parser::Value *login=NULL;
    json_parser::Value *password=NULL;
  try{
    json_parser::Value *val = parser.jValue();
    
    json_parser::Object* my_object = dynamic_cast<json_parser::Object*>(val);
    if (my_object==NULL)
      return;
    login=getValue(my_object,"login");
    password=getValue(my_object,"password");
    
  } catch (json_parser::ParseError e) {
    std::cerr << "Oops, the json you gave me does not contain JSON data:" << std::endl;
    std::cerr << e.what() << std::endl;
  }
  mkdirer(ConfigCentral::getGamePath());
   std::ifstream ifs ((ConfigCentral::getGamePath()+"/login.csv").c_str(), std::ifstream::in);
    
  std::ofstream ofs ((ConfigCentral::getGamePath()+"/login2.csv").c_str(),std::ofstream::in | std::ofstream::out | std::ofstream::app);
      
    //search for existing login
    for( std::string line; std::getline( ifs, line ); )
    {
      std::vector<std::string> list=tokenize( line);
      if (list[0]==login->cleanStr())
      {
	ofs <<list[0]<<";"<<password->cleanStr()<<";"<<list[2]<<";"<<list[3]<<";"<<list[4]<<";"<<list[5]<<std::endl;
	
	continue;
      }
      ofs <<line<<std::endl;
      
      
    }
    ofs.close();
    ifs.close();
    std::remove( (ConfigCentral::getGamePath()+"/login.csv").c_str() );
    std::rename( (ConfigCentral::getGamePath()+"/login2.csv").c_str(), (ConfigCentral::getGamePath()+"/login.csv").c_str() ); 
}

bool LoginService::login(std::string login,std::string password){
    mkdirer(ConfigCentral::getGamePath());
    std::ifstream ifs ((ConfigCentral::getGamePath()+"/login.csv").c_str(), std::ifstream::in);
    
    //search for existing login
    for( std::string line; std::getline( ifs, line ); )
    {
      std::vector<std::string> list=tokenize( line);
      if (list[0]==login&&list[1]==password)
      {
	ifs.close();
	return true;
      }
    }
    ifs.close();
    return false;
}

bool LoginService::login(std::string json){
  std::istringstream  ssJson(json);
  json_parser::Parser parser(&ssJson);
  json_parser::Value *loginer;
  json_parser::Value *password;
  try{
    json_parser::Value *val = parser.jValue();
    
    json_parser::Object* my_object = dynamic_cast<json_parser::Object*>(val);
    if (my_object==NULL)
      return false;
    loginer=getValue(my_object,"login");
    password=getValue(my_object,"password");
    } catch (json_parser::ParseError e) {
    std::cerr << "Oops, the json you gave me does not contain JSON data:" << std::endl;
    std::cerr << e.what() << std::endl;
    return false;
  }
  return login(loginer->cleanStr(),password->cleanStr());
}

void LoginService::remove(std::string json){
  std::istringstream  ssJson(json);
  json_parser::Parser parser(&ssJson);
  json_parser::Value *login;
  try{
    json_parser::Value *val = parser.jValue();
    
    json_parser::Object* my_object = dynamic_cast<json_parser::Object*>(val);
    if (my_object==NULL)
      return;
    login=getValue(my_object,"login");
    
    } catch (json_parser::ParseError e) {
    std::cerr << "Oops, the json you gave me does not contain JSON data:" << std::endl;
    std::cerr << e.what() << std::endl;
  }
  mkdirer(ConfigCentral::getGamePath());
  std::ifstream ifs ((ConfigCentral::getGamePath()+"/login.csv").c_str(), std::ifstream::in);
    
  std::ofstream ofs ((ConfigCentral::getGamePath()+"/login2.csv").c_str(),std::ofstream::in | std::ofstream::out | std::ofstream::app);
      
    //search for existing login
    for( std::string line; std::getline( ifs, line ); )
    {
      std::vector<std::string> list=tokenize( line);
      if (list[0]==login->cleanStr())
      {
	continue;
      }
      ofs <<line<<std::endl;
      
      
    }
    ofs.close();
    ifs.close();
    std::remove( (ConfigCentral::getGamePath()+"/login.csv").c_str() );
    std::rename( (ConfigCentral::getGamePath()+"/login2.csv").c_str(), (ConfigCentral::getGamePath()+"/login.csv").c_str() ); 

  
}



