/*  Motti -- a strategy game
    Copyright (C) 1999-2014 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "StdAfx.h"
#include "MottiRulesManager.h"
#include "Case.h"
#include <iostream>
MottiRulesManager::MottiRulesManager():board_(NULL)
{
}


MottiRulesManager::~MottiRulesManager(void)
{
}

void MottiRulesManager::setBoard(Board *board){
	board_=board;
}

Player * MottiRulesManager::getActualPlayer(){
	if (board_!=NULL)
	{
		return board_->getActualPlayer();
	}
	else
	{
		return NULL;
	}
}

void MottiRulesManager::initGame(){
	initTurn();
	//Take the first player and activate it
	if (board_!=NULL)
	{
		board_->setFirstPlayerAsActualPlayer();
	}
}

void MottiRulesManager::initTurn(){
	board_->setActionMode(Board::NOTCHOOSE);
	board_->setNbCoutRestant(0);
	
}

void MottiRulesManager::initPlayerGame(Player *player){
	
}

void MottiRulesManager::attack(int x,int y){

	if (board_->getWinner()!=NULL) return;
	if (board_->getActionMode()==Board::NOTCHOOSE)
	{
		board_->setActionMode(Board::ATTACK);
		board_->setNbCoutRestant(board_->getNbCoupperTurnAttack());
	}
	if (board_->getActionMode()!=Board::ATTACK){
		return;
	}
	if (board_->getNbCoutRestant()==0) return;
	  Case &cases=*board_->getCaseNoThrow(x,y);
	if (&cases==NULL||cases.getPlayer()==NULL) return;
	if (cases.getPlayer()->getName()!=board_->getActualPlayer()->getName()&&cases.getType()!=Case::LOCKED) 
	{
		//if not the actual player, search near to know if a locked case exist for the actual player
		int ix=0,iy=0;
		bool searchedCase=false;
		for (ix=-1;ix<2;ix++)
		for (iy=-1;iy<2;iy++)
		{
			
			try{
				Case &casesnear=*board_->getCaseNoThrow(x+ix,y+iy);
				if (&casesnear==NULL) continue;
				if (casesnear.getPlayer()==NULL) continue;
				if (casesnear.getPlayer()->getName()==board_->getActualPlayer()->getName()&&casesnear.getType()==Case::LOCKED)
				{
					
					searchedCase=true;
					
				}
			}catch(...)
			{}
		}

		if (!searchedCase)
		{
			return;
		}
		else
		{

			cases.setPreviousPlayer(cases.getPlayer());
			cases.setPlayer(board_->getActualPlayer());
			cases.setCaseType(Case::SELECTED);
			board_->decNbCoutRestant();
		}
	}
	
	if (cases.getType()==Case::LOCKED) return;
	if (cases.getType()==Case::NOTUSED) return;
	if (cases.getType()==Case::FREE)
	{
		cases.setCaseType(Case::SELECTED);
		board_->decNbCoutRestant();
	}
	
}
void MottiRulesManager::unattack(int x,int y){
	if (board_->getWinner()!=NULL) return;
	 
	Case &cases=*board_->getCaseNoThrow(x,y);

	if (cases.getType()==Case::LOCKED) return;
	
	if (cases.getType()==Case::NOTUSED) return;
	
	if (cases.getType()==Case::SELECTED)
	{
		cases.setPlayer(cases.getPreviousPlayer());
		
		cases.setCaseType(Case::FREE);
		board_->incNbCoutRestant();
	}
	if (board_->getNbCoutRestant()==board_->getNbCoupperTurnAttack())
	{
		board_->setActionMode(Board::NOTCHOOSE);
	}
}

Board* MottiRulesManager::getBoard(){
	return board_;
}

void MottiRulesManager::endTurn(){
	
	std::cout<< "fixCase !"<<std::endl;
	fixCase();
	std::cout<< "calculateMap !"<<std::endl;
	calculateMap();
	std::cout<< "searchWinner2 !"<<std::endl;
	searchWinner2();
	std::cout<< "cleanIFOne !"<<std::endl;
	cleanIFOne();
	std::cout<< "nextPlayer !"<<std::endl;
	nextPlayer();
	std::cout<< "initTurn !"<<std::endl;
	initTurn();
	std::cout<< "cleanSurvyvor !"<<std::endl;
	cleanSurvyvor();
		
}

void MottiRulesManager::nextPlayer(){
	board_->setNextPlayer();
}

void MottiRulesManager::calculateMap(){
	int ix=0,iy=0;
	for (ix=0;ix<board_->getWidth();ix++)
		for (iy=0;iy<board_->getHeight();iy++)
		{
			uncolorCase();
			if (isEncircled(ix,iy))
			{
				colorizeEncircled(ix,iy);
			}
		}
}

void MottiRulesManager::cleanIFullLocked(){
	int nbCase=0;
	int nbCaseLocked=0;
	int ix=0,iy=0;
	for (ix=0;ix<board_->getWidth();ix++)
		for (iy=0;iy<board_->getHeight();iy++)
		{
			Case *cc=board_->getCaseNoThrow(ix,iy);
			if (cc!=NULL)
			{
				if (cc->getPlayer()!=NULL)
				{
					nbCase++;
					if (cc->getType()==Case::LOCKED)
					{
						nbCaseLocked++;
					}
				
				}
			}
		}
		//need to be cleaned
		if (nbCase==nbCaseLocked)
		{
			for (ix=0;ix<board_->getWidth();ix++)
			for (iy=0;iy<board_->getHeight();iy++)
			{
				Case *cc=board_->getCaseNoThrow(ix,iy);
				if (cc!=NULL)
				{
					if (cc->getPlayer()!=NULL)
					{
					
						cc->setCaseType(Case::FREE);
				
					}
				}
			}
		}
}
struct CaseLockedNoLocked{
	int nbCase;
	int nbCaseLocked;
	CaseLockedNoLocked():nbCase(0),nbCaseLocked(0){
	}
};

void MottiRulesManager::cleanSurvyvor(){
	
	int i=0;
	for (i=0;i<board_->getNbPlayers();i++)
	{
		Player *aa=board_->getPlayer(i);
		if (aa!=NULL&&aa->hasLost())
		{
			int ix=0,iy=0;
			for (ix=0;ix<board_->getWidth();ix++)
				for (iy=0;iy<board_->getHeight();iy++)
				{
					Case *cc=board_->getCaseNoThrow(ix,iy);
					if (cc!=NULL)
					{
						if (cc->getPlayer()!=NULL&&aa->getName()==cc->getPlayer()->getName())
						{
							cc->setCaseType(Case::NOTUSED);
						}
					}
				}
		}
	}
}

void MottiRulesManager::cleanIFOne(){
	std::map<std::string,CaseLockedNoLocked> listByPlay;
	
	int ix=0,iy=0;
	for (ix=0;ix<board_->getWidth();ix++)
		for (iy=0;iy<board_->getHeight();iy++)
		{
			Case *cc=board_->getCaseNoThrow(ix,iy);
			if (cc!=NULL)
			{
				if (cc->getPlayer()!=NULL)
				{
					if (!cc->getPlayer()->hasLost())
					{
						listByPlay[cc->getPlayer()->getName()].nbCase++;
						if (cc->getType()==Case::LOCKED)
						{
							listByPlay[cc->getPlayer()->getName()].nbCaseLocked++;
						}
					}
				}
			}
		}
		//need to be cleaned

		std::map<std::string,CaseLockedNoLocked>::iterator iterCC=listByPlay.begin();
		while (iterCC!=listByPlay.end())
		{
			if (iterCC->second.nbCase==iterCC->second.nbCaseLocked)
			{
				for (ix=0;ix<board_->getWidth();ix++)
				for (iy=0;iy<board_->getHeight();iy++)
				{
					Case *cc=board_->getCaseNoThrow(ix,iy);
					if (cc!=NULL)
					{
						if (cc->getPlayer()!=NULL)
						{
					
							cc->setCaseType(Case::FREE);
				
						}
					}
				}
				break;
			}
			iterCC++;
		}
}

void MottiRulesManager::affectPlayerMapWinner(Player *a,Player *b){
	int ix=0,iy=0;
	for (ix=0;ix<board_->getWidth();ix++)
		for (iy=0;iy<board_->getHeight();iy++)
		{
			Case &cases=*board_->getCaseNoThrow(ix,iy);
			if (cases.getPlayer()!=NULL)
			if (cases.getPlayer()->getName()==a->getName())
			{
				cases.setPlayer(b);
				cases.setPreviousPlayer(b);
				cases.setCaseType(Case::FREE);
			}

		}
}

void MottiRulesManager::searchWinner(){
	int ix=0,iy=0;
	Player *actPlayer=NULL;
	bool isWinner=true;
	for (ix=0;ix<board_->getWidth();ix++)
		for (iy=0;iy<board_->getHeight();iy++)
		{
			Case &cases=*board_->getCaseNoThrow(ix,iy);
			if (cases.getPlayer()==NULL) continue;
			if (actPlayer==NULL){
				if (cases.getPlayer()!=NULL)
				{
					actPlayer=cases.getPlayer();
			
				}
			}
			if (actPlayer->getName()!=cases.getPlayer()->getName())
			{
				isWinner=false;
			}
		}
		if (isWinner)
		{
			board_->setWinner(actPlayer);
		}
}


void MottiRulesManager::searchWinner2(){
	int ix=0,iy=0;
	Player *actPlayer=NULL;
	bool isWinner=true;
	
	for (ix=0;ix<board_->getWidth();ix++)
		for (iy=0;iy<board_->getHeight();iy++)
		{
			Case &cases=*board_->getCaseNoThrow(ix,iy);
			if (cases.getPlayer()==NULL) continue;
			if (actPlayer==NULL){
				if (cases.getPlayer()!=NULL)
				{
					actPlayer=cases.getPlayer();
			
				}
			}
			if(cases.isCityCenter())
			if (actPlayer->getName()!=cases.getPlayer()->getName())
			{
				isWinner=false;
			}
		}
		if (isWinner)
		{
			board_->setWinner(actPlayer);
		}
}

void MottiRulesManager::fixCase(){
	int ix=0,iy=0;
	for (ix=0;ix<board_->getWidth();ix++)
		for (iy=0;iy<board_->getHeight();iy++)
		{
			Case &cases=*board_->getCaseNoThrow(ix,iy);
			if (cases.getPlayer()==NULL) continue;
			if (cases.getPlayer()->getName()==board_->getActualPlayer()->getName()&&cases.getType()==Case::SELECTED)
			{
				//Hazard choose
				if (board_->getActionMode()==Board::GUERILLA)
				{
					cases.setCaseType(Case::LOCKED);
					
				}
				else if (randGen_.nextBoolean()||board_->getActionMode()==Board::DEFEND)
				{
					cases.setCaseType(Case::LOCKED);
				}
				else
				{
					cases.setCaseType(Case::FREE);
					if (cases.getPreviousPlayer()->getName()!=board_->getActualPlayer()->getName())
					{
						cases.setPlayer(cases.getPreviousPlayer());
					}
				}
				if (cases.getType()==Case::LOCKED&&cases.getPreviousPlayer()->getName()!=board_->getActualPlayer()->getName()&&cases.isCityCenter())
				{
					cases.getPreviousPlayer()->setLost(true);
					affectPlayerMapWinner(cases.getPreviousPlayer(),board_->getActualPlayer());
					
					cases.setPreviousPlayer(board_->getActualPlayer());
					cases.setPlayer(board_->getActualPlayer());
					
				}

				
			}
		}
}

void MottiRulesManager::uncolorCase(){
	int ix=0,iy=0;
	for (ix=0;ix<board_->getWidth();ix++)
		for (iy=0;iy<board_->getHeight();iy++)
		{
			board_->getCaseNoThrow(ix,iy)->setColored(false);
		}
}


bool MottiRulesManager::isEncircled(int x, int y){
	Case &cases=*board_->getCaseNoThrow(x,y);
	if (cases.getPlayer()==NULL) return false;
	if (cases.getPlayer()->getName()==board_->getActualPlayer()->getName())
	{
		return true;
	}
	cases.setColored(true );
	int ix=0,iy=0;
	int nbcase=0;
	int nbvalidedcase=0;
	for (ix=-1;ix<2;ix++)
		for (iy=-1;iy<2;iy++)
		{
			
			try{
				Case &casesnear=*board_->getCaseNoThrow(x+ix,y+iy);
				if (&casesnear==NULL) continue;
				if (casesnear.isColored()) continue;
				if (casesnear.getPlayer()==NULL) continue;
				nbcase++;
				if (casesnear.getPlayer()->getName()==board_->getActualPlayer()->getName()&&casesnear.getType()==Case::FREE)
				{
					return false;
				}
				if (casesnear.getPlayer()->getName()!=board_->getActualPlayer()->getName())
				{
					if (!isEncircled(x+ix,y+iy))
					{
						return false;
					}
					else
					{
						nbvalidedcase++;
					}
					
				}
				else
				{
					if (casesnear.getPlayer()->getName()==board_->getActualPlayer()->getName()&&(casesnear.getType()==Case::SELECTED||casesnear.getType()==Case::LOCKED||casesnear.getType()==Case::FREE))
					{
						nbvalidedcase++;
					}
				}
				
			}catch(...)
			{
				return false;
			}
		}
	if (nbvalidedcase==0)
	return false;
	else
	return true;
}
void MottiRulesManager::colorizeEncircled(int x, int y){

	Case &cases=*board_->getCaseNoThrow(x,y);
	if (cases.getPlayer()==NULL)  return;
	if (cases.getPlayer()->getName()==board_->getActualPlayer()->getName())
	{
		return ;
	}
	else
	{
		if (cases.isCityCenter())
		{
			cases.getPreviousPlayer()->setLost(true);
			affectPlayerMapWinner(cases.getPreviousPlayer(),board_->getActualPlayer());
			cases.setPreviousPlayer(board_->getActualPlayer());
			cases.setPlayer(board_->getActualPlayer());
		}
		else
		{
			cases.setPlayer(board_->getActualPlayer());
			cases.setCaseType(Case::FREE);
		}
		
	}
	int ix=0,iy=0;
	for (ix=-1;ix<2;ix++)
		for (iy=-1;iy<2;iy++)
		{
			
			try{
				Case &casesnear=*board_->getCaseNoThrow(x+ix,y+iy);
				if (&casesnear==NULL) continue;
				if (casesnear.getPlayer()==NULL) continue;
				if (casesnear.getPlayer()->getName()!=board_->getActualPlayer()->getName())
				{

					colorizeEncircled(x+ix,y+iy);
					
					
				}
				
				
			}catch(...)
			{}
		}
	

}

RandomGenerator & MottiRulesManager::getRandomGenerator(){
	return randGen_;
}

void MottiRulesManager::defend(int x,int y){
	if (board_->getWinner()!=NULL) return;
	if (board_->getActionMode()==Board::NOTCHOOSE)
	{
		board_->setActionMode(Board::DEFEND);
		board_->setNbCoutRestant(board_->getNbCoupperTurnDefend());
	}
	if (board_->getActionMode()!=Board::DEFEND){
		return;
	}

	if (board_->getNbCoutRestant()==0) return;
	 
	Case &cases=*board_->getCaseNoThrow(x,y);
	if (cases.getPlayer()==NULL) return;
	if (cases.getPlayer()->getName()!=board_->getActualPlayer()->getName()) 
	{
		return ;
	}
	if (cases.getType()==Case::LOCKED) return;
	if (cases.getType()==Case::NOTUSED) return;
	if (cases.getType()==Case::FREE)
	{

		cases.setCaseType(Case::SELECTED);
		board_->decNbCoutRestant();
		
	}


}
void MottiRulesManager::undefend(int x,int y){
	if (board_->getWinner()!=NULL) return;
	Case &cases=*board_->getCaseNoThrow(x,y);

	if (cases.getType()==Case::LOCKED) return;
	
	if (cases.getType()==Case::NOTUSED) return;
	
	if (cases.getType()==Case::SELECTED)
	{
		cases.setCaseType(Case::FREE);
		board_->incNbCoutRestant();
	}


	if (board_->getNbCoutRestant()==board_->getNbCoupperTurnDefend())
	{
		board_->setActionMode(Board::NOTCHOOSE);
	}
}
void MottiRulesManager::guerilla(int x,int y){
	
	if (board_->getWinner()!=NULL) return;
	if (board_->getActionMode()==Board::NOTCHOOSE)
	{
		board_->setActionMode(Board::GUERILLA);
		board_->setNbCoutRestant(board_->getNbCoupperTurnGuerilla());
	}
	
	if (board_->getActionMode()!=Board::GUERILLA){
		return;
	}
	
	if (board_->getNbCoutRestant()==0) return;
	 
	Case &cases=*board_->getCaseNoThrow(x,y);
	Player * caPla=cases.getPlayer();
	if (cases.getPlayer()==NULL) return;
	if (cases.getPlayer()->getName()!=board_->getActualPlayer()->getName()) 
	{
		//if not the actual player, search near to know if a locked case exist for the actual player
		int ix=0,iy=0;
		bool searchedCase=false;
		for (ix=-1;ix<2;ix++)
		for (iy=-1;iy<2;iy++)
		{
			
			try{
				Case &casesnear=*board_->getCaseNoThrow(x+ix,y+iy);
				if (&casesnear==NULL) continue;
				if (casesnear.getPlayer()==NULL) continue;
				if (casesnear.getPlayer()->getName()==board_->getActualPlayer()->getName()&&casesnear.getType()==Case::LOCKED)
				{
					
					searchedCase=true;
					
				}
			}catch(...)
			{}
		}

		if (!searchedCase)
		{
			return;
		}
		else
		{
			cases.setPreviousPlayer(cases.getPlayer());
			cases.setPlayer(board_->getActualPlayer());
			cases.setCaseType(Case::SELECTED);
			cases.setPreviousPlayer(caPla);
			board_->decNbCoutRestant();
			
		}
	}
	
	if (cases.getType()==Case::LOCKED) return;
	if (cases.getType()==Case::NOTUSED) return;
	if (cases.getType()==Case::FREE)
	{

		cases.setCaseType(Case::SELECTED);
		board_->decNbCoutRestant();
	}

}
void MottiRulesManager::unguerilla(int x,int y){
	if (board_->getWinner()!=NULL) return;

	Case &cases=*board_->getCaseNoThrow(x,y);

	if (cases.getType()==Case::LOCKED) return;
	
	if (cases.getType()==Case::NOTUSED) return;


	if (board_->getNbCoutRestant()==board_->getNbCoupperTurnGuerilla())
	{
		board_->setActionMode(Board::NOTCHOOSE);
	}	

	if (cases.getType()==Case::SELECTED)
	{
		cases.setCaseType(Case::FREE);
		if (cases.getPlayer()->getName()!=cases.getPreviousPlayer()->getName())
		{
			cases.setCaseType(Case::LOCKED);
		
		}
		cases.setPlayer(cases.getPreviousPlayer());
		board_->incNbCoutRestant();
		board_->setActionMode(Board::NOTCHOOSE);
	}

}

void MottiRulesManager::attack(Player *p,int x,int y){
	if (p==board_->getActualPlayer())
	{
		attack(x,y);
	}
}
	void MottiRulesManager::unattack(Player *p,int x,int y){
	if (p==board_->getActualPlayer())
	{
		unattack(x,y);
	}
}
	void MottiRulesManager::defend(Player *p,int x,int y){
	if (p==board_->getActualPlayer())
	{
		defend(x,y);
	}
}
	void MottiRulesManager::undefend(Player *p,int x,int y){
	if (p==board_->getActualPlayer())
	{
		undefend(x,y);
	}
}
	void MottiRulesManager::guerilla(Player *p,int x,int y){
		
	if (p==board_->getActualPlayer())
	{
		guerilla(x,y);
	}
	
}
	void MottiRulesManager::unguerilla(Player *p,int x,int y){
	if (p==board_->getActualPlayer())
	{
		unguerilla(x,y);
	}
}