# This file is part of grecs - Gray's Extensible Configuration System
# Copyright (C) 2007, 2009 Sergey Poznyakoff
#
# Grex is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3, or (at your option)
# any later version.
#
# Grex is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Grex.  If not, see <http://www.gnu.org/licenses/>.

# GRECS_SETUP([no-preproc])
AC_DEFUN([GRECS_SETUP],[
  # **********************	
  # Preprocessor
  # **********************
  m4_if($1,[no-preproc],
        [use_ext_pp=no],
        [AC_ARG_WITH([preprocessor],
		      AC_HELP_STRING([--without-preprocessor],
				     [do not use external preprocessor]),
	  [case "${withval}" in
	   yes) use_ext_pp=yes ;;
	   no)  use_ext_pp=no ;;
	   *)   AC_MSG_ERROR(bad value ${withval} for --with-preprocessor) ;;
	   esac],[use_ext_pp=yes])])

  if test $use_ext_pp != no; then
    # Check for default preprocessor
    AC_ARG_VAR([DEFAULT_PREPROCESSOR],
               [Set default preprocessor name])
    if test -z "$DEFAULT_PREPROCESSOR" ; then
      DEFAULT_PREPROCESSOR="m4 -s"
    fi
  
    save_PATH=$PATH
    PREPROC_OPTIONS=`echo $DEFAULT_PREPROCESSOR | sed -n 's/[[^ ]][[^ ]]* //p'`
    case "$DEFAULT_PREPROCESSOR" in
    /*) PATH=`expr $DEFAULT_PREPROCESSOR : '\(.*\)/.*'`:$PATH
        DEFAULT_PREPROCESSOR=`expr $DEFAULT_PREPROCESSOR : '.*/\(.*\)'`;;
    esac
    AC_PATH_PROG(PPBIN, $DEFAULT_PREPROCESSOR)
    DEFAULT_PREPROCESSOR=$PPBIN
    if test -n "$DEFAULT_PREPROCESSOR"; then
      DEFAULT_PREPROCESSOR="$DEFAULT_PREPROCESSOR $PREPROC_OPTIONS"
      case $PPBIN in
        *m4) AC_SUBST(PP_SETUP_FILE,'pp-setup');; # Install default pp-setup
      esac
    fi
    PATH=$save_PATH
    DEFAULT_PREPROCESSOR="\\\"$DEFAULT_PREPROCESSOR\\\""
  else
    DEFAULT_PREPROCESSOR=NULL
  fi
])
