/* This file is part of GNU Pies
   Copyright (C) 2015-2021 Sergey Poznyakoff
  
   GNU Pies is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Pies is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Pies.  If not, see <http://www.gnu.org/licenses/>. */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "libpies.h"
#include <grecs.h>

char *
mkfilename (const char *dir, const char *name, const char *suf)
{
  size_t dirlen = strlen (dir);
  char *s;
  
  while (dirlen > 0 && dir[dirlen-1] == '/')
    dirlen--;

  s = malloc (dirlen + 1 + strlen (name) + (suf ? strlen (suf) : 0) + 1);
  if (!s)
    grecs_alloc_die ();
  strcpy (s, dir);
  strcat (s, "/");
  strcat (s, name);
  if (suf)
    strcat (s, suf);
  return s;
}

