/* proxyknife -- customizable proxy hunter
 * Copyright (C) 2005-2006 Jia Wang (skyroam@gmail.com)
 *
 *
 *
 * This file is part of proxyknife.
 * Proxyknife is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by the 
 * Free Software Foundation; either version 2 of the License, or (at your 
 * option) any later version.
 *
 * Proxyknife is distributed in the hope that it will be useful, but WITHOUT ANY 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
 * for more details.
 *
 *
 * You should have received a copy of the GNU General Public License 
 * along with Proxyknife; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* all functions are declared in proxyknife.h */
#include <proxyknife.h>

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
char * td(char *q,char **data)
{
        char *p;
        int len;
                p = strstr(q,"<td");
                if( p == NULL) return NULL;
                q = strstr(p,">")+1;/* ignore <td ...> */
                if( q == NULL ) return NULL;

                p = strstr(q,"</td>");/* only for no other <>,find </td> */
                if( p == NULL) return NULL;
                
                len = p-q;
               
                *data = xmalloc(len+1);
                memmove(*data,q,len); /* no trailling '\0' */
                (*data)[len]='\x0';

                q = p+strlen("</td>"); /* start next search after </td> */
                return q;
}
/* Fetch a proxylist from the remote web server 
 * Exit the process if it fail.
 * In: url without "http://"
 * Out: proxyknife_in_buffer will be modified after a successful call.
 */
void  fetchproxylist(char *proxyknife_in)
{
        int ret;
        int sockfd;
        int n,numbytes,total;
        char *host,*path,*buf;
        char *p,*q;
        char *data;
        struct sockaddr_in addr;
        char *url;
        char *proxylist;

        struct hostent *h;

        url = proxyknife_in;

        /* get hostname */
        p = strchr(url,'/');
        if(p == NULL){
                n = strlen(url);
                
                host = xmalloc(n+1);
                memmove(host,url,n);
                host[n]='\x0';

                
                path = xmalloc(2);
                path[0]='/';
                path[1]='\x0';
        }else{
                n = p - url;
                
                host = xmalloc(n+1);
                memmove(host,url,n);
                host[n]='\x0';


                n = strlen(p);
                path = xmalloc(n+1);
                memmove(path,p,n);
                path[n]='\x0';
        }

        printf("Connect to host %s to fetch %s\n",host,path);
        
        h = gethostbyname(host);

        if( h == NULL){
                herror("gethostbyname");
                xexit(EXIT_FAILURE);
        }

        sockfd = socket(AF_INET,SOCK_STREAM,0);
        if(sockfd == -1){
                perror("socket");
                xexit(EXIT_FAILURE);
        }

        memset(&addr.sin_zero,0,sizeof(addr.sin_zero));
        addr.sin_family = AF_INET;
        addr.sin_port = htons(80);
        addr.sin_addr = *(struct in_addr *) h->h_addr;

        /* here need to add myproxy support */
        n = connect(sockfd,(struct sockaddr *)&addr,sizeof(struct sockaddr));
        if(n == -1){
                perror(__FILE__"connect");
                xexit(EXIT_FAILURE);
        }
        
        n = strlen("GET "     " HTTP/1.0" "\r\n" "Host: ""\r\n""\r\n");
        n += strlen(path);
        n += strlen(host);
        buf = xmalloc(n+1);
        snprintf(buf,n+1,"GET %s HTTP/1.0\r\nHost: %s\r\n\r\n",
                        path,host
                        );
        if(write(sockfd,buf,n)!=n){
                perror(__FILE__"write");
                xexit(EXIT_FAILURE);
        }
        xfree((void **)&buf);
        xfree((void **)&host);
        xfree((void **)&path);

        n = 1024;
        buf = xmalloc(n); 
        total = 0;
        do{
                numbytes = read(sockfd,buf+total,n);
                if( numbytes >0) total+=numbytes;
                else break;
                //if( numbytes < n) break;
                buf = xrealloc(buf,total+n);
        }while(1);
        /* numbytes should be 0 */
        if( numbytes < 0){
                perror("read");
                fprintf(stderr,__FILE__": fetchproxylist: error above!\n");
        }
        if( total == 0){
                fprintf(stderr,__FILE__": fetchproxylist: No response!\n");
                xexit(EXIT_FAILURE);
        }
        buf = xrealloc(buf,total);
        /* for debug */
        write(1,buf,total);
        write(1,"\n",1);
        /* parse table -> td */
        q = buf;
        proxylist  = xmalloc(2);
        total = 0;
        if( !strncmp(proxyknife_in,PROXYKNIFE_DEFAULT_LISTSITE,
                                strlen(PROXYKNIFE_DEFAULT_LISTSITE))){
                /* read data between <pre> </pre>. */
                /* I hope all site use this format */
              q = strstr(q,"<pre>");
              if( q == NULL ) {
                      fprintf(stderr,__FILE__": fetchproxylist: no <pre> on "
                                      PROXYKNIFE_DEFAULT_LISTSITE);
                      xexit(EXIT_FAILURE);
              }
              q+= strlen("<pre>");
              p = strstr(q,"</pre>");
              if( p == NULL ){
                      fprintf(stderr,__FILE__": fetchproxylist: no </pre> after </pre> on " PROXYKNIFE_DEFAULT_LISTSITE);
                      xexit(EXIT_FAILURE);
              }
              total = p - q;
              proxylist = xrealloc(proxylist,total);
              memmove(proxylist,q,total);
        }else{
        while(1){
                q = td(q,&data);
                if( q == NULL) break;
                p = strstr(data,"&nbsp;");
                xfree((void **)&data);
                if(p!=NULL){/* the proxydata start with &nbsp; */
                        q = td(q,&data);
                        if(q == NULL) break;
                        else {
                                printf("Host: %s\n",data);
                                n = strlen(data);
                                proxylist = xrealloc(proxylist,total+n);
                                if( proxylist == NULL){
                                        perror("proxylist ralloc");
                                        xexit(EXIT_FAILURE);
                                }
                                memmove(proxylist+total,data,n);
                                total +=n;
                                xfree((void **)&data);
                        }
                        q = td(q,&data);
                        if( q == NULL) break;
                        else {
                                printf("Port: %s\n",data);
                                n = strlen(data);
                                proxylist = xrealloc(proxylist,total+n+1+1);
                                proxylist[total]=':';
                                total++;
                                memmove(proxylist+total,data,n);
                                total +=n;
                                proxylist[total]='\n';
                                total ++;
                                xfree((void **)&data);
                        }
                        /* this can be ignored */
                        q = td(q,&data);
                        if( q == NULL ) break;
                        else {
                                printf("Timeout: %s\n",data);
                                xfree((void **)&data);
                        }
                }

        }
        }
        /* now data was committed, buf can be released */
        xfree((void **)&buf);

        if( total == 0){/* No useful data */
                fprintf(stderr,__FILE__": fetchproxylist: No list found,dump:\n");
                if(proxylist)xfree((void **)&proxylist);
                xexit(EXIT_FAILURE);
        }
        proxyknife_in_buffer = proxylist;
        proxyknife_in_buffer = xrealloc(proxyknife_in_buffer,total+1);
        proxyknife_in_buffer[total]='\0'; /* for strchr */
        fprintf(stderr,"OK!Get proxylist in %d bytes\n",total);
        printf("%s\n",proxyknife_in_buffer);

}
/* read a line from string *s. 
   point *s to the start of the next line. 
   */
char * sgetaline (char *s,struct thread_mem *thread_mem)
{
        int len;
        char *p;
        len = strlen(s);
        p = strchr(s,'\n');
        if(p == NULL) {
                fprintf(stderr,__FILE__": sgetaline: End of buffer\n");
                return NULL; /* end of buffer or invalid data,
                                      ->exit thread */
        }
        p++;
        len = p-s;
        thread_mem->line = pxmalloc(len+1,thread_mem);
        
        if( thread_mem->line == NULL) {
                fprintf(stderr,__FILE__": sgetaline:memory error");
                return NULL;/* memory error ->exit thread */
        }
        memmove(thread_mem->line,s,len);
        thread_mem->line[len] = '\x0';
        return p;
}
