/*
   Copyright (C) 2001, Sergey Poznyakoff.

   This file is part of GNU Radius SNMP Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

struct snmp_def {
	int req_id;
	struct snmp_session *session_list;
	int retries;
	int timeout;
	snmp_alloc_t alloc;
	snmp_free_t free;
} ;

extern struct snmp_def snmp_def;

void snmp_request_free(struct snmp_request *req);
void snmp_request_free_list(struct snmp_request *req);
int snmp_request_xmit(struct snmp_session *sess, struct snmp_request *req);

