
/*  A Bison parser, made from /home/gray/gnu/radius/radiusd/./config.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define	T_EOL	257
#define	T_WORD	258
#define	T_STRING	259
#define	T_NUMBER	260
#define	T_PUNCT	261
#define	T_BOOL	262
#define	T_IPADDR	263

#line 1 "config.y"

/* This file is part of GNU Radius.
   Copyright (C) 2000,2001,2002,2003,2004 Free Software Foundation, Inc.

   Written by Sergey Poznyakoff

   GNU Radius is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   GNU Radius is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with GNU Radius; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <netdb.h> 
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>	
#include <ctype.h>
	
#include <radiusd.h>
#include <cfg.h>
 
#define YYMAXDEPTH 16

struct cfg_memblock {
	void (*destructor)();
	int line_num;
};

static grad_list_t /* of struct cfg_memblock */ *cfg_memory_pool;
 
static grad_list_t *_cfg_vlist_create(cfg_value_t *val);
static void _cfg_vlist_append(grad_list_t *vlist, cfg_value_t *val);

void *cfg_malloc(size_t size, void (*destructor)(void *));
 
static void _cfg_free_memory_pool();
static void _cfg_run_begin(struct cfg_stmt *stmt, void *up_data);

static int cclex();
static int ccerror(char *s); 

static char *typestr[] = {
	"integer",
	"boolean",
	"string",
	"network",
	"ipaddr",
	"port",
	"char",
	"host"
};
	 
struct syntax_block {
	struct syntax_block *prev;
	struct cfg_stmt *stmt;
	cfg_end_fp end;
	void *data;
};

static struct syntax_block *block;

static void _cfg_push_block(struct cfg_stmt *stmt, cfg_end_fp end, void *data);
static struct syntax_block *_cfg_pop_block();

int _cfg_make_argv(cfg_value_t **argv, char *keyword, grad_list_t *vlist);
void _cfg_free_argv(int argc, cfg_value_t *argv);

struct cfg_stmt *_cfg_find_keyword(struct cfg_stmt *stmt, char *str);
static int _get_value(cfg_value_t *arg, int type, void *base);

static struct obstack cfg_obstack;
char *cfg_filename;
int cfg_line_num;
static char *buffer;
static char *curp;


#line 97 "config.y"
typedef union {
        size_t number;
        int bool;
        grad_uint32_t ipaddr;
        char *string;
        cfg_value_t value;
        cfg_network_t network;
	grad_list_t *vlist;
	struct cfg_stmt *stmt;
} YYSTYPE;
#ifndef YYDEBUG
#define YYDEBUG 1
#endif

#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		42
#define	YYFLAG		-32768
#define	YYNTBASE	14

#define YYTRANSLATE(x) ((unsigned)(x) <= 263 ? cctranslate[x] : 30)

static const char cctranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,    12,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,    13,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    10,     2,    11,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9
};

#if YYDEBUG != 0
static const short ccprhs[] = {     0,
     0,     2,     4,     7,     8,    10,    12,    14,    17,    19,
    21,    26,    30,    32,    33,    35,    39,    41,    44,    48,
    50,    52,    54,    56,    58,    60,    62,    66,    68,    72,
    74,    76
};

static const short ccrhs[] = {    15,
     0,    17,     0,    15,    17,     0,     0,    15,     0,     3,
     0,    18,     0,     1,     3,     0,    23,     0,    19,     0,
    20,    16,    21,     3,     0,    25,    22,    10,     0,    11,
     0,     0,    24,     0,    25,    24,     3,     0,    26,     0,
    24,    26,     0,    24,    12,    26,     0,     4,     0,     4,
     0,     5,     0,     6,     0,     8,     0,     7,     0,    27,
     0,     9,    13,     6,     0,     9,     0,     9,    28,    29,
     0,     7,     0,     9,     0,     6,     0
};

#endif

#if YYDEBUG != 0
static const short ccrline[] = { 0,
   122,   125,   126,   129,   130,   133,   134,   135,   141,   142,
   145,   148,   177,   184,   188,   191,   215,   219,   224,   231,
   237,   242,   247,   252,   257,   262,   267,   275,   280,   287,
   294,   295
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const cctname[] = {   "$","error","$undefined.","T_EOL",
"T_WORD","T_STRING","T_NUMBER","T_PUNCT","T_BOOL","T_IPADDR","'{'","'}'","','",
"':'","input","list","opt_list","line","stmt","block_stmt","block_open","block_close",
"tag","simple_stmt","value_list","keyword","value","network","slash","netmask", NULL
};
#endif

static const short ccr1[] = {     0,
    14,    15,    15,    16,    16,    17,    17,    17,    18,    18,
    19,    20,    21,    22,    22,    23,    24,    24,    24,    25,
    26,    26,    26,    26,    26,    26,    26,    27,    27,    28,
    29,    29
};

static const short ccr2[] = {     0,
     1,     1,     2,     0,     1,     1,     1,     2,     1,     1,
     4,     3,     1,     0,     1,     3,     1,     2,     3,     1,
     1,     1,     1,     1,     1,     1,     3,     1,     3,     1,
     1,     1
};

static const short ccdefact[] = {     0,
     0,     6,    20,     0,     2,     7,    10,     0,     9,    14,
     8,     3,     0,     0,    21,    22,    23,    25,    24,    28,
     0,    15,    17,    26,    13,     0,    30,     0,     0,    12,
    16,     0,    18,    11,    27,    32,    31,    29,    19,     0,
     0,     0
};

static const short ccdefgoto[] = {    40,
     4,    14,     5,     6,     7,     8,    26,    21,     9,    22,
    10,    23,    24,    29,    38
};

static const short ccpact[] = {    24,
     2,-32768,-32768,    36,-32768,-32768,-32768,    -1,-32768,    26,
-32768,-32768,     3,    -3,-32768,-32768,-32768,-32768,-32768,    16,
    33,    12,-32768,-32768,-32768,     6,-32768,    20,    32,-32768,
-32768,    26,-32768,-32768,-32768,-32768,-32768,-32768,-32768,    42,
    44,-32768
};

static const short ccpgoto[] = {-32768,
     4,-32768,     9,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,   -21,-32768,-32768,-32768
};


#define	YYLAST		44


static const short cctable[] = {     1,
    33,     2,     3,     1,    11,     2,     3,    25,    34,    -4,
    39,    13,    12,    -5,    31,    15,    16,    17,    18,    19,
    20,    12,    27,    32,     1,    35,     2,     3,    28,    15,
    16,    17,    18,    19,    20,    -1,     1,    36,     2,     3,
    37,    41,    30,    42
};

static const short cccheck[] = {     1,
    22,     3,     4,     1,     3,     3,     4,    11,     3,    11,
    32,     8,     4,    11,     3,     4,     5,     6,     7,     8,
     9,    13,     7,    12,     1,     6,     3,     4,    13,     4,
     5,     6,     7,     8,     9,     0,     1,     6,     3,     4,
     9,     0,    10,     0
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define ccerrok		(ccerrstatus = 0)
#define ccclearin	(ccchar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto ccacceptlab
#define YYABORT 	goto ccabortlab
#define YYERROR		goto ccerrlab1
/* Like YYERROR except do call ccerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto ccerrlab
#define YYRECOVERING()  (!!ccerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (ccchar == YYEMPTY && cclen == 1)				\
    { ccchar = (token), cclval = (value);			\
      ccchar1 = YYTRANSLATE (ccchar);				\
      YYPOPSTACK;						\
      goto ccbackup;						\
    }								\
  else								\
    { ccerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		cclex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		cclex(&cclval, &cclloc, YYLEX_PARAM)
#else
#define YYLEX		cclex(&cclval, &cclloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		cclex(&cclval, YYLEX_PARAM)
#else
#define YYLEX		cclex(&cclval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	ccchar;			/*  the lookahead symbol		*/
YYSTYPE	cclval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE cclloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int ccnerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int ccdebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __cc_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __cc_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__cc_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__cc_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/usr/share/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into ccparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int ccparse (void *);
#else
int ccparse (void);
#endif
#endif

int
ccparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int ccstate;
  register int ccn;
  register short *ccssp;
  register YYSTYPE *ccvsp;
  int ccerrstatus;	/*  number of tokens to shift before error messages enabled */
  int ccchar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	ccssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE ccvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *ccss = ccssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *ccvs = ccvsa;	/*  to allow ccoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE cclsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *ccls = cclsa;
  YYLTYPE *cclsp;

#define YYPOPSTACK   (ccvsp--, ccssp--, cclsp--)
#else
#define YYPOPSTACK   (ccvsp--, ccssp--)
#endif

  int ccstacksize = YYINITDEPTH;
  int ccfree_stacks = 0;

#ifdef YYPURE
  int ccchar;
  YYSTYPE cclval;
  int ccnerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE cclloc;
#endif
#endif

  YYSTYPE ccval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int cclen;

#if YYDEBUG != 0
  if (ccdebug)
    fprintf(stderr, "Starting parse\n");
#endif

  ccstate = 0;
  ccerrstatus = 0;
  ccnerrs = 0;
  ccchar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  ccssp = ccss - 1;
  ccvsp = ccvs;
#ifdef YYLSP_NEEDED
  cclsp = ccls;
#endif

/* Push a new state, which is found in  ccstate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
ccnewstate:

  *++ccssp = ccstate;

  if (ccssp >= ccss + ccstacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *ccvs1 = ccvs;
      short *ccss1 = ccss;
#ifdef YYLSP_NEEDED
      YYLTYPE *ccls1 = ccls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = ccssp - ccss + 1;

#ifdef ccoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if ccoverflow is a macro.  */
      ccoverflow("parser stack overflow",
		 &ccss1, size * sizeof (*ccssp),
		 &ccvs1, size * sizeof (*ccvsp),
		 &ccls1, size * sizeof (*cclsp),
		 &ccstacksize);
#else
      ccoverflow("parser stack overflow",
		 &ccss1, size * sizeof (*ccssp),
		 &ccvs1, size * sizeof (*ccvsp),
		 &ccstacksize);
#endif

      ccss = ccss1; ccvs = ccvs1;
#ifdef YYLSP_NEEDED
      ccls = ccls1;
#endif
#else /* no ccoverflow */
      /* Extend the stack our own way.  */
      if (ccstacksize >= YYMAXDEPTH)
	{
	  ccerror("parser stack overflow");
	  if (ccfree_stacks)
	    {
	      free (ccss);
	      free (ccvs);
#ifdef YYLSP_NEEDED
	      free (ccls);
#endif
	    }
	  return 2;
	}
      ccstacksize *= 2;
      if (ccstacksize > YYMAXDEPTH)
	ccstacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      ccfree_stacks = 1;
#endif
      ccss = (short *) YYSTACK_ALLOC (ccstacksize * sizeof (*ccssp));
      __cc_memcpy ((char *)ccss, (char *)ccss1,
		   size * (unsigned int) sizeof (*ccssp));
      ccvs = (YYSTYPE *) YYSTACK_ALLOC (ccstacksize * sizeof (*ccvsp));
      __cc_memcpy ((char *)ccvs, (char *)ccvs1,
		   size * (unsigned int) sizeof (*ccvsp));
#ifdef YYLSP_NEEDED
      ccls = (YYLTYPE *) YYSTACK_ALLOC (ccstacksize * sizeof (*cclsp));
      __cc_memcpy ((char *)ccls, (char *)ccls1,
		   size * (unsigned int) sizeof (*cclsp));
#endif
#endif /* no ccoverflow */

      ccssp = ccss + size - 1;
      ccvsp = ccvs + size - 1;
#ifdef YYLSP_NEEDED
      cclsp = ccls + size - 1;
#endif

#if YYDEBUG != 0
      if (ccdebug)
	fprintf(stderr, "Stack size increased to %d\n", ccstacksize);
#endif

      if (ccssp >= ccss + ccstacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (ccdebug)
    fprintf(stderr, "Entering state %d\n", ccstate);
#endif

  goto ccbackup;
 ccbackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* ccresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  ccn = ccpact[ccstate];
  if (ccn == YYFLAG)
    goto ccdefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* ccchar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (ccchar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (ccdebug)
	fprintf(stderr, "Reading a token: ");
#endif
      ccchar = YYLEX;
    }

  /* Convert token to internal form (in ccchar1) for indexing tables with */

  if (ccchar <= 0)		/* This means end of input. */
    {
      ccchar1 = 0;
      ccchar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (ccdebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      ccchar1 = YYTRANSLATE(ccchar);

#if YYDEBUG != 0
      if (ccdebug)
	{
	  fprintf (stderr, "Next token is %d (%s", ccchar, cctname[ccchar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, ccchar, cclval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  ccn += ccchar1;
  if (ccn < 0 || ccn > YYLAST || cccheck[ccn] != ccchar1)
    goto ccdefault;

  ccn = cctable[ccn];

  /* ccn is what to do for this token type in this state.
     Negative => reduce, -ccn is rule number.
     Positive => shift, ccn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (ccn < 0)
    {
      if (ccn == YYFLAG)
	goto ccerrlab;
      ccn = -ccn;
      goto ccreduce;
    }
  else if (ccn == 0)
    goto ccerrlab;

  if (ccn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (ccdebug)
    fprintf(stderr, "Shifting token %d (%s), ", ccchar, cctname[ccchar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (ccchar != YYEOF)
    ccchar = YYEMPTY;

  *++ccvsp = cclval;
#ifdef YYLSP_NEEDED
  *++cclsp = cclloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (ccerrstatus) ccerrstatus--;

  ccstate = ccn;
  goto ccnewstate;

/* Do the default action for the current state.  */
ccdefault:

  ccn = ccdefact[ccstate];
  if (ccn == 0)
    goto ccerrlab;

/* Do a reduction.  ccn is the number of a rule to reduce with.  */
ccreduce:
  cclen = ccr2[ccn];
  if (cclen > 0)
    ccval = ccvsp[1-cclen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (ccdebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       ccn, ccrline[ccn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = ccprhs[ccn]; ccrhs[i] > 0; i++)
	fprintf (stderr, "%s ", cctname[ccrhs[i]]);
      fprintf (stderr, " -> %s\n", cctname[ccr1[ccn]]);
    }
#endif


  switch (ccn) {

case 8:
#line 136 "config.y"
{
		      ccclearin; ccerrok;
	      ;
    break;}
case 12:
#line 149 "config.y"
{
		      if (ccvsp[-2].stmt && ccvsp[-2].stmt->type == CS_BLOCK) {
			      if (ccvsp[-2].stmt->handler) {
				      cfg_value_t *argv;
				      int rc;
				      int argc = _cfg_make_argv(&argv,
								ccvsp[-2].stmt->keyword,
								ccvsp[-1].vlist);
				      rc = ccvsp[-2].stmt->handler(argc, argv,
						       block->data,
						       ccvsp[-2].stmt->data);
				      _cfg_free_argv(argc, argv);
				      if (rc)
					      ccerror("syntax error");
			      }
			      _cfg_push_block(ccvsp[-2].stmt->block, ccvsp[-2].stmt->end, ccvsp[-2].stmt->data);
		      } else {
			      if (block->stmt) {
				      grad_log(L_ERR,
					       "%s:%d: %s",
					       cfg_filename, cfg_line_num,
					       _("unknown block statement"));
			      }
			      _cfg_push_block(NULL, NULL, NULL);
		      }
	      ;
    break;}
case 13:
#line 178 "config.y"
{
		      if (block->prev)
			      _cfg_pop_block();
	      ;
    break;}
case 14:
#line 185 "config.y"
{
		      ccval.vlist = NULL;
	      ;
    break;}
case 16:
#line 192 "config.y"
{
		      if (ccvsp[-2].stmt) {
			      if (ccvsp[-2].stmt->handler) {
				      cfg_value_t *argv;
				      int rc;
				      int argc = _cfg_make_argv(&argv,
								ccvsp[-2].stmt->keyword,
								ccvsp[-1].vlist);
				      rc = ccvsp[-2].stmt->handler(argc, argv,
						       block->data,
						       ccvsp[-2].stmt->data);
				      _cfg_free_argv(argc, argv);
				      if (rc)
					      ccerror("syntax error");
			      }
		      } else if (block->stmt)
			      grad_log(L_ERR,
				       "%s:%d: %s",
				       cfg_filename, cfg_line_num,
				       _("unknown keyword"));
	      ;
    break;}
case 17:
#line 216 "config.y"
{
		      ccval.vlist = _cfg_vlist_create(&ccvsp[0].value);
	      ;
    break;}
case 18:
#line 220 "config.y"
{
		      _cfg_vlist_append(ccvsp[-1].vlist, &ccvsp[0].value);
		      ccval.vlist = ccvsp[-1].vlist;
	      ;
    break;}
case 19:
#line 225 "config.y"
{
		      _cfg_vlist_append(ccvsp[-2].vlist, &ccvsp[0].value);
		      ccval.vlist = ccvsp[-2].vlist;
	      ;
    break;}
case 20:
#line 232 "config.y"
{
		      ccval.stmt = _cfg_find_keyword(block->stmt, ccvsp[0].string);
	      ;
    break;}
case 21:
#line 238 "config.y"
{
		      ccval.value.type = CFG_STRING;
		      ccval.value.v.string = ccvsp[0].string;
	      ;
    break;}
case 22:
#line 243 "config.y"
{
		      ccval.value.type = CFG_STRING;
		      ccval.value.v.string = ccvsp[0].string;
	      ;
    break;}
case 23:
#line 248 "config.y"
{
		      ccval.value.type = CFG_INTEGER;
		      ccval.value.v.number = ccvsp[0].number;
	      ;
    break;}
case 24:
#line 253 "config.y"
{
		      ccval.value.type = CFG_BOOLEAN;
		      ccval.value.v.bool = ccvsp[0].bool;
	      ;
    break;}
case 25:
#line 258 "config.y"
{
		      ccval.value.type = CFG_CHAR;
		      ccval.value.v.ch = ccvsp[0].number;
	      ;
    break;}
case 26:
#line 263 "config.y"
{
		      ccval.value.type = CFG_NETWORK;
		      ccval.value.v.network = ccvsp[0].network;
	      ;
    break;}
case 27:
#line 268 "config.y"
{
		      ccval.value.type = CFG_HOST;
		      ccval.value.v.host.ipaddr = ccvsp[-2].ipaddr;
		      ccval.value.v.host.port = ccvsp[0].number;
	      ;
    break;}
case 28:
#line 276 "config.y"
{
		      ccval.network.ipaddr = ccvsp[0].ipaddr;
		      ccval.network.netmask = 0xffffffffL;
	      ;
    break;}
case 29:
#line 281 "config.y"
{
		      ccval.network.ipaddr = ccvsp[-2].ipaddr;
		      ccval.network.netmask = ccvsp[0].ipaddr;
	      ;
    break;}
case 30:
#line 288 "config.y"
{
		      if (ccvsp[0].number != '/')
			      YYERROR;
	      ;
    break;}
case 32:
#line 296 "config.y"
{
		      if (ccvsp[0].number > 32) {
			      grad_log(L_ERR,
				       _("invalid netmask length: %d"), ccvsp[0].number);
			      YYERROR;
		      }
		      ccval.ipaddr = (0xfffffffful >> (32-ccvsp[0].number)) << (32-ccvsp[0].number);
	      ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/usr/share/bison.simple"

  ccvsp -= cclen;
  ccssp -= cclen;
#ifdef YYLSP_NEEDED
  cclsp -= cclen;
#endif

#if YYDEBUG != 0
  if (ccdebug)
    {
      short *ssp1 = ccss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != ccssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++ccvsp = ccval;

#ifdef YYLSP_NEEDED
  cclsp++;
  if (cclen == 0)
    {
      cclsp->first_line = cclloc.first_line;
      cclsp->first_column = cclloc.first_column;
      cclsp->last_line = (cclsp-1)->last_line;
      cclsp->last_column = (cclsp-1)->last_column;
      cclsp->text = 0;
    }
  else
    {
      cclsp->last_line = (cclsp+cclen-1)->last_line;
      cclsp->last_column = (cclsp+cclen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  ccn = ccr1[ccn];

  ccstate = ccpgoto[ccn - YYNTBASE] + *ccssp;
  if (ccstate >= 0 && ccstate <= YYLAST && cccheck[ccstate] == *ccssp)
    ccstate = cctable[ccstate];
  else
    ccstate = ccdefgoto[ccn - YYNTBASE];

  goto ccnewstate;

ccerrlab:   /* here on detecting error */

  if (! ccerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++ccnerrs;

#ifdef YYERROR_VERBOSE
      ccn = ccpact[ccstate];

      if (ccn > YYFLAG && ccn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -ccn if nec to avoid negative indexes in cccheck.  */
	  for (x = (ccn < 0 ? -ccn : 0);
	       x < (sizeof(cctname) / sizeof(char *)); x++)
	    if (cccheck[x + ccn] == x)
	      size += strlen(cctname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (ccn < 0 ? -ccn : 0);
		       x < (sizeof(cctname) / sizeof(char *)); x++)
		    if (cccheck[x + ccn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, cctname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      ccerror(msg);
	      free(msg);
	    }
	  else
	    ccerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	ccerror("parse error");
    }

  goto ccerrlab1;
ccerrlab1:   /* here on error raised explicitly by an action */

  if (ccerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (ccchar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (ccdebug)
	fprintf(stderr, "Discarding token %d (%s).\n", ccchar, cctname[ccchar1]);
#endif

      ccchar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  ccerrstatus = 3;		/* Each real token shifted decrements this */

  goto ccerrhandle;

ccerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  ccn = ccdefact[ccstate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (ccn) goto ccdefault;
#endif

ccerrpop:   /* pop the current state because it cannot handle the error token */

  if (ccssp == ccss) YYABORT;
  ccvsp--;
  ccstate = *--ccssp;
#ifdef YYLSP_NEEDED
  cclsp--;
#endif

#if YYDEBUG != 0
  if (ccdebug)
    {
      short *ssp1 = ccss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != ccssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

ccerrhandle:

  ccn = ccpact[ccstate];
  if (ccn == YYFLAG)
    goto ccerrdefault;

  ccn += YYTERROR;
  if (ccn < 0 || ccn > YYLAST || cccheck[ccn] != YYTERROR)
    goto ccerrdefault;

  ccn = cctable[ccn];
  if (ccn < 0)
    {
      if (ccn == YYFLAG)
	goto ccerrpop;
      ccn = -ccn;
      goto ccreduce;
    }
  else if (ccn == 0)
    goto ccerrpop;

  if (ccn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (ccdebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++ccvsp = cclval;
#ifdef YYLSP_NEEDED
  *++cclsp = cclloc;
#endif

  ccstate = ccn;
  goto ccnewstate;

 ccacceptlab:
  /* YYACCEPT comes here.  */
  if (ccfree_stacks)
    {
      free (ccss);
      free (ccvs);
#ifdef YYLSP_NEEDED
      free (ccls);
#endif
    }
  return 0;

 ccabortlab:
  /* YYABORT comes here.  */
  if (ccfree_stacks)
    {
      free (ccss);
      free (ccvs);
#ifdef YYLSP_NEEDED
      free (ccls);
#endif
    }
  return 1;
}
#line 306 "config.y"


static void
skipws()
{
        while (*curp && isspace(*curp)) {
                if (*curp == '\n')
                        cfg_line_num++;
                curp++;
        }
}

static void
skipline()
{
        while (*curp && *curp != '\n')
                curp++;
}

static int
isword(int c)
{
        return isalnum(c) || c == '_' || c == '-';
}

static char *
copy_alpha()
{
        do {
		obstack_1grow(&cfg_obstack, *curp);
                curp++;
        } while (*curp && isword(*curp));
	obstack_1grow(&cfg_obstack, 0);
	return obstack_finish(&cfg_obstack);
}

static char *
copy_string()
{
        int quote = *curp++;

        while (*curp) {
		if (*curp == '\\') {
			grad_obstack_grow_backslash(&cfg_obstack, curp, &curp);
		} else if (*curp == quote) {
                        curp++;
                        break;
                } else {
			obstack_1grow(&cfg_obstack, *curp);
			curp++;
		}
        } 
	obstack_1grow(&cfg_obstack, 0);
	return obstack_finish(&cfg_obstack);
}

static int
copy_digit()
{
        int dot = 0;

        if (*curp == '0') {
                if (curp[1] == 'x' || curp[1] == 'X') {
			obstack_1grow(&cfg_obstack, *curp);
			curp++;
			obstack_1grow(&cfg_obstack, *curp);
			curp++;
                }
        }
        
        do {
		obstack_1grow(&cfg_obstack, *curp);
                if (*curp++ == '.')
                        dot++;
        } while (*curp && (isdigit(*curp) || *curp == '.'));
	obstack_1grow(&cfg_obstack, 0);
	cclval.string = obstack_finish(&cfg_obstack);
        return dot;
}

static grad_keyword_t booleans[] = {
	{ "on", 1 }, 
	{ "off", 0 },
	{ "yes", 1 }, 
	{ "no", 0 },
	{ 0 }
};

static int
keyword()
{
	int tok;
	
	if ((tok = grad_xlat_keyword(booleans, cclval.string, -1)) != -1) {
		cclval.bool = tok;
		return T_BOOL;
	}
	return T_WORD;
}

#define ismath(c) (strchr("=!+-/*.", c)!=NULL)

static int
cclex()
{
again:
        skipws();

        if (*curp == '#') {
                skipline();
                goto again;
        } 
        if (*curp == '/' && curp[1] == '*') {
                int keep_line = cfg_line_num;

                curp += 2;
                do {
                        while (*curp != '*') {
                                if (*curp == 0) {
                                        grad_log(L_ERR, 
                       _("%s:%d: unexpected EOF in comment started at line %d"),
                                                 cfg_filename, 
                                                 cfg_line_num, 
                                                 keep_line);
                                        return 0;
                                } else if (*curp == '\n')
                                        cfg_line_num++;
                                ++curp;
                        }
                } while (*++curp != '/');
                ++curp;
                goto again;
        }

        if (*curp == 0)
                return 0;
        
        if (isalpha(*curp)) {
                cclval.string = copy_alpha();
                return keyword();
        }

        if (*curp == '\"') {
                cclval.string = copy_string();
                return T_STRING;
        }

	if (*curp == '-' && !isspace(curp[1])) {
		/* For the sake of passing keyword arguments
		   to scheme */
		cclval.string = copy_alpha();
		return T_STRING;
	}
	
        if (isdigit(*curp)) {
                if (copy_digit()) {
                        /* IP address */
                        cclval.ipaddr = grad_ip_strtoip(cclval.string);
                        return T_IPADDR;
                }
                cclval.number = strtol(cclval.string, NULL, 0);
                return T_NUMBER;
        } 

        if (*curp == ';') {
                curp++;
                return T_EOL;
        }

        if (ismath(*curp)) {
		cclval.number = *curp++;
		return T_PUNCT;
	}
        return *curp++;
}

static int
ccerror(char *s)
{
        grad_log(L_ERR, "%s:%d: %s", cfg_filename, cfg_line_num, s);
}
                
/* ************************************************************************* */
/* Internal functions */

void
_cfg_run_begin(struct cfg_stmt *stmt, void *up_data)
{
	for ( ; stmt->keyword; stmt++) {
		if (stmt->term)
			stmt->term(0, stmt->data, up_data);
		if (stmt->type == CS_BLOCK)
			_cfg_run_begin(stmt->block, stmt->data);
	}
}

void
_cfg_run_finish(struct cfg_stmt *stmt, void *up_data)
{
	for ( ; stmt->keyword; stmt++) {
		if (stmt->term)
			stmt->term(1, stmt->data, up_data);
		if (stmt->type == CS_BLOCK)
			_cfg_run_finish(stmt->block, stmt->data);
	}
}

static int
_cfg_free_item(void *item, void *data)
{
	struct cfg_memblock *p = item;
	if (p->destructor)
		p->destructor(p+1);
	grad_free(p);
	return 0;
}

void
_cfg_free_memory_pool()
{
	grad_list_destroy(&cfg_memory_pool, _cfg_free_item, NULL);
}

int
_cfg_make_argv(cfg_value_t **argv, char *keyword, grad_list_t *vlist)
{
	int argc;

	if (vlist)
		argc = grad_list_count(vlist) + 1;
	else
		argc = 1;
	*argv = grad_emalloc(sizeof(**argv)*argc);
	(*argv)[0].type = CFG_STRING;
	(*argv)[0].v.string = keyword;
	if (vlist) {
		int i;
		cfg_value_t *val;
		grad_iterator_t *itr = grad_iterator_create(vlist);

		if (itr) {
			for (i = 1, val = grad_iterator_first(itr); val;
		     	     i++, val = grad_iterator_next(itr))
				(*argv)[i] = *val;
			grad_iterator_destroy(&itr);
		}
	}
	return argc;
}

void
_cfg_free_argv(int argc, cfg_value_t *argv)
{
	grad_free(argv);
}

static void
_cfg_vlist_destroy(void *arg)
{
	grad_list_t **pl = arg;
	grad_list_destroy(pl, NULL, NULL);
}

void
_cfg_vlist_append(grad_list_t *vlist, cfg_value_t *val)
{
	cfg_value_t *vp = cfg_malloc(sizeof(*vp), NULL);
	*vp = *val;
	grad_list_append(vlist, vp);
}

grad_list_t *
_cfg_vlist_create(cfg_value_t *val)
{
	grad_list_t *vlist = grad_list_create();
	grad_list_t **lp = cfg_malloc(sizeof(*lp), _cfg_vlist_destroy);
	*lp = vlist;
	_cfg_vlist_append(vlist, val);
	return vlist;
}

void
_cfg_push_block(struct cfg_stmt *stmt, cfg_end_fp end, void *block_data)
{
	struct syntax_block *p = grad_emalloc(sizeof(*p));
	p->stmt = stmt;
	p->end  = end;
	p->data = block_data;
	p->prev = block;
	block = p;
}

struct syntax_block *
_cfg_pop_block()
{
	struct syntax_block *p = block;

	if (p) {
		block = p->prev;
		if (p->end)
			p->end(block ? block->data : NULL, p->data);
		grad_free(p);
	}
	return block;
}

struct cfg_stmt *
_cfg_find_keyword(struct cfg_stmt *stmt, char *str)
{
	if (stmt)
		for (; stmt->keyword; stmt++) {
			if (strcmp(stmt->keyword, str) == 0)
				return stmt;
		}
	return NULL;
}

int
_get_value(cfg_value_t *arg, int type, void *base)
{
        struct servent *s;
        grad_uint32_t ipaddr;
        cfg_value_t value;

	value = *arg;
        switch (type) {
        case CFG_PORT:
                switch (value.type) {
                case CFG_INTEGER:
                        type = CFG_INTEGER;
                        break;
			
                case CFG_STRING:
                          s = getservbyname(value.v.string, "udp");
                          if (s) 
                                  value.v.number = ntohs(s->s_port);
                          else {
                                  grad_log(L_ERR, 
                                           _("%s:%d: no such service: %s"),
                                           cfg_filename, cfg_line_num,
                                           value.v.string);
                                  return 0;
                          }
                          type = value.type = CFG_INTEGER;
                          break;
			  
                default:
                        break;
                }
                break;
                        
        case CFG_IPADDR:
                switch (value.type) {
                case CFG_IPADDR:
                        break;
			
                case CFG_INTEGER:
                        type = CFG_IPADDR;
                        break;
			
                case CFG_STRING:
                        ipaddr = grad_ip_gethostaddr(value.v.string);
                        if (ipaddr == 0) {
                                grad_log(L_ERR, 
                                         _("%s:%d: unknown host: %s"),
                                         cfg_filename, cfg_line_num,
                                         value.v.string);
                        }
                        value.v.ipaddr = ipaddr;
                        value.type = CFG_IPADDR;
                        break;

		case CFG_NETWORK:
			if (value.v.network.netmask != 0xffffffffL) 
				break;
			value.v.ipaddr = value.v.network.ipaddr;
			value.type = CFG_IPADDR;
			break;

                default:
                        break;
                }
		break;
		
        }
        
        if (type != value.type) {
		cfg_type_error(type);
                return 0;
        }

        switch (type) {
        case CFG_INTEGER:
                *(size_t*) base = value.v.number;
                break;
		
        case CFG_STRING:
                grad_string_replace((char**)base, value.v.string);
                break;
		
        case CFG_IPADDR:
                *(grad_uint32_t*) base = value.v.ipaddr;
                break;
		
        case CFG_BOOLEAN:
                *(int*) base = value.v.bool;
                break;
		
	case CFG_NETWORK:
		*(cfg_network_t *) base = value.v.network;
		break;
		
        default:
                grad_log(L_CRIT,
                         _("INTERNAL ERROR at %s:%d: unknown datatype %d"),
                         __FILE__, __LINE__, type);
        }
	return 0;
}


/* ************************************************************************* */
/* Global functions */

void *
cfg_malloc(size_t size,	void (*destructor)(void *))
{
	struct cfg_memblock *p = grad_emalloc(size + sizeof(*p));
	p->destructor = destructor;
	p->line_num = cfg_line_num;
	if (!cfg_memory_pool)
		cfg_memory_pool = grad_list_create();
	grad_list_append(cfg_memory_pool, p);
	return p+1;
}

void
cfg_type_error(int type)
{
	grad_log(L_ERR, 
	         _("%s:%d: wrong datatype (should be %s)"),
	         cfg_filename, cfg_line_num, typestr[type]);
}

void
cfg_argc_error(int few)
{
	grad_log(L_ERR,
	         "%s:%d: %s",
	         cfg_filename, cfg_line_num,
	         few ? _("too few arguments") : _("too many arguments"));
}

#define _check_argc(argc, max) \
 if (argc-1 > max) {\
     grad_log(L_ERR, "%s:%d: %s", \
              cfg_filename, cfg_line_num, _("too many arguments"));\
     return 0;\
 }		

int
cfg_ignore(int argc ARG_UNUSED, cfg_value_t *argv ARG_UNUSED,
	   void *block_data ARG_UNUSED, void *handler_data ARG_UNUSED)
{
	return 0;
}

int
cfg_obsolete(int argc ARG_UNUSED, cfg_value_t *argv ARG_UNUSED,
	     void *block_data ARG_UNUSED, void *handler_data ARG_UNUSED)
{
	grad_log(L_WARN, _("%s:%d: obsolete statement"),
	       cfg_filename, cfg_line_num);
	return 0;
}

int
cfg_get_ipaddr(int argc, cfg_value_t *argv, void *block_data,
	       void *handler_data)
{
	_check_argc(argc, 1);
	return _get_value(&argv[1], CFG_IPADDR, handler_data);
}

int
cfg_get_integer(int argc, cfg_value_t *argv, void *block_data,
		void *handler_data)
{
	size_t val;
	int rc;
	
	_check_argc(argc, 1);
	rc = _get_value(&argv[1], CFG_INTEGER, &val);
	*(int*)handler_data = val;
	return rc;
}

int
cfg_get_number(int argc, cfg_value_t *argv, void *block_data,
	       void *handler_data)
{
	_check_argc(argc, 1);
	return _get_value(&argv[1], CFG_INTEGER, handler_data);
}

int
cfg_get_string(int argc, cfg_value_t *argv, void *block_data,
	       void *handler_data)
{
	_check_argc(argc, 1);
	return _get_value(&argv[1], CFG_STRING, handler_data);
}

int
cfg_get_boolean(int argc, cfg_value_t *argv, void *block_data,
		void *handler_data)
{
	_check_argc(argc, 1);
	return _get_value(&argv[1], CFG_BOOLEAN, handler_data);
}

int
cfg_get_network(int argc, cfg_value_t *argv,
		void *block_data, void *handler_data)
{
	_check_argc(argc, 1);
	return _get_value(&argv[1], CFG_NETWORK, handler_data);
}

int
cfg_get_port(int argc, cfg_value_t *argv,
	     void *block_data, void *handler_data)
{
	_check_argc(argc, 1);
	return _get_value(&argv[1], CFG_PORT, handler_data);
}

int
cfg_read(char *fname, struct cfg_stmt *syntax, void *data)
{
        struct stat st;
        int fd;
        extern int ccdebug;

	cfg_memory_pool = NULL;
	block = NULL;
	
        cfg_filename = fname;
	_cfg_push_block(syntax, NULL, data);
        if (stat(cfg_filename, &st)) {
                grad_log(L_ERR|L_PERROR, _("can't stat `%s'"), cfg_filename);
                return -1;
        }
        fd = open(cfg_filename, O_RDONLY);
        if (fd == -1) {
                if (errno != ENOENT)
                        grad_log(L_ERR|L_PERROR, 
                                _("can't open config file `%s'"), cfg_filename);
                return -1;
        }
        buffer = cfg_malloc(st.st_size+1, NULL);
        
        read(fd, buffer, st.st_size);
        buffer[st.st_size] = 0;
        close(fd);
        curp = buffer;

        grad_log(L_INFO, _("reading %s"), cfg_filename);
        cfg_line_num = 1;

        if (strncmp(curp, "#debug", 6) == 0) {
		/* Note: can't check YYDEBUG here, because some yaccs
		   (most notably, sun's) define YYDEBUG after including
		   code block */     
                ccdebug = 1;
        } else {
                ccdebug = 0;
        }

	obstack_init(&cfg_obstack);
	_cfg_run_begin(syntax, data);
	
        /* Parse configuration */
        ccparse();

	_cfg_run_finish(syntax, data);

        /* Clean up the things */
	while (_cfg_pop_block())
		;

	_cfg_free_memory_pool();
	obstack_free(&cfg_obstack, NULL);

        return 0;
}       

