
#line 3 "cflex.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

/* %not-for-header */

/* %if-c-only */
/* %if-not-reentrant */

/* %endif */
/* %endif */
/* %ok-for-header */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 0
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* %if-c++-only */
/* %endif */

/* %if-c-only */
    
/* %endif */

/* %if-c-only */

/* %endif */

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
/* %if-c-only */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
/* %endif */

/* %if-tables-serialization */
/* %endif */
/* end standard C headers. */

/* %if-c-or-c++ */
/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* %endif */

/* %if-c++-only */
/* %endif */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* %not-for-header */

/* Returned upon end-of-file. */
#define YY_NULL 0
/* %ok-for-header */

/* %not-for-header */

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)
/* %ok-for-header */

/* %if-reentrant */
/* %endif */

/* %if-not-reentrant */

/* %endif */

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart(yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

/* %if-not-reentrant */
extern yy_size_t yyleng;
/* %endif */

/* %if-c-only */
/* %if-not-reentrant */
extern FILE *yyin, *yyout;
/* %endif */
/* %endif */

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
/* %if-c-only */
	FILE *yy_input_file;
/* %endif */

/* %if-c++-only */
/* %endif */

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	yy_size_t yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* %if-c-only Standard (non-C++) definition */
/* %not-for-header */

/* %if-not-reentrant */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */
/* %endif */
/* %ok-for-header */

/* %endif */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* %if-c-only Standard (non-C++) definition */

/* %if-not-reentrant */
/* %not-for-header */

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static yy_size_t yy_n_chars;		/* number of characters read into yy_ch_buf */
yy_size_t yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;
/* %ok-for-header */

/* %endif */

void yyrestart (FILE *input_file  );
void yy_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer (FILE *file,int size  );
void yy_delete_buffer (YY_BUFFER_STATE b  );
void yy_flush_buffer (YY_BUFFER_STATE b  );
void yypush_buffer_state (YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state (void );

static void yyensure_buffer_stack (void );
static void yy_load_buffer_state (void );
static void yy_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER yy_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE yy_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes (yyconst char *bytes,yy_size_t len  );

/* %endif */

void *yyalloc (yy_size_t  );
void *yyrealloc (void *,yy_size_t  );
void yyfree (void *  );

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* %% [1.0] yytext/yyin/yyout/yy_state_type/yylineno etc. def's & init go here */
/* Begin user sect3 */

#define FLEX_DEBUG

typedef unsigned char YY_CHAR;

FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;

typedef int yy_state_type;

extern int yylineno;

int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

/* %% [1.5] DFA */

/* %if-c-only Standard (non-C++) definition */

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
#if defined(__GNUC__) && __GNUC__ >= 3
__attribute__((__noreturn__))
#endif
static void yy_fatal_error (yyconst char msg[]  );

/* %endif */

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
/* %% [2.0] code to fiddle yytext and yyleng for yymore() goes here \ */\
	yyleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
/* %% [3.0] code to copy yytext_ptr to yytext[] goes here, if %array \ */\
	(yy_c_buf_p) = yy_cp;

/* %% [4.0] data tables for the DFA and the user's section 1 definitions go here */
#define YY_NUM_RULES 76
#define YY_END_OF_BUFFER 77
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[247] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
       77,    7,    6,    5,    7,    7,    7,    7,   31,   11,
       10,   31,   30,   31,   30,   30,   30,   30,   30,   30,
       30,   30,   30,   30,   30,   30,   48,   11,   34,   60,
       60,   60,   60,   60,   60,   48,   48,   46,   37,   60,
       39,   47,   60,   47,   47,   60,   66,   65,   61,   66,
       74,   74,   75,   75,   75,   67,    6,    0,    4,    0,
        0,    3,    0,   11,    0,    9,   30,    8,   30,   30,
       30,   30,   30,   30,   30,   30,   30,   30,   30,   30,
       30,   30,   48,   36,   41,    0,   55,    0,   54,   52,

       49,    0,    0,   32,   46,   44,   45,   38,   35,   59,
       40,   47,   47,   42,   33,    0,   61,    0,   64,   64,
       64,   74,    0,   70,    0,   68,   68,    0,    2,    0,
       30,   30,   30,   30,   30,   30,   30,   30,   30,   30,
       28,   30,   30,   30,   14,   30,   58,   58,   58,   49,
        0,    0,    0,    0,   47,    0,    0,   71,   71,   71,
       68,    0,    0,    0,    1,   30,   30,   30,   27,   30,
       30,   30,   30,   30,   30,   30,   30,   12,   30,   30,
        0,    0,   53,    0,   51,   51,    0,    0,   50,   47,
       62,   63,    0,    0,   69,    0,   69,    0,   30,   30,

       30,   30,   30,   30,   30,   30,   30,   30,   17,   30,
       30,   15,   56,   57,   43,   72,   73,   21,   26,   30,
       30,   30,   13,   30,   16,   30,   20,   29,   22,   30,
       25,   30,   30,   19,   24,   30,   30,   30,   23,   30,
       30,   30,   30,   30,   18,    0
    } ;

static yyconst YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    4,    5,    6,    7,    8,    9,    1,   10,
       10,   11,   12,    1,   13,   14,    1,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   15,   16,    1,   17,
       18,   19,   20,   11,   21,   21,   21,   21,   21,   21,
       22,   23,   23,   23,   23,   24,   23,   23,   22,   23,
       23,   23,   22,   23,   23,   23,   23,   25,   23,   23,
       10,   26,   10,    1,   23,    1,   27,   28,   29,   30,

       31,   32,   33,   34,   35,   23,   36,   37,   38,   39,
       40,   41,   23,   42,   43,   44,   45,   46,   22,   47,
       23,   23,   48,   49,   50,   51,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst YY_CHAR yy_meta[52] =
    {   0,
        1,    2,    3,    2,    4,    5,    4,    4,    2,    2,
        6,    7,    8,    1,    9,    7,    2,   10,    2,    7,
        9,   11,   11,   11,   11,    2,    9,    9,    9,    9,
        9,    9,   11,   11,   11,   11,   11,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,   12,    2,   13,
        2
    } ;

static yyconst flex_uint16_t yy_base[276] =
    {   0,
        0,    2,   44,    0,   95,    0,    4,    7,  144,  150,
      606,  607,  603,  607,  601,    4,  600,  557,  607,  599,
      607,  597,    0,  596,  561,  566,  113,  569,  558,  555,
      562,  557,  564,  117,  559,  550,    0,  586,  132,    6,
      584,  150,  139,  577,  607,  570,  186,  569,  565,  145,
      564,   23,  578,  165,  125,  531,   15,  607,  607,  155,
        0,    0,  163,  156,  607,  607,  577,  574,  607,  555,
        7,  607,  520,  557,  539,  607,    0,  607,  496,  483,
      481,  462,  433,  426,  143,  430,  422,  134,  421,  421,
      410,  409,    0,  607,  607,  164,  607,  159,  607,  607,

        0,    1,  436,  607,  423,    0,    0,  607,  607,  607,
      607,  392,  151,  387,  607,  177,  607,  196,  607,  413,
        0,    0,  183,  607,  198,  607,    0,   10,  412,  392,
      392,  323,  316,  308,  314,  322,  312,  317,  306,  310,
        0,  315,  303,  311,  310,  309,  607,  324,    0,    0,
      323,  222,  234,  180,  194,  322,    0,  607,  321,    0,
        0,  320,  243,  253,  607,  295,  289,  301,    0,  213,
      304,  285,  287,  297,  283,  292,  281,    0,  281,  275,
      298,    0,  607,  262,  607,  265,  274,  284,  607,  183,
      607,  607,  296,    0,  607,  287,  296,  305,  264,  275,

      262,  254,  261,  254,  259,  244,  240,  233,    0,  226,
      222,  236,  607,  607,  222,  607,  607,    0,    0,  216,
      226,  211,    0,  220,    0,  203,    0,    0,    0,  209,
        0,  202,  201,    0,    0,  186,  172,  160,    0,  154,
      164,  159,  139,    6,    0,  607,  355,  368,  381,  394,
      407,  413,  424,  435,  444,  456,  467,  480,  493,  505,
      510,  522,  528,  532,   29,  543,  549,  553,   27,  558,
       22,   20,  565,   18,    4
    } ;

static yyconst flex_int16_t yy_def[276] =
    {   0,
      247,  247,  246,    3,  246,    5,  248,  248,  249,  249,
      246,  246,  246,  246,  250,  246,  246,  246,  246,  246,
      246,  251,  252,  246,  252,  252,  252,  252,  252,  252,
      252,  252,  252,  252,  252,  252,  253,  246,  246,  254,
      251,  255,  246,  246,  246,  253,  253,  253,  246,  246,
      246,  256,  246,  256,   54,  246,  257,  246,  246,  258,
      259,  259,  260,  261,  246,  246,  246,  250,  246,  246,
      246,  246,  246,  246,  251,  246,  252,  246,  252,  252,
      252,  252,  252,  252,  252,  252,  252,  252,  252,  252,
      252,  252,  253,  246,  246,  254,  246,  262,  246,  246,

      263,  264,  246,  246,  253,  253,  253,  246,  246,  246,
      246,   54,   54,   54,  246,  257,  246,  258,  246,  246,
      265,  259,  260,  246,  266,  246,  267,  268,  246,  246,
      252,  252,  252,  252,  252,  252,  252,  252,  252,  252,
      252,  252,  252,  252,  252,  252,  246,  246,  269,  263,
      246,  246,  270,  246,   54,  246,  271,  246,  246,  272,
      267,  246,  246,  273,  246,  252,  252,  252,  252,  252,
      252,  252,  252,  252,  252,  252,  252,  252,  252,  252,
      246,  274,  246,  246,  246,  270,  270,  246,  246,   54,
      246,  246,  246,  275,  246,  246,  273,  273,  252,  252,

      252,  252,  252,  252,  252,  252,  252,  252,  252,  252,
      252,  252,  246,  246,   54,  246,  246,  252,  252,  252,
      252,  252,  252,  252,  252,  252,  252,  252,  252,  252,
      252,  252,  252,  252,  252,  252,  252,  252,  252,  252,
      252,  252,  252,  252,  252,    0,  246,  246,  246,  246,
      246,  246,  246,  246,  246,  246,  246,  246,  246,  246,
      246,  246,  246,  246,  246,  246,  246,  246,  246,  246,
      246,  246,  246,  246,  246
    } ;

static yyconst flex_uint16_t yy_nxt[659] =
    {   0,
      246,   13,   14,   13,   14,   15,   58,   15,   59,   58,
       97,   59,  217,  151,   16,  152,   16,   70,   71,  117,
       70,   71,  162,   93,  163,   17,  214,   17,  194,   60,
      192,   98,   60,   93,   93,  182,   93,  157,   93,  245,
      118,   18,   93,   18,   19,   20,   21,   19,   19,   22,
       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
       19,   19,   19,   19,   23,   23,   23,   23,   23,   24,
       23,   23,   25,   26,   27,   28,   29,   23,   30,   31,
       32,   33,   23,   23,   23,   34,   35,   23,   36,   23,
       23,   19,   19,   19,   19,   37,   38,   21,   39,   40,

       41,   42,   43,   44,   45,   37,   46,   47,   37,   48,
       37,   49,   50,   51,   37,   52,   52,   52,   52,   52,
       53,   52,   52,   52,   52,   52,   52,   54,   52,   55,
       52,   52,   52,   52,   52,   52,   52,   52,   52,   52,
       52,   52,   45,   56,   45,   45,   62,   89,   63,   94,
       64,   65,   62,   99,   63,   99,   64,   65,   81,   82,
       99,   90,  109,  114,  100,   93,  112,  124,   97,  120,
      126,  137,  245,  148,  141,   93,   93,  142,   93,  121,
       93,  117,   95,  149,   93,  138,  103,  124,  125,   98,
      155,  244,  112,   66,  154,  110,  243,  102,  242,   66,

      105,  121,  118,  128,  241,  149,  113,  106,  125,  107,
      120,  240,  159,  106,  106,  106,  106,  106,  106,  107,
      121,  106,  160,  215,  112,  202,  106,  106,  106,   99,
      106,  239,  106,  183,  183,  112,  152,  184,  190,  183,
      238,  183,  121,  237,  160,  185,  186,  236,  235,  188,
      234,  185,  233,  185,  195,  195,  203,  163,  196,  232,
      195,  231,  195,  112,  195,  197,  230,  229,  196,  228,
      195,  100,  195,  183,  183,  227,  185,  186,  226,  183,
      188,  183,  185,  189,  185,  185,  186,  225,  224,  188,
      223,  185,  126,  185,  222,  185,  185,  221,  195,  195,

      220,  185,  126,  185,  195,  219,  195,  195,  197,  218,
      216,  196,  213,  195,  189,  195,  195,  197,  212,  211,
      196,  210,  195,  189,  195,  209,  208,  207,  206,  205,
      204,  201,  200,  199,  163,  193,  191,  152,  181,  180,
      179,  178,  177,  176,  175,  126,  174,  173,  172,  171,
      170,  169,  168,  167,  126,   12,   12,   12,   12,   12,
       12,   12,   12,   12,   12,   12,   12,   12,   57,   57,
       57,   57,   57,   57,   57,   57,   57,   57,   57,   57,
       57,   61,   61,   61,   61,   61,   61,   61,   61,   61,
       61,   61,   61,   61,   68,   68,   68,   68,   68,   68,

       68,   68,   68,   68,   68,   68,   68,   75,   75,   75,
       75,   75,   75,   75,   75,   75,   75,   75,   75,   75,
       77,   77,  166,   77,   93,  165,  129,  156,  112,   93,
       93,   93,   93,  112,   93,   96,   96,  105,   96,   96,
       96,   96,   96,   96,   96,   96,   96,   96,  101,  101,
      154,  146,  101,  145,  101,  101,  112,  144,  143,  140,
      139,  112,  112,  112,  112,  136,  112,  116,  116,  135,
      116,  116,  116,  116,  116,  116,  116,  116,  116,  116,
      119,  119,  119,  119,  119,  119,  119,  119,  119,  119,
      119,  119,  119,  122,  122,  122,  134,  122,  122,  122,

      122,  122,  122,  122,  122,  123,  123,  133,  123,  123,
      123,  123,  123,  123,  123,  123,  123,  123,  127,  132,
      127,  127,  147,  147,  147,  147,  147,  147,  147,  147,
      147,  147,  147,  147,  147,  150,  150,  131,  150,  153,
      153,   76,  153,  158,  158,  158,  158,  158,  158,  158,
      158,  158,  158,  158,  158,  158,  161,  161,   74,  161,
      164,  164,  130,  164,  187,  187,  187,  187,  187,  129,
      187,  198,  198,  198,  198,  198,   69,  198,   67,  115,
       78,  111,  108,  105,  105,  104,   76,   74,   92,   91,
       88,   87,   86,   85,   84,   83,   80,   79,   78,   76,

       74,   73,   72,   69,   67,  246,   11,  246,  246,  246,
      246,  246,  246,  246,  246,  246,  246,  246,  246,  246,
      246,  246,  246,  246,  246,  246,  246,  246,  246,  246,
      246,  246,  246,  246,  246,  246,  246,  246,  246,  246,
      246,  246,  246,  246,  246,  246,  246,  246,  246,  246,
      246,  246,  246,  246,  246,  246,  246,  246
    } ;

static yyconst flex_int16_t yy_chk[659] =
    {   0,
        0,    1,    1,    2,    2,    1,    7,    2,    7,    8,
       40,    8,  275,  102,    1,  102,    2,   16,   16,   57,
       71,   71,  128,   52,  128,    1,  274,    2,  272,    7,
      271,   40,    8,   52,   52,  269,   52,  265,   52,  244,
       57,    1,   52,    2,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    5,    5,    5,    5,    5,

        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    9,   34,    9,   39,
        9,    9,   10,   43,   10,   42,   10,   10,   27,   27,
       42,   34,   50,   55,   42,   54,   55,   63,   96,   60,
       64,   85,  243,   98,   88,   54,   54,   88,   54,   60,
       54,  116,   39,   98,   54,   85,   43,  123,   63,   96,
      113,  242,  113,    9,  154,   50,  241,   42,  240,   10,

       47,   60,  116,   64,  238,   98,   54,   47,  123,   47,
      118,  237,  125,   47,   47,   47,   47,   47,   47,   47,
      118,   47,  125,  190,  190,  170,   47,   47,   47,  154,
       47,  236,   47,  152,  152,  155,  152,  152,  155,  152,
      233,  152,  118,  232,  125,  153,  153,  230,  226,  153,
      224,  153,  222,  153,  163,  163,  170,  163,  163,  221,
      163,  220,  163,  215,  164,  164,  212,  211,  164,  210,
      164,  152,  164,  184,  184,  208,  186,  186,  207,  184,
      186,  184,  186,  153,  186,  187,  187,  206,  205,  187,
      204,  187,  163,  187,  203,  188,  188,  202,  196,  196,

      201,  188,  164,  188,  196,  200,  196,  197,  197,  199,
      193,  197,  181,  197,  186,  197,  198,  198,  180,  179,
      198,  177,  198,  187,  198,  176,  175,  174,  173,  172,
      171,  168,  167,  166,  162,  159,  156,  151,  148,  146,
      145,  144,  143,  142,  140,  197,  139,  138,  137,  136,
      135,  134,  133,  132,  198,  247,  247,  247,  247,  247,
      247,  247,  247,  247,  247,  247,  247,  247,  248,  248,
      248,  248,  248,  248,  248,  248,  248,  248,  248,  248,
      248,  249,  249,  249,  249,  249,  249,  249,  249,  249,
      249,  249,  249,  249,  250,  250,  250,  250,  250,  250,

      250,  250,  250,  250,  250,  250,  250,  251,  251,  251,
      251,  251,  251,  251,  251,  251,  251,  251,  251,  251,
      252,  252,  131,  252,  253,  130,  129,  120,  114,  253,
      253,  253,  253,  112,  253,  254,  254,  105,  254,  254,
      254,  254,  254,  254,  254,  254,  254,  254,  255,  255,
      103,   92,  255,   91,  255,  255,  256,   90,   89,   87,
       86,  256,  256,  256,  256,   84,  256,  257,  257,   83,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      258,  258,  258,  258,  258,  258,  258,  258,  258,  258,
      258,  258,  258,  259,  259,  259,   82,  259,  259,  259,

      259,  259,  259,  259,  259,  260,  260,   81,  260,  260,
      260,  260,  260,  260,  260,  260,  260,  260,  261,   80,
      261,  261,  262,  262,  262,  262,  262,  262,  262,  262,
      262,  262,  262,  262,  262,  263,  263,   79,  263,  264,
      264,   75,  264,  266,  266,  266,  266,  266,  266,  266,
      266,  266,  266,  266,  266,  266,  267,  267,   74,  267,
      268,  268,   73,  268,  270,  270,  270,  270,  270,   70,
      270,  273,  273,  273,  273,  273,   68,  273,   67,   56,
       53,   51,   49,   48,   46,   44,   41,   38,   36,   35,
       33,   32,   31,   30,   29,   28,   26,   25,   24,   22,

       20,   18,   17,   15,   13,   11,  246,  246,  246,  246,
      246,  246,  246,  246,  246,  246,  246,  246,  246,  246,
      246,  246,  246,  246,  246,  246,  246,  246,  246,  246,
      246,  246,  246,  246,  246,  246,  246,  246,  246,  246,
      246,  246,  246,  246,  246,  246,  246,  246,  246,  246,
      246,  246,  246,  246,  246,  246,  246,  246
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 1;

static yyconst flex_int16_t yy_rule_linenum[76] =
    {   0,
      293,  294,  298,  299,  300,  301,  302,  306,  307,  310,
      313,  319,  324,  325,  326,  327,  328,  329,  330,  331,
      332,  333,  334,  335,  336,  337,  338,  339,  340,  341,
      353,  359,  360,  361,  362,  363,  364,  365,  366,  367,
      368,  369,  370,  371,  372,  373,  376,  378,  380,  382,
      384,  388,  390,  395,  397,  401,  405,  410,  415,  416,
      422,  431,  432,  434,  435,  437,  444,  452,  453,  456,
      457,  459,  461,  462,  463
    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "cflex.l"
/* This file is part of GNU Rush.                  
   Copyright (C) 2008-2021 Sergey Poznyakoff

   GNU Rush is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Rush is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Rush.  If not, see <http://www.gnu.org/licenses/>. */
#line 18 "cflex.l"
#include <rush.h>
#include <sys/stat.h>
#include <cf.h>
#include <cfgram.h>

/* Current input stream (yyin is not used) */
static CFSTREAM *input_stream;
/* Buffer for composing string values */
static struct stringbuf sb;

/* Names of the source files form a singly-linked list. They remain in
   the memory until the end of run because various objects refer to them
   (most notably, rush_rule). */
struct source_file {
	struct source_file *prev;
	char filename[1];
};

struct source_file *source_file_last;

char const *
new_source_file_name(char const *f)
{
	struct source_file *file;

	for (file = source_file_last; file; file = file->prev) {
		if (strcmp(file->filename, f) == 0)
			return file->filename;
	}

	file = xmalloc(sizeof(file[0]) + strlen(f));
	strcpy(file->filename, f);
	file->prev = source_file_last;
	source_file_last = file;
	return file->filename;
}

/* Current input location */
struct cfloc curloc;
/* User action is set uo to update end column. */
#define YY_USER_ACTION	(curloc.end.column += yyleng);

/* Advance the end point of the current location N lines. */
static inline void
advance_line(size_t n)
{
	curloc.end.line += n;
	curloc.end.column = 1;
}

/* Reset the start point of the current location to its end point. This
   starts the next token. */
static inline void
reset_loc(void)
{
	curloc.beg = curloc.end;
}

/* This is used in the scanner actions below to return token types. */
static inline int
tok(int c)
{
	yylloc = curloc;
	yylloc.end.column--;
	reset_loc();
	return c;
}

/* The scanner implements several exclusive conditions, some of which
   are preserved on stack. */
struct start_cond {
	struct start_cond *next;
	int start;
};
static struct start_cond *start_tos;

static inline void
pushstart(int newstart)
{
	struct start_cond *sc = malloc(sizeof(sc[0]));
	sc->start = YY_START;
	sc->next = start_tos;
	start_tos = sc;
	BEGIN(newstart);
}

static inline void
popstart(void)
{
	struct start_cond *tos = start_tos;
	if (!tos)
		die(system_error, NULL,
		    _("INTERNAL ERROR at %s:%d: state stack is empty"),
		    __FILE__, __LINE__);
	start_tos = tos->next;
	BEGIN(tos->start);
	free(tos);
}

static int in_var(void);

/* Read next chunk of the input. */
#undef YY_INPUT
#define YY_INPUT(buf,result,max_size)		\
	(result) = cfstream_read(input_stream, buf, max_size)

/* Additional stringbuf function for use when processing escape sequences.
   SB is the string buffer, TEXT is the input text ending with '\' + something,
   LENG is number of bytes in it.
 */

/* Default function: TEXT ends with a C-style escape sequence (e.g. \v) or
   rush-specific \% escape.
   Unrecognized escape sequence is reported and transferred varbatim
   to the output.
   Within a ${V:-""} construct, only "\\n" and "\%" are processed, the rest
   is retained. It will be expanded by wordsplit.
*/
static void
stringbuf_add_escape_dfl(struct stringbuf *sb, char const *text, size_t leng)
{
	int c = text[leng - 1];

	if (in_var()) {
		if (c != '\n' && c != '%') {
			stringbuf_add_array(sb, text, leng);
			return;
		}
	}

	stringbuf_add_array(sb, text, leng - 2);
	switch (c) {
	case 'a':
		stringbuf_add_char(sb, '\a');
		break;
	case 'b':
		stringbuf_add_char(sb, '\b');
		break;
	case 'f':
		stringbuf_add_char(sb, '\f');
		break;
	case 'n':
		stringbuf_add_char(sb, '\n');
		break;
	case 'r':
		stringbuf_add_char(sb, '\r');
		break;
	case 't':
		stringbuf_add_char(sb, '\t');
		break;
	case 'v':
		stringbuf_add_char(sb, '\v');
		break;
	case '\\':
	case '\"':
		stringbuf_add_char(sb, c);
		break;
	case '\n':
		advance_line(1);
		break;
	case '%':
		stringbuf_add_array(sb, text + leng - 2, 2);
		break;
	default: {
		struct cfloc loc;
		loc.beg = loc.end = curloc.end;
		loc.beg.column -= 2;
		cferror(&loc, _("unrecognized escape \\%c"), c);
		stringbuf_add_array(sb, text + leng - 2, 2);
	}
	}
}

/* TEXT ends with a '\' followed by a 3-byte octal number.
   No expansion occurs within a ${V:-""} construct.
*/
static void
stringbuf_add_escape_octal(struct stringbuf *sb, char const *text, size_t leng)
{
	if (in_var()) {
		stringbuf_add_array(sb, text, leng);
	} else {
		stringbuf_add_array(sb, text, leng - 4);
		stringbuf_add_char(sb, strtoul(text + leng - 3, NULL, 8));
	}
}

/* TEXT ends with a '\x' followed by a 2-byte hex number.
   No expansion occurs within a ${V:-""} construct.
*/
static void
stringbuf_add_escape_hex(struct stringbuf *sb, char const *text, size_t leng)
{
	if (in_var()) {
		stringbuf_add_array(sb, text, leng);
	} else {
		stringbuf_add_array(sb, text, leng - 4);
		stringbuf_add_char(sb, strtoul(text + leng - 2, NULL, 16));
	}
}

/* Input_Stream context stack */
struct inpctx {
	struct inpctx   *prev;
	struct cfloc    loc;   /* Location */
	CFSTREAM        *input_stream;
	YY_BUFFER_STATE buf;   /* lex buffer state */
};

static struct inpctx *inpctx_tos;

/* Returns 1 if an included file is being processed. */
static inline int
in_included_file(void)
{
	return inpctx_tos != NULL;
}

/* Look up in the stack for the input context matching the device and
   inode numbers from ST. */
static struct inpctx *
inpctx_locate(struct stat *st)
{
	struct inpctx *ctx;

	for (ctx = inpctx_tos; ctx; ctx = ctx->prev)
		if (cfstream_same_file(ctx->input_stream, st))
			break;
	return ctx;
}

/* Push current input context on stack. */
static void
inpctx_push(void)
{
	struct inpctx *ctx = xmalloc(sizeof(ctx[0]));

	ctx->loc = curloc;
	ctx->input_stream = input_stream;
	ctx->buf = YY_CURRENT_BUFFER;
	ctx->prev = inpctx_tos;
	inpctx_tos = ctx;
	yy_switch_to_buffer(yy_create_buffer(yyin,YY_BUF_SIZE));
}

/* Pop the top of stack into the current input context. */
static int
inpctx_pop(void)
{
	struct inpctx *ctx = inpctx_tos;
	if (!ctx)
		return 1;
	inpctx_tos = ctx->prev;

	curloc = ctx->loc;
	input_stream = ctx->input_stream;
	yy_delete_buffer(YY_CURRENT_BUFFER);
	yy_switch_to_buffer(ctx->buf);
	free(ctx);
	return 0;
}

/* Forward declarations */
static void straychar(int);
static int noinc(void);

#line 1075 "cflex.c"

#define INITIAL 0
#define NORMAL 1
#define ARGS 2
#define QSTR 3
#define VAR 4

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
/* %if-c-only */
#include <unistd.h>
/* %endif */
/* %if-c++-only */
/* %endif */
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* %if-c-only Reentrant structure and macros (non-C++). */
/* %if-reentrant */
/* %if-c-only */

static int yy_init_globals (void );

/* %endif */
/* %if-reentrant */
/* %endif */
/* %endif End reentrant structures and macros. */

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy (void );

int yyget_debug (void );

void yyset_debug (int debug_flag  );

YY_EXTRA_TYPE yyget_extra (void );

void yyset_extra (YY_EXTRA_TYPE user_defined  );

FILE *yyget_in (void );

void yyset_in  (FILE * _in_str  );

FILE *yyget_out (void );

void yyset_out  (FILE * _out_str  );

yy_size_t yyget_leng (void );

char *yyget_text (void );

int yyget_lineno (void );

void yyset_lineno (int _line_number  );

/* %if-bison-bridge */
/* %endif */

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap (void );
#else
extern int yywrap (void );
#endif
#endif

/* %not-for-header */

#ifndef YY_NO_UNPUT
    
#endif
/* %ok-for-header */

/* %endif */

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT
/* %if-c-only Standard (non-C++) definition */
/* %not-for-header */

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif
/* %ok-for-header */

/* %endif */
#endif

/* %if-c-only */

/* %endif */

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* %if-c-only Standard (non-C++) definition */
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, yyleng, 1, yyout )) {} } while (0)
/* %endif */
/* %if-c++-only C++ definition */
/* %endif */
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
/* %% [5.0] fread()/read() definition of YY_INPUT goes here unless we're doing C++ \ */\
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\
/* %if-c++-only C++ definition \ */\
/* %endif */

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
/* %if-c-only */
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
/* %endif */
/* %if-c++-only */
/* %endif */
#endif

/* %if-tables-serialization structures and prototypes */
/* %not-for-header */

/* %ok-for-header */

/* %not-for-header */

/* %tables-yydmap generated elements */
/* %endif */
/* end tables serialization structures and prototypes */

/* %ok-for-header */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1
/* %if-c-only Standard (non-C++) definition */

extern int yylex (void);

#define YY_DECL int yylex (void)
/* %endif */
/* %if-c++-only C++ definition */
/* %endif */
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

/* %% [6.0] YY_RULE_SETUP definition goes here */
#define YY_RULE_SETUP \
	YY_USER_ACTION

/* %not-for-header */

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
/* %if-c-only */
			yyin = stdin;
/* %endif */
/* %if-c++-only */
/* %endif */

		if ( ! yyout )
/* %if-c-only */
			yyout = stdout;
/* %endif */
/* %if-c++-only */
/* %endif */

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer(yyin,YY_BUF_SIZE );
		}

		yy_load_buffer_state( );
		}

	{
/* %% [7.0] user's declarations go here */
#line 286 "cflex.l"

 /* INITIAL: The scanner is processing the initial portion of the input file,
    until the version clause ("rush X.Y\n"), upon which the NORMAL state is
    activated, or any other token, upon which the control is transferred to
    the legacy parser (see config.c).
  */
#line 1369 "cflex.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
/* %% [8.0] yymore()-related code goes here */
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

/* %% [9.0] code to set up and find next match goes here */
		yy_current_state = (yy_start);
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 247 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 607 );

yy_find_action:
/* %% [10.0] code to find the action number goes here */
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

/* %% [11.0] code for yylineno update goes here */

do_action:	/* This label is used only to access EOF actions. */

/* %% [12.0] debug code goes here */
		if ( yy_flex_debug )
			{
			if ( yy_act == 0 )
				fprintf( stderr, "--scanner backing up\n" );
			else if ( yy_act < 76 )
				fprintf( stderr, "--accepting rule at line %ld (\"%s\")\n",
				         (long)yy_rule_linenum[yy_act], yytext );
			else if ( yy_act == 76 )
				fprintf( stderr, "--accepting default rule (\"%s\")\n",
				         yytext );
			else if ( yy_act == 77 )
				fprintf( stderr, "--(end of buffer or a NUL)\n" );
			else
				fprintf( stderr, "--EOF (start condition %d)\n", YY_START );
			}

		switch ( yy_act )
	{ /* beginning of action switch */
/* %% [13.0] actions go here */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 293 "cflex.l"
return RUSH;
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 294 "cflex.l"
{ char *p;
	          yylval.version.major = strtoul(yytext, &p, 10);
		  yylval.version.minor = strtoul(p + 1, NULL, 10);
		  return tok(T_VERSION); }
	YY_BREAK
case 3:
/* rule 3 can match eol */
YY_RULE_SETUP
#line 298 "cflex.l"
{ advance_line(1); }
	YY_BREAK
case 4:
/* rule 4 can match eol */
YY_RULE_SETUP
#line 299 "cflex.l"
{ advance_line(1); return EOL; }
	YY_BREAK
case 5:
/* rule 5 can match eol */
YY_RULE_SETUP
#line 300 "cflex.l"
{ advance_line(1); return EOL; }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 301 "cflex.l"
reset_loc();
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 302 "cflex.l"
return tok(BOGUS);
	YY_BREAK


case 8:
/* rule 8 can match eol */
YY_RULE_SETUP
#line 306 "cflex.l"
{ advance_line(1); }
	YY_BREAK
case 9:
/* rule 9 can match eol */
YY_RULE_SETUP
#line 307 "cflex.l"
{ advance_line(1);
	      BEGIN(NORMAL);
	      return tok(EOL); }	 
	YY_BREAK
case 10:
/* rule 10 can match eol */
YY_RULE_SETUP
#line 310 "cflex.l"
{ advance_line(1);
	      BEGIN(NORMAL);
	      return tok(EOL); }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 313 "cflex.l"
reset_loc();
	YY_BREAK

/* NORMAL: The input point is before the next keyword.
  */

case 12:
YY_RULE_SETUP
#line 319 "cflex.l"
{ if (!noinc()) {
	              BEGIN(ARGS);
		      return tok(RULE);
              }
            }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 324 "cflex.l"
{ if (!noinc()) return tok(GLOBAL); }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 325 "cflex.l"
{ BEGIN(ARGS); return tok(SET); }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 326 "cflex.l"
{ BEGIN(ARGS); return tok(UNSET); }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 327 "cflex.l"
{ BEGIN(ARGS); return tok(INSERT); }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 328 "cflex.l"
{ BEGIN(ARGS); return tok(MATCH); }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 329 "cflex.l"
{ BEGIN(ARGS); return tok(FALLTHROUGH); }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 330 "cflex.l"
{ BEGIN(ARGS); return tok(INCLUDE); }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 331 "cflex.l"
{ BEGIN(ARGS); return tok(LIMITS); }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 332 "cflex.l"
{ BEGIN(ARGS); return tok(CLRENV); }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 333 "cflex.l"
{ BEGIN(ARGS); return tok(SETENV); }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 334 "cflex.l"
{ BEGIN(ARGS); return tok(UNSETENV); }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 335 "cflex.l"
{ BEGIN(ARGS); return tok(KEEPENV); }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 336 "cflex.l"
{ BEGIN(ARGS); return tok(EVALENV); }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 337 "cflex.l"
{ BEGIN(ARGS); return tok(DELETE); }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 338 "cflex.l"
{ BEGIN(ARGS); return tok(EXIT); }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 339 "cflex.l"
{ BEGIN(ARGS); return tok(MAP); }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 340 "cflex.l"
{ BEGIN(ARGS); return tok(REMOPT); }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 341 "cflex.l"
{
	if ((yylval.attrib = rule_attrib_lookup(yytext))) {
	        BEGIN(ARGS);
		return tok(ATTRIB);
	} else if ((yylval.global_attrib = global_attrib_lookup(yytext))) {
		BEGIN(ARGS);
		return tok(GLATTRIB);
	} else {
		yylval.str = xstrdup(yytext);
  	        return tok(IDENT);
        }
		}
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 353 "cflex.l"
return tok(yytext[0]);
	YY_BREAK

/* ARGS: Processing arguments to a configuration statement.
  */

case 32:
YY_RULE_SETUP
#line 359 "cflex.l"
return tok(AND);
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 360 "cflex.l"
return tok(OR);
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 361 "cflex.l"
return tok(NOT);
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 362 "cflex.l"
return tok(EQ);
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 363 "cflex.l"
return tok(NE);
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 364 "cflex.l"
return tok(LT);
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 365 "cflex.l"
return tok(LE);
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 366 "cflex.l"
return tok(GT);
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 367 "cflex.l"
return tok(GE);
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 368 "cflex.l"
return tok(NM);
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 369 "cflex.l"
return tok(IN);
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 370 "cflex.l"
return tok(GROUP);
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 371 "cflex.l"
{ yylval.fstest = yytext[1]; return tok(TEST); }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 372 "cflex.l"
{ yylval.fstest = fs_symlink; return tok(TEST); } 
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 373 "cflex.l"
{ yylval.num.strval = xstrdup(yytext);
				yylval.num.intval = atoi(yytext);
				return tok(NUMBER); }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 376 "cflex.l"
{ yylval.str = xstrdup(yytext);
				return tok(IDENT); }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 378 "cflex.l"
{ yylval.str = xstrdup(yytext);
			  	   return tok(STRING); }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 380 "cflex.l"
{ yylval.str = xstrdup(yytext);
				return tok(STRING);  }
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 382 "cflex.l"
{ yylval.str = xstrdup(yytext);
				return tok(STRING); }
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 384 "cflex.l"
{
				stringbuf_init(&sb);
				stringbuf_add_array(&sb, yytext, yyleng);
				pushstart(VAR); }
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 388 "cflex.l"
{ yylval.str = xstrdup(yytext);
				return tok(STRING); }
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 390 "cflex.l"
{
				stringbuf_init(&sb);
				stringbuf_add_array(&sb, yytext, yyleng);
				pushstart(VAR); }
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 395 "cflex.l"
{ yylval.str = xstrdup(yytext);
			        return tok(STRING); }
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 397 "cflex.l"
{ yylval.str = xmalloc(yyleng-1);
			   memcpy(yylval.str, yytext + 1, yyleng - 2);
			   yylval.str[yyleng - 2] = 0;
			   return tok(STRING); }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 401 "cflex.l"
{ stringbuf_init(&sb);
			   stringbuf_add_escape_octal(&sb,
						      yytext + 1, yyleng - 1);
			   pushstart(QSTR); }
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 405 "cflex.l"
{
			   stringbuf_init(&sb);
			   stringbuf_add_escape_hex(&sb,
						    yytext + 1, yyleng - 1);
			   pushstart(QSTR); }
	YY_BREAK
case 58:
/* rule 58 can match eol */
YY_RULE_SETUP
#line 410 "cflex.l"
{
	                   stringbuf_init(&sb);
			   stringbuf_add_escape_dfl(&sb,
						    yytext + 1, yyleng - 1);
			   pushstart(QSTR); }
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 415 "cflex.l"
return tok(XF);
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 416 "cflex.l"
return tok(yytext[0]);
	YY_BREAK

/* QSTR: Composing a quoted string.
  */

case 61:
YY_RULE_SETUP
#line 422 "cflex.l"
{ stringbuf_add_array(&sb, yytext, yyleng - 1);
			   popstart();
	                   if (YY_START == ARGS) {
	                           stringbuf_finish(&sb);
			           yylval.str = sb.buffer;
			           return tok(STRING);
			   } else
				   stringbuf_add_char(&sb, yytext[yyleng-1]);
                         }
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 431 "cflex.l"
{ stringbuf_add_escape_octal(&sb, yytext, yyleng); }
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 432 "cflex.l"
{
	                   stringbuf_add_escape_hex(&sb, yytext, yyleng); }
	YY_BREAK
case 64:
/* rule 64 can match eol */
YY_RULE_SETUP
#line 434 "cflex.l"
{ stringbuf_add_escape_dfl(&sb, yytext, yyleng); }
	YY_BREAK
case 65:
/* rule 65 can match eol */
YY_RULE_SETUP
#line 435 "cflex.l"
{  advance_line(1);
	yyerror("unescaped newline in quoted string"); }
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 437 "cflex.l"
{  straychar(yytext[0]); }
	YY_BREAK

/* VAR: The scanner is processing an unquoted variable reference with
    a default value (e.g. ${X:-0}).
  */

case 67:
YY_RULE_SETUP
#line 444 "cflex.l"
{ stringbuf_add_char(&sb, yytext[0]);
	                        popstart();
				if (YY_START != VAR) {
					stringbuf_finish(&sb);
					yylval.str = sb.buffer;
					return tok(STRING);
				}
			      }
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 452 "cflex.l"
{ stringbuf_add_array(&sb, yytext, yyleng); }
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 453 "cflex.l"
{
				stringbuf_add_array(&sb, yytext, yyleng);
				pushstart(VAR); }
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 456 "cflex.l"
{ stringbuf_add_array(&sb, yytext, yyleng); }
	YY_BREAK
case 71:
/* rule 71 can match eol */
YY_RULE_SETUP
#line 457 "cflex.l"
{ stringbuf_add_escape_dfl(&sb, yytext, yyleng);
                                   pushstart(QSTR); }
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 459 "cflex.l"
{ stringbuf_add_escape_octal(&sb, yytext, yyleng);
				pushstart(QSTR); }
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 461 "cflex.l"
{ stringbuf_add_escape_hex(&sb, yytext, yyleng);				   pushstart(QSTR); }
	YY_BREAK
case 74:
/* rule 74 can match eol */
YY_RULE_SETUP
#line 462 "cflex.l"
{ stringbuf_add_array(&sb, yytext, yyleng); }
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 463 "cflex.l"
{ straychar(yytext[0]);
	                        stringbuf_add_char(&sb, yytext[0]); }
	YY_BREAK

case 76:
YY_RULE_SETUP
#line 466 "cflex.l"
ECHO;
	YY_BREAK
#line 1932 "cflex.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(NORMAL):
case YY_STATE_EOF(ARGS):
case YY_STATE_EOF(QSTR):
case YY_STATE_EOF(VAR):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
/* %if-c-only */
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
/* %endif */
/* %if-c++-only */
/* %endif */
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
/* %% [14.0] code to do back-up for compressed tables and set up yy_cp goes here */
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */
/* %ok-for-header */

/* %if-c++-only */
/* %not-for-header */

/* %ok-for-header */

/* %endif */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
/* %if-c-only */
static int yy_get_next_buffer (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	yy_size_t number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (yy_size_t) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			yy_size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				yy_size_t new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart(yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) ((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

/* %if-c-only */
/* %not-for-header */

    static yy_state_type yy_get_previous_state (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
/* %% [15.0] code to get the start state into yy_current_state goes here */
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
/* %% [16.0] code to find the next state goes here */
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 247 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
/* %if-c-only */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
/* %endif */
/* %if-c++-only */
/* %endif */
{
	int yy_is_jam;
    /* %% [17.0] code to find the next state, and perhaps do backing up, goes here */
	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 247 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 246);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT
/* %if-c-only */

/* %endif */
#endif

/* %if-c-only */
#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

/* %endif */
/* %if-c++-only */
/* %endif */
{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			yy_size_t offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart(yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

/* %% [19.0] update BOL and yylineno */

	return c;
}
/* %if-c-only */
#endif	/* ifndef YY_NO_INPUT */
/* %endif */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
/* %if-c-only */
    void yyrestart  (FILE * input_file )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer(yyin,YY_BUF_SIZE );
	}

	yy_init_buffer(YY_CURRENT_BUFFER,input_file );
	yy_load_buffer_state( );
}

/* %if-c++-only */
/* %endif */

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
/* %if-c-only */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

/* %if-c-only */
static void yy_load_buffer_state  (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
/* %if-c-only */
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
/* %endif */
/* %if-c++-only */
/* %endif */
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
/* %if-c-only */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
/* %endif */
/* %if-c++-only */
/* %endif */
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = (yy_size_t)size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer(b,file );

	return b;
}

/* %if-c++-only */
/* %endif */

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
/* %if-c-only */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree((void *) b->yy_ch_buf  );

	yyfree((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
/* %if-c-only */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )
/* %endif */
/* %if-c++-only */
/* %endif */

{
	int oerrno = errno;
    
	yy_flush_buffer(b );

/* %if-c-only */
	b->yy_input_file = file;
/* %endif */
/* %if-c++-only */
/* %endif */
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

/* %if-c-only */

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
/* %endif */
/* %if-c++-only */
/* %endif */
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
/* %if-c-only */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( );
}

/* %if-c-or-c++ */
/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
/* %if-c-only */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}
/* %endif */

/* %if-c-or-c++ */
/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
/* %if-c-only */
void yypop_buffer_state (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}
/* %endif */

/* %if-c-or-c++ */
/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
/* %if-c-only */
static void yyensure_buffer_stack (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1; // After all that talk, this was set to 1 anyways...
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );
								  
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer(b  );

	return b;
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (yyconst char * yystr )
{
    
	return yy_scan_bytes(yystr,strlen(yystr) );
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (yyconst char * yybytes, yy_size_t  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	yy_size_t i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) yyalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}
/* %endif */

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

/* %if-c-only */
static void yy_fatal_error (yyconst char* msg )
{
			(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}
/* %endif */
/* %if-c++-only */
/* %endif */

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/* %if-c-only */
/* %if-reentrant */
/* %endif */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
        
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
yy_size_t yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/* %if-reentrant */
/* %endif */

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

/* %endif */

/* %if-reentrant */
/* %if-bison-bridge */
/* %endif */
/* %endif if-c-only */

/* %if-c-only */
static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = (FILE *) 0;
    yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}
/* %endif */

/* %if-c-only SNIP! this currently causes conflicts with the c++ scanner */
/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

/* %if-reentrant */
/* %endif */
    return 0;
}
/* %endif */

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return (void *) malloc( size );
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

/* %if-tables-serialization definitions */
/* %define-yytables   The name for this specific scanner's tables. */
#define YYTABLES_NAME "yytables"
/* %endif */

/* %ok-for-header */

#line 466 "cflex.l"


/* If processing the included file, report an error, drain the input, and
   return 1. Otherwise, return 0. */
static int
noinc(void)
{
	if (in_included_file()) {
		yyerror(_("the %s statement is not allowed in included file"),
		        yytext);
		cferror(&curloc, _("skipping to the end of file"));
		while (input() != EOF)
			      ;
		return 1;
	}
	return 0;
}             

/* Return true if the quoted string being expanded occurs within a
   variable construct -- ${V:-"string"} */
static int
in_var(void)
{
	return (start_tos && start_tos->start == VAR);
}

/* Report a stray character C */
static void
straychar(int c)
{
	static char *start_name[] = {
		[INITIAL] = N_("looking for rush version clause"),
		[NORMAL] =  N_("looking for rule"),
		[ARGS] = N_("scanning arguments"),
		[QSTR] = N_("scanning quoted string"),
		[VAR] = N_("scanning variable reference")
	};
	if (isprint(c)) {
		yyerror(_("stray character %c while %s"), c,
			gettext(start_name[YY_START]));
	} else {
		yyerror(_("stray character %03o while %s"), c,
			gettext(start_name[YY_START]));
	}
}

/* Skip the input up to the next '\n' character. */
void
skiptoeol(void)
{
	int c;

	while ((c = input()) != EOF && c != '\n')
		;
}

/* Clear the start state stack and switch scanner to the NORMAL state. */
void
restorenormal(void)
{
	while (start_tos)
		popstart();
	BEGIN(NORMAL);
}

/* Initialize current location to point to this filename and line number. */
static void
curloc_init(char const *filename, int line)
{
	curloc.beg.filename = new_source_file_name(filename);
	curloc.beg.line = line;
	curloc.beg.column = 1;
	curloc.end = curloc.beg;
}

/* Switch to input from CF. FILENAME and LINE give the initial location. */
void
cflex_setup(CFSTREAM *cf, char const *filename, int line)
{
	curloc_init(filename, line);
	input_stream = cf;
	YY_FLUSH_BUFFER;
}

/* Set scanner debug level to V. */
void
cflex_debug(int v)
{
#ifdef FLEX_DEBUG
	yy_flex_debug = v;
#endif
}

/* Switch to the NORMAL condition. */
void
cflex_normal(void)
{
	BEGIN(NORMAL);
}

/* Include FILENAME. Return 0 on success, -1 on error. */
int
cflex_include(char const *filename, struct cfloc const *loc)
{
	char *name = expand_tilde(filename, rush_pw->pw_dir);
	struct stat st;
	struct inpctx *ctx;
	
	if (trimslash(name) == 0) {
		free(name);
		cferror(loc, _("invalid include file name"));
		return -1;
	}

	if (stat(name, &st)) {
		if (errno == ENOENT) {
			debug(1, _("Ignoring non-existing include file %s"),
			      name);
			free(name);
			return 0;
		} else {
			cferror(loc, _("cannot stat file %s: %s"),
				name, strerror(errno));
			free(name);
			return -1;
		}
	} 

	if (S_ISDIR(st.st_mode)) {
		char *file = make_file_name(name, rush_pw->pw_name);
		free(name);
		name = file;
		if (access(name, F_OK)) {
		        if (errno == ENOENT) {
				debug(1,
				      _("Ignoring non-existing include file %s"),
				      name);
				free(name);
				return 0;
			} else {
				cferror(loc, "access(%s): %s",
					name, strerror(errno));
				free(name);
				return -1;
			}
		}
	}

	inpctx_push();
	if ((ctx = inpctx_locate(&st))) {
		ctx = ctx->prev;
		if (ctx) {
			cferror(loc, "%s already included", name);
			cferror(&ctx->loc, "%s already included here", name);
		} else
			cferror(loc, "%s: main configuration file cannot be included", name);
		inpctx_pop();
		free(name);
		return -1;
	}

	cflex_setup(cfstream_open_file(name), name, 1);
	free(name);

	return 0;
}

int
yywrap(void)
{
	return inpctx_pop();
}

/* Preserve the current start state on stack and switch to ARGS. */ 
void
cflex_pushargs(void)
{
	pushstart(ARGS);
}

/* Extern interface to popstart */
void
cflex_popargs(void)
{
	popstart();
}

/* Remove trailing whitespace from S. */
void
trimws(char *s)
{
	size_t len = strlen(s);
	while (len > 0 && ISWS(s[len-1])) 
		s[--len] = 0;
}

/* Remove trailing slashes from S. Return the length of the resulting
   string. */
size_t
trimslash(char *s)
{
	size_t len = strlen(s);
	while (len > 0 && s[len-1] == '\\')
		s[--len] = 0;
	return len;
}

/* Rewind the input stream to the beginning and parse it as a legacy
   configuration. */
int
parse_old_rc(void)
{
	CFSTREAM *cf = input_stream;
	char const *filename = curloc.beg.filename;
	
	YY_FLUSH_BUFFER;
	input_stream = NULL;

	cfstream_rewind(cf);
	return cfparse_old(cf, filename, 1);
}

void
cflex_test(char const *filename)
{
	int c;
	CFSTREAM *cf;

	if (filename) {
		cf = cfstream_open_file(filename);
	} else {
		cf = cfstream_open_stdin();
		filename = "stdin";
	}
	cflex_setup(cf, filename, 1);
	BEGIN(NORMAL);
	while ((c = yylex()) != 0) {
		printf("state %d, ",YY_START);
		YY_LOCATION_PRINT(stdout, yylloc);
		printf(": ");
		switch (c) {
		case STRING:
			printf("STRING ");
			dumpstr(yylval.str, stdout);
			break;
		case IDENT:
			printf("IDENT %s", yylval.str);
			break;
		case NUMBER:
			printf("NUMBER %s", yylval.num.strval);
			break;
		case ATTRIB:
			printf("ATTRIB %s", yytext);
			break;
		case GLATTRIB:
			printf("GLATTRIB %s", yylval.global_attrib->name);
			break;
		case EOL:
			printf("EOL");
			break;
		default:
			printf("'%s'", yytext);
		}
		putchar('\n');
	}
	exit(0);
}

