/*------------------------->  ANSI C - sourcefile  <-------------------------*/
/* Copyright (C) 199x by International Computer Science Institute            */
/* This file is part of the GNU Sather library. It is free software; you may */
/* redistribute  and/or modify it under the terms of the GNU Library General */
/* Public  License (LGPL)  as published  by the  Free  Software  Foundation; */
/* either version 2 of the license, or (at your option) any later version.   */
/* This  library  is distributed  in the  hope that it will  be  useful, but */
/* WITHOUT ANY WARRANTY without even the implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE. See Doc/LGPL for more details.       */
/* The license text is also available from:  Free Software Foundation, Inc., */
/* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA                     */
/*------------>  Please email comments to <bug-sather@gnu.org>  <------------*/

#ifdef AT_THREADS
#include <at.h>
#else
#include <memory.h>
#include <malloc.h>
#endif
#include <string.h>

void *GC_malloc(size_t size)
{ void *a=malloc(size);memset(a,0,size);return a; }

void *GC_malloc_atomic(size_t size)
{ void *a=malloc(size);memset(a,0,size);return a; }

void GC_free(void *p)
{ free(p); }

void *GC_calloc(size_t a,size_t b)
{ void *p=calloc(a,b);memset(p,0,a*b);return p; }

void *GC_realloc(void *a,size_t size)
{ return realloc(a,size); }

void *GC_malloc_atomic_ignore_off_page(size_t size)
{ void *a=calloc(size,1);memset(a,0,size); return a; }

void *GC_malloc_ignore_off_page(size_t size)
{ void *a=calloc(size,1);memset(a,0,size); return a; }
