# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000-2001  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

def key_to_accidentals(key):
    i = ['aeses', 'eeses', 'beses', 'fes', 'ces', 'ges', 'des', 'aes',
         'ees', 'bes', 'f', 'c', 'g', 'd', 'a', 'e', 'b', 'fis', 'cis',
         'gis', 'dis', 'ais', 'eis'].index(key[0])-11
    if key[1] == 'minor':
        i = i - 3
    if i > 0:
        return ['fis', 'cis', 'gis', 'dis', 'ais', 'eis',
                'bis', 'fis', 'cis', 'gis', 'dis'][:i]
    elif i < 0:
        return ['bes', 'ees', 'aes', 'des', 'ges', 'ces',
                'fes', 'bes', 'ees', 'aes', 'des'][:-i]
    else:
        return []

class DataClass:
    def __init__(self, names):
        self.__dict__['__names'] = names
        for n in names:
            self.__dict__[n] = None
    def __getattr__(self, name):
        if name in self.__dict__.keys():
            return self.__dict__[name]
    def __setattr__(self, name, value):
        if name in self.__dict__['__names']:
            self.__dict__[name] = value
        else:
            print "Trying varibale:", name
            raise "DataClass: variable name not allowed"

