#!/usr/bin/python

import glob
import os
import src.i18n
src.i18n.setup(".")

from src import lessonfile
from src.learning_tree_editor import LearningTree
tree_names = ('learning', 'debug')
trees = {}

lessonfile_manager = lessonfile.LessonFileManager(True)

def read_tree(name):
    fn = "%stree.txt" % name
    t = LearningTree(lessonfile_manager)
    t.load(fn)
    v = []
    for lesson_id in t.iterate_all_lessons():
        v.append(lesson_id)
    trees[name] = (t, v)

def get_use(fn):
    """
    Return the use of the lessonfile.
    """
    p = lessonfile.parse_lesson_file_header(fn)
    return [p.header['lesson_id'] in trees[t][1] for t in tree_names]

for t in tree_names:
    read_tree(t)
v = glob.glob("lesson-files/*")
v.sort()
for fn in v:
    if fn == 'lesson-files/Makefile':
        continue
    if os.path.isfile(fn):
        use = get_use(fn)
        if use[0] != True:
            print "use:", use, fn
