%{
/*
 * Copyright (C) 1999, 2000, 2001  Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

static  int lineno = 1 ; /* number of scanned lines */
//char linebuf[1024] ; /* current code line in the source */
// int tokenpos = 0 ; /* current token position in the current line */

//#include "tags.h"
//#include "tokens.h"
//#include "colors.h"

#include "genfun.h"

#define PUSH(s) yy_push_state(s);
#define POP() yy_pop_state();

%}
%option prefix="cpp_scanner_"
%option noyywrap
%option stack

nl \n
cr \r
STRING \"[^\"\n]*\"
not_alpha [^a-zA-Z0-9]

%s COMMENT_STATE
%s SINGLELINE_COMMENT
%s STRING_STATE
%s CHAR_STATE
%s PREPROC_STATE

IDE [a-zA-Z_]([a-zA-Z0-9_])*
wspace [ \t\n\r]
templspec \<({wspace}|{IDE})*\>


keyword1 (asm|auto|break|case|catch|class|const|const_cast|continue|default)
keyword2 (delete|do|dynamic_cast|else|enum|explicit|export|extern|false|for)
keyword3 (friend|goto|if|inline|mutable|namespace|new|operator|private)
keyword4 (protected|public|register|reinterpret_cast|return|sizeof|static)
keyword5 (static_cast|struct|switch|template|throw|this|true|try|typedef)
keyword6 (typeid|typename|union|using|virtual|volatile|while)

keyword ({keyword1}|{keyword2}|{keyword3}|{keyword4}|{keyword5}|{keyword6})
basetype (bool|char|double|float|int|long|short|signed|unsigned|void|wchar_t)
symbol [\~\!\%\^\*\(\)\-\+\=\[\]\|\\\:\;\,\.\/\?\&\<\>]
cbracket [\{\}]

funccall {IDE}/{wspace}*({templspec}){0,1}{wspace}*\(

%%

<INITIAL>"/*" { BEGIN COMMENT_STATE ;
       startComment( yytext ) ;      
     }
<INITIAL>"/*".*"*/" { generateComment( yytext ) ;  }

<COMMENT_STATE>\r*\n { 
   endComment (""); 
   ++lineno;
   generateNewLine(yytext) ;
   startComment ("");
   /* if we encounter another // during a comment we simply
      treat it as a ordinary string */
 }
<COMMENT_STATE>"*/" { endComment(yytext) ;
                      BEGIN INITIAL ; /* end of the comment */ }

<INITIAL>"//" { BEGIN SINGLELINE_COMMENT ; startComment( yytext ) ; }
<SINGLELINE_COMMENT>\r*\n { 
   BEGIN INITIAL ; 
   yyless (0); // put the \n back
   endComment( yytext ) ; 
   /* if we encounter another // during a comment we simply
      treat it as a ordinary string */
 }

<INITIAL>\" { BEGIN STRING_STATE ; startString( yytext );  }
<STRING_STATE>\\\\ {  generate_preproc( yytext ) ; }
<STRING_STATE>"\\\"" {  generate_preproc( yytext ) ; }
<STRING_STATE>\" { BEGIN INITIAL ; endString( yytext ) ; }

<INITIAL>\' { BEGIN CHAR_STATE ; startString( yytext );  }
<CHAR_STATE>\\\\ {  generate_preproc( yytext ) ; }
<CHAR_STATE>"\\\'" {  generate_preproc( yytext ) ; }
<CHAR_STATE>\' { BEGIN INITIAL ; endString( yytext ) ; }

<INITIAL>\#[^\"\n\t\r ]* {
        generatePreProc( yytext) ; 
}

<INITIAL>\#[ \t]*[^\"\n\t\r ]* {
        yyless (1); // put back anything after the #
        generatePreProc( yytext) ; 
        PUSH (PREPROC_STATE);
}

<PREPROC_STATE>{IDE} {
        generatePreProc (yytext);
        POP ();
}

<INITIAL>{keyword} { generateKeyWord( yytext ) ; }
<INITIAL>{basetype} { generateBaseType( yytext ) ; }
<INITIAL>{symbol} { generateSymbol( yytext ); }
<INITIAL>[\{\}] { generateCBracket ( yytext ); }

<INITIAL>{keyword}/{wspace}*\( { generateKeyWord( yytext ) ; }
<INITIAL>{basetype}/{wspace}*\( { generateBaseType( yytext ) ; }
<INITIAL>{funccall} { generateFunction ( yytext ); }

<INITIAL>0[xX][0-9a-fA-F]* { generateNumber( yytext ) ; }
<INITIAL>[0-9][0-9]*(\.[0-9]*[eE]?[-+]?[0-9]*)? { generateNumber( yytext ) ; }

<INITIAL>\<[^\"\n ]*\> { generateString (yytext); }

<INITIAL>[a-zA-Z_]([a-zA-Z0-9_])* { generate_normal( yytext ) ; }

\t {
        generateTab() ;
}

\r* {
        generate_preproc(&yytext[yyleng-1]);
        // skip the previous ones, only generate one
}

. { generate_preproc( yytext ) ; /* anything else */ }

\n { 
       ++lineno;
       generateNewLine() ;
}

%%
/*
void yyerror( char *s ) ;

void yyerror( char *s )
{  
  fprintf( stderr, "%d: %s: %s\n%s\n", lineno, s, yytext, linebuf ) ;
  fprintf( stderr, "%*s\n", tokenpos, "^" ) ;
}
*/
/* vim:set ft=flex expandtab cindent tabstop=4 softtabstop=4 shiftwidth=4 textwidth=0: */
