/*
 * Copyright (C) 1999, 2000, 2001, 2002  Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

// xhtmlgeneratorfactory.cc

#include "xhtmlgeneratorfactory.h"

#include "xhtmltags.h"
#include "htmltags.h"
#include "xhtmldocgenerator.h"
#include "htmltaggen.h"

DocGenerator *
XHtmlGeneratorFactory::createDocGenerator()
{
  return new XHtmlDocGenerator (title, input_file_name, doc_header, doc_footer,
                               css_url);
}

const string
generateXHtmlTag(const string &attr, const string &val)
{
  return startTAG(SPAN_TAG, "style", attr + ": " + val);
}

void
XHtmlGeneratorFactory::addBold()
{
  addStartTag(generateXHtmlTag(XHTML_BOLD_TAG, XHTML_BOLD_VAL));
  addCloseTag(endTAG(SPAN_TAG));
}

void
XHtmlGeneratorFactory::addItalic()
{
  addStartTag(generateXHtmlTag(XHTML_ITALIC_TAG, XHTML_ITALIC_VAL));
  addCloseTag(endTAG(SPAN_TAG));
}

void
XHtmlGeneratorFactory::addUnderline()
{
  addStartTag(generateXHtmlTag(XHTML_UNDERLINE_TAG, XHTML_UNDERLINE_VAL));
  addCloseTag(endTAG(SPAN_TAG));
}

void
XHtmlGeneratorFactory::addColor(const string &color)
{
  addStartTag(generateXHtmlTag(COLOR_TAG, color));
  addCloseTag(endTAG(SPAN_TAG));  
}
