/*
 * Copyright (C) 1999, 2000, 2001, 2002  Lorenzo Bettini, bettini@gnu.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "htmldecorator.h"
#include "htmltags.h"
#include "colors.h"

// for globals
#include "globalostream.h"

TagDecorator::TagDecorator( TextGenerator *t, CharTranslator *tr,
                            const string &ta, const string &a,
                            const string &v ) :
  TextDecorator (t, tr), tag(ta), attr(a), val(v)
{
}

void
TagDecorator::startDecorate()
{
  startTAG( ) ;
}

void
TagDecorator::endDecorate()
{
  endTAG( ) ;
}

void
TagDecorator::startTAG( ) const
{
  (*sout) << "<" << tag ;
  if ( attr.size () && val.size () )
    generateAttrVal ();
  (*sout) << ">" ;
}

void
TagDecorator::generateAttrVal() const
{
  (*sout) << " " << attr << "=" << val ;
}

void
TagDecorator::endTAG( ) const
{
  (*sout) << "</" << tag << ">" ;
}

// ColorDecorator
ColorDecorator::ColorDecorator( TextGenerator *t, CharTranslator *tr,
                                const string &color ) :
  TagDecorator( t, tr, FONT_TAG, COLOR_TAG, color )
{
}

