/*
** Copyright (C) 1999, 2000, 2002 Lorenzo Bettini <bettini@gnu.org>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/

// abstract factory for generators

#ifndef GENERATORFACTORY_H
#define GENERATORFACTORY_H

#include "decorators.h"

#include <string>

using std::string;

class DocGenerator;
class ColorMap;

class GeneratorFactory
{
 protected:
  CharTranslator *char_translator; // translator of special characters
  bool line_number_option; // whether line number option is given
  bool gen_line_ref; // whether line numbers are added an anchor
  string title;

  virtual TextGenerator *createBoldDecorator(TextGenerator *) = 0;
  virtual TextGenerator *createItalicDecorator(TextGenerator *) = 0;
  virtual TextGenerator *createUnderlineDecorator(TextGenerator *) = 0;
  virtual TextGenerator *createColorDecorator(TextGenerator *,
                                              const string &color) = 0;

  virtual ColorMap *createColorMap() = 0;
  virtual TextGenerator *createGenerator(TextGenerator *final_dec,
                                         const string &key);
  virtual DocGenerator *createDocGenerator();

  virtual CharTranslator *createCharTranslator() = 0;

  template <class Decorator>
    void decorate_generator(TextGenerator *&decorated);

  template <class Decorator>
    void decorate_generators();

 public:
  GeneratorFactory(bool line_number, const string &t = "",
                   bool line_ref = false);
  virtual ~GeneratorFactory() {}

  virtual void createGenerators();
};

#endif // GENERATORFACTORY_H
