#!/usr/bin/env node
/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { getFilesInDirectory, initializeDev } from "@gnu-taler/web-util/build";
import { serve } from "@gnu-taler/web-util/node";
import linaria from "@linaria/esbuild";

const allStaticFiles = getFilesInDirectory("src/pwa");

const devEntryPoints = [
  "src/popupEntryPoint.dev.tsx",
  "src/walletEntryPoint.dev.tsx",
  "src/background.dev.ts",
  "src/browserWorkerEntry.ts",
  "src/stories.tsx",
];

const build = initializeDev({
  type: "development",
  source: {
    js: devEntryPoints,
    assets: allStaticFiles,
  },
  destination: "./dist/dev",
  public: "/app",
  css: "linaria",
  linariaPlugin: () => {
    // linaria has a bug if this run in web-util library
    return linaria({
      babelOptions: {
        presets: [
          "@babel/preset-typescript",
          "@babel/preset-react",
          "@linaria",
        ],
      },
      sourceMap: true,
    });
  },
});

await build();

serve({
  folder: "./dist/dev",
  port: 8080,
  source: "./src",
  onSourceUpdate: build,
});

// FIXME: create a mocha test in the browser as it was before

// fs.writeFileSync("dev-html/manifest.json", fs.readFileSync("manifest-v2.json"))
// fs.writeFileSync("dev-html/mocha.css", fs.readFileSync("node_modules/mocha/mocha.css"))
// fs.writeFileSync("dev-html/mocha.js", fs.readFileSync("node_modules/mocha/mocha.js"))
// fs.writeFileSync("dev-html/mocha.js.map", fs.readFileSync("node_modules/mocha/mocha.js.map"))
