webpackJsonp([7],{

/***/ 165:
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*
 This file is part of TALER
 (C) 2015-2016 GNUnet e.V.

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Page that shows refund status for purchases.
 *
 * @author Florian Dold
 */
const React = __webpack_require__(1);
const ReactDOM = __webpack_require__(3);
const URI = __webpack_require__(6);
const Amounts = __webpack_require__(4);
const renderHtml_1 = __webpack_require__(5);
const wxApi = __webpack_require__(2);
const RefundDetail = ({ purchase, fullRefundFees }) => {
    const pendingKeys = Object.keys(purchase.refundsPending);
    const doneKeys = Object.keys(purchase.refundsDone);
    if (pendingKeys.length === 0 && doneKeys.length === 0) {
        return React.createElement("p", null, "No refunds");
    }
    const firstRefundKey = [...pendingKeys, ...doneKeys][0];
    if (!firstRefundKey) {
        return React.createElement("p", null, "Waiting for refunds ...");
    }
    const allRefunds = Object.assign({}, purchase.refundsDone, purchase.refundsPending);
    const currency = Amounts.parseOrThrow(allRefunds[firstRefundKey].refund_amount).currency;
    if (!currency) {
        throw Error("invariant");
    }
    let amountPending = Amounts.getZero(currency);
    for (const k of pendingKeys) {
        const refundAmount = Amounts.parseOrThrow(purchase.refundsPending[k].refund_amount);
        amountPending = Amounts.add(amountPending, refundAmount).amount;
    }
    let amountDone = Amounts.getZero(currency);
    for (const k of doneKeys) {
        const refundAmount = Amounts.parseOrThrow(purchase.refundsDone[k].refund_amount);
        amountDone = Amounts.add(amountDone, refundAmount).amount;
    }
    const hasPending = amountPending.fraction !== 0 || amountPending.value !== 0;
    return (React.createElement("div", null,
        hasPending ? React.createElement("p", null,
            "Refund pending: ",
            React.createElement(renderHtml_1.AmountDisplay, { amount: amountPending })) : null,
        React.createElement("p", null,
            "Refund received: ",
            React.createElement(renderHtml_1.AmountDisplay, { amount: amountDone }),
            " (refund fees: ",
            React.createElement(renderHtml_1.AmountDisplay, { amount: fullRefundFees }),
            ")")));
};
class RefundStatusView extends React.Component {
    constructor(props) {
        super(props);
        this.state = { gotResult: false };
    }
    componentDidMount() {
        this.update();
        const port = chrome.runtime.connect();
        port.onMessage.addListener((msg) => {
            if (msg.notify) {
                console.log("got notified");
                this.update();
            }
        });
    }
    render() {
        if (!this.props.contractTermsHash && !this.props.refundUrl) {
            return (React.createElement("div", { id: "main" },
                React.createElement("span", null, "Error: Neither contract terms hash nor refund url given.")));
        }
        const purchase = this.state.purchase;
        if (!purchase) {
            let message;
            if (this.state.gotResult) {
                message = React.createElement("span", null,
                    "No purchase with contract terms hash ",
                    this.props.contractTermsHash,
                    " found");
            }
            else {
                message = React.createElement("span", null, "...");
            }
            return React.createElement("div", { id: "main" }, message);
        }
        const merchantName = purchase.contractTerms.merchant.name || "(unknown)";
        const summary = purchase.contractTerms.summary || purchase.contractTerms.order_id;
        return (React.createElement("div", { id: "main" },
            React.createElement("h1", null, "Refund Status"),
            React.createElement("p", null,
                "Status of purchase ",
                React.createElement("strong", null, summary),
                " from merchant ",
                React.createElement("strong", null, merchantName),
                " ",
                "(order id ",
                purchase.contractTerms.order_id,
                ")."),
            React.createElement("p", null,
                "Total amount: ",
                React.createElement(renderHtml_1.AmountDisplay, { amount: Amounts.parseOrThrow(purchase.contractTerms.amount) })),
            purchase.finished
                ? React.createElement(RefundDetail, { purchase: purchase, fullRefundFees: this.state.refundFees })
                : React.createElement("p", null, "Purchase not completed.")));
    }
    update() {
        return __awaiter(this, void 0, void 0, function* () {
            let contractTermsHash = this.state.contractTermsHash;
            if (!contractTermsHash) {
                const refundUrl = this.props.refundUrl;
                if (!refundUrl) {
                    console.error("neither contractTermsHash nor refundUrl is given");
                    return;
                }
                contractTermsHash = yield wxApi.acceptRefund(refundUrl);
                this.setState({ contractTermsHash });
            }
            const purchase = yield wxApi.getPurchase(contractTermsHash);
            console.log("got purchase", purchase);
            const refundsDone = Object.keys(purchase.refundsDone).map((x) => purchase.refundsDone[x]);
            if (refundsDone.length) {
                const refundFees = yield wxApi.getFullRefundFees({ refundPermissions: refundsDone });
                this.setState({ purchase, gotResult: true, refundFees });
            }
        });
    }
}
function main() {
    return __awaiter(this, void 0, void 0, function* () {
        const url = new URI(document.location.href);
        const query = URI.parseQuery(url.query());
        const container = document.getElementById("container");
        if (!container) {
            console.error("fatal: can't mount component, countainer missing");
            return;
        }
        const contractTermsHash = query.contractTermsHash;
        const refundUrl = query.refundUrl;
        ReactDOM.render(React.createElement(RefundStatusView, { contractTermsHash: contractTermsHash, refundUrl: refundUrl }), container);
    });
}
document.addEventListener("DOMContentLoaded", () => main());


/***/ })

},[165]);
//# sourceMappingURL=refund-bundle.js.map