webpackJsonp([13],{

/***/ 138:
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*
 This file is part of TALER
 (C) 2017 Inria

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const components_1 = __webpack_require__(8);
const wxApi_1 = __webpack_require__(2);
const React = __webpack_require__(1);
const ReactDOM = __webpack_require__(3);
const URI = __webpack_require__(6);
class ConfirmAuditor extends components_1.ImplicitStateComponent {
    constructor(props) {
        super(props);
        this.addDone = this.makeState(false);
    }
    add() {
        return __awaiter(this, void 0, void 0, function* () {
            const currencies = yield wxApi_1.getCurrencies();
            let currency;
            for (const c of currencies) {
                if (c.name === this.props.currency) {
                    currency = c;
                }
            }
            if (!currency) {
                currency = { name: this.props.currency, auditors: [], fractionalDigits: 2, exchanges: [] };
            }
            const newAuditor = {
                auditorPub: this.props.auditorPub,
                baseUrl: this.props.url,
                expirationStamp: this.props.expirationStamp,
            };
            let auditorFound = false;
            for (const idx in currency.auditors) {
                const a = currency.auditors[idx];
                if (a.baseUrl === this.props.url) {
                    auditorFound = true;
                    // Update auditor if already found by URL.
                    currency.auditors[idx] = newAuditor;
                }
            }
            if (!auditorFound) {
                currency.auditors.push(newAuditor);
            }
            yield wxApi_1.updateCurrency(currency);
            this.addDone(true);
        });
    }
    back() {
        window.history.back();
    }
    render() {
        return (React.createElement("div", { id: "main" },
            React.createElement("p", null,
                "Do you want to let ",
                React.createElement("strong", null, this.props.auditorPub),
                " audit the currency \"",
                this.props.currency,
                "\"?"),
            this.addDone() ?
                (React.createElement("div", null,
                    "Auditor was added! You can also",
                    " ",
                    React.createElement("a", { href: chrome.extension.getURL("/src/webex/pages/auditors.html") }, "view and edit"),
                    " ",
                    "auditors."))
                :
                    (React.createElement("div", null,
                        React.createElement("button", { onClick: () => this.add(), className: "pure-button pure-button-primary" }, "Yes"),
                        React.createElement("button", { onClick: () => this.back(), className: "pure-button" }, "No")))));
    }
}
function main() {
    const walletPageUrl = new URI(document.location.href);
    const query = JSON.parse(URI.parseQuery(walletPageUrl.query()).req);
    const url = query.url;
    const currency = query.currency;
    const auditorPub = query.auditorPub;
    const expirationStamp = Number.parseInt(query.expirationStamp);
    const args = { url, currency, auditorPub, expirationStamp };
    ReactDOM.render(React.createElement(ConfirmAuditor, Object.assign({}, args)), document.getElementById("container"));
}
document.addEventListener("DOMContentLoaded", main);


/***/ })

},[138]);
//# sourceMappingURL=add-auditor-bundle.js.map