webpackJsonp([9],{

/***/ 160:
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*
 This file is part of TALER
 (C) 2017 Inria

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const components_1 = __webpack_require__(8);
const renderHtml_1 = __webpack_require__(5);
const wxApi_1 = __webpack_require__(2);
const React = __webpack_require__(1);
const ReactDOM = __webpack_require__(3);
class Payback extends components_1.ImplicitStateComponent {
    constructor(props) {
        super(props);
        this.reserves = this.makeState(null);
        const port = chrome.runtime.connect();
        port.onMessage.addListener((msg) => {
            if (msg.notify) {
                console.log("got notified");
                this.update();
            }
        });
        this.update();
    }
    update() {
        return __awaiter(this, void 0, void 0, function* () {
            const reserves = yield wxApi_1.getPaybackReserves();
            this.reserves(reserves);
        });
    }
    withdrawPayback(pub) {
        wxApi_1.withdrawPaybackReserve(pub);
    }
    render() {
        const reserves = this.reserves();
        if (!reserves) {
            return React.createElement("span", null, "loading ...");
        }
        if (reserves.length === 0) {
            return React.createElement("span", null, "No reserves with payback available.");
        }
        return (React.createElement("div", null, reserves.map((r) => (React.createElement("div", null,
            React.createElement("h2", null,
                "Reserve for $",
                renderHtml_1.renderAmount(r.current_amount)),
            React.createElement("ul", null,
                React.createElement("li", null,
                    "Exchange: $",
                    r.exchange_base_url)),
            React.createElement("button", { onClick: () => this.withdrawPayback(r.reserve_pub) }, "Withdraw again"))))));
    }
}
function main() {
    ReactDOM.render(React.createElement(Payback, null), document.getElementById("container"));
}
document.addEventListener("DOMContentLoaded", main);


/***/ })

},[160]);
//# sourceMappingURL=payback-bundle.js.map