/*
 * Decompiled with CFR 0.152.
 */
package wb;

import java.lang.reflect.Method;
import wb.Blink;
import wb.Blk;
import wb.Blkio;
import wb.Ent;
import wb.Han;
import wb.Handle;
import wb.Lck;
import wb.Pkt;
import wb.Prev;
import wb.Scan;
import wb.SchlepRT;
import wb.Seg;
import wb.Stats;
import wb.Wbdefs;
import wb.Wbsys;

public class Ents {
    public static Lck[] lckTab = null;
    public static Ent[] bukTab = null;
    public static Ent[] entTab = null;
    public static int numEntsCt = 0;
    public static int numBuks = 0;
    public static int blkSize = 0;
    public static boolean cacheEntEnable_P = true;
    public static int flushEntCntr = 0;
    public static Lck flushEntLck = Lck.makeLck(-2);
    public static int freeBukCntr = 0;
    public static Ent freeEnts = null;
    public static Lck freeEntLck = Lck.makeLck(-1);

    public static boolean ents_EntWrite(Ent ent) {
        Seg seg = Ent.ent_Seg(ent);
        byte[] byArray = Ent.ent_Blk(ent);
        if (!Blk.blk_Typ_P(byArray, 83)) {
            Ents.checkKeyOrder(byArray);
        }
        Blk.blk_SetTime(byArray, (int)(System.currentTimeMillis() / 1000L));
        if (!Seg.seg_Mutable_P(seg)) {
            System.err.print(">>>>ERROR<<<< entWrite on read only segment " + Seg.seg_Id(seg) + "?\n");
            return false;
        }
        if (Blkio.blkio_Write(Seg.seg_Port(seg), byArray, Seg.seg_Bsiz(seg), Ent.ent_Id(ent))) {
            Ent.ent_SetDty(ent, null);
            return true;
        }
        Ent.ent_SetDty(ent, true);
        return false;
    }

    public static int entsFlush(int n, int n2) {
        int n3 = 0;
        if (SchlepRT.a2b(flushEntLck) && Lck.tryLck_P(flushEntLck)) {
            for (int i = n; 0 != i && n3 < n2; --i) {
                Ent ent = entTab[flushEntCntr = (1 + flushEntCntr) % numEntsCt];
                if (!Ent.ent_Dty_P(ent) || SchlepRT.a2b(Ent.ent_Acc(ent)) || !Ents.entFlush_P(ent)) continue;
                Stats.showBuffer1(ent);
                ++n3;
            }
            Lck.unlck(flushEntLck);
            return n3;
        }
        return 0;
    }

    public static boolean entFlush_P(Ent ent) {
        Seg seg = Ent.ent_Seg(ent);
        int n = Ent.ent_Id(ent);
        Wbdefs.getBukLck_P(Seg.seg_Id(seg), n);
        Ent ent2 = Wbdefs.getBuk(Seg.seg_Id(seg), n);
        while (true) {
            if (!SchlepRT.a2b(ent2)) {
                Wbdefs.relBuk(Seg.seg_Id(seg), n);
                return false;
            }
            if (ent == ent2) break;
            ent2 = Ent.ent_Next(ent2);
        }
        if (!Ent.ent_Dty_P(ent2) || 1 != Ent.ent_Acc(ent2)) {
            Wbdefs.relBuk(Seg.seg_Id(seg), n);
            return false;
        }
        Ent.ent_SetAcc(ent2, 4);
        Wbdefs.relBuk(Seg.seg_Id(seg), n);
        Ents.ents_EntWrite(ent2);
        Wbdefs.getBukWait(Seg.seg_Id(seg), n);
        Ent.ent_SetAcc(ent2, 1);
        Wbdefs.relBuk(Seg.seg_Id(seg), n);
        ++Stats.flushCt;
        return true;
    }

    public static void releaseEnt(Ent ent, int n) {
        int n2 = Ent.ent_Id(ent);
        Seg seg = Ent.ent_Seg(ent);
        Ent ent2 = null;
        ent2 = Wbdefs.getBukWait(Seg.seg_Id(seg), n2);
        if (1 != n && Ent.ent_Acc(ent) != n) {
            System.err.print(">>>>ERROR<<<< releaseEnt: unexpected accmode of " + Seg.seg_Id(seg) + ":" + n2 + " is " + Ent.ent_Acc(ent) + " not " + n + "\n");
        }
        if (1 != n && Ent.ent_Dty_P(ent)) {
            if (Blk.blk_Typ_P(Ent.ent_Blk(ent), 68) && Wbdefs.leaf_P(Ent.ent_Blk(ent))) {
                System.err.print("WARNING: Directory block " + Seg.seg_Id(seg) + ":" + n2 + " dirty at RELEASE-ENT! \n");
                Stats.dirDtyCt = 1 + Stats.dirDtyCt;
            } else if (Blk.blk_Typ_P(Ent.ent_Blk(ent), 83)) {
                Wbdefs.relBuk(Seg.seg_Id(seg), n2);
                Ents.ents_EntWrite(ent);
                ent2 = Wbdefs.getBukWait(Seg.seg_Id(seg), n2);
            }
        }
        if (1 != n) {
            Ent.ent_SetAcc(ent, 1);
        }
        if (Ent.ent_Ref(ent) <= 0) {
            Ent.ent_SetRef(ent, 0);
            System.err.print(">>>>ERROR<<<< REF count below 0 in " + Seg.seg_Id(seg) + ":" + n2 + "\n");
        } else {
            Ent.ent_SetRef(ent, Ent.ent_Ref(ent) - 1);
        }
        if (!SchlepRT.a2b(seg)) {
            Ents.spliceOutEnt(seg, n2, ent2, ent);
        } else {
            Ent.ent_SetAge(ent, (Ent.ent_Dty_P(ent) ? 5 : 0) + 5 * (6 + (48 - Blk.blk_Level(Ent.ent_Blk(ent)))));
        }
        Wbdefs.relBuk(Seg.seg_Id(seg), n2);
    }

    public static boolean ents_EntUpdateAccess_P(Ent ent, int n, int n2) {
        Wbdefs.getBukWait(Seg.seg_Id(Ent.ent_Seg(ent)), Ent.ent_Id(ent));
        if (Ent.ent_Acc(ent) != n) {
            Wbdefs.relBuk(Seg.seg_Id(Ent.ent_Seg(ent)), Ent.ent_Id(ent));
            System.err.print(">>>>ERROR<<<< unexpected accmode type on " + Seg.seg_Id(Ent.ent_Seg(ent)) + ":" + Ent.ent_Id(ent) + " " + Ent.ent_Acc(ent) + " (expected " + n + ")\n");
        }
        if (1 != n && Ent.ent_Dty_P(ent)) {
            if (Blk.blk_Typ_P(Ent.ent_Blk(ent), 83)) {
                Wbdefs.relBuk(Seg.seg_Id(Ent.ent_Seg(ent)), Ent.ent_Id(ent));
                Ents.ents_EntWrite(ent);
                Wbdefs.getBukWait(Seg.seg_Id(Ent.ent_Seg(ent)), Ent.ent_Id(ent));
            } else if (Blk.blk_Typ_P(Ent.ent_Blk(ent), 68) && Wbdefs.leaf_P(Ent.ent_Blk(ent))) {
                System.err.print("WARNING: Directory block " + Seg.seg_Id(Ent.ent_Seg(ent)) + ":" + Ent.ent_Id(ent) + " dirty at ENT-UPD-ACCESS! \n");
                Stats.dirDtyCt = 1 + Stats.dirDtyCt;
            }
        }
        Ent.ent_SetAcc(ent, n2);
        Wbdefs.relBuk(Seg.seg_Id(Ent.ent_Seg(ent)), Ent.ent_Id(ent));
        return SchlepRT.a2b(ent);
    }

    public static Ent getFreeFreeEnt() {
        Lck.lck(freeEntLck);
        if (SchlepRT.a2b(freeEnts)) {
            Ent ent = freeEnts;
            freeEnts = Ent.ent_Next(freeEnts);
            Lck.unlck(freeEntLck);
            return ent;
        }
        return null;
    }

    public static void spliceOutEnt(Seg seg, int n, Ent ent, Ent ent2) {
        Ent ent3 = ent;
        Ent ent4 = null;
        while (SchlepRT.a2b(ent3) && ent3 != ent2) {
            Ent ent5 = Ent.ent_Next(ent3);
            ent4 = ent3;
            ent3 = ent5;
        }
        if (SchlepRT.a2b(ent3)) {
            if (SchlepRT.a2b(ent4)) {
                Ent.ent_SetNext(ent4, Ent.ent_Next(ent3));
            } else {
                Wbdefs.setBuk(Seg.seg_Id(seg), n, Ent.ent_Next(ent3));
            }
            Ents.recycleEnt(ent3);
            return;
        }
        System.err.print("WARNING: spliceOutEnt couldn't " + Seg.seg_Id(seg) + ":" + n + "\n");
    }

    public static void recycleEnt(Ent ent) {
        Ent.ent_SetDty(ent, null);
        Ent.ent_SetPus(ent, 0);
        Ent.ent_SetSeg(ent, null);
        Ent.ent_SetId(ent, 0);
        Lck.lck(freeEntLck);
        Ent.ent_SetRef(ent, 0);
        Ent.ent_SetAcc(ent, 1);
        Ent.ent_SetNext(ent, freeEnts);
        freeEnts = ent;
        Lck.unlck(freeEntLck);
    }

    public static Ent selectIdleEnt(Seg seg, int n) {
        int n2;
        Ent ent = null;
        int n3 = Math.max(Math.min(numBuks, 10), numBuks / 20);
        int n4 = freeBukCntr;
        freeBukCntr = (n3 + freeBukCntr) % numBuks;
        Lck.unlck(freeEntLck);
        for (n2 = 0; !(n2 > n3 && SchlepRT.a2b(ent) || n2 > numBuks); ++n2) {
            boolean bl;
            int n5 = (n4 + n2) % numBuks;
            boolean bl2 = !SchlepRT.a2b(seg) ? false : (bl = n5 == Wbdefs.hash2int(Seg.seg_Id(seg), n));
            if (!bl && !Wbdefs.getBukLck_P(0, n5)) continue;
            Ent ent2 = Wbdefs.getBuk(0, n5);
            while (SchlepRT.a2b(ent2)) {
                if (0 == Ent.ent_Ref(ent2)) {
                    Ent.ent_SetAge(ent2, (Ent.ent_Dty_P(ent2) ? 1 : 2) + Ent.ent_Age(ent2));
                    if (!(1 != Ent.ent_Acc(ent2) || SchlepRT.a2b(ent) && Ent.ent_Age(ent2) <= Ent.ent_Age(ent))) {
                        ent = ent2;
                    }
                }
                ent2 = Ent.ent_Next(ent2);
            }
            if (bl) continue;
            Wbdefs.relBuk(0, n5);
        }
        if (n2 > numBuks) {
            System.err.print(">>>>ERROR<<<< No free ents\n");
        }
        return ent;
    }

    public static Ent reclaimEnt(Ent ent, Seg seg, int n) {
        Ent ent2;
        Seg seg2 = Ent.ent_Seg(ent);
        int n2 = Ent.ent_Id(ent);
        boolean bl = SchlepRT.a2b(seg) && Wbdefs.sameBuk_P(Seg.seg_Id(seg), n, Seg.seg_Id(seg2), n2);
        Ent ent3 = ent2 = bl ? Wbdefs.getBuk(Seg.seg_Id(seg2), n2) : Wbdefs.getBukWait(Seg.seg_Id(seg2), n2);
        if (0 != Ent.ent_Ref(ent) || 1 != Ent.ent_Acc(ent)) {
            Wbdefs.relBuk(Seg.seg_Id(seg2), n2);
            if (!bl && SchlepRT.a2b(seg)) {
                Wbdefs.relBuk(Seg.seg_Id(seg), n);
            }
            System.err.print("WARNING: reclaimEnt: couldn't splice-out-ent " + Seg.seg_Id(seg) + ":" + n + "\n");
            return null;
        }
        Ent ent4 = ent2;
        Ent ent5 = null;
        while (SchlepRT.a2b(ent4) && ent != ent4) {
            Ent ent6 = Ent.ent_Next(ent4);
            ent5 = ent4;
            ent4 = ent6;
        }
        if (!SchlepRT.a2b(ent4)) {
            Wbdefs.relBuk(Seg.seg_Id(seg2), n2);
            if (!bl && SchlepRT.a2b(seg)) {
                Wbdefs.relBuk(Seg.seg_Id(seg), n);
            }
            System.err.print(">>>>ERROR<<<< reclaimEnt: couldn't find ent in bucket " + Seg.seg_Id(seg2) + ":" + n2 + " l=" + Seg.seg_Id(seg) + ":" + n + "\n");
            return null;
        }
        if (!Ent.ent_Dty_P(ent)) {
            if (SchlepRT.a2b(ent5)) {
                Ent.ent_SetNext(ent5, Ent.ent_Next(ent));
            } else {
                Wbdefs.setBuk(Seg.seg_Id(seg2), n2, Ent.ent_Next(ent));
            }
            Ent.ent_SetNext(ent, null);
            if (!bl) {
                Wbdefs.relBuk(Seg.seg_Id(seg2), n2);
            }
            return ent;
        }
        Ent.ent_SetAcc(ent, 4);
        Wbdefs.relBuk(Seg.seg_Id(seg2), n2);
        if (!bl && SchlepRT.a2b(seg)) {
            Wbdefs.relBuk(Seg.seg_Id(seg), n);
        }
        Ents.ents_EntWrite(ent);
        ent2 = Wbdefs.getBukWait(Seg.seg_Id(seg2), n2);
        Ent.ent_SetAcc(ent, 1);
        Ents.spliceOutEnt(seg2, n2, ent2, ent);
        Wbdefs.relBuk(Seg.seg_Id(seg2), n2);
        return null;
    }

    public static Ent tryGetFreeEnt(Seg seg, int n) {
        Ent ent = Ents.getFreeFreeEnt();
        if (!SchlepRT.a2b(ent)) {
            ent = Ents.selectIdleEnt(seg, n);
            if (SchlepRT.a2b(ent)) {
                ent = Ents.reclaimEnt(ent, seg, n);
            } else if (SchlepRT.a2b(seg)) {
                Wbdefs.relBuk(Seg.seg_Id(seg), n);
            }
        }
        return ent;
    }

    public static Ent allocateEnt() {
        Ent ent = Ents.tryGetFreeEnt(null, -1);
        int n = 19;
        while (true) {
            if (SchlepRT.a2b(ent)) {
                Ent.ent_SetAcc(ent, 3);
                Ent.ent_SetDty(ent, true);
                Ent.ent_SetPus(ent, 0);
                Ent.ent_SetSeg(ent, null);
                Ent.ent_SetId(ent, 0);
                Ent.ent_SetRef(ent, 1);
                Ent.ent_SetNext(ent, null);
                return ent;
            }
            if (0 == n) {
                return null;
            }
            ent = Ents.tryGetFreeEnt(null, -1);
            n = -1 + n;
        }
    }

    public static void entCopy(Ent ent, Ent ent2) {
        if (Ent.ent_Acc(ent) != 3) {
            System.err.print(">>>>ERROR<<<< entCopy: copying into non-ACCWRITE " + Seg.seg_Id(Ent.ent_Seg(ent)) + ":" + Ent.ent_Id(ent) + "\n");
        }
        Ent.ent_SetSeg(ent, Ent.ent_Seg(ent2));
        Ent.ent_SetId(ent, Ent.ent_Id(ent2));
        SchlepRT.subbytesMove(Ent.ent_Blk(ent2), 0, Seg.seg_Bsiz(Ent.ent_Seg(ent2)), Ent.ent_Blk(ent), 0);
    }

    public static boolean getEntCopy(Ent ent, Seg seg, int n) {
        Ent ent2 = Ents.getEnt(seg, n, 2);
        if (SchlepRT.a2b(ent2)) {
            Ents.entCopy(ent, ent2);
            Ents.releaseEnt(ent2, 2);
            return true;
        }
        return false;
    }

    public static void flushFlc(Seg seg, int n) {
        while (true) {
            byte[] byArray = new byte[4];
            byte[] byArray2 = new byte[4];
            Lck.lck(Seg.seg_Lck(seg));
            if (Seg.seg_FlcLen(seg) <= n) {
                Lck.unlck(Seg.seg_Lck(seg));
                return;
            }
            Blink.long2str(byArray, 0, Seg.seg_Flc(seg)[Seg.seg_FlcLen(seg) - 1]);
            Seg.seg_SetFlcLen(seg, Seg.seg_FlcLen(seg) - 1);
            Lck.unlck(Seg.seg_Lck(seg));
            Blink.long2str(byArray2, 0, (int)(System.currentTimeMillis() / 1000L));
            Handle.btPut(Seg.seg_FlHan(seg), byArray, 4, byArray2, 4);
        }
    }

    public static boolean initloadFlc_P(Seg seg) {
        switch (Seg.seg_FlcLen(seg)) {
            case -1: {
                byte[] byArray = new byte[20];
                int n = Handle.btGet(Seg.seg_RtHan(seg), Wbdefs.flcByts, 3, byArray);
                if (0 > n) {
                    n = 0;
                }
                Handle.btPut(Seg.seg_RtHan(seg), Wbdefs.flcByts, 3, Wbdefs.noByts, 0);
                Seg.seg_SetFlcLen(seg, n / 4);
                for (int n2 = -4 + n; 0 <= n2; n2 = -4 + n2) {
                    Seg.seg_Flc((Seg)seg)[n2 / 4] = Blink.str2long(byArray, n2);
                }
                return true;
            }
            case -2: {
                System.err.print(">>>>ERROR<<<< initloadFlc on read only segment " + Seg.seg_Id(seg) + "?\n");
                return false;
            }
        }
        return true;
    }

    public static void amnesiaEnt(Ent ent) {
        int n = Seg.seg_Id(Ent.ent_Seg(ent));
        int n2 = Wbdefs.hash2int(n, Ent.ent_Id(ent));
        int n3 = Wbdefs.hash2int(1 + n, Ent.ent_Id(ent));
        Ent.ent_SetId(ent, n3);
        Ent.ent_SetSeg(ent, null);
        if (n2 != Wbdefs.hash2int(-1, n3)) {
            System.err.print("WARNING: amnesiaEnt: hash mismatch " + n2 + " >< " + Wbdefs.hash2int(-1, n3) + "\n");
        }
        Ent.ent_SetDty(ent, null);
        Ent.ent_SetPus(ent, 0);
        if (SchlepRT.a2b(Ent.ent_Blk(ent)) && Blk.blk_Typ_P(Ent.ent_Blk(ent), 68)) {
            Blk.blk_SetTyp(Ent.ent_Blk(ent), 84);
        }
        Ent.ent_SetAge(ent, 128);
    }

    public static boolean blkFree(Ent ent) {
        Seg seg;
        while (true) {
            seg = Ent.ent_Seg(ent);
            if (Ent.ent_Acc(ent) != 3) {
                System.err.print(">>>>ERROR<<<< blkFree: " + Seg.seg_Id(seg) + ":" + Ent.ent_Id(ent) + " without ACCWRITE\n");
                return false;
            }
            Lck.lck(Seg.seg_Lck(seg));
            if (!Ents.initloadFlc_P(seg)) {
                Lck.unlck(Seg.seg_Lck(seg));
                return false;
            }
            if (Seg.seg_FlcLen(seg) < 9) break;
            Lck.unlck(Seg.seg_Lck(seg));
            Ents.flushFlc(seg, 8);
        }
        Seg.seg_Flc((Seg)seg)[Seg.seg_FlcLen((Seg)seg)] = Ent.ent_Id(ent);
        Seg.seg_SetFlcLen(seg, Seg.seg_FlcLen(seg) + 1);
        Ents.amnesiaEnt(ent);
        Lck.unlck(Seg.seg_Lck(seg));
        return true;
    }

    public static int flcFill(Seg seg) {
        int n;
        byte[] byArray = new byte[4];
        int n2 = 0;
        Lck.lck(Seg.seg_Lck(seg));
        if (Seg.seg_FlcLen(seg) >= 1) {
            Lck.unlck(Seg.seg_Lck(seg));
            return 0;
        }
        if (!Lck.tryLck_P(Seg.seg_Fck(seg))) {
            Lck.unlck(Seg.seg_Lck(seg));
            System.err.print("WARNING: flcFill failed -- branch never tried before! Segment " + Seg.seg_Id(seg) + " " + Seg.seg_Str(seg) + "\n");
            return -10;
        }
        n2 = Handle.btNext(Seg.seg_FlHan(seg), Wbdefs.noByts, 0, byArray);
        if (Wbdefs.err_P(n2)) {
            int n3 = Seg.seg_Used(seg) + 5;
            if (Blkio.blkio_FileExtend(Seg.seg_Port(seg), Seg.seg_Bsiz(seg), n3)) {
                for (int i = 0; i <= 5; ++i) {
                    Seg.seg_Flc((Seg)seg)[Seg.seg_FlcLen((Seg)seg)] = n3 - i;
                    Seg.seg_SetFlcLen(seg, Seg.seg_FlcLen(seg) + 1);
                    Seg.seg_SetUsed(seg, Seg.seg_Used(seg) + 1);
                }
                byte[] byArray2 = new byte[4];
                Blink.long2str(byArray2, 0, Seg.seg_Used(seg));
                Handle.btPut(Seg.seg_RtHan(seg), Wbdefs.usedByts, 4, byArray2, 4);
                n = 0;
            } else {
                System.err.print(">>>>ERROR<<<< No more file space available! Segment " + Seg.seg_Id(seg) + " " + Seg.seg_Str(seg) + "\n");
                n = -20;
            }
        } else {
            Lck.unlck(Seg.seg_Lck(seg));
            int[] nArray = new int[11];
            byte[] byArray3 = new byte[256];
            int[] nArray2 = new int[6];
            int n4 = 0;
            SchlepRT.subbytesMove(byArray, 0, n2, byArray3, 0);
            nArray[0] = 0;
            Pkt.pkt_SetSkeyCount(nArray2, 0);
            n4 = Scan.btScan(Seg.seg_FlHan(seg), -1, byArray3, n2, Wbdefs.noByts, -1, Wbsys.getMethod("wb.Ents", "flcProc", new Class[]{byte[].class, Integer.TYPE, byte[].class, Integer.TYPE, int[].class}), nArray, nArray2, 1);
            if (n4 == 0 || n4 == -1 || n4 == -2) {
                Lck.lck(Seg.seg_Lck(seg));
                for (int i = nArray[0]; i > 0; --i) {
                    Seg.seg_Flc((Seg)seg)[Seg.seg_FlcLen((Seg)seg)] = nArray[i];
                    Seg.seg_SetFlcLen(seg, Seg.seg_FlcLen(seg) + 1);
                }
                n = 0;
            } else {
                Lck.unlck(Seg.seg_Fck(seg));
                return n4;
            }
        }
        Lck.unlck(Seg.seg_Lck(seg));
        Lck.unlck(Seg.seg_Fck(seg));
        return n;
    }

    public static int flcProc(byte[] byArray, int n, byte[] byArray2, int n2, int[] nArray) {
        int n3 = nArray[0];
        if (n3 < 5) {
            int n4 = Blink.str2long(byArray, 0);
            nArray[0] = ++n3;
            nArray[n3] = n4;
            return 0;
        }
        return -2;
    }

    public static Ent createNewBlkEnt(Seg seg) {
        block3: {
            do {
                Lck.lck(Seg.seg_Lck(seg));
                if (!Ents.initloadFlc_P(seg)) {
                    Lck.unlck(Seg.seg_Lck(seg));
                    return null;
                }
                if (Seg.seg_FlcLen(seg) > 0) break block3;
                Lck.unlck(Seg.seg_Lck(seg));
            } while (!Wbdefs.realerr_P(Ents.flcFill(seg)));
            return null;
        }
        Seg.seg_SetFlcLen(seg, Seg.seg_FlcLen(seg) - 1);
        int n = Seg.seg_Flc(seg)[Seg.seg_FlcLen(seg)];
        Lck.unlck(Seg.seg_Lck(seg));
        Ent ent = Ents.getEnt(seg, n, 3);
        if (SchlepRT.a2b(ent)) {
            Ent.ent_SetDty(ent, true);
        }
        return ent;
    }

    public static Ent tryGetEnt(Seg seg, int n, int n2) {
        Ent ent;
        Ent ent2 = ent = Wbdefs.getBukWait(Seg.seg_Id(seg), n);
        while (true) {
            if (!SchlepRT.a2b(ent2)) {
                Wbdefs.relBuk(Seg.seg_Id(seg), n);
                Stats.tgeFct = 1 + Stats.tgeFct;
                return null;
            }
            if (seg == Ent.ent_Seg(ent2) && n == Ent.ent_Id(ent2)) break;
            ent2 = Ent.ent_Next(ent2);
        }
        if (Blk.blk_Id(Ent.ent_Blk(ent2)) != n) {
            Wbdefs.relBuk(Seg.seg_Id(seg), n);
            System.err.print(">>>>ERROR<<<< corrutped buffer " + Seg.seg_Id(Ent.ent_Seg(ent2)) + ":" + Blk.blk_Id(Ent.ent_Blk(ent2)) + " <> " + n + "\n");
            Stats.tgeFct = 1 + Stats.tgeFct;
            return null;
        }
        if (1 == n2) {
            Ent.ent_SetRef(ent2, 1 + Ent.ent_Ref(ent2));
            Wbdefs.relBuk(Seg.seg_Id(seg), n);
            Stats.tgeCt = 1 + Stats.tgeCt;
            return ent2;
        }
        if (1 == Ent.ent_Acc(ent2)) {
            Ent.ent_SetAcc(ent2, n2);
            Ent.ent_SetRef(ent2, 1 + Ent.ent_Ref(ent2));
            Wbdefs.relBuk(Seg.seg_Id(seg), n);
            Stats.tgeCt = 1 + Stats.tgeCt;
            return ent2;
        }
        Wbdefs.relBuk(Seg.seg_Id(seg), n);
        Stats.tgeFct = 1 + Stats.tgeFct;
        return null;
    }

    public static Ent chainFindEnt(Han han, int n, byte[] byArray, int n2, int[] nArray) {
        Ent ent;
        Ent ent2 = ent = cacheEntEnable_P && SchlepRT.a2b(Han.han_Last(han)) ? Ents.tryGetEnt(Han.han_Seg(han), Han.han_Last(han), n) : null;
        if (SchlepRT.a2b(ent) && Wbdefs.leaf_P(Ent.ent_Blk(ent)) && Blk.blk_TopId(Ent.ent_Blk(ent)) == Han.han_Id(han) && Blink.blk_FindPos(Ent.ent_Blk(ent), byArray, n2, nArray) && (Pkt.pkt_MatchType(nArray) == 7 || (Pkt.pkt_MatchType(nArray) == 5 || Pkt.pkt_MatchType(nArray) == 6) && Pkt.pkt_MatchPos(nArray) > 20)) {
            ++Stats.tceCt;
            return ent;
        }
        if (SchlepRT.a2b(ent)) {
            Ents.releaseEnt(ent, n);
        }
        ++Stats.tceFct;
        ent = Ents.getEnt(Han.han_Seg(han), Han.han_Id(han), 1);
        if (!Wbdefs.root_P(Ent.ent_Blk(ent)) || Blk.blk_Typ_P(Ent.ent_Blk(ent), 83)) {
            System.err.print(">>>>ERROR<<<< btOpen: not a B-tree root " + Seg.seg_Id(Ent.ent_Seg(ent)) + ":" + Ent.ent_Id(ent) + "\n");
            Ents.releaseEnt(ent, 1);
            ent = null;
        } else {
            ent = Blink.findEnt(ent, 48, -1, byArray, n2);
        }
        if (SchlepRT.a2b(ent) && 2 != n && !Ents.ents_EntUpdateAccess_P(ent, 2, n)) {
            Ents.releaseEnt(ent, 2);
            ent = null;
        }
        if (SchlepRT.a2b(ent)) {
            ent = Blink.chainFind(ent, n, byArray, n2, nArray);
        }
        if (SchlepRT.a2b(ent)) {
            Han.han_SetLast(han, Ent.ent_Id(ent));
        }
        return ent;
    }

    public static Ent chainFindPrevEnt(Han han, int n, byte[] byArray, int n2, int[] nArray) {
        Ent ent;
        Ent ent2 = ent = cacheEntEnable_P && SchlepRT.a2b(Han.han_Last(han)) ? Ents.tryGetEnt(Han.han_Seg(han), Han.han_Last(han), n) : null;
        if (SchlepRT.a2b(ent) && Wbdefs.leaf_P(Ent.ent_Blk(ent)) && Blk.blk_TopId(Ent.ent_Blk(ent)) == Han.han_Id(han) && Blink.blk_FindPos(Ent.ent_Blk(ent), byArray, n2, nArray) && (Pkt.pkt_MatchType(nArray) == 7 || Pkt.pkt_MatchType(nArray) == 8 || (Pkt.pkt_MatchType(nArray) == 5 || Pkt.pkt_MatchType(nArray) == 6) && Pkt.pkt_MatchPos(nArray) > 20)) {
            ++Stats.tceCt;
            return ent;
        }
        if (SchlepRT.a2b(ent)) {
            Ents.releaseEnt(ent, n);
        }
        ++Stats.tceFct;
        ent = Prev.prev_FindPrevEnt(Ents.getEnt(Han.han_Seg(han), Han.han_Id(han), 1), 48, -1, byArray, n2);
        if (SchlepRT.a2b(ent) && n != 2 && !Ents.ents_EntUpdateAccess_P(ent, 2, n)) {
            Ents.releaseEnt(ent, 2);
            ent = null;
        }
        return ent;
    }

    public static Ent getEnt(Seg seg, int n, int n2) {
        if (0 > n) {
            System.err.print(">>>>ERROR<<<< negative block number " + n + "\n");
            return null;
        }
        if (n >= Seg.seg_Used(seg)) {
            System.err.print(">>>>ERROR<<<< bad block number " + Seg.seg_Id(seg) + ":" + n + " (>= " + Seg.seg_Used(seg) + ")\n");
            return null;
        }
        Ent ent = Wbdefs.getBukWait(Seg.seg_Id(seg), n);
        while (true) {
            if (!SchlepRT.a2b(ent)) {
                ent = Ents.tryGetFreeEnt(seg, n);
                if (SchlepRT.a2b(ent)) {
                    Ent.ent_SetNext(ent, Wbdefs.getBuk(Seg.seg_Id(seg), n));
                    Wbdefs.setBuk(Seg.seg_Id(seg), n, ent);
                    Ent.ent_SetAcc(ent, 4);
                    Ent.ent_SetSeg(ent, seg);
                    Ent.ent_SetId(ent, n);
                    Ent.ent_SetAge(ent, -127);
                    Ent.ent_SetDty(ent, null);
                    Ent.ent_SetPus(ent, 0);
                    Ent.ent_SetRef(ent, 1);
                    Wbdefs.relBuk(Seg.seg_Id(seg), n);
                    if (n2 == 3) {
                        Ent.ent_SetAcc(ent, 3);
                        Ent.ent_SetDty(ent, true);
                        Blink.initLeafBlk(Ent.ent_Blk(ent), n, 84);
                        Stats.geCt = 1 + Stats.geCt;
                        return ent;
                    }
                    if (Blkio.blkio_Read(Seg.seg_Port(seg), Ent.ent_Blk(ent), Seg.seg_Bsiz(seg), n)) {
                        Ent.ent_SetAcc(ent, n2);
                        if (Blk.blk_Id(Ent.ent_Blk(ent)) != n) {
                            System.err.print(">>>>ERROR<<<< corrupted blk " + Seg.seg_Id(Ent.ent_Seg(ent)) + ":" + n + " <> " + Blk.blk_Id(Ent.ent_Blk(ent)) + "\n");
                        }
                        Stats.geCt = 1 + Stats.geCt;
                        return ent;
                    }
                    Ent.ent_SetRef(ent, 0);
                    Ent.ent_SetAcc(ent, 1);
                    Stats.geFct = 1 + Stats.geFct;
                    return null;
                }
                ent = Wbdefs.getBukWait(Seg.seg_Id(seg), n);
                continue;
            }
            if (seg == Ent.ent_Seg(ent) && n == Ent.ent_Id(ent)) break;
            ent = Ent.ent_Next(ent);
        }
        if (Blk.blk_Id(Ent.ent_Blk(ent)) != n) {
            Wbdefs.relBuk(Seg.seg_Id(seg), n);
            System.err.print(">>>>ERROR<<<< corrupted buffer " + Seg.seg_Id(Ent.ent_Seg(ent)) + ":" + Blk.blk_Id(Ent.ent_Blk(ent)) + " <> " + n + "\n");
            Stats.geFct = 1 + Stats.geFct;
            return null;
        }
        if (1 == n2) {
            Ent.ent_SetRef(ent, 1 + Ent.ent_Ref(ent));
            Wbdefs.relBuk(Seg.seg_Id(seg), n);
            Stats.geCt = 1 + Stats.geCt;
            return ent;
        }
        if (1 == Ent.ent_Acc(ent)) {
            Ent.ent_SetAcc(ent, n2);
            Ent.ent_SetRef(ent, 1 + Ent.ent_Ref(ent));
            Wbdefs.relBuk(Seg.seg_Id(seg), n);
            Stats.geCt = 1 + Stats.geCt;
            return ent;
        }
        Wbdefs.relBuk(Seg.seg_Id(seg), n);
        Stats.geFct = 1 + Stats.geFct;
        return null;
    }

    public static Ent switchEnt(Ent ent, int n, int n2, int n3) {
        Ent ent2 = Ents.getEnt(Ent.ent_Seg(ent), n2, 1);
        Ents.releaseEnt(ent, n);
        if (SchlepRT.a2b(ent2)) {
            Ents.ents_EntUpdateAccess_P(ent2, 1, n3);
        }
        return ent2;
    }

    public static void checkBlk(byte[] byArray) {
        int n;
        int n2 = Blk.blk_End(byArray);
        int n3 = 20;
        while (true) {
            if ((n = Wbdefs.nextField(byArray, 1 + n3)) == n2) {
                return;
            }
            if (n >= n2) break;
            n3 = Wbdefs.nextCnvpair(byArray, n3);
        }
        System.err.print(">>>>ERROR<<<< checkBlk: blk " + Blk.blk_Id(byArray) + " past end " + n + "\n");
    }

    public static void checkKeyOrder(byte[] byArray) {
        byte[] byArray2 = new byte[256];
        int n = Blink.splitKeyPos(byArray);
        if (0 < n) {
            Blink.reconThisKey(byArray, n, byArray2, 0, 256);
        }
    }

    public static int doSegBuffers(Seg seg, Method method) {
        int n = numBuks;
        Ent ent = null;
        while (true) {
            int n2;
            if (!SchlepRT.a2b(ent)) {
                if (0 == n) {
                    return 0;
                }
                n2 = n - 1;
                ent = bukTab[n - 1];
                n = n2;
                continue;
            }
            if (!SchlepRT.a2b(seg) || seg == Ent.ent_Seg(ent)) {
                n2 = Wbsys.intFunInvoke(method, null, new Object[]{ent});
                if (Wbdefs.success_P(n2)) {
                    ent = Ent.ent_Next(ent);
                    continue;
                }
                return n2;
            }
            ent = Ent.ent_Next(ent);
        }
    }

    public static int checkBuffer(Ent ent) {
        if (0 != Ent.ent_Ref(ent)) {
            System.err.print(">>>>ERROR<<<< Entry still referenced: " + Seg.seg_Id(Ent.ent_Seg(ent)) + ":" + Ent.ent_Id(ent) + "\n");
            Ent.ent_SetRef(ent, 0);
        }
        if (1 != Ent.ent_Acc(ent)) {
            System.err.print(">>>>ERROR<<<< Entry still lcked: " + Seg.seg_Id(Ent.ent_Seg(ent)) + ":" + Ent.ent_Id(ent) + "\n");
            Ents.ents_EntUpdateAccess_P(ent, Ent.ent_Acc(ent), 1);
        }
        return 0;
    }

    public static void checkAccess() {
        Lck.checkLcks();
        Ents.doSegBuffers(null, Wbsys.getMethod("wb.Ents", "checkBuffer", new Class[]{Ent.class}));
    }

    public static int flushBuffer(Ent ent) {
        if (1 != Ent.ent_Acc(ent)) {
            return -2;
        }
        if (Ent.ent_Dty_P(ent)) {
            if (Ents.ents_EntWrite(ent)) {
                return 0;
            }
            return -10;
        }
        return 0;
    }

    public static int purgeBuffer(Ent ent) {
        if (Ent.ent_Dty_P(ent)) {
            if (Ent.ent_Acc(ent) == 3 || Ent.ent_Acc(ent) == 4) {
                System.err.print("  Purging " + (Ent.ent_Acc(ent) == 3 ? "ACCWRITE" : "ACCPEND") + " entry: " + Seg.seg_Id(Ent.ent_Seg(ent)) + ":" + Ent.ent_Id(ent) + "\n");
            }
            Ents.ents_EntWrite(ent);
        }
        Ents.amnesiaEnt(ent);
        return 0;
    }
}

