/* region.c generated by valac 0.56.17, the Vala compiler
 * generated from region.vala, do not modify */

/* Regions

   Copyright (c) 1997-2020 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <estr.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_REGION (region_get_type ())
#define REGION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGION, Region))
#define REGION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGION, RegionClass))
#define IS_REGION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGION))
#define IS_REGION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGION))
#define REGION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGION, RegionClass))

typedef struct _Region Region;
typedef struct _RegionClass RegionClass;
typedef struct _RegionPrivate RegionPrivate;

#define TYPE_BUFFER (buffer_get_type ())
#define BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUFFER, Buffer))
#define BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUFFER, BufferClass))
#define IS_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUFFER))
#define IS_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUFFER))
#define BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUFFER, BufferClass))

typedef struct _Buffer Buffer;
typedef struct _BufferClass BufferClass;
typedef struct _BufferPrivate BufferPrivate;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MARKER, MarkerClass))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define IS_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MARKER))
#define MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MARKER, MarkerClass))

typedef struct _Marker Marker;
typedef struct _MarkerClass MarkerClass;

#define TYPE_UNDO (undo_get_type ())
#define UNDO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO, Undo))
#define UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO, UndoClass))
#define IS_UNDO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO))
#define IS_UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO))
#define UNDO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO, UndoClass))

typedef struct _Undo Undo;
typedef struct _UndoClass UndoClass;

#define TYPE_VAR_ENTRY (var_entry_get_type ())
#define VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VAR_ENTRY, VarEntry))
#define VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VAR_ENTRY, VarEntryClass))
#define IS_VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VAR_ENTRY))
#define IS_VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VAR_ENTRY))
#define VAR_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VAR_ENTRY, VarEntryClass))

typedef struct _VarEntry VarEntry;
typedef struct _VarEntryClass VarEntryClass;
#define _marker_unref0(var) ((var == NULL) ? NULL : (var = (marker_unref (var), NULL)))
typedef struct _ParamSpecRegion ParamSpecRegion;

struct _Region {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RegionPrivate * priv;
};

struct _RegionClass {
	GTypeClass parent_class;
	void (*finalize) (Region *self);
};

struct _RegionPrivate {
	gsize _start;
	gsize _end;
};

struct _Buffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BufferPrivate * priv;
	gchar* name;
	gchar* filename;
	Buffer* next;
	gsize goalc;
	Marker* mark;
	Marker* markers;
	GList* last_undop;
	GList* next_undop;
	GHashTable* vars;
	gboolean modified;
	gboolean nosave;
	gboolean needname;
	gboolean temporary;
	gboolean readonly;
	gboolean backup;
	gboolean noundo;
	gboolean autofill;
	gboolean isearch;
	gboolean mark_active;
	gchar* dir;
};

struct _BufferClass {
	GTypeClass parent_class;
	void (*finalize) (Buffer *self);
	gsize (*get_length) (Buffer* self);
	const gchar* (*get_eol) (Buffer* self);
};

struct _ParamSpecRegion {
	GParamSpec parent_instance;
};

static gint Region_private_offset;
static gpointer region_parent_class = NULL;
VALA_EXTERN Buffer* cur_bp;

VALA_EXTERN gpointer region_ref (gpointer instance);
VALA_EXTERN void region_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_region (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_region (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_region (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_region (const GValue* value);
VALA_EXTERN GType region_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Region, region_unref)
VALA_EXTERN Region* region_new (gsize o1,
                    gsize o2);
VALA_EXTERN Region* region_construct (GType object_type,
                          gsize o1,
                          gsize o2);
VALA_EXTERN void region_set_start (Region* self,
                       gsize value);
VALA_EXTERN void region_set_end (Region* self,
                     gsize value);
VALA_EXTERN gsize region_size (Region* self);
VALA_EXTERN gsize region_get_end (Region* self);
VALA_EXTERN gsize region_get_start (Region* self);
VALA_EXTERN Region* region_calculate (void);
VALA_EXTERN gpointer buffer_ref (gpointer instance);
VALA_EXTERN void buffer_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_buffer (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_buffer (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_buffer (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_buffer (const GValue* value);
VALA_EXTERN GType buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Buffer, buffer_unref)
VALA_EXTERN gsize buffer_get_pt (Buffer* self);
VALA_EXTERN gpointer marker_ref (gpointer instance);
VALA_EXTERN void marker_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_marker (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_marker (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_marker (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_marker (const GValue* value);
VALA_EXTERN GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, marker_unref)
VALA_EXTERN gpointer undo_ref (gpointer instance);
VALA_EXTERN void undo_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_undo (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
VALA_EXTERN void value_set_undo (GValue* value,
                     gpointer v_object);
VALA_EXTERN void value_take_undo (GValue* value,
                      gpointer v_object);
VALA_EXTERN gpointer value_get_undo (const GValue* value);
VALA_EXTERN GType undo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Undo, undo_unref)
VALA_EXTERN gpointer var_entry_ref (gpointer instance);
VALA_EXTERN void var_entry_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_var_entry (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_var_entry (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_var_entry (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_var_entry (const GValue* value);
VALA_EXTERN GType var_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VarEntry, var_entry_unref)
VALA_EXTERN gsize marker_get_o (Marker* self);
VALA_EXTERN gboolean region_delete (Region* self);
VALA_EXTERN gboolean buffer_warn_if_readonly (Buffer* self);
VALA_EXTERN Marker* marker_point (void);
VALA_EXTERN void buffer_goto_offset (Buffer* self,
                         gsize o);
VALA_EXTERN gboolean buffer_replace_estr (Buffer* self,
                              gsize del,
                              ImmutableEstr* es);
VALA_EXTERN void marker_unchain (Marker* self);
VALA_EXTERN gboolean region_contains (Region* self,
                          gsize o);
static void region_finalize (Region * obj);
static GType region_get_type_once (void);

static inline gpointer
region_get_instance_private (Region* self)
{
	return G_STRUCT_MEMBER_P (self, Region_private_offset);
}

Region*
region_construct (GType object_type,
                  gsize o1,
                  gsize o2)
{
	Region* self = NULL;
#line 27 "src/region.vala"
	self = (Region*) g_type_create_instance (object_type);
#line 28 "src/region.vala"
	region_set_start (self, MIN (o1, o2));
#line 29 "src/region.vala"
	region_set_end (self, MAX (o1, o2));
#line 27 "src/region.vala"
	return self;
#line 279 "region.c"
}

Region*
region_new (gsize o1,
            gsize o2)
{
#line 27 "src/region.vala"
	return region_construct (TYPE_REGION, o1, o2);
#line 288 "region.c"
}

gsize
region_size (Region* self)
{
	gsize _tmp0_;
	gsize _tmp1_;
	gsize result;
#line 32 "src/region.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 33 "src/region.vala"
	_tmp0_ = self->priv->_end;
#line 33 "src/region.vala"
	_tmp1_ = self->priv->_start;
#line 33 "src/region.vala"
	result = _tmp0_ - _tmp1_;
#line 33 "src/region.vala"
	return result;
#line 307 "region.c"
}

Region*
region_calculate (void)
{
	Buffer* _tmp0_;
	gsize _tmp1_;
	gsize _tmp2_;
	Buffer* _tmp3_;
	Marker* _tmp4_;
	gsize _tmp5_;
	gsize _tmp6_;
	Region* _tmp7_;
	Region* result;
#line 40 "src/region.vala"
	_tmp0_ = cur_bp;
#line 40 "src/region.vala"
	_tmp1_ = buffer_get_pt (_tmp0_);
#line 40 "src/region.vala"
	_tmp2_ = _tmp1_;
#line 40 "src/region.vala"
	_tmp3_ = cur_bp;
#line 40 "src/region.vala"
	_tmp4_ = _tmp3_->mark;
#line 40 "src/region.vala"
	_tmp5_ = marker_get_o (_tmp4_);
#line 40 "src/region.vala"
	_tmp6_ = _tmp5_;
#line 40 "src/region.vala"
	_tmp7_ = region_new (_tmp2_, _tmp6_);
#line 40 "src/region.vala"
	result = _tmp7_;
#line 40 "src/region.vala"
	return result;
#line 342 "region.c"
}

gboolean
region_delete (Region* self)
{
	Buffer* _tmp0_;
	Marker* m = NULL;
	Marker* _tmp1_;
	Buffer* _tmp2_;
	gsize _tmp3_;
	Buffer* _tmp4_;
	ImmutableEstr* _tmp5_;
	Buffer* _tmp6_;
	Marker* _tmp7_;
	gsize _tmp8_;
	gsize _tmp9_;
	Marker* _tmp10_;
	gboolean result;
#line 43 "src/region.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 44 "src/region.vala"
	_tmp0_ = cur_bp;
#line 44 "src/region.vala"
	if (buffer_warn_if_readonly (_tmp0_)) {
#line 45 "src/region.vala"
		result = FALSE;
#line 45 "src/region.vala"
		return result;
#line 371 "region.c"
	}
#line 47 "src/region.vala"
	_tmp1_ = marker_point ();
#line 47 "src/region.vala"
	m = _tmp1_;
#line 48 "src/region.vala"
	_tmp2_ = cur_bp;
#line 48 "src/region.vala"
	_tmp3_ = self->priv->_start;
#line 48 "src/region.vala"
	buffer_goto_offset (_tmp2_, _tmp3_);
#line 49 "src/region.vala"
	_tmp4_ = cur_bp;
#line 49 "src/region.vala"
	_tmp5_ = immutable_estr_empty;
#line 49 "src/region.vala"
	buffer_replace_estr (_tmp4_, region_size (self), _tmp5_);
#line 50 "src/region.vala"
	_tmp6_ = cur_bp;
#line 50 "src/region.vala"
	_tmp7_ = m;
#line 50 "src/region.vala"
	_tmp8_ = marker_get_o (_tmp7_);
#line 50 "src/region.vala"
	_tmp9_ = _tmp8_;
#line 50 "src/region.vala"
	buffer_goto_offset (_tmp6_, _tmp9_);
#line 51 "src/region.vala"
	_tmp10_ = m;
#line 51 "src/region.vala"
	marker_unchain (_tmp10_);
#line 52 "src/region.vala"
	result = TRUE;
#line 52 "src/region.vala"
	_marker_unref0 (m);
#line 52 "src/region.vala"
	return result;
#line 409 "region.c"
}

gboolean
region_contains (Region* self,
                 gsize o)
{
	gboolean _tmp0_ = FALSE;
	gsize _tmp1_;
	gboolean result;
#line 55 "src/region.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 56 "src/region.vala"
	_tmp1_ = self->priv->_start;
#line 56 "src/region.vala"
	if (o >= _tmp1_) {
#line 425 "region.c"
		gsize _tmp2_;
#line 56 "src/region.vala"
		_tmp2_ = self->priv->_end;
#line 56 "src/region.vala"
		_tmp0_ = o < _tmp2_;
#line 431 "region.c"
	} else {
#line 56 "src/region.vala"
		_tmp0_ = FALSE;
#line 435 "region.c"
	}
#line 56 "src/region.vala"
	result = _tmp0_;
#line 56 "src/region.vala"
	return result;
#line 441 "region.c"
}

gsize
region_get_start (Region* self)
{
	gsize result;
#line 21 "src/region.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 21 "src/region.vala"
	result = self->priv->_start;
#line 21 "src/region.vala"
	return result;
#line 454 "region.c"
}

void
region_set_start (Region* self,
                  gsize value)
{
#line 21 "src/region.vala"
	g_return_if_fail (self != NULL);
#line 21 "src/region.vala"
	self->priv->_start = value;
#line 465 "region.c"
}

gsize
region_get_end (Region* self)
{
	gsize result;
#line 22 "src/region.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 22 "src/region.vala"
	result = self->priv->_end;
#line 22 "src/region.vala"
	return result;
#line 478 "region.c"
}

void
region_set_end (Region* self,
                gsize value)
{
#line 22 "src/region.vala"
	g_return_if_fail (self != NULL);
#line 22 "src/region.vala"
	self->priv->_end = value;
#line 489 "region.c"
}

static void
value_region_init (GValue* value)
{
#line 20 "src/region.vala"
	value->data[0].v_pointer = NULL;
#line 497 "region.c"
}

static void
value_region_free_value (GValue* value)
{
#line 20 "src/region.vala"
	if (value->data[0].v_pointer) {
#line 20 "src/region.vala"
		region_unref (value->data[0].v_pointer);
#line 507 "region.c"
	}
}

static void
value_region_copy_value (const GValue* src_value,
                         GValue* dest_value)
{
#line 20 "src/region.vala"
	if (src_value->data[0].v_pointer) {
#line 20 "src/region.vala"
		dest_value->data[0].v_pointer = region_ref (src_value->data[0].v_pointer);
#line 519 "region.c"
	} else {
#line 20 "src/region.vala"
		dest_value->data[0].v_pointer = NULL;
#line 523 "region.c"
	}
}

static gpointer
value_region_peek_pointer (const GValue* value)
{
#line 20 "src/region.vala"
	return value->data[0].v_pointer;
#line 532 "region.c"
}

static gchar*
value_region_collect_value (GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
#line 20 "src/region.vala"
	if (collect_values[0].v_pointer) {
#line 543 "region.c"
		Region * object;
		object = collect_values[0].v_pointer;
#line 20 "src/region.vala"
		if (object->parent_instance.g_class == NULL) {
#line 20 "src/region.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 550 "region.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 20 "src/region.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 554 "region.c"
		}
#line 20 "src/region.vala"
		value->data[0].v_pointer = region_ref (object);
#line 558 "region.c"
	} else {
#line 20 "src/region.vala"
		value->data[0].v_pointer = NULL;
#line 562 "region.c"
	}
#line 20 "src/region.vala"
	return NULL;
#line 566 "region.c"
}

static gchar*
value_region_lcopy_value (const GValue* value,
                          guint n_collect_values,
                          GTypeCValue* collect_values,
                          guint collect_flags)
{
	Region ** object_p;
	object_p = collect_values[0].v_pointer;
#line 20 "src/region.vala"
	if (!object_p) {
#line 20 "src/region.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 581 "region.c"
	}
#line 20 "src/region.vala"
	if (!value->data[0].v_pointer) {
#line 20 "src/region.vala"
		*object_p = NULL;
#line 587 "region.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 20 "src/region.vala"
		*object_p = value->data[0].v_pointer;
#line 591 "region.c"
	} else {
#line 20 "src/region.vala"
		*object_p = region_ref (value->data[0].v_pointer);
#line 595 "region.c"
	}
#line 20 "src/region.vala"
	return NULL;
#line 599 "region.c"
}

GParamSpec*
param_spec_region (const gchar* name,
                   const gchar* nick,
                   const gchar* blurb,
                   GType object_type,
                   GParamFlags flags)
{
	ParamSpecRegion* spec;
#line 20 "src/region.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_REGION), NULL);
#line 20 "src/region.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 20 "src/region.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 20 "src/region.vala"
	return G_PARAM_SPEC (spec);
#line 618 "region.c"
}

gpointer
value_get_region (const GValue* value)
{
#line 20 "src/region.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REGION), NULL);
#line 20 "src/region.vala"
	return value->data[0].v_pointer;
#line 628 "region.c"
}

void
value_set_region (GValue* value,
                  gpointer v_object)
{
	Region * old;
#line 20 "src/region.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REGION));
#line 20 "src/region.vala"
	old = value->data[0].v_pointer;
#line 20 "src/region.vala"
	if (v_object) {
#line 20 "src/region.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_REGION));
#line 20 "src/region.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "src/region.vala"
		value->data[0].v_pointer = v_object;
#line 20 "src/region.vala"
		region_ref (value->data[0].v_pointer);
#line 650 "region.c"
	} else {
#line 20 "src/region.vala"
		value->data[0].v_pointer = NULL;
#line 654 "region.c"
	}
#line 20 "src/region.vala"
	if (old) {
#line 20 "src/region.vala"
		region_unref (old);
#line 660 "region.c"
	}
}

void
value_take_region (GValue* value,
                   gpointer v_object)
{
	Region * old;
#line 20 "src/region.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REGION));
#line 20 "src/region.vala"
	old = value->data[0].v_pointer;
#line 20 "src/region.vala"
	if (v_object) {
#line 20 "src/region.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_REGION));
#line 20 "src/region.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "src/region.vala"
		value->data[0].v_pointer = v_object;
#line 681 "region.c"
	} else {
#line 20 "src/region.vala"
		value->data[0].v_pointer = NULL;
#line 685 "region.c"
	}
#line 20 "src/region.vala"
	if (old) {
#line 20 "src/region.vala"
		region_unref (old);
#line 691 "region.c"
	}
}

static void
region_class_init (RegionClass * klass,
                   gpointer klass_data)
{
#line 20 "src/region.vala"
	region_parent_class = g_type_class_peek_parent (klass);
#line 20 "src/region.vala"
	((RegionClass *) klass)->finalize = region_finalize;
#line 20 "src/region.vala"
	g_type_class_adjust_private_offset (klass, &Region_private_offset);
#line 705 "region.c"
}

static void
region_instance_init (Region * self,
                      gpointer klass)
{
#line 20 "src/region.vala"
	self->priv = region_get_instance_private (self);
#line 20 "src/region.vala"
	self->ref_count = 1;
#line 716 "region.c"
}

static void
region_finalize (Region * obj)
{
	Region * self;
#line 20 "src/region.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REGION, Region);
#line 20 "src/region.vala"
	g_signal_handlers_destroy (self);
#line 727 "region.c"
}

static GType
region_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_region_init, value_region_free_value, value_region_copy_value, value_region_peek_pointer, "p", value_region_collect_value, "p", value_region_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (RegionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) region_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Region), 0, (GInstanceInitFunc) region_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType region_type_id;
	region_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Region", &g_define_type_info, &g_define_type_fundamental_info, 0);
	Region_private_offset = g_type_add_instance_private (region_type_id, sizeof (RegionPrivate));
	return region_type_id;
}

GType
region_get_type (void)
{
	static volatile gsize region_type_id__once = 0;
	if (g_once_init_enter (&region_type_id__once)) {
		GType region_type_id;
		region_type_id = region_get_type_once ();
		g_once_init_leave (&region_type_id__once, region_type_id);
	}
	return region_type_id__once;
}

gpointer
region_ref (gpointer instance)
{
	Region * self;
	self = instance;
#line 20 "src/region.vala"
	g_atomic_int_inc (&self->ref_count);
#line 20 "src/region.vala"
	return instance;
#line 763 "region.c"
}

void
region_unref (gpointer instance)
{
	Region * self;
	self = instance;
#line 20 "src/region.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 20 "src/region.vala"
		REGION_GET_CLASS (self)->finalize (self);
#line 20 "src/region.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 777 "region.c"
	}
}

