/* lisp.c generated by valac 0.56.17, the Vala compiler
 * generated from lisp.vala, do not modify */

/* "Lisp" "interpreter".

   Copyright (c) 2001-2020 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>
#include <errno.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PARSE_ERROR (parse_error_get_type ())

#define TYPE_LEXP (lexp_get_type ())
#define LEXP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LEXP, Lexp))
#define LEXP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LEXP, LexpClass))
#define IS_LEXP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LEXP))
#define IS_LEXP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LEXP))
#define LEXP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LEXP, LexpClass))

typedef struct _Lexp Lexp;
typedef struct _LexpClass LexpClass;
typedef struct _LexpPrivate LexpPrivate;
typedef enum  {
	LEXP_TOKEN_TYPE_closeparen,
	LEXP_TOKEN_TYPE_openparen,
	LEXP_TOKEN_TYPE_quote,
	LEXP_TOKEN_TYPE_word
} LexpTokenType;

#define LEXP_TYPE_TOKEN_TYPE (lexp_token_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _lexp_unref0(var) ((var == NULL) ? NULL : (var = (lexp_unref (var), NULL)))

#define TYPE_LISP_FUNC (lisp_func_get_type ())
#define LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LISP_FUNC, LispFunc))
#define LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LISP_FUNC, LispFuncClass))
#define IS_LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LISP_FUNC))
#define IS_LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LISP_FUNC))
#define LISP_FUNC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LISP_FUNC, LispFuncClass))

typedef struct _LispFunc LispFunc;
typedef struct _LispFuncClass LispFuncClass;
#define _lisp_func_unref0(var) ((var == NULL) ? NULL : (var = (lisp_func_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecLexp ParamSpecLexp;
typedef gboolean (*Function) (glong uniarg, GeeQueue* args);
typedef struct _LispFuncPrivate LispFuncPrivate;
typedef enum  {
	FLAGS_NEED_RESYNC = 1 << 0,
	FLAGS_SET_UNIARG = 1 << 1,
	FLAGS_UNIARG_EMPTY = 1 << 2,
	FLAGS_DEFINING_MACRO = 1 << 3
} Flags;

#define TYPE_FLAGS (flags_get_type ())

typedef enum  {
	PARSE_ERROR_EOF,
	PARSE_ERROR_UNCLOSED_QUOTE
} ParseError;
#define PARSE_ERROR parse_error_quark ()

struct _Lexp {
	GTypeInstance parent_instance;
	volatile int ref_count;
	LexpPrivate * priv;
	gboolean quoted;
	gchar* atom;
	GeeList* list;
};

struct _LexpClass {
	GTypeClass parent_class;
	void (*finalize) (Lexp *self);
};

struct _ParamSpecLexp {
	GParamSpec parent_instance;
};

struct _LispFunc {
	GTypeInstance parent_instance;
	volatile int ref_count;
	LispFuncPrivate * priv;
	gchar* name;
	Function func;
	gboolean interactive;
	gchar* doc;
};

struct _LispFuncClass {
	GTypeClass parent_class;
	void (*finalize) (LispFunc *self);
};

static gpointer lexp_parent_class = NULL;
VALA_EXTERN Flags lastflag;

VALA_EXTERN GQuark parse_error_quark (void);
VALA_EXTERN GType parse_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer lexp_ref (gpointer instance);
VALA_EXTERN void lexp_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_lexp (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
VALA_EXTERN void value_set_lexp (GValue* value,
                     gpointer v_object);
VALA_EXTERN void value_take_lexp (GValue* value,
                      gpointer v_object);
VALA_EXTERN gpointer value_get_lexp (const GValue* value);
VALA_EXTERN GType lexp_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Lexp, lexp_unref)
static GType lexp_token_type_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN Lexp* lexp_new (const gchar* text);
VALA_EXTERN Lexp* lexp_construct (GType object_type,
                      const gchar* text);
VALA_EXTERN gboolean lexp_eval (Lexp* self);
static gchar* ___lambda22_ (Lexp* self,
                     Lexp* l);
static gpointer ____lambda22__gee_map_func (gpointer g,
                                     gpointer self);
VALA_EXTERN gpointer lisp_func_ref (gpointer instance);
VALA_EXTERN void lisp_func_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_lisp_func (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_lisp_func (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_lisp_func (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_lisp_func (const GValue* value);
VALA_EXTERN GType lisp_func_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LispFunc, lisp_func_unref)
VALA_EXTERN LispFunc* lisp_func_find (const gchar* name);
VALA_EXTERN gboolean call_command (LispFunc* f,
                       glong uniarg,
                       GeeQueue* args);
VALA_EXTERN void lexp_eval_list (GeeList* list);
static gchar lexp_read_char (const gchar* a,
                      guint* pos,
                      GError** error);
static LexpTokenType lexp_read_token (const gchar* a,
                               guint* pos,
                               gchar** tok,
                               GError** error);
static Lexp* lexp_read_sexp (const gchar* a,
                      guint* pos,
                      LexpTokenType* tokenid,
                      GError** error);
VALA_EXTERN GeeList* lexp_read_list (const gchar* a,
                         guint* pos);
static void lexp_finalize (Lexp * obj);
static GType lexp_get_type_once (void);
VALA_EXTERN gboolean funcall (const gchar* name,
                  glong* maybe_uniarg,
                  GeeQueue* args);
VALA_EXTERN gboolean noarg (GeeQueue* args);
VALA_EXTERN GType flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean bool_arg (GeeQueue* args,
                   gboolean* val);
VALA_EXTERN glong* parse_number (const gchar* s);
static glong* _long_dup (glong* self);
VALA_EXTERN gboolean int_arg (GeeQueue* args,
                  glong* n);
VALA_EXTERN gboolean int_or_uniarg (GeeQueue* args,
                        glong* n,
                        glong uniarg);
VALA_EXTERN void lisp_loadstring (const gchar* a);
VALA_EXTERN gboolean lisp_loadfile (const gchar* file);
VALA_EXTERN void lisp_init (void);
static gboolean __lambda113_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda113__function (glong uniarg,
                                 GeeQueue* args);
VALA_EXTERN LispFunc* lisp_func_new (const gchar* name,
                         Function func,
                         gboolean interactive,
                         const gchar* doc);
VALA_EXTERN LispFunc* lisp_func_construct (GType object_type,
                               const gchar* name,
                               Function func,
                               gboolean interactive,
                               const gchar* doc);

GQuark
parse_error_quark (void)
{
	return g_quark_from_static_string ("parse-error-quark");
}

static GType
parse_error_get_type_once (void)
{
	static const GEnumValue values[] = {{PARSE_ERROR_EOF, "PARSE_ERROR_EOF", "eof"}, {PARSE_ERROR_UNCLOSED_QUOTE, "PARSE_ERROR_UNCLOSED_QUOTE", "unclosed-quote"}, {0, NULL, NULL}};
	GType parse_error_type_id;
	parse_error_type_id = g_enum_register_static ("ParseError", values);
	return parse_error_type_id;
}

GType
parse_error_get_type (void)
{
	static volatile gsize parse_error_type_id__once = 0;
	if (g_once_init_enter (&parse_error_type_id__once)) {
		GType parse_error_type_id;
		parse_error_type_id = parse_error_get_type_once ();
		g_once_init_leave (&parse_error_type_id__once, parse_error_type_id);
	}
	return parse_error_type_id__once;
}

static GType
lexp_token_type_get_type_once (void)
{
	static const GEnumValue values[] = {{LEXP_TOKEN_TYPE_closeparen, "LEXP_TOKEN_TYPE_closeparen", "closeparen"}, {LEXP_TOKEN_TYPE_openparen, "LEXP_TOKEN_TYPE_openparen", "openparen"}, {LEXP_TOKEN_TYPE_quote, "LEXP_TOKEN_TYPE_quote", "quote"}, {LEXP_TOKEN_TYPE_word, "LEXP_TOKEN_TYPE_word", "word"}, {0, NULL, NULL}};
	GType lexp_token_type_type_id;
	lexp_token_type_type_id = g_enum_register_static ("LexpTokenType", values);
	return lexp_token_type_type_id;
}

static GType
lexp_token_type_get_type (void)
{
	static volatile gsize lexp_token_type_type_id__once = 0;
	if (g_once_init_enter (&lexp_token_type_type_id__once)) {
		GType lexp_token_type_type_id;
		lexp_token_type_type_id = lexp_token_type_get_type_once ();
		g_once_init_leave (&lexp_token_type_type_id__once, lexp_token_type_type_id);
	}
	return lexp_token_type_type_id__once;
}

Lexp*
lexp_construct (GType object_type,
                const gchar* text)
{
	Lexp* self = NULL;
#line 31 "src/lisp.vala"
	self = (Lexp*) g_type_create_instance (object_type);
#line 32 "src/lisp.vala"
	if (text != NULL) {
#line 287 "lisp.c"
		gchar* _tmp0_;
#line 33 "src/lisp.vala"
		_tmp0_ = g_strdup (text);
#line 33 "src/lisp.vala"
		_g_free0 (self->atom);
#line 33 "src/lisp.vala"
		self->atom = _tmp0_;
#line 295 "lisp.c"
	} else {
		GeeArrayList* _tmp1_;
#line 35 "src/lisp.vala"
		_tmp1_ = gee_array_list_new (TYPE_LEXP, (GBoxedCopyFunc) lexp_ref, (GDestroyNotify) lexp_unref, NULL, NULL, NULL);
#line 35 "src/lisp.vala"
		_g_object_unref0 (self->list);
#line 35 "src/lisp.vala"
		self->list = (GeeList*) _tmp1_;
#line 304 "lisp.c"
	}
#line 31 "src/lisp.vala"
	return self;
#line 308 "lisp.c"
}

Lexp*
lexp_new (const gchar* text)
{
#line 31 "src/lisp.vala"
	return lexp_construct (TYPE_LEXP, text);
#line 316 "lisp.c"
}

static gchar*
___lambda22_ (Lexp* self,
              Lexp* l)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 45 "src/lisp.vala"
	g_return_val_if_fail (l != NULL, NULL);
#line 45 "src/lisp.vala"
	_tmp0_ = l->atom;
#line 45 "src/lisp.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 45 "src/lisp.vala"
	result = _tmp1_;
#line 45 "src/lisp.vala"
	_lexp_unref0 (l);
#line 45 "src/lisp.vala"
	return result;
#line 338 "lisp.c"
}

static gpointer
____lambda22__gee_map_func (gpointer g,
                            gpointer self)
{
	gpointer result;
	result = ___lambda22_ ((Lexp*) self, (Lexp*) g);
#line 45 "src/lisp.vala"
	return result;
#line 349 "lisp.c"
}

gboolean
lexp_eval (Lexp* self)
{
	const gchar* _tmp0_;
	GeeQueue* args = NULL;
	GeeList* _tmp1_;
	LispFunc* func = NULL;
	GeeQueue* _tmp7_;
	gpointer _tmp8_;
	gchar* _tmp9_;
	LispFunc* _tmp10_;
	LispFunc* _tmp11_;
	LispFunc* _tmp12_;
	gboolean result;
#line 38 "src/lisp.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 39 "src/lisp.vala"
	_tmp0_ = self->atom;
#line 39 "src/lisp.vala"
	if (_tmp0_ != NULL) {
#line 40 "src/lisp.vala"
		result = FALSE;
#line 40 "src/lisp.vala"
		return result;
#line 376 "lisp.c"
	}
#line 42 "src/lisp.vala"
	args = NULL;
#line 43 "src/lisp.vala"
	_tmp1_ = self->list;
#line 43 "src/lisp.vala"
	if (_tmp1_ != NULL) {
#line 384 "lisp.c"
		GeeArrayQueue* _tmp2_;
		GeeQueue* _tmp3_;
		GeeList* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
#line 44 "src/lisp.vala"
		_tmp2_ = gee_array_queue_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 44 "src/lisp.vala"
		_g_object_unref0 (args);
#line 44 "src/lisp.vala"
		args = (GeeQueue*) _tmp2_;
#line 45 "src/lisp.vala"
		_tmp3_ = args;
#line 45 "src/lisp.vala"
		_tmp4_ = self->list;
#line 45 "src/lisp.vala"
		_tmp5_ = gee_traversable_map ((GeeTraversable*) _tmp4_, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, ____lambda22__gee_map_func, self);
#line 45 "src/lisp.vala"
		_tmp6_ = _tmp5_;
#line 45 "src/lisp.vala"
		gee_collection_add_all_iterator ((GeeCollection*) _tmp3_, _tmp6_);
#line 45 "src/lisp.vala"
		_g_object_unref0 (_tmp6_);
#line 408 "lisp.c"
	}
#line 48 "src/lisp.vala"
	_tmp7_ = args;
#line 48 "src/lisp.vala"
	_tmp8_ = gee_queue_poll (_tmp7_);
#line 48 "src/lisp.vala"
	_tmp9_ = (gchar*) _tmp8_;
#line 48 "src/lisp.vala"
	_tmp10_ = lisp_func_find (_tmp9_);
#line 48 "src/lisp.vala"
	_tmp11_ = _tmp10_;
#line 48 "src/lisp.vala"
	_g_free0 (_tmp9_);
#line 48 "src/lisp.vala"
	func = _tmp11_;
#line 49 "src/lisp.vala"
	_tmp12_ = func;
#line 49 "src/lisp.vala"
	if (_tmp12_ != NULL) {
#line 428 "lisp.c"
		LispFunc* _tmp13_;
		GeeQueue* _tmp14_;
#line 50 "src/lisp.vala"
		_tmp13_ = func;
#line 50 "src/lisp.vala"
		_tmp14_ = args;
#line 50 "src/lisp.vala"
		result = call_command (_tmp13_, (glong) 1, _tmp14_);
#line 50 "src/lisp.vala"
		_lisp_func_unref0 (func);
#line 50 "src/lisp.vala"
		_g_object_unref0 (args);
#line 50 "src/lisp.vala"
		return result;
#line 443 "lisp.c"
	}
#line 51 "src/lisp.vala"
	result = FALSE;
#line 51 "src/lisp.vala"
	_lisp_func_unref0 (func);
#line 51 "src/lisp.vala"
	_g_object_unref0 (args);
#line 51 "src/lisp.vala"
	return result;
#line 453 "lisp.c"
}

void
lexp_eval_list (GeeList* list)
{
#line 54 "src/lisp.vala"
	g_return_if_fail (list != NULL);
#line 461 "lisp.c"
	{
		GeeList* _l_list = NULL;
		gint _l_size = 0;
		GeeList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _l_index = 0;
#line 55 "src/lisp.vala"
		_l_list = list;
#line 55 "src/lisp.vala"
		_tmp0_ = _l_list;
#line 55 "src/lisp.vala"
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
#line 55 "src/lisp.vala"
		_tmp2_ = _tmp1_;
#line 55 "src/lisp.vala"
		_l_size = _tmp2_;
#line 55 "src/lisp.vala"
		_l_index = -1;
#line 55 "src/lisp.vala"
		while (TRUE) {
#line 483 "lisp.c"
			gint _tmp3_;
			gint _tmp4_;
			Lexp* l = NULL;
			GeeList* _tmp5_;
			gpointer _tmp6_;
			Lexp* _tmp7_;
#line 55 "src/lisp.vala"
			_l_index = _l_index + 1;
#line 55 "src/lisp.vala"
			_tmp3_ = _l_index;
#line 55 "src/lisp.vala"
			_tmp4_ = _l_size;
#line 55 "src/lisp.vala"
			if (!(_tmp3_ < _tmp4_)) {
#line 55 "src/lisp.vala"
				break;
#line 500 "lisp.c"
			}
#line 55 "src/lisp.vala"
			_tmp5_ = _l_list;
#line 55 "src/lisp.vala"
			_tmp6_ = gee_list_get (_tmp5_, _l_index);
#line 55 "src/lisp.vala"
			l = (Lexp*) _tmp6_;
#line 56 "src/lisp.vala"
			_tmp7_ = l;
#line 56 "src/lisp.vala"
			lexp_eval (_tmp7_);
#line 55 "src/lisp.vala"
			_lexp_unref0 (l);
#line 514 "lisp.c"
		}
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
#line 1283 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1284 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1284 "glib-2.0.vapi"
	result = _tmp0_;
#line 1284 "glib-2.0.vapi"
	return result;
#line 533 "lisp.c"
}

static gchar
lexp_read_char (const gchar* a,
                guint* pos,
                GError** error)
{
	gint _tmp0_;
	gint _tmp1_;
	guint _tmp5_;
	GError* _inner_error0_ = NULL;
	gchar result;
#line 69 "src/lisp.vala"
	g_return_val_if_fail (a != NULL, '\0');
#line 70 "src/lisp.vala"
	_tmp0_ = strlen (a);
#line 70 "src/lisp.vala"
	_tmp1_ = _tmp0_;
#line 70 "src/lisp.vala"
	if ((*pos) >= ((guint) _tmp1_)) {
#line 554 "lisp.c"
		GError* _tmp2_;
#line 71 "src/lisp.vala"
		_tmp2_ = g_error_new_literal (PARSE_ERROR, PARSE_ERROR_EOF, "EOF");
#line 71 "src/lisp.vala"
		_inner_error0_ = _tmp2_;
#line 71 "src/lisp.vala"
		if (_inner_error0_->domain == PARSE_ERROR) {
#line 562 "lisp.c"
			gchar _tmp3_ = '\0';
#line 71 "src/lisp.vala"
			g_propagate_error (error, _inner_error0_);
#line 71 "src/lisp.vala"
			return _tmp3_;
#line 568 "lisp.c"
		} else {
			gchar _tmp4_ = '\0';
#line 71 "src/lisp.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 71 "src/lisp.vala"
			g_clear_error (&_inner_error0_);
#line 71 "src/lisp.vala"
			return _tmp4_;
#line 577 "lisp.c"
		}
	}
#line 72 "src/lisp.vala"
	_tmp5_ = *pos;
#line 72 "src/lisp.vala"
	*pos = _tmp5_ + 1;
#line 72 "src/lisp.vala"
	result = string_get (a, (glong) _tmp5_);
#line 72 "src/lisp.vala"
	return result;
#line 588 "lisp.c"
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1535 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1535 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1535 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1536 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1537 "glib-2.0.vapi"
		start = string_length + start;
#line 615 "lisp.c"
	}
#line 1539 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1540 "glib-2.0.vapi"
		end = string_length + end;
#line 621 "lisp.c"
	}
#line 1542 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 627 "lisp.c"
	} else {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 631 "lisp.c"
	}
#line 1542 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1543 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 639 "lisp.c"
	} else {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 643 "lisp.c"
	}
#line 1543 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1544 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1545 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1545 "glib-2.0.vapi"
	result = _tmp4_;
#line 1545 "glib-2.0.vapi"
	return result;
#line 655 "lisp.c"
}

static LexpTokenType
lexp_read_token (const gchar* a,
                 guint* pos,
                 gchar** tok,
                 GError** error)
{
	gchar* _vala_tok = NULL;
	gchar c = '\0';
	gchar* _tmp6_;
	gboolean doublequotes = FALSE;
	GError* _inner_error0_ = NULL;
	LexpTokenType result;
#line 75 "src/lisp.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 78 "src/lisp.vala"
	c = (gchar) 0;
#line 674 "lisp.c"
	{
		gboolean _tmp0_ = FALSE;
#line 79 "src/lisp.vala"
		_tmp0_ = TRUE;
#line 79 "src/lisp.vala"
		while (TRUE) {
#line 681 "lisp.c"
			gchar _tmp1_ = '\0';
			gchar _tmp2_;
#line 79 "src/lisp.vala"
			if (!_tmp0_) {
#line 87 "src/lisp.vala"
				if (!g_ascii_isspace (c)) {
#line 87 "src/lisp.vala"
					break;
#line 690 "lisp.c"
				}
			}
#line 79 "src/lisp.vala"
			_tmp0_ = FALSE;
#line 80 "src/lisp.vala"
			_tmp2_ = lexp_read_char (a, pos, &_inner_error0_);
#line 80 "src/lisp.vala"
			_tmp1_ = _tmp2_;
#line 80 "src/lisp.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 80 "src/lisp.vala"
				if (_inner_error0_->domain == PARSE_ERROR) {
#line 80 "src/lisp.vala"
					g_propagate_error (error, _inner_error0_);
#line 80 "src/lisp.vala"
					_g_free0 (_vala_tok);
#line 80 "src/lisp.vala"
					return 0;
#line 709 "lisp.c"
				} else {
#line 80 "src/lisp.vala"
					_g_free0 (_vala_tok);
#line 80 "src/lisp.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 80 "src/lisp.vala"
					g_clear_error (&_inner_error0_);
#line 80 "src/lisp.vala"
					return 0;
#line 719 "lisp.c"
				}
			}
#line 80 "src/lisp.vala"
			c = _tmp1_;
#line 83 "src/lisp.vala"
			if (c == ';') {
#line 726 "lisp.c"
				{
					gboolean _tmp3_ = FALSE;
#line 84 "src/lisp.vala"
					_tmp3_ = TRUE;
#line 84 "src/lisp.vala"
					while (TRUE) {
#line 733 "lisp.c"
						gchar _tmp4_ = '\0';
						gchar _tmp5_;
#line 84 "src/lisp.vala"
						if (!_tmp3_) {
#line 86 "src/lisp.vala"
							if (!(c != '\n')) {
#line 86 "src/lisp.vala"
								break;
#line 742 "lisp.c"
							}
						}
#line 84 "src/lisp.vala"
						_tmp3_ = FALSE;
#line 85 "src/lisp.vala"
						_tmp5_ = lexp_read_char (a, pos, &_inner_error0_);
#line 85 "src/lisp.vala"
						_tmp4_ = _tmp5_;
#line 85 "src/lisp.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 85 "src/lisp.vala"
							if (_inner_error0_->domain == PARSE_ERROR) {
#line 85 "src/lisp.vala"
								g_propagate_error (error, _inner_error0_);
#line 85 "src/lisp.vala"
								_g_free0 (_vala_tok);
#line 85 "src/lisp.vala"
								return 0;
#line 761 "lisp.c"
							} else {
#line 85 "src/lisp.vala"
								_g_free0 (_vala_tok);
#line 85 "src/lisp.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 85 "src/lisp.vala"
								g_clear_error (&_inner_error0_);
#line 85 "src/lisp.vala"
								return 0;
#line 771 "lisp.c"
							}
						}
#line 85 "src/lisp.vala"
						c = _tmp4_;
#line 776 "lisp.c"
					}
				}
			}
		}
	}
#line 90 "src/lisp.vala"
	_tmp6_ = g_strdup ("");
#line 90 "src/lisp.vala"
	_g_free0 (_vala_tok);
#line 90 "src/lisp.vala"
	_vala_tok = _tmp6_;
#line 91 "src/lisp.vala"
	if (c == '(') {
#line 92 "src/lisp.vala"
		result = LEXP_TOKEN_TYPE_openparen;
#line 92 "src/lisp.vala"
		if (tok) {
#line 92 "src/lisp.vala"
			*tok = _vala_tok;
#line 796 "lisp.c"
		} else {
#line 92 "src/lisp.vala"
			_g_free0 (_vala_tok);
#line 800 "lisp.c"
		}
#line 92 "src/lisp.vala"
		return result;
#line 804 "lisp.c"
	} else {
#line 93 "src/lisp.vala"
		if (c == ')') {
#line 94 "src/lisp.vala"
			result = LEXP_TOKEN_TYPE_closeparen;
#line 94 "src/lisp.vala"
			if (tok) {
#line 94 "src/lisp.vala"
				*tok = _vala_tok;
#line 814 "lisp.c"
			} else {
#line 94 "src/lisp.vala"
				_g_free0 (_vala_tok);
#line 818 "lisp.c"
			}
#line 94 "src/lisp.vala"
			return result;
#line 822 "lisp.c"
		} else {
#line 95 "src/lisp.vala"
			if (c == '\'') {
#line 96 "src/lisp.vala"
				result = LEXP_TOKEN_TYPE_quote;
#line 96 "src/lisp.vala"
				if (tok) {
#line 96 "src/lisp.vala"
					*tok = _vala_tok;
#line 832 "lisp.c"
				} else {
#line 96 "src/lisp.vala"
					_g_free0 (_vala_tok);
#line 836 "lisp.c"
				}
#line 96 "src/lisp.vala"
				return result;
#line 840 "lisp.c"
			}
		}
	}
#line 99 "src/lisp.vala"
	doublequotes = FALSE;
#line 100 "src/lisp.vala"
	if (c == '\"') {
#line 848 "lisp.c"
		gchar _tmp7_ = '\0';
		gchar _tmp8_;
#line 101 "src/lisp.vala"
		doublequotes = TRUE;
#line 102 "src/lisp.vala"
		_tmp8_ = lexp_read_char (a, pos, &_inner_error0_);
#line 102 "src/lisp.vala"
		_tmp7_ = _tmp8_;
#line 102 "src/lisp.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 102 "src/lisp.vala"
			if (_inner_error0_->domain == PARSE_ERROR) {
#line 102 "src/lisp.vala"
				g_propagate_error (error, _inner_error0_);
#line 102 "src/lisp.vala"
				_g_free0 (_vala_tok);
#line 102 "src/lisp.vala"
				return 0;
#line 867 "lisp.c"
			} else {
#line 102 "src/lisp.vala"
				_g_free0 (_vala_tok);
#line 102 "src/lisp.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 102 "src/lisp.vala"
				g_clear_error (&_inner_error0_);
#line 102 "src/lisp.vala"
				return 0;
#line 877 "lisp.c"
			}
		}
#line 102 "src/lisp.vala"
		c = _tmp7_;
#line 882 "lisp.c"
	}
	{
		gboolean _tmp9_ = FALSE;
#line 105 "src/lisp.vala"
		_tmp9_ = TRUE;
#line 105 "src/lisp.vala"
		while (TRUE) {
#line 890 "lisp.c"
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
#line 105 "src/lisp.vala"
			if (!_tmp9_) {
#line 897 "lisp.c"
				gchar _tmp10_ = '\0';
				gchar _tmp11_;
#line 105 "src/lisp.vala"
				_tmp11_ = lexp_read_char (a, pos, &_inner_error0_);
#line 105 "src/lisp.vala"
				_tmp10_ = _tmp11_;
#line 105 "src/lisp.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 105 "src/lisp.vala"
					if (_inner_error0_->domain == PARSE_ERROR) {
#line 105 "src/lisp.vala"
						g_propagate_error (error, _inner_error0_);
#line 105 "src/lisp.vala"
						_g_free0 (_vala_tok);
#line 105 "src/lisp.vala"
						return 0;
#line 914 "lisp.c"
					} else {
#line 105 "src/lisp.vala"
						_g_free0 (_vala_tok);
#line 105 "src/lisp.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 105 "src/lisp.vala"
						g_clear_error (&_inner_error0_);
#line 105 "src/lisp.vala"
						return 0;
#line 924 "lisp.c"
					}
				}
#line 105 "src/lisp.vala"
				c = _tmp10_;
#line 929 "lisp.c"
			}
#line 105 "src/lisp.vala"
			_tmp9_ = FALSE;
#line 106 "src/lisp.vala"
			_tmp12_ = _vala_tok;
#line 106 "src/lisp.vala"
			_tmp13_ = g_strdup_printf ("%c", (gchar) c);
#line 106 "src/lisp.vala"
			_tmp14_ = _tmp13_;
#line 106 "src/lisp.vala"
			_tmp15_ = g_strconcat (_tmp12_, _tmp14_, NULL);
#line 106 "src/lisp.vala"
			_g_free0 (_vala_tok);
#line 106 "src/lisp.vala"
			_vala_tok = _tmp15_;
#line 106 "src/lisp.vala"
			_g_free0 (_tmp14_);
#line 108 "src/lisp.vala"
			if (!doublequotes) {
#line 949 "lisp.c"
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
				gboolean _tmp18_ = FALSE;
#line 109 "src/lisp.vala"
				if (c == ')') {
#line 109 "src/lisp.vala"
					_tmp18_ = TRUE;
#line 957 "lisp.c"
				} else {
#line 109 "src/lisp.vala"
					_tmp18_ = c == '(';
#line 961 "lisp.c"
				}
#line 109 "src/lisp.vala"
				if (_tmp18_) {
#line 109 "src/lisp.vala"
					_tmp17_ = TRUE;
#line 967 "lisp.c"
				} else {
#line 109 "src/lisp.vala"
					_tmp17_ = c == ';';
#line 971 "lisp.c"
				}
#line 109 "src/lisp.vala"
				if (_tmp17_) {
#line 109 "src/lisp.vala"
					_tmp16_ = TRUE;
#line 977 "lisp.c"
				} else {
#line 109 "src/lisp.vala"
					_tmp16_ = g_ascii_isspace (c);
#line 981 "lisp.c"
				}
#line 109 "src/lisp.vala"
				if (_tmp16_) {
#line 985 "lisp.c"
					guint _tmp19_;
					const gchar* _tmp20_;
					gchar* _tmp21_;
#line 110 "src/lisp.vala"
					_tmp19_ = *pos;
#line 110 "src/lisp.vala"
					*pos = _tmp19_ - 1;
#line 111 "src/lisp.vala"
					_tmp20_ = _vala_tok;
#line 111 "src/lisp.vala"
					_tmp21_ = string_slice (_tmp20_, (glong) 0, (glong) -1);
#line 111 "src/lisp.vala"
					_g_free0 (_vala_tok);
#line 111 "src/lisp.vala"
					_vala_tok = _tmp21_;
#line 112 "src/lisp.vala"
					result = LEXP_TOKEN_TYPE_word;
#line 112 "src/lisp.vala"
					if (tok) {
#line 112 "src/lisp.vala"
						*tok = _vala_tok;
#line 1007 "lisp.c"
					} else {
#line 112 "src/lisp.vala"
						_g_free0 (_vala_tok);
#line 1011 "lisp.c"
					}
#line 112 "src/lisp.vala"
					return result;
#line 1015 "lisp.c"
				}
			} else {
				gboolean _tmp22_ = FALSE;
#line 115 "src/lisp.vala"
				if (c == '\n') {
#line 115 "src/lisp.vala"
					_tmp22_ = TRUE;
#line 1023 "lisp.c"
				} else {
#line 115 "src/lisp.vala"
					_tmp22_ = c == '\r';
#line 1027 "lisp.c"
				}
#line 115 "src/lisp.vala"
				if (_tmp22_) {
#line 1031 "lisp.c"
					GError* _tmp23_;
#line 116 "src/lisp.vala"
					_tmp23_ = g_error_new_literal (PARSE_ERROR, PARSE_ERROR_UNCLOSED_QUOTE, "EOL");
#line 116 "src/lisp.vala"
					_inner_error0_ = _tmp23_;
#line 116 "src/lisp.vala"
					if (_inner_error0_->domain == PARSE_ERROR) {
#line 116 "src/lisp.vala"
						g_propagate_error (error, _inner_error0_);
#line 116 "src/lisp.vala"
						_g_free0 (_vala_tok);
#line 116 "src/lisp.vala"
						return 0;
#line 1045 "lisp.c"
					} else {
#line 116 "src/lisp.vala"
						_g_free0 (_vala_tok);
#line 116 "src/lisp.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 116 "src/lisp.vala"
						g_clear_error (&_inner_error0_);
#line 116 "src/lisp.vala"
						return 0;
#line 1055 "lisp.c"
					}
				}
#line 117 "src/lisp.vala"
				if (c == '\"') {
#line 1060 "lisp.c"
					const gchar* _tmp24_;
					gchar* _tmp25_;
#line 118 "src/lisp.vala"
					_tmp24_ = _vala_tok;
#line 118 "src/lisp.vala"
					_tmp25_ = string_slice (_tmp24_, (glong) 0, (glong) -1);
#line 118 "src/lisp.vala"
					_g_free0 (_vala_tok);
#line 118 "src/lisp.vala"
					_vala_tok = _tmp25_;
#line 119 "src/lisp.vala"
					result = LEXP_TOKEN_TYPE_word;
#line 119 "src/lisp.vala"
					if (tok) {
#line 119 "src/lisp.vala"
						*tok = _vala_tok;
#line 1077 "lisp.c"
					} else {
#line 119 "src/lisp.vala"
						_g_free0 (_vala_tok);
#line 1081 "lisp.c"
					}
#line 119 "src/lisp.vala"
					return result;
#line 1085 "lisp.c"
				}
			}
		}
	}
}

static Lexp*
lexp_read_sexp (const gchar* a,
                guint* pos,
                LexpTokenType* tokenid,
                GError** error)
{
	LexpTokenType _vala_tokenid = 0;
	gchar* tok = NULL;
	LexpTokenType _tmp0_ = 0;
	gchar* _tmp1_ = NULL;
	LexpTokenType _tmp2_;
	Lexp* sexp = NULL;
	Lexp* _tmp3_;
	GError* _inner_error0_ = NULL;
	Lexp* result;
#line 125 "src/lisp.vala"
	g_return_val_if_fail (a != NULL, NULL);
#line 128 "src/lisp.vala"
	_tmp2_ = lexp_read_token (a, pos, &_tmp1_, &_inner_error0_);
#line 128 "src/lisp.vala"
	_g_free0 (tok);
#line 128 "src/lisp.vala"
	tok = _tmp1_;
#line 128 "src/lisp.vala"
	_tmp0_ = _tmp2_;
#line 128 "src/lisp.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 128 "src/lisp.vala"
		if (_inner_error0_->domain == PARSE_ERROR) {
#line 128 "src/lisp.vala"
			g_propagate_error (error, _inner_error0_);
#line 128 "src/lisp.vala"
			_g_free0 (tok);
#line 128 "src/lisp.vala"
			return NULL;
#line 1127 "lisp.c"
		} else {
#line 128 "src/lisp.vala"
			_g_free0 (tok);
#line 128 "src/lisp.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 128 "src/lisp.vala"
			g_clear_error (&_inner_error0_);
#line 128 "src/lisp.vala"
			return NULL;
#line 1137 "lisp.c"
		}
	}
#line 128 "src/lisp.vala"
	_vala_tokenid = _tmp0_;
#line 129 "src/lisp.vala"
	_tmp3_ = lexp_new (NULL);
#line 129 "src/lisp.vala"
	sexp = _tmp3_;
#line 131 "src/lisp.vala"
	if (_vala_tokenid == LEXP_TOKEN_TYPE_quote) {
#line 1148 "lisp.c"
		Lexp* _tmp4_;
		LexpTokenType _tmp5_ = 0;
		gchar* _tmp6_ = NULL;
		LexpTokenType _tmp7_;
#line 132 "src/lisp.vala"
		_tmp4_ = sexp;
#line 132 "src/lisp.vala"
		_tmp4_->quoted = TRUE;
#line 133 "src/lisp.vala"
		_tmp7_ = lexp_read_token (a, pos, &_tmp6_, &_inner_error0_);
#line 133 "src/lisp.vala"
		_g_free0 (tok);
#line 133 "src/lisp.vala"
		tok = _tmp6_;
#line 133 "src/lisp.vala"
		_tmp5_ = _tmp7_;
#line 133 "src/lisp.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 133 "src/lisp.vala"
			if (_inner_error0_->domain == PARSE_ERROR) {
#line 133 "src/lisp.vala"
				g_propagate_error (error, _inner_error0_);
#line 133 "src/lisp.vala"
				_lexp_unref0 (sexp);
#line 133 "src/lisp.vala"
				_g_free0 (tok);
#line 133 "src/lisp.vala"
				return NULL;
#line 1177 "lisp.c"
			} else {
#line 133 "src/lisp.vala"
				_lexp_unref0 (sexp);
#line 133 "src/lisp.vala"
				_g_free0 (tok);
#line 133 "src/lisp.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 133 "src/lisp.vala"
				g_clear_error (&_inner_error0_);
#line 133 "src/lisp.vala"
				return NULL;
#line 1189 "lisp.c"
			}
		}
#line 133 "src/lisp.vala"
		_vala_tokenid = _tmp5_;
#line 1194 "lisp.c"
	}
#line 136 "src/lisp.vala"
	switch (_vala_tokenid) {
#line 136 "src/lisp.vala"
		case LEXP_TOKEN_TYPE_openparen:
#line 1200 "lisp.c"
		{
			Lexp* _tmp8_;
			GeeList* _tmp9_;
#line 138 "src/lisp.vala"
			_tmp8_ = sexp;
#line 138 "src/lisp.vala"
			_tmp9_ = lexp_read_list (a, pos);
#line 138 "src/lisp.vala"
			_g_object_unref0 (_tmp8_->list);
#line 138 "src/lisp.vala"
			_tmp8_->list = _tmp9_;
#line 139 "src/lisp.vala"
			break;
#line 1214 "lisp.c"
		}
#line 136 "src/lisp.vala"
		case LEXP_TOKEN_TYPE_word:
#line 1218 "lisp.c"
		{
			Lexp* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
#line 142 "src/lisp.vala"
			_tmp10_ = sexp;
#line 142 "src/lisp.vala"
			_tmp11_ = tok;
#line 142 "src/lisp.vala"
			_tmp12_ = g_strdup (_tmp11_);
#line 142 "src/lisp.vala"
			_g_free0 (_tmp10_->atom);
#line 142 "src/lisp.vala"
			_tmp10_->atom = _tmp12_;
#line 143 "src/lisp.vala"
			break;
#line 1235 "lisp.c"
		}
#line 136 "src/lisp.vala"
		case LEXP_TOKEN_TYPE_closeparen:
#line 1239 "lisp.c"
		{
#line 146 "src/lisp.vala"
			break;
#line 1243 "lisp.c"
		}
		default:
		{
#line 149 "src/lisp.vala"
			break;
#line 1249 "lisp.c"
		}
	}
#line 152 "src/lisp.vala"
	result = sexp;
#line 152 "src/lisp.vala"
	_g_free0 (tok);
#line 152 "src/lisp.vala"
	if (tokenid) {
#line 152 "src/lisp.vala"
		*tokenid = _vala_tokenid;
#line 1260 "lisp.c"
	}
#line 152 "src/lisp.vala"
	return result;
#line 1264 "lisp.c"
}

GeeList*
lexp_read_list (const gchar* a,
                guint* pos)
{
	GeeList* list = NULL;
	GeeArrayList* _tmp0_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
#line 155 "src/lisp.vala"
	g_return_val_if_fail (a != NULL, NULL);
#line 156 "src/lisp.vala"
	_tmp0_ = gee_array_list_new (TYPE_LEXP, (GBoxedCopyFunc) lexp_ref, (GDestroyNotify) lexp_unref, NULL, NULL, NULL);
#line 156 "src/lisp.vala"
	list = (GeeList*) _tmp0_;
#line 1281 "lisp.c"
	{
#line 158 "src/lisp.vala"
		while (TRUE) {
#line 1285 "lisp.c"
			LexpTokenType tokenid = 0;
			Lexp* sexp = NULL;
			LexpTokenType _tmp1_ = 0;
			Lexp* _tmp2_;
			GeeList* _tmp3_;
			Lexp* _tmp4_;
#line 160 "src/lisp.vala"
			_tmp2_ = lexp_read_sexp (a, pos, &_tmp1_, &_inner_error0_);
#line 160 "src/lisp.vala"
			tokenid = _tmp1_;
#line 160 "src/lisp.vala"
			sexp = _tmp2_;
#line 160 "src/lisp.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 160 "src/lisp.vala"
				if (_inner_error0_->domain == PARSE_ERROR) {
#line 1302 "lisp.c"
					goto __catch0_parse_error;
				}
#line 160 "src/lisp.vala"
				_g_object_unref0 (list);
#line 160 "src/lisp.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 160 "src/lisp.vala"
				g_clear_error (&_inner_error0_);
#line 160 "src/lisp.vala"
				return NULL;
#line 1313 "lisp.c"
			}
#line 161 "src/lisp.vala"
			if (tokenid == LEXP_TOKEN_TYPE_closeparen) {
#line 162 "src/lisp.vala"
				_lexp_unref0 (sexp);
#line 162 "src/lisp.vala"
				break;
#line 1321 "lisp.c"
			}
#line 163 "src/lisp.vala"
			_tmp3_ = list;
#line 163 "src/lisp.vala"
			_tmp4_ = sexp;
#line 163 "src/lisp.vala"
			gee_collection_add ((GeeCollection*) _tmp3_, _tmp4_);
#line 158 "src/lisp.vala"
			_lexp_unref0 (sexp);
#line 1331 "lisp.c"
		}
	}
	goto __finally0;
	__catch0_parse_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
#line 157 "src/lisp.vala"
		e = _inner_error0_;
#line 157 "src/lisp.vala"
		_inner_error0_ = NULL;
#line 166 "src/lisp.vala"
		_tmp5_ = e;
#line 166 "src/lisp.vala"
		if (!g_error_matches (_tmp5_, PARSE_ERROR, PARSE_ERROR_EOF)) {
#line 167 "src/lisp.vala"
			_g_object_unref0 (list);
#line 167 "src/lisp.vala"
			list = NULL;
#line 1351 "lisp.c"
		}
#line 157 "src/lisp.vala"
		_g_error_free0 (e);
#line 1355 "lisp.c"
	}
	__finally0:
#line 157 "src/lisp.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 157 "src/lisp.vala"
		_g_object_unref0 (list);
#line 157 "src/lisp.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 157 "src/lisp.vala"
		g_clear_error (&_inner_error0_);
#line 157 "src/lisp.vala"
		return NULL;
#line 1368 "lisp.c"
	}
#line 169 "src/lisp.vala"
	result = list;
#line 169 "src/lisp.vala"
	return result;
#line 1374 "lisp.c"
}

static void
value_lexp_init (GValue* value)
{
#line 24 "src/lisp.vala"
	value->data[0].v_pointer = NULL;
#line 1382 "lisp.c"
}

static void
value_lexp_free_value (GValue* value)
{
#line 24 "src/lisp.vala"
	if (value->data[0].v_pointer) {
#line 24 "src/lisp.vala"
		lexp_unref (value->data[0].v_pointer);
#line 1392 "lisp.c"
	}
}

static void
value_lexp_copy_value (const GValue* src_value,
                       GValue* dest_value)
{
#line 24 "src/lisp.vala"
	if (src_value->data[0].v_pointer) {
#line 24 "src/lisp.vala"
		dest_value->data[0].v_pointer = lexp_ref (src_value->data[0].v_pointer);
#line 1404 "lisp.c"
	} else {
#line 24 "src/lisp.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1408 "lisp.c"
	}
}

static gpointer
value_lexp_peek_pointer (const GValue* value)
{
#line 24 "src/lisp.vala"
	return value->data[0].v_pointer;
#line 1417 "lisp.c"
}

static gchar*
value_lexp_collect_value (GValue* value,
                          guint n_collect_values,
                          GTypeCValue* collect_values,
                          guint collect_flags)
{
#line 24 "src/lisp.vala"
	if (collect_values[0].v_pointer) {
#line 1428 "lisp.c"
		Lexp * object;
		object = collect_values[0].v_pointer;
#line 24 "src/lisp.vala"
		if (object->parent_instance.g_class == NULL) {
#line 24 "src/lisp.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1435 "lisp.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 24 "src/lisp.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1439 "lisp.c"
		}
#line 24 "src/lisp.vala"
		value->data[0].v_pointer = lexp_ref (object);
#line 1443 "lisp.c"
	} else {
#line 24 "src/lisp.vala"
		value->data[0].v_pointer = NULL;
#line 1447 "lisp.c"
	}
#line 24 "src/lisp.vala"
	return NULL;
#line 1451 "lisp.c"
}

static gchar*
value_lexp_lcopy_value (const GValue* value,
                        guint n_collect_values,
                        GTypeCValue* collect_values,
                        guint collect_flags)
{
	Lexp ** object_p;
	object_p = collect_values[0].v_pointer;
#line 24 "src/lisp.vala"
	if (!object_p) {
#line 24 "src/lisp.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1466 "lisp.c"
	}
#line 24 "src/lisp.vala"
	if (!value->data[0].v_pointer) {
#line 24 "src/lisp.vala"
		*object_p = NULL;
#line 1472 "lisp.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 24 "src/lisp.vala"
		*object_p = value->data[0].v_pointer;
#line 1476 "lisp.c"
	} else {
#line 24 "src/lisp.vala"
		*object_p = lexp_ref (value->data[0].v_pointer);
#line 1480 "lisp.c"
	}
#line 24 "src/lisp.vala"
	return NULL;
#line 1484 "lisp.c"
}

GParamSpec*
param_spec_lexp (const gchar* name,
                 const gchar* nick,
                 const gchar* blurb,
                 GType object_type,
                 GParamFlags flags)
{
	ParamSpecLexp* spec;
#line 24 "src/lisp.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_LEXP), NULL);
#line 24 "src/lisp.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 24 "src/lisp.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 24 "src/lisp.vala"
	return G_PARAM_SPEC (spec);
#line 1503 "lisp.c"
}

gpointer
value_get_lexp (const GValue* value)
{
#line 24 "src/lisp.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LEXP), NULL);
#line 24 "src/lisp.vala"
	return value->data[0].v_pointer;
#line 1513 "lisp.c"
}

void
value_set_lexp (GValue* value,
                gpointer v_object)
{
	Lexp * old;
#line 24 "src/lisp.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LEXP));
#line 24 "src/lisp.vala"
	old = value->data[0].v_pointer;
#line 24 "src/lisp.vala"
	if (v_object) {
#line 24 "src/lisp.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_LEXP));
#line 24 "src/lisp.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 24 "src/lisp.vala"
		value->data[0].v_pointer = v_object;
#line 24 "src/lisp.vala"
		lexp_ref (value->data[0].v_pointer);
#line 1535 "lisp.c"
	} else {
#line 24 "src/lisp.vala"
		value->data[0].v_pointer = NULL;
#line 1539 "lisp.c"
	}
#line 24 "src/lisp.vala"
	if (old) {
#line 24 "src/lisp.vala"
		lexp_unref (old);
#line 1545 "lisp.c"
	}
}

void
value_take_lexp (GValue* value,
                 gpointer v_object)
{
	Lexp * old;
#line 24 "src/lisp.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LEXP));
#line 24 "src/lisp.vala"
	old = value->data[0].v_pointer;
#line 24 "src/lisp.vala"
	if (v_object) {
#line 24 "src/lisp.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_LEXP));
#line 24 "src/lisp.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 24 "src/lisp.vala"
		value->data[0].v_pointer = v_object;
#line 1566 "lisp.c"
	} else {
#line 24 "src/lisp.vala"
		value->data[0].v_pointer = NULL;
#line 1570 "lisp.c"
	}
#line 24 "src/lisp.vala"
	if (old) {
#line 24 "src/lisp.vala"
		lexp_unref (old);
#line 1576 "lisp.c"
	}
}

static void
lexp_class_init (LexpClass * klass,
                 gpointer klass_data)
{
#line 24 "src/lisp.vala"
	lexp_parent_class = g_type_class_peek_parent (klass);
#line 24 "src/lisp.vala"
	((LexpClass *) klass)->finalize = lexp_finalize;
#line 1588 "lisp.c"
}

static void
lexp_instance_init (Lexp * self,
                    gpointer klass)
{
#line 24 "src/lisp.vala"
	self->ref_count = 1;
#line 1597 "lisp.c"
}

static void
lexp_finalize (Lexp * obj)
{
	Lexp * self;
#line 24 "src/lisp.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LEXP, Lexp);
#line 24 "src/lisp.vala"
	g_signal_handlers_destroy (self);
#line 28 "src/lisp.vala"
	_g_free0 (self->atom);
#line 29 "src/lisp.vala"
	_g_object_unref0 (self->list);
#line 1612 "lisp.c"
}

static GType
lexp_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_lexp_init, value_lexp_free_value, value_lexp_copy_value, value_lexp_peek_pointer, "p", value_lexp_collect_value, "p", value_lexp_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (LexpClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lexp_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Lexp), 0, (GInstanceInitFunc) lexp_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType lexp_type_id;
	lexp_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Lexp", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return lexp_type_id;
}

GType
lexp_get_type (void)
{
	static volatile gsize lexp_type_id__once = 0;
	if (g_once_init_enter (&lexp_type_id__once)) {
		GType lexp_type_id;
		lexp_type_id = lexp_get_type_once ();
		g_once_init_leave (&lexp_type_id__once, lexp_type_id);
	}
	return lexp_type_id__once;
}

gpointer
lexp_ref (gpointer instance)
{
	Lexp * self;
	self = instance;
#line 24 "src/lisp.vala"
	g_atomic_int_inc (&self->ref_count);
#line 24 "src/lisp.vala"
	return instance;
#line 1647 "lisp.c"
}

void
lexp_unref (gpointer instance)
{
	Lexp * self;
	self = instance;
#line 24 "src/lisp.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 24 "src/lisp.vala"
		LEXP_GET_CLASS (self)->finalize (self);
#line 24 "src/lisp.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1661 "lisp.c"
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 184 "src/lisp.vala"
	return self ? g_object_ref (self) : NULL;
#line 1670 "lisp.c"
}

gboolean
funcall (const gchar* name,
         glong* maybe_uniarg,
         GeeQueue* args)
{
	glong uniarg = 0L;
	GeeQueue* args_ = NULL;
	GeeQueue* _tmp0_;
	LispFunc* _tmp2_;
	LispFunc* _tmp3_;
	Function _tmp4_;
	GeeQueue* _tmp5_;
	gboolean _tmp6_;
	gboolean result;
#line 179 "src/lisp.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 184 "src/lisp.vala"
	_tmp0_ = _g_object_ref0 (args);
#line 184 "src/lisp.vala"
	args_ = _tmp0_;
#line 185 "src/lisp.vala"
	if (maybe_uniarg == NULL) {
#line 1695 "lisp.c"
		GeeArrayQueue* _tmp1_;
#line 186 "src/lisp.vala"
		uniarg = (glong) 1;
#line 187 "src/lisp.vala"
		_tmp1_ = gee_array_queue_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 187 "src/lisp.vala"
		_g_object_unref0 (args_);
#line 187 "src/lisp.vala"
		args_ = (GeeQueue*) _tmp1_;
#line 1705 "lisp.c"
	} else {
#line 189 "src/lisp.vala"
		uniarg = *maybe_uniarg;
#line 1709 "lisp.c"
	}
#line 190 "src/lisp.vala"
	_tmp2_ = lisp_func_find (name);
#line 190 "src/lisp.vala"
	_tmp3_ = _tmp2_;
#line 190 "src/lisp.vala"
	_tmp4_ = _tmp3_->func;
#line 190 "src/lisp.vala"
	_tmp5_ = args_;
#line 190 "src/lisp.vala"
	_tmp6_ = _tmp4_ (uniarg, _tmp5_);
#line 190 "src/lisp.vala"
	_lisp_func_unref0 (_tmp3_);
#line 190 "src/lisp.vala"
	result = _tmp6_;
#line 190 "src/lisp.vala"
	_g_object_unref0 (args_);
#line 190 "src/lisp.vala"
	return result;
#line 1729 "lisp.c"
}

gboolean
noarg (GeeQueue* args)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
#line 194 "src/lisp.vala"
	if (!((lastflag & FLAGS_SET_UNIARG) == FLAGS_SET_UNIARG)) {
#line 1739 "lisp.c"
		gboolean _tmp1_ = FALSE;
#line 194 "src/lisp.vala"
		if (args != NULL) {
#line 1743 "lisp.c"
			gint _tmp2_;
			gint _tmp3_;
#line 194 "src/lisp.vala"
			_tmp2_ = gee_collection_get_size ((GeeCollection*) args);
#line 194 "src/lisp.vala"
			_tmp3_ = _tmp2_;
#line 194 "src/lisp.vala"
			_tmp1_ = _tmp3_ == 0;
#line 1752 "lisp.c"
		} else {
#line 194 "src/lisp.vala"
			_tmp1_ = FALSE;
#line 1756 "lisp.c"
		}
#line 194 "src/lisp.vala"
		_tmp0_ = _tmp1_;
#line 1760 "lisp.c"
	} else {
#line 194 "src/lisp.vala"
		_tmp0_ = FALSE;
#line 1764 "lisp.c"
	}
#line 194 "src/lisp.vala"
	result = _tmp0_;
#line 194 "src/lisp.vala"
	return result;
#line 1770 "lisp.c"
}

gboolean
bool_arg (GeeQueue* args,
          gboolean* val)
{
	gboolean _vala_val = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean result;
#line 198 "src/lisp.vala"
	_vala_val = FALSE;
#line 199 "src/lisp.vala"
	if (args != NULL) {
#line 1784 "lisp.c"
		gint _tmp1_;
		gint _tmp2_;
#line 199 "src/lisp.vala"
		_tmp1_ = gee_collection_get_size ((GeeCollection*) args);
#line 199 "src/lisp.vala"
		_tmp2_ = _tmp1_;
#line 199 "src/lisp.vala"
		_tmp0_ = _tmp2_ > 0;
#line 1793 "lisp.c"
	} else {
#line 199 "src/lisp.vala"
		_tmp0_ = FALSE;
#line 1797 "lisp.c"
	}
#line 199 "src/lisp.vala"
	if (_tmp0_) {
#line 1801 "lisp.c"
		gchar* s = NULL;
		gpointer _tmp3_;
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
#line 200 "src/lisp.vala"
		_tmp3_ = gee_queue_poll (args);
#line 200 "src/lisp.vala"
		s = (gchar*) _tmp3_;
#line 201 "src/lisp.vala"
		_tmp5_ = s;
#line 201 "src/lisp.vala"
		if (_tmp5_ != NULL) {
#line 1814 "lisp.c"
			const gchar* _tmp6_;
#line 201 "src/lisp.vala"
			_tmp6_ = s;
#line 201 "src/lisp.vala"
			_tmp4_ = g_strcmp0 (_tmp6_, "nil") == 0;
#line 1820 "lisp.c"
		} else {
#line 201 "src/lisp.vala"
			_tmp4_ = FALSE;
#line 1824 "lisp.c"
		}
#line 201 "src/lisp.vala"
		_vala_val = !_tmp4_;
#line 202 "src/lisp.vala"
		result = TRUE;
#line 202 "src/lisp.vala"
		_g_free0 (s);
#line 202 "src/lisp.vala"
		if (val) {
#line 202 "src/lisp.vala"
			*val = _vala_val;
#line 1836 "lisp.c"
		}
#line 202 "src/lisp.vala"
		return result;
#line 1840 "lisp.c"
	}
#line 204 "src/lisp.vala"
	result = FALSE;
#line 204 "src/lisp.vala"
	if (val) {
#line 204 "src/lisp.vala"
		*val = _vala_val;
#line 1848 "lisp.c"
	}
#line 204 "src/lisp.vala"
	return result;
#line 1852 "lisp.c"
}

static gboolean
long_try_parse (const gchar* str,
                glong* _result_,
                const gchar** unparsed,
                guint _base)
{
	glong _vala__result_ = 0L;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
#line 319 "glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, FALSE);
#line 321 "glib-2.0.vapi"
	errno = 0;
#line 322 "glib-2.0.vapi"
	_tmp1_ = strtol (str, &_tmp0_, (gint) _base);
#line 322 "glib-2.0.vapi"
	endptr = _tmp0_;
#line 322 "glib-2.0.vapi"
	_vala__result_ = _tmp1_;
#line 323 "glib-2.0.vapi"
	_tmp2_ = endptr;
#line 323 "glib-2.0.vapi"
	_tmp3_ = strlen (str);
#line 323 "glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 323 "glib-2.0.vapi"
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
#line 1888 "lisp.c"
		gboolean _tmp5_ = FALSE;
#line 324 "glib-2.0.vapi"
		_vala_unparsed = "";
#line 325 "glib-2.0.vapi"
		if (errno != ERANGE) {
#line 325 "glib-2.0.vapi"
			_tmp5_ = errno != EINVAL;
#line 1896 "lisp.c"
		} else {
#line 325 "glib-2.0.vapi"
			_tmp5_ = FALSE;
#line 1900 "lisp.c"
		}
#line 325 "glib-2.0.vapi"
		result = _tmp5_;
#line 325 "glib-2.0.vapi"
		if (_result_) {
#line 325 "glib-2.0.vapi"
			*_result_ = _vala__result_;
#line 1908 "lisp.c"
		}
#line 325 "glib-2.0.vapi"
		if (unparsed) {
#line 325 "glib-2.0.vapi"
			*unparsed = _vala_unparsed;
#line 1914 "lisp.c"
		}
#line 325 "glib-2.0.vapi"
		return result;
#line 1918 "lisp.c"
	} else {
		gchar* _tmp6_;
#line 327 "glib-2.0.vapi"
		_tmp6_ = endptr;
#line 327 "glib-2.0.vapi"
		_vala_unparsed = (const gchar*) _tmp6_;
#line 328 "glib-2.0.vapi"
		result = FALSE;
#line 328 "glib-2.0.vapi"
		if (_result_) {
#line 328 "glib-2.0.vapi"
			*_result_ = _vala__result_;
#line 1931 "lisp.c"
		}
#line 328 "glib-2.0.vapi"
		if (unparsed) {
#line 328 "glib-2.0.vapi"
			*unparsed = _vala_unparsed;
#line 1937 "lisp.c"
		}
#line 328 "glib-2.0.vapi"
		return result;
#line 1941 "lisp.c"
	}
}

static glong*
_long_dup (glong* self)
{
	glong* dup;
#line 212 "src/lisp.vala"
	dup = g_new0 (glong, 1);
#line 212 "src/lisp.vala"
	memcpy (dup, self, sizeof (glong));
#line 212 "src/lisp.vala"
	return dup;
#line 1955 "lisp.c"
}

static gpointer
__long_dup0 (gpointer self)
{
#line 212 "src/lisp.vala"
	return self ? _long_dup (self) : NULL;
#line 1963 "lisp.c"
}

glong*
parse_number (const gchar* s)
{
	glong res = 0L;
	glong _tmp0_ = 0L;
	gboolean _tmp1_;
	glong* result;
#line 208 "src/lisp.vala"
	if (s == NULL) {
#line 209 "src/lisp.vala"
		result = NULL;
#line 209 "src/lisp.vala"
		return result;
#line 1979 "lisp.c"
	}
#line 211 "src/lisp.vala"
	_tmp1_ = long_try_parse (s, &_tmp0_, NULL, (guint) 10);
#line 211 "src/lisp.vala"
	res = _tmp0_;
#line 211 "src/lisp.vala"
	if (_tmp1_) {
#line 1987 "lisp.c"
		glong* _tmp2_;
#line 212 "src/lisp.vala"
		_tmp2_ = __long_dup0 (&res);
#line 212 "src/lisp.vala"
		result = _tmp2_;
#line 212 "src/lisp.vala"
		return result;
#line 1995 "lisp.c"
	}
#line 213 "src/lisp.vala"
	result = NULL;
#line 213 "src/lisp.vala"
	return result;
#line 2001 "lisp.c"
}

gboolean
int_arg (GeeQueue* args,
         glong* n)
{
	glong _vala_n = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* s = NULL;
	gpointer _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	glong _tmp6_ = 0L;
	gboolean _tmp7_;
	gboolean result;
#line 217 "src/lisp.vala"
	_vala_n = (glong) 0;
#line 218 "src/lisp.vala"
	if (args == NULL) {
#line 218 "src/lisp.vala"
		_tmp0_ = TRUE;
#line 2023 "lisp.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 218 "src/lisp.vala"
		_tmp1_ = gee_collection_get_size ((GeeCollection*) args);
#line 218 "src/lisp.vala"
		_tmp2_ = _tmp1_;
#line 218 "src/lisp.vala"
		_tmp0_ = _tmp2_ == 0;
#line 2033 "lisp.c"
	}
#line 218 "src/lisp.vala"
	if (_tmp0_) {
#line 219 "src/lisp.vala"
		result = FALSE;
#line 219 "src/lisp.vala"
		if (n) {
#line 219 "src/lisp.vala"
			*n = _vala_n;
#line 2043 "lisp.c"
		}
#line 219 "src/lisp.vala"
		return result;
#line 2047 "lisp.c"
	}
#line 220 "src/lisp.vala"
	_tmp3_ = gee_queue_poll (args);
#line 220 "src/lisp.vala"
	s = (gchar*) _tmp3_;
#line 221 "src/lisp.vala"
	_tmp4_ = s;
#line 221 "src/lisp.vala"
	if (_tmp4_ == NULL) {
#line 222 "src/lisp.vala"
		result = FALSE;
#line 222 "src/lisp.vala"
		_g_free0 (s);
#line 222 "src/lisp.vala"
		if (n) {
#line 222 "src/lisp.vala"
			*n = _vala_n;
#line 2065 "lisp.c"
		}
#line 222 "src/lisp.vala"
		return result;
#line 2069 "lisp.c"
	}
#line 223 "src/lisp.vala"
	_tmp5_ = s;
#line 223 "src/lisp.vala"
	_tmp7_ = long_try_parse (_tmp5_, &_tmp6_, NULL, (guint) 10);
#line 223 "src/lisp.vala"
	_vala_n = _tmp6_;
#line 223 "src/lisp.vala"
	result = _tmp7_;
#line 223 "src/lisp.vala"
	_g_free0 (s);
#line 223 "src/lisp.vala"
	if (n) {
#line 223 "src/lisp.vala"
		*n = _vala_n;
#line 2085 "lisp.c"
	}
#line 223 "src/lisp.vala"
	return result;
#line 2089 "lisp.c"
}

gboolean
int_or_uniarg (GeeQueue* args,
               glong* n,
               glong uniarg)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
#line 227 "src/lisp.vala"
	if (args != NULL) {
#line 2101 "lisp.c"
		gint _tmp1_;
		gint _tmp2_;
#line 227 "src/lisp.vala"
		_tmp1_ = gee_collection_get_size ((GeeCollection*) args);
#line 227 "src/lisp.vala"
		_tmp2_ = _tmp1_;
#line 227 "src/lisp.vala"
		_tmp0_ = _tmp2_ > 0;
#line 2110 "lisp.c"
	} else {
#line 227 "src/lisp.vala"
		_tmp0_ = FALSE;
#line 2114 "lisp.c"
	}
#line 227 "src/lisp.vala"
	if (_tmp0_) {
#line 2118 "lisp.c"
		glong* num = NULL;
		gpointer _tmp3_;
		gchar* _tmp4_;
		glong* _tmp5_;
		glong* _tmp6_;
		glong* _tmp7_;
		glong* _tmp9_;
#line 228 "src/lisp.vala"
		_tmp3_ = gee_queue_poll (args);
#line 228 "src/lisp.vala"
		_tmp4_ = (gchar*) _tmp3_;
#line 228 "src/lisp.vala"
		_tmp5_ = parse_number (_tmp4_);
#line 228 "src/lisp.vala"
		_tmp6_ = _tmp5_;
#line 228 "src/lisp.vala"
		_g_free0 (_tmp4_);
#line 228 "src/lisp.vala"
		num = _tmp6_;
#line 229 "src/lisp.vala"
		_tmp7_ = num;
#line 229 "src/lisp.vala"
		if (_tmp7_ != NULL) {
#line 2142 "lisp.c"
			glong* _tmp8_;
#line 230 "src/lisp.vala"
			_tmp8_ = num;
#line 230 "src/lisp.vala"
			*n = *_tmp8_;
#line 2148 "lisp.c"
		}
#line 231 "src/lisp.vala"
		_tmp9_ = num;
#line 231 "src/lisp.vala"
		result = _tmp9_ != NULL;
#line 231 "src/lisp.vala"
		_g_free0 (num);
#line 231 "src/lisp.vala"
		return result;
#line 2158 "lisp.c"
	}
#line 233 "src/lisp.vala"
	*n = uniarg;
#line 234 "src/lisp.vala"
	result = TRUE;
#line 234 "src/lisp.vala"
	return result;
#line 2166 "lisp.c"
}

void
lisp_loadstring (const gchar* a)
{
	guint pos = 0U;
	GeeList* list = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
#line 240 "src/lisp.vala"
	g_return_if_fail (a != NULL);
#line 241 "src/lisp.vala"
	pos = (guint) 0;
#line 242 "src/lisp.vala"
	_tmp0_ = lexp_read_list (a, &pos);
#line 242 "src/lisp.vala"
	list = _tmp0_;
#line 243 "src/lisp.vala"
	_tmp1_ = list;
#line 243 "src/lisp.vala"
	if (_tmp1_ != NULL) {
#line 2188 "lisp.c"
		GeeList* _tmp2_;
#line 244 "src/lisp.vala"
		_tmp2_ = list;
#line 244 "src/lisp.vala"
		lexp_eval_list (_tmp2_);
#line 2194 "lisp.c"
	}
#line 240 "src/lisp.vala"
	_g_object_unref0 (list);
#line 2198 "lisp.c"
}

gboolean
lisp_loadfile (const gchar* file)
{
	gchar* s = NULL;
	const gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	gboolean result;
#line 247 "src/lisp.vala"
	g_return_val_if_fail (file != NULL, FALSE);
#line 2210 "lisp.c"
	{
		gchar* _tmp0_ = NULL;
#line 250 "src/lisp.vala"
		g_file_get_contents (file, &_tmp0_, NULL, &_inner_error0_);
#line 250 "src/lisp.vala"
		_g_free0 (s);
#line 250 "src/lisp.vala"
		s = _tmp0_;
#line 250 "src/lisp.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2221 "lisp.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 249 "src/lisp.vala"
		g_clear_error (&_inner_error0_);
#line 252 "src/lisp.vala"
		result = FALSE;
#line 252 "src/lisp.vala"
		_g_free0 (s);
#line 252 "src/lisp.vala"
		return result;
#line 2236 "lisp.c"
	}
	__finally0:
#line 249 "src/lisp.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2241 "lisp.c"
		gboolean _tmp1_ = FALSE;
#line 249 "src/lisp.vala"
		_g_free0 (s);
#line 249 "src/lisp.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 249 "src/lisp.vala"
		g_clear_error (&_inner_error0_);
#line 249 "src/lisp.vala"
		return _tmp1_;
#line 2251 "lisp.c"
	}
#line 254 "src/lisp.vala"
	_tmp2_ = s;
#line 254 "src/lisp.vala"
	lisp_loadstring (_tmp2_);
#line 255 "src/lisp.vala"
	result = TRUE;
#line 255 "src/lisp.vala"
	_g_free0 (s);
#line 255 "src/lisp.vala"
	return result;
#line 2263 "lisp.c"
}

static gboolean
__lambda113_ (glong uniarg,
              GeeQueue* args)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
#line 263 "src/lisp.vala"
	if (args != NULL) {
#line 2275 "lisp.c"
		gboolean _tmp2_;
		gboolean _tmp3_;
#line 263 "src/lisp.vala"
		_tmp2_ = gee_collection_get_is_empty ((GeeCollection*) args);
#line 263 "src/lisp.vala"
		_tmp3_ = _tmp2_;
#line 263 "src/lisp.vala"
		_tmp1_ = !_tmp3_;
#line 2284 "lisp.c"
	} else {
#line 263 "src/lisp.vala"
		_tmp1_ = FALSE;
#line 2288 "lisp.c"
	}
#line 263 "src/lisp.vala"
	if (_tmp1_) {
#line 2292 "lisp.c"
		gpointer _tmp4_;
		gchar* _tmp5_;
#line 263 "src/lisp.vala"
		_tmp4_ = gee_queue_poll (args);
#line 263 "src/lisp.vala"
		_tmp5_ = (gchar*) _tmp4_;
#line 263 "src/lisp.vala"
		_tmp0_ = lisp_loadfile (_tmp5_);
#line 263 "src/lisp.vala"
		_g_free0 (_tmp5_);
#line 2303 "lisp.c"
	} else {
#line 263 "src/lisp.vala"
		_tmp0_ = FALSE;
#line 2307 "lisp.c"
	}
#line 263 "src/lisp.vala"
	result = _tmp0_;
#line 263 "src/lisp.vala"
	return result;
#line 2313 "lisp.c"
}

static gboolean
___lambda113__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda113_ (uniarg, args);
#line 260 "src/lisp.vala"
	return result;
#line 2324 "lisp.c"
}

void
lisp_init (void)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
#line 260 "src/lisp.vala"
	_tmp0_ = lisp_func_new ("load", ___lambda113__function, TRUE, "Execute a file of Lisp code named FILE.");
#line 260 "src/lisp.vala"
	_tmp1_ = _tmp0_;
#line 260 "src/lisp.vala"
	_lisp_func_unref0 (_tmp1_);
#line 2338 "lisp.c"
}

