# Building the Connector/ODBC

Following are build instructions for various operating systems. Paths and filenames are given for example, and may be different on your
system of for your purposes.

## Windows

Prior to start building on Windows you need to have following tools installed:
- Microsoft Visual Studio https://visualstudio.microsoft.com/downloads/
- Git https://git-scm.com/download/win
- cmake https://cmake.org/download/
If you need msi package to be generated by the build process, you also need:
- WiX Toolset https://wixtoolset.org/releases/
and provide WIX_DIR parameter for cmake with path to WiX binaries, or set WIX env variable with path to WiX installation directory.

If you need 32bit(or 64bit) build, you may need to give cmake -A Win32 parameter(or -A Win64), or specify correct cmake generator name using option -G

```
git clone https://github.com/MariaDB/mariadb-connector-odbc.git
cd mariadb-connector-odbc
cmake -DCMAKE_BUILD_TYPE=RelWithDebInfo -DCONC_WITH_UNIT_TESTS=Off -DCONC_WITH_MSI=OFF -DWITH_SSL=SCHANNEL -DWIX_DIR="C:\Program Files (x86)\WiX Toolset v3.11\bin\" .
cmake --build . --config RelWithDebInfo
msiexec.exe /i wininstall\mariadb-connector-odbc-3.0.6-win32.msi
```

## CentOS

```
sudo yum -y install git cmake make gcc openssl-devel unixODBC unixODBC-devel
git clone https://github.com/MariaDB/mariadb-connector-odbc.git
mkdir build && cd build
cmake ../mariadb-connector-odbc/ -DCMAKE_BUILD_TYPE=RelWithDebInfo -DCONC_WITH_UNIT_TESTS=Off -DCMAKE_INSTALL_PREFIX=/usr/local -DWITH_SSL=OPENSSL
cmake --build . --config RelWithDebInfo
sudo make install
```

## Debian & Ubuntu

```
sudo apt-get update
sudo sh apt-get install -y git cmake make gcc libssl-dev unixodbc-dev
git clone https://github.com/MariaDB/mariadb-connector-odbc.git
mkdir build && cd build
cmake ../mariadb-connector-odbc/ -DCMAKE_BUILD_TYPE=RelWithDebInfo -DCONC_WITH_UNIT_TESTS=Off -DCMAKE_INSTALL_PREFIX=/usr/local -DWITH_SSL=OPENSSL
cmake --build . --config RelWithDebInfo
sudo make install
```
