/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.core.io;

import com.mysql.cj.api.conf.PropertySet;
import com.mysql.cj.api.exceptions.ExceptionInterceptor;
import com.mysql.cj.api.io.SocketConnection;
import com.mysql.cj.api.io.SocketFactory;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.exceptions.CJException;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.exceptions.UnableToConnectException;
import com.mysql.cj.core.io.ExportControlled;
import com.mysql.cj.core.io.FullReadInputStream;
import com.mysql.cj.core.io.NetworkResources;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.net.Socket;

public abstract class AbstractSocketConnection
implements SocketConnection {
    protected String host = null;
    protected int port = 3306;
    protected SocketFactory socketFactory = null;
    protected Socket mysqlSocket = null;
    protected FullReadInputStream mysqlInput = null;
    protected BufferedOutputStream mysqlOutput = null;
    protected ExceptionInterceptor exceptionInterceptor;
    protected PropertySet propertySet;

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public Socket getMysqlSocket() {
        return this.mysqlSocket;
    }

    @Override
    public void setMysqlSocket(Socket mysqlSocket) {
        this.mysqlSocket = mysqlSocket;
    }

    @Override
    public FullReadInputStream getMysqlInput() {
        return this.mysqlInput;
    }

    @Override
    public void setMysqlInput(InputStream mysqlInput) {
        this.mysqlInput = new FullReadInputStream(mysqlInput);
    }

    @Override
    public BufferedOutputStream getMysqlOutput() {
        return this.mysqlOutput;
    }

    @Override
    public void setMysqlOutput(BufferedOutputStream mysqlOutput) {
        this.mysqlOutput = mysqlOutput;
    }

    @Override
    public boolean isSSLEstablished() {
        return ExportControlled.enabled() && ExportControlled.isSSLEstablished(this.getMysqlSocket());
    }

    @Override
    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    @Override
    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    @Override
    public final void forceClose() {
        try {
            this.getNetworkResources().forceClose();
        }
        finally {
            this.mysqlSocket = null;
            this.mysqlInput = null;
            this.mysqlOutput = null;
        }
    }

    @Override
    public NetworkResources getNetworkResources() {
        return new NetworkResources(this.mysqlSocket, this.mysqlInput, this.mysqlOutput);
    }

    @Override
    public ExceptionInterceptor getExceptionInterceptor() {
        return this.exceptionInterceptor;
    }

    @Override
    public PropertySet getPropertySet() {
        return this.propertySet;
    }

    protected SocketFactory createSocketFactory(String socketFactoryClassName) {
        try {
            if (socketFactoryClassName == null) {
                throw ExceptionFactory.createException(UnableToConnectException.class, Messages.getString("SocketConnection.0"), this.getExceptionInterceptor());
            }
            return (SocketFactory)Class.forName(socketFactoryClassName).newInstance();
        }
        catch (CJException | ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw ExceptionFactory.createException(UnableToConnectException.class, Messages.getString("SocketConnection.1", new String[]{socketFactoryClassName}), this.getExceptionInterceptor());
        }
    }
}

