/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqla.authentication;

import com.mysql.cj.api.MysqlConnection;
import com.mysql.cj.api.authentication.AuthenticationPlugin;
import com.mysql.cj.api.io.PacketBuffer;
import com.mysql.cj.api.io.Protocol;
import com.mysql.cj.api.jdbc.JdbcConnection;
import com.mysql.cj.api.log.Log;
import com.mysql.cj.core.authentication.Security;
import com.mysql.cj.mysqla.io.Buffer;
import java.util.List;
import java.util.Properties;

public class MysqlNativePasswordPlugin
implements AuthenticationPlugin {
    private Protocol protocol;
    private String password = null;

    @Override
    public void init(MysqlConnection conn, Properties props, Log log) {
        this.init(conn, ((JdbcConnection)conn).getSession().getProtocol(), props);
    }

    @Override
    public void init(MysqlConnection conn, Protocol prot, Properties props) {
        this.protocol = prot;
    }

    @Override
    public void destroy() {
        this.password = null;
    }

    @Override
    public String getProtocolPluginName() {
        return "mysql_native_password";
    }

    @Override
    public boolean requiresConfidentiality() {
        return false;
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    @Override
    public void setAuthenticationParameters(String user, String password) {
        this.password = password;
    }

    @Override
    public boolean nextAuthenticationStep(PacketBuffer fromServer, List<PacketBuffer> toServer) {
        toServer.clear();
        Buffer bresp = null;
        String pwd = this.password;
        bresp = fromServer == null || pwd == null || pwd.length() == 0 ? new Buffer(new byte[0]) : new Buffer(Security.scramble411(pwd, fromServer.readString(), this.protocol.getPasswordCharacterEncoding()));
        toServer.add(bresp);
        return true;
    }
}

