/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.AggregateIterableImpl;
import com.mongodb.DistinctIterableImpl;
import com.mongodb.FindIterableImpl;
import com.mongodb.ListIndexesIterableImpl;
import com.mongodb.MapReduceIterableImpl;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.MongoWriteException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.WriteError;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.DeleteRequest;
import com.mongodb.bulk.IndexRequest;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.bulk.UpdateRequest;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MapReduceIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.FindOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.operation.CountOperation;
import com.mongodb.operation.CreateIndexesOperation;
import com.mongodb.operation.DropCollectionOperation;
import com.mongodb.operation.DropIndexOperation;
import com.mongodb.operation.FindAndDeleteOperation;
import com.mongodb.operation.FindAndReplaceOperation;
import com.mongodb.operation.FindAndUpdateOperation;
import com.mongodb.operation.MixedBulkWriteOperation;
import com.mongodb.operation.OperationExecutor;
import com.mongodb.operation.RenameCollectionOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class MongoCollectionImpl<TDocument>
implements MongoCollection<TDocument> {
    private final MongoNamespace namespace;
    private final Class<TDocument> documentClass;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final WriteConcern writeConcern;
    private final ReadConcern readConcern;
    private final OperationExecutor executor;

    MongoCollectionImpl(MongoNamespace namespace, Class<TDocument> documentClass, CodecRegistry codecRegistry, ReadPreference readPreference, WriteConcern writeConcern, ReadConcern readConcern, OperationExecutor executor) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.documentClass = Assertions.notNull("documentClass", documentClass);
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        this.executor = Assertions.notNull("executor", executor);
    }

    @Override
    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public Class<TDocument> getDocumentClass() {
        return this.documentClass;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    @Override
    public <NewTDocument> MongoCollection<NewTDocument> withDocumentClass(Class<NewTDocument> clazz) {
        return new MongoCollectionImpl<NewTDocument>(this.namespace, clazz, this.codecRegistry, this.readPreference, this.writeConcern, this.readConcern, this.executor);
    }

    @Override
    public MongoCollection<TDocument> withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoCollectionImpl<TDocument>(this.namespace, this.documentClass, codecRegistry, this.readPreference, this.writeConcern, this.readConcern, this.executor);
    }

    @Override
    public MongoCollection<TDocument> withReadPreference(ReadPreference readPreference) {
        return new MongoCollectionImpl<TDocument>(this.namespace, this.documentClass, this.codecRegistry, readPreference, this.writeConcern, this.readConcern, this.executor);
    }

    @Override
    public MongoCollection<TDocument> withWriteConcern(WriteConcern writeConcern) {
        return new MongoCollectionImpl<TDocument>(this.namespace, this.documentClass, this.codecRegistry, this.readPreference, writeConcern, this.readConcern, this.executor);
    }

    @Override
    public MongoCollection<TDocument> withReadConcern(ReadConcern readConcern) {
        return new MongoCollectionImpl<TDocument>(this.namespace, this.documentClass, this.codecRegistry, this.readPreference, this.writeConcern, readConcern, this.executor);
    }

    @Override
    public long count() {
        return this.count(new BsonDocument(), new CountOptions());
    }

    @Override
    public long count(Bson filter) {
        return this.count(filter, new CountOptions());
    }

    @Override
    public long count(Bson filter, CountOptions options) {
        CountOperation operation = new CountOperation(this.namespace).filter(this.toBsonDocument(filter)).skip(options.getSkip()).limit(options.getLimit()).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).collation(options.getCollation());
        if (options.getHint() != null) {
            operation.hint(this.toBsonDocument(options.getHint()));
        } else if (options.getHintString() != null) {
            operation.hint(new BsonString(options.getHintString()));
        }
        return this.executor.execute(operation, this.readPreference);
    }

    @Override
    public <TResult> DistinctIterable<TResult> distinct(String fieldName, Class<TResult> resultClass) {
        return this.distinct(fieldName, new BsonDocument(), resultClass);
    }

    @Override
    public <TResult> DistinctIterable<TResult> distinct(String fieldName, Bson filter, Class<TResult> resultClass) {
        return new DistinctIterableImpl<TDocument, TResult>(this.namespace, this.documentClass, resultClass, this.codecRegistry, this.readPreference, this.readConcern, this.executor, fieldName, filter);
    }

    @Override
    public FindIterable<TDocument> find() {
        return this.find(new BsonDocument(), this.documentClass);
    }

    @Override
    public <TResult> FindIterable<TResult> find(Class<TResult> resultClass) {
        return this.find(new BsonDocument(), resultClass);
    }

    @Override
    public FindIterable<TDocument> find(Bson filter) {
        return this.find(filter, this.documentClass);
    }

    @Override
    public <TResult> FindIterable<TResult> find(Bson filter, Class<TResult> resultClass) {
        return new FindIterableImpl<TDocument, TResult>(this.namespace, this.documentClass, resultClass, this.codecRegistry, this.readPreference, this.readConcern, this.executor, filter, new FindOptions());
    }

    @Override
    public AggregateIterable<TDocument> aggregate(List<? extends Bson> pipeline) {
        return this.aggregate(pipeline, this.documentClass);
    }

    @Override
    public <TResult> AggregateIterable<TResult> aggregate(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new AggregateIterableImpl<TDocument, TResult>(this.namespace, this.documentClass, resultClass, this.codecRegistry, this.readPreference, this.readConcern, this.writeConcern, this.executor, pipeline);
    }

    @Override
    public MapReduceIterable<TDocument> mapReduce(String mapFunction, String reduceFunction) {
        return this.mapReduce(mapFunction, reduceFunction, this.documentClass);
    }

    @Override
    public <TResult> MapReduceIterable<TResult> mapReduce(String mapFunction, String reduceFunction, Class<TResult> resultClass) {
        return new MapReduceIterableImpl<TDocument, TResult>(this.namespace, this.documentClass, resultClass, this.codecRegistry, this.readPreference, this.readConcern, this.writeConcern, this.executor, mapFunction, reduceFunction);
    }

    @Override
    public BulkWriteResult bulkWrite(List<? extends WriteModel<? extends TDocument>> requests) {
        return this.bulkWrite(requests, new BulkWriteOptions());
    }

    @Override
    public BulkWriteResult bulkWrite(List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options) {
        Assertions.notNull("requests", requests);
        ArrayList<InsertRequest> writeRequests = new ArrayList<InsertRequest>(requests.size());
        for (WriteModel<TDocument> writeModel : requests) {
            WriteRequest writeRequest;
            if (writeModel == null) {
                throw new IllegalArgumentException("requests can not contain a null value");
            }
            if (writeModel instanceof InsertOneModel) {
                Object document = ((InsertOneModel)writeModel).getDocument();
                if (this.getCodec() instanceof CollectibleCodec) {
                    document = ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(document);
                }
                writeRequest = new InsertRequest(this.documentToBsonDocument(document));
            } else if (writeModel instanceof ReplaceOneModel) {
                ReplaceOneModel replaceOneModel = (ReplaceOneModel)writeModel;
                writeRequest = new UpdateRequest(this.toBsonDocument(replaceOneModel.getFilter()), this.documentToBsonDocument(replaceOneModel.getReplacement()), WriteRequest.Type.REPLACE).upsert(replaceOneModel.getOptions().isUpsert()).collation(replaceOneModel.getOptions().getCollation());
            } else if (writeModel instanceof UpdateOneModel) {
                UpdateOneModel updateOneModel = (UpdateOneModel)writeModel;
                writeRequest = new UpdateRequest(this.toBsonDocument(updateOneModel.getFilter()), this.toBsonDocument(updateOneModel.getUpdate()), WriteRequest.Type.UPDATE).multi(false).upsert(updateOneModel.getOptions().isUpsert()).collation(updateOneModel.getOptions().getCollation());
            } else if (writeModel instanceof UpdateManyModel) {
                UpdateManyModel updateManyModel = (UpdateManyModel)writeModel;
                writeRequest = new UpdateRequest(this.toBsonDocument(updateManyModel.getFilter()), this.toBsonDocument(updateManyModel.getUpdate()), WriteRequest.Type.UPDATE).multi(true).upsert(updateManyModel.getOptions().isUpsert()).collation(updateManyModel.getOptions().getCollation());
            } else if (writeModel instanceof DeleteOneModel) {
                DeleteOneModel deleteOneModel = (DeleteOneModel)writeModel;
                writeRequest = new DeleteRequest(this.toBsonDocument(deleteOneModel.getFilter())).multi(false).collation(deleteOneModel.getOptions().getCollation());
            } else if (writeModel instanceof DeleteManyModel) {
                DeleteManyModel deleteManyModel = (DeleteManyModel)writeModel;
                writeRequest = new DeleteRequest(this.toBsonDocument(deleteManyModel.getFilter())).multi(true).collation(deleteManyModel.getOptions().getCollation());
            } else {
                throw new UnsupportedOperationException(String.format("WriteModel of type %s is not supported", writeModel.getClass()));
            }
            writeRequests.add((InsertRequest)writeRequest);
        }
        return this.executor.execute(new MixedBulkWriteOperation(this.namespace, writeRequests, options.isOrdered(), this.writeConcern).bypassDocumentValidation(options.getBypassDocumentValidation()));
    }

    @Override
    public void insertOne(TDocument document) {
        this.insertOne(document, new InsertOneOptions());
    }

    @Override
    public void insertOne(TDocument document, InsertOneOptions options) {
        Assertions.notNull("document", document);
        TDocument insertDocument = document;
        if (this.getCodec() instanceof CollectibleCodec) {
            insertDocument = ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(document);
        }
        this.executeSingleWriteRequest(new InsertRequest(this.documentToBsonDocument(insertDocument)), options.getBypassDocumentValidation());
    }

    @Override
    public void insertMany(List<? extends TDocument> documents) {
        this.insertMany(documents, new InsertManyOptions());
    }

    @Override
    public void insertMany(List<? extends TDocument> documents, InsertManyOptions options) {
        Assertions.notNull("documents", documents);
        ArrayList<InsertRequest> requests = new ArrayList<InsertRequest>(documents.size());
        for (TDocument document : documents) {
            if (document == null) {
                throw new IllegalArgumentException("documents can not contain a null value");
            }
            if (this.getCodec() instanceof CollectibleCodec) {
                document = ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(document);
            }
            requests.add(new InsertRequest(this.documentToBsonDocument(document)));
        }
        this.executor.execute(new MixedBulkWriteOperation(this.namespace, requests, options.isOrdered(), this.writeConcern).bypassDocumentValidation(options.getBypassDocumentValidation()));
    }

    @Override
    public DeleteResult deleteOne(Bson filter) {
        return this.deleteOne(filter, new DeleteOptions());
    }

    @Override
    public DeleteResult deleteOne(Bson filter, DeleteOptions options) {
        return this.delete(filter, options, false);
    }

    @Override
    public DeleteResult deleteMany(Bson filter) {
        return this.deleteMany(filter, new DeleteOptions());
    }

    @Override
    public DeleteResult deleteMany(Bson filter, DeleteOptions options) {
        return this.delete(filter, options, true);
    }

    @Override
    public UpdateResult replaceOne(Bson filter, TDocument replacement) {
        return this.replaceOne(filter, replacement, new UpdateOptions());
    }

    @Override
    public UpdateResult replaceOne(Bson filter, TDocument replacement, UpdateOptions updateOptions) {
        return this.toUpdateResult(this.executeSingleWriteRequest(new UpdateRequest(this.toBsonDocument(filter), this.documentToBsonDocument(replacement), WriteRequest.Type.REPLACE).upsert(updateOptions.isUpsert()).collation(updateOptions.getCollation()), updateOptions.getBypassDocumentValidation()));
    }

    @Override
    public UpdateResult updateOne(Bson filter, Bson update) {
        return this.updateOne(filter, update, new UpdateOptions());
    }

    @Override
    public UpdateResult updateOne(Bson filter, Bson update, UpdateOptions updateOptions) {
        return this.update(filter, update, updateOptions, false);
    }

    @Override
    public UpdateResult updateMany(Bson filter, Bson update) {
        return this.updateMany(filter, update, new UpdateOptions());
    }

    @Override
    public UpdateResult updateMany(Bson filter, Bson update, UpdateOptions updateOptions) {
        return this.update(filter, update, updateOptions, true);
    }

    @Override
    public TDocument findOneAndDelete(Bson filter) {
        return this.findOneAndDelete(filter, new FindOneAndDeleteOptions());
    }

    @Override
    public TDocument findOneAndDelete(Bson filter, FindOneAndDeleteOptions options) {
        return this.executor.execute(new FindAndDeleteOperation<TDocument>(this.namespace, this.writeConcern, this.getCodec()).filter(this.toBsonDocument(filter)).projection(this.toBsonDocument(options.getProjection())).sort(this.toBsonDocument(options.getSort())).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).collation(options.getCollation()));
    }

    @Override
    public TDocument findOneAndReplace(Bson filter, TDocument replacement) {
        return this.findOneAndReplace(filter, replacement, new FindOneAndReplaceOptions());
    }

    @Override
    public TDocument findOneAndReplace(Bson filter, TDocument replacement, FindOneAndReplaceOptions options) {
        return this.executor.execute(new FindAndReplaceOperation<TDocument>(this.namespace, this.writeConcern, this.getCodec(), this.documentToBsonDocument(replacement)).filter(this.toBsonDocument(filter)).projection(this.toBsonDocument(options.getProjection())).sort(this.toBsonDocument(options.getSort())).returnOriginal(options.getReturnDocument() == ReturnDocument.BEFORE).upsert(options.isUpsert()).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).bypassDocumentValidation(options.getBypassDocumentValidation()).collation(options.getCollation()));
    }

    @Override
    public TDocument findOneAndUpdate(Bson filter, Bson update) {
        return this.findOneAndUpdate(filter, update, new FindOneAndUpdateOptions());
    }

    @Override
    public TDocument findOneAndUpdate(Bson filter, Bson update, FindOneAndUpdateOptions options) {
        return this.executor.execute(new FindAndUpdateOperation<TDocument>(this.namespace, this.writeConcern, this.getCodec(), this.toBsonDocument(update)).filter(this.toBsonDocument(filter)).projection(this.toBsonDocument(options.getProjection())).sort(this.toBsonDocument(options.getSort())).returnOriginal(options.getReturnDocument() == ReturnDocument.BEFORE).upsert(options.isUpsert()).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).bypassDocumentValidation(options.getBypassDocumentValidation()).collation(options.getCollation()));
    }

    @Override
    public void drop() {
        this.executor.execute(new DropCollectionOperation(this.namespace, this.writeConcern));
    }

    @Override
    public String createIndex(Bson keys) {
        return this.createIndex(keys, new IndexOptions());
    }

    @Override
    public String createIndex(Bson keys, IndexOptions indexOptions) {
        return this.createIndexes(Collections.singletonList(new IndexModel(keys, indexOptions))).get(0);
    }

    @Override
    public List<String> createIndexes(List<IndexModel> indexes) {
        Assertions.notNull("indexes", indexes);
        ArrayList<IndexRequest> indexRequests = new ArrayList<IndexRequest>(indexes.size());
        for (IndexModel model : indexes) {
            if (model == null) {
                throw new IllegalArgumentException("indexes can not contain a null value");
            }
            indexRequests.add(new IndexRequest(this.toBsonDocument(model.getKeys())).name(model.getOptions().getName()).background(model.getOptions().isBackground()).unique(model.getOptions().isUnique()).sparse(model.getOptions().isSparse()).expireAfter(model.getOptions().getExpireAfter(TimeUnit.SECONDS), TimeUnit.SECONDS).version(model.getOptions().getVersion()).weights(this.toBsonDocument(model.getOptions().getWeights())).defaultLanguage(model.getOptions().getDefaultLanguage()).languageOverride(model.getOptions().getLanguageOverride()).textVersion(model.getOptions().getTextVersion()).sphereVersion(model.getOptions().getSphereVersion()).bits(model.getOptions().getBits()).min(model.getOptions().getMin()).max(model.getOptions().getMax()).bucketSize(model.getOptions().getBucketSize()).storageEngine(this.toBsonDocument(model.getOptions().getStorageEngine())).partialFilterExpression(this.toBsonDocument(model.getOptions().getPartialFilterExpression())).collation(model.getOptions().getCollation()));
        }
        CreateIndexesOperation createIndexesOperation = new CreateIndexesOperation(this.getNamespace(), indexRequests, this.writeConcern);
        this.executor.execute(createIndexesOperation);
        return createIndexesOperation.getIndexNames();
    }

    @Override
    public ListIndexesIterable<Document> listIndexes() {
        return this.listIndexes(Document.class);
    }

    @Override
    public <TResult> ListIndexesIterable<TResult> listIndexes(Class<TResult> resultClass) {
        return new ListIndexesIterableImpl<TResult>(this.getNamespace(), resultClass, this.codecRegistry, ReadPreference.primary(), this.executor);
    }

    @Override
    public void dropIndex(String indexName) {
        this.executor.execute(new DropIndexOperation(this.namespace, indexName, this.writeConcern));
    }

    @Override
    public void dropIndex(Bson keys) {
        this.executor.execute(new DropIndexOperation(this.namespace, keys.toBsonDocument(BsonDocument.class, this.codecRegistry), this.writeConcern));
    }

    @Override
    public void dropIndexes() {
        this.dropIndex("*");
    }

    @Override
    public void renameCollection(MongoNamespace newCollectionNamespace) {
        this.renameCollection(newCollectionNamespace, new RenameCollectionOptions());
    }

    @Override
    public void renameCollection(MongoNamespace newCollectionNamespace, RenameCollectionOptions renameCollectionOptions) {
        this.executor.execute(new RenameCollectionOperation(this.getNamespace(), newCollectionNamespace, this.writeConcern).dropTarget(renameCollectionOptions.isDropTarget()));
    }

    private DeleteResult delete(Bson filter, DeleteOptions deleteOptions, boolean multi) {
        BulkWriteResult result = this.executeSingleWriteRequest(new DeleteRequest(this.toBsonDocument(filter)).multi(multi).collation(deleteOptions.getCollation()), null);
        if (result.wasAcknowledged()) {
            return DeleteResult.acknowledged(result.getDeletedCount());
        }
        return DeleteResult.unacknowledged();
    }

    private UpdateResult update(Bson filter, Bson update, UpdateOptions updateOptions, boolean multi) {
        return this.toUpdateResult(this.executeSingleWriteRequest(new UpdateRequest(this.toBsonDocument(filter), this.toBsonDocument(update), WriteRequest.Type.UPDATE).upsert(updateOptions.isUpsert()).multi(multi).collation(updateOptions.getCollation()), updateOptions.getBypassDocumentValidation()));
    }

    private BulkWriteResult executeSingleWriteRequest(WriteRequest request, Boolean bypassDocumentValidation) {
        try {
            return this.executor.execute(new MixedBulkWriteOperation(this.namespace, Arrays.asList(request), true, this.writeConcern).bypassDocumentValidation(bypassDocumentValidation));
        }
        catch (MongoBulkWriteException e) {
            if (e.getWriteErrors().isEmpty()) {
                throw new MongoWriteConcernException(e.getWriteConcernError(), this.translateBulkWriteResult(request, e.getWriteResult()), e.getServerAddress());
            }
            throw new MongoWriteException(new WriteError(e.getWriteErrors().get(0)), e.getServerAddress());
        }
    }

    private WriteConcernResult translateBulkWriteResult(WriteRequest request, BulkWriteResult writeResult) {
        switch (request.getType()) {
            case INSERT: {
                return WriteConcernResult.acknowledged(writeResult.getInsertedCount(), false, null);
            }
            case DELETE: {
                return WriteConcernResult.acknowledged(writeResult.getDeletedCount(), false, null);
            }
            case UPDATE: 
            case REPLACE: {
                return WriteConcernResult.acknowledged(writeResult.getMatchedCount() + writeResult.getUpserts().size(), writeResult.getMatchedCount() > 0, writeResult.getUpserts().isEmpty() ? null : writeResult.getUpserts().get(0).getId());
            }
        }
        throw new MongoInternalException("Unhandled write request type: " + (Object)((Object)request.getType()));
    }

    private UpdateResult toUpdateResult(BulkWriteResult result) {
        if (result.wasAcknowledged()) {
            Long modifiedCount = result.isModifiedCountAvailable() ? Long.valueOf(result.getModifiedCount()) : null;
            BsonValue upsertedId = result.getUpserts().isEmpty() ? null : result.getUpserts().get(0).getId();
            return UpdateResult.acknowledged(result.getMatchedCount(), modifiedCount, upsertedId);
        }
        return UpdateResult.unacknowledged();
    }

    private Codec<TDocument> getCodec() {
        return this.codecRegistry.get(this.documentClass);
    }

    private BsonDocument documentToBsonDocument(TDocument document) {
        return BsonDocumentWrapper.asBsonDocument(document, this.codecRegistry);
    }

    private BsonDocument toBsonDocument(Bson bson) {
        return bson == null ? null : bson.toBsonDocument(this.documentClass, this.codecRegistry);
    }
}

