/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBObject;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.bson.BSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectionDBObject
implements DBObject {
    JavaWrapper _wrapper;
    Object _id;
    private static final Map<Class, JavaWrapper> _wrappers = Collections.synchronizedMap(new HashMap());
    private static final Set<String> IGNORE_FIELDS = new HashSet<String>();

    @Override
    public Object get(String key) {
        return this.getWrapper().get(this, key);
    }

    @Override
    public Set<String> keySet() {
        return this.getWrapper().keySet();
    }

    @Override
    @Deprecated
    public boolean containsKey(String s) {
        return this.containsField(s);
    }

    @Override
    public boolean containsField(String s) {
        return this.getWrapper().containsKey(s);
    }

    @Override
    public Object put(String key, Object v) {
        return this.getWrapper().set(this, key, v);
    }

    @Override
    public void putAll(Map m) {
        for (Map.Entry entry : m.entrySet()) {
            this.put(entry.getKey().toString(), entry.getValue());
        }
    }

    @Override
    public void putAll(BSONObject o) {
        for (String k : o.keySet()) {
            this.put(k, o.get(k));
        }
    }

    public Object get_id() {
        return this._id;
    }

    public void set_id(Object id) {
        this._id = id;
    }

    @Override
    public boolean isPartialObject() {
        return false;
    }

    @Override
    public Map toMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (String s : this.keySet()) {
            m.put(s, this.get(s + ""));
        }
        return m;
    }

    @Override
    public void markAsPartialObject() {
        throw new RuntimeException("ReflectionDBObjects can't be partial");
    }

    @Override
    public Object removeField(String key) {
        throw new RuntimeException("can't remove from a ReflectionDBObject");
    }

    JavaWrapper getWrapper() {
        if (this._wrapper != null) {
            return this._wrapper;
        }
        this._wrapper = ReflectionDBObject.getWrapper(this.getClass());
        return this._wrapper;
    }

    public static JavaWrapper getWrapperIfReflectionObject(Class c) {
        if (ReflectionDBObject.class.isAssignableFrom(c)) {
            return ReflectionDBObject.getWrapper(c);
        }
        return null;
    }

    public static JavaWrapper getWrapper(Class c) {
        JavaWrapper w = _wrappers.get(c);
        if (w == null) {
            w = new JavaWrapper(c);
            _wrappers.put(c, w);
        }
        return w;
    }

    static {
        IGNORE_FIELDS.add("Int");
    }

    static class FieldInfo {
        final String _name;
        final Class _class;
        Method _getter;
        Method _setter;

        FieldInfo(String name, Class c) {
            this._name = name;
            this._class = c;
        }

        boolean ok() {
            return this._getter != null && this._setter != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JavaWrapper {
        final Class _class;
        final String _name;
        final Map<String, FieldInfo> _fields;
        final Set<String> _keys;

        JavaWrapper(Class c) {
            this._class = c;
            this._name = c.getName();
            this._fields = new TreeMap<String, FieldInfo>();
            for (Method m : c.getMethods()) {
                String name;
                if (!m.getName().startsWith("get") && !m.getName().startsWith("set") || (name = m.getName().substring(3)).length() == 0 || IGNORE_FIELDS.contains(name)) continue;
                Class<?> type = m.getName().startsWith("get") ? m.getReturnType() : m.getParameterTypes()[0];
                FieldInfo fi = this._fields.get(name);
                if (fi == null) {
                    fi = new FieldInfo(name, type);
                    this._fields.put(name, fi);
                }
                if (m.getName().startsWith("get")) {
                    fi._getter = m;
                    continue;
                }
                fi._setter = m;
            }
            HashSet<String> names = new HashSet<String>(this._fields.keySet());
            for (String name : names) {
                if (this._fields.get(name).ok()) continue;
                this._fields.remove(name);
            }
            this._keys = Collections.unmodifiableSet(this._fields.keySet());
        }

        public Set<String> keySet() {
            return this._keys;
        }

        @Deprecated
        public boolean containsKey(String key) {
            return this._keys.contains(key);
        }

        public Object get(ReflectionDBObject document, String fieldName) {
            FieldInfo i = this._fields.get(fieldName);
            if (i == null) {
                return null;
            }
            try {
                return i._getter.invoke((Object)document, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("could not invoke getter for [" + fieldName + "] on [" + this._name + "]", e);
            }
        }

        public Object set(ReflectionDBObject t, String name, Object val) {
            FieldInfo i = this._fields.get(name);
            if (i == null) {
                throw new IllegalArgumentException("no field [" + name + "] on [" + this._name + "]");
            }
            try {
                return i._setter.invoke((Object)t, val);
            }
            catch (Exception e) {
                throw new RuntimeException("could not invoke setter for [" + name + "] on [" + this._name + "]", e);
            }
        }

        Class getInternalClass(String path) {
            FieldInfo fi;
            String cur = path;
            String next = null;
            int idx = path.indexOf(".");
            if (idx >= 0) {
                cur = path.substring(0, idx);
                next = path.substring(idx + 1);
            }
            if ((fi = this._fields.get(cur)) == null) {
                return null;
            }
            if (next == null) {
                return fi._class;
            }
            JavaWrapper w = ReflectionDBObject.getWrapperIfReflectionObject(fi._class);
            if (w == null) {
                return null;
            }
            return w.getInternalClass(next);
        }
    }
}

