/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management;

import com.mysql.management.HelpOptionsParser;
import com.mysql.management.util.ListToString;
import com.mysql.management.util.Streams;
import com.mysql.management.util.TestUtil;
import com.mysql.management.util.Utils;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;
import junit.framework.TestCase;

public class HelpOptionsParserTest
extends TestCase {
    public void testOptionParser() throws Exception {
        String resourceVersion = new TestUtil().getSystemPropertyWithDefaultFromResource("mysql-version", "connector-mxj.properties", System.err);
        String resourceVersionDir = resourceVersion.replaceAll("\\.", "-");
        String sampleHelp = resourceVersionDir + "/com/mysql/management/MySQL_Help.txt";
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        InputStream is = cl.getResourceAsStream(sampleHelp);
        String help = new Streams().readString(is);
        is.close();
        HelpOptionsParser parser = new HelpOptionsParser(System.err, new Utils());
        Map parsed = parser.getOptionsFromHelp(help);
        String optStr = new ListToString().toString(parsed);
        HelpOptionsParserTest.assertEquals((String)optStr, (Object)"TRUE", parsed.get("auto-rehash"));
    }

    public void testTrimOptionsErrorMsg() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        HelpOptionsParser parser = new HelpOptionsParser(new PrintStream(out), new Utils());
        Exception expected = null;
        try {
            parser.trimToOptions("bogus");
        }
        catch (Exception e) {
            expected = e;
        }
        HelpOptionsParserTest.assertNotNull((Object)expected);
        String errMsg = new String(out.toByteArray());
        HelpOptionsParserTest.assertTrue((errMsg.indexOf("bogus") >= 0 ? 1 : 0) != 0);
    }

    public void testOptionParserSupportIssue8601() throws Exception {
        String text = "support-issue-8601-help-output.txt";
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        InputStream is = cl.getResourceAsStream(text);
        String help = new Streams().readString(is);
        is.close();
        HelpOptionsParser parser = new HelpOptionsParser(System.err, new Utils());
        Map parsed = parser.getOptionsFromHelp(help);
        HelpOptionsParserTest.assertEquals((Object)"FALSE", parsed.get("allow-suspicious-udfs"));
    }
}

