/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.SQLRuntimeException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class QueryUtil {
    private final Connection conn;
    private PrintStream err;

    public QueryUtil(Connection conn) {
        this(conn, System.err);
    }

    public QueryUtil(Connection conn, PrintStream err) {
        this.conn = conn;
        this.err = err;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List executeQuery(String query, Object[] params) {
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            try {
                pStmt = this.prepareStatement(query, params);
                rs = pStmt.executeQuery();
                List list = this.mapRows(rs);
                Object var6_6 = null;
                this.cleanupRsAndStmt(pStmt, rs, query, null);
                return list;
            }
            catch (SQLException sqlEx) {
                throw new SQLRuntimeException(sqlEx, query, params);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.cleanupRsAndStmt(pStmt, rs, query, null);
            throw throwable;
        }
    }

    private List mapRows(ResultSet rs) throws SQLException {
        int columns = rs.getMetaData().getColumnCount();
        ArrayList rows = new ArrayList();
        while (rs.next()) {
            LinkedHashMap<String, Object> rowVals = new LinkedHashMap<String, Object>(columns);
            int i = 1;
            while (i <= columns) {
                String columnName = rs.getMetaData().getColumnName(i);
                Object columValue = rs.getObject(i);
                rowVals.put(columnName, columValue);
                ++i;
            }
            rows.add(rowVals);
        }
        return rows;
    }

    public List executeQuery(String query) {
        return this.executeQuery(query, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(String query, Object[] params) {
        PreparedStatement pStmt = null;
        try {
            try {
                pStmt = this.prepareStatement(query, params);
                int n = pStmt.executeUpdate();
                Object var5_5 = null;
                this.cleanupRsAndStmt(pStmt, null, query, params);
                return n;
            }
            catch (SQLException sqlEx) {
                throw new SQLRuntimeException(sqlEx, query, params);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.cleanupRsAndStmt(pStmt, null, query, params);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(String query, Object[] params) {
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = this.prepareStatement(query, params);
                boolean bl = pstmt.execute();
                Object var5_5 = null;
                this.cleanupRsAndStmt(pstmt, null, query, null);
                return bl;
            }
            catch (SQLException e) {
                throw new SQLRuntimeException(e, query, params);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.cleanupRsAndStmt(pstmt, null, query, null);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch(String query, Object[][] params) {
        PreparedStatement pStmt = null;
        ResultSet resultSet = null;
        try {
            try {
                pStmt = this.prepareStatement(query);
                int i = 0;
                while (true) {
                    if (i >= params.length) {
                        int[] nArray = pStmt.executeBatch();
                        Object var6_8 = null;
                        this.cleanupRsAndStmt(pStmt, resultSet, query, (Object[])params);
                        return nArray;
                    }
                    this.setParameters(query, params[i], pStmt);
                    pStmt.addBatch();
                    ++i;
                }
            }
            catch (SQLException e) {
                throw new SQLRuntimeException(e, query, (Object[])params);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.cleanupRsAndStmt(pStmt, resultSet, query, (Object[])params);
            throw throwable;
        }
    }

    public int executeUpdate(String query) {
        return this.executeUpdate(query, null);
    }

    public boolean execute(String query) {
        return this.execute(query, null);
    }

    public List executeUpdateReturningKeys(String query) {
        return this.executeUpdateReturningKeys(query, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List executeUpdateReturningKeys(String query, Object[] params) {
        PreparedStatement pStmt = null;
        ResultSet resultSet = null;
        try {
            try {
                pStmt = this.prepareStatement(query, params);
                pStmt.executeUpdate();
                resultSet = pStmt.getGeneratedKeys();
                List list = this.mapRows(resultSet);
                Object var6_6 = null;
                this.cleanupRsAndStmt(pStmt, resultSet, query, params);
                return list;
            }
            catch (SQLException e) {
                throw new SQLRuntimeException(e, query, params);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.cleanupRsAndStmt(pStmt, resultSet, query, params);
            throw throwable;
        }
    }

    private PreparedStatement prepareStatement(String query, Object[] params) throws SQLException {
        PreparedStatement pStmt = this.prepareStatement(query);
        this.setParameters(query, params, pStmt);
        return pStmt;
    }

    private void setParameters(String query, Object[] params, PreparedStatement pStmt) throws SQLException {
        int paramCount;
        int numParams = pStmt.getParameterMetaData().getParameterCount();
        int n = paramCount = params == null ? 0 : params.length;
        if (numParams != paramCount) {
            String msg = "Expected " + numParams + " parameters, got " + paramCount;
            throw new SQLRuntimeException(msg, query, params);
        }
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                Object param = params[i];
                pStmt.setObject(i + 1, param);
                ++i;
            }
        }
    }

    private PreparedStatement prepareStatement(String query) throws SQLException {
        if (query == null) {
            throw new IllegalArgumentException("query string may not be null");
        }
        if (query.length() == 0) {
            throw new IllegalArgumentException("query string may not be empty");
        }
        return this.conn.prepareStatement(query);
    }

    private void cleanupRsAndStmt(Statement stmt, ResultSet rs, String origSql, Object[] params) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Throwable t) {
                new SQLRuntimeException(t, origSql, params).printStackTrace(this.err);
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Throwable t) {
                new SQLRuntimeException(t, origSql, params).printStackTrace(this.err);
            }
        }
    }

    public String queryForString(String query) {
        return this.queryForString(query, null);
    }

    public String queryForString(String query, Object[] params) {
        List restults = this.executeQuery(query, params);
        Iterator it = restults.iterator();
        while (it.hasNext()) {
            Map row = (Map)it.next();
            Iterator it2 = row.entrySet().iterator();
            if (!it2.hasNext()) continue;
            Map.Entry column = it2.next();
            if (column.getValue() == null) {
                return null;
            }
            return column.getValue().toString();
        }
        return null;
    }
}

