/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.Exceptions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class Streams {
    public static final String RESOURCE_SEPARATOR = "/";
    private static final int END_OF_STREAM = -1;
    private Exceptions exceptions = new Exceptions();

    public void copy(InputStream from, OutputStream to) throws IOException {
        this.copy(from, to, true, false);
    }

    void copy(InputStream from, OutputStream to, boolean buffer, boolean terminateOnFailure) throws IOException {
        if (buffer) {
            from = new BufferedInputStream(from);
            to = new BufferedOutputStream(to);
        }
        while (true) {
            try {
                int i = from.read();
                if (i == -1) break;
                to.write(i);
            }
            catch (Exception e) {
                if (terminateOnFailure) break;
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw this.exceptions.toRuntime(e);
            }
        }
        to.flush();
    }

    public String readString(InputStream from) throws IOException {
        String string;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            this.copy(from, buf);
            string = buf.toString();
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            buf.close();
            throw throwable;
        }
        buf.close();
        return string;
    }

    public InputStream getResourceAsStream(String name) {
        return this.getResourceAsStream(this.getClass(), name);
    }

    public InputStream getResourceAsStream(Class aClass, String name) {
        InputStream is = null;
        ClassLoader classLoader = aClass.getClassLoader();
        if (classLoader != null) {
            is = classLoader.getResourceAsStream(name);
        }
        if (is == null && classLoader != null) {
            is = classLoader.getResourceAsStream(RESOURCE_SEPARATOR + name);
        }
        if (is == null) {
            is = aClass.getResourceAsStream(name);
        }
        if (is == null) {
            is = aClass.getResourceAsStream(RESOURCE_SEPARATOR + name);
        }
        if (is == null) {
            String msg = "Resource '" + name + "' not found";
            throw new MissingResourceException(msg, null, name);
        }
        return is;
    }

    public void createFileFromResource(final String resourceName, final File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        Exceptions.VoidBlock block = new Exceptions.VoidBlock(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void inner() throws Exception {
                InputStream is = Streams.this.getResourceAsStream(resourceName);
                try {
                    FileOutputStream fos = new FileOutputStream(file);
                    try {
                        Streams.this.copy(is, fos);
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        fos.close();
                        throw throwable;
                    }
                    {
                        Object var3_5 = null;
                        fos.close();
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    is.close();
                    throw throwable;
                }
                {
                    Object var5_8 = null;
                }
                is.close();
            }
        };
        block.exec();
    }

    public void expandResourceJar(final File outputDir, final String jarResourceName) {
        Exceptions.VoidBlock block = new Exceptions.VoidBlock(){

            public void inner() throws Exception {
                Streams.this.expandResourceJarInner(outputDir, jarResourceName);
            }
        };
        block.exec();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void expandResourceJarInner(File outputDir, String jarResourceName) throws IOException {
        InputStream is = this.getResourceAsStream(jarResourceName);
        try {
            JarInputStream jis = new JarInputStream(is);
            try {
                this.expandEachEntry(outputDir, jis);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                jis.close();
                throw throwable;
            }
            {
                Object var5_7 = null;
                jis.close();
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            is.close();
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        is.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void expandEachEntry(File outputDir, JarInputStream jis) throws IOException, FileNotFoundException {
        JarEntry entry;
        while ((entry = jis.getNextJarEntry()) != null) {
            Object var7_7;
            File file = new File(outputDir, entry.getName());
            if (file.exists()) continue;
            if (entry.isDirectory()) {
                file.mkdirs();
                continue;
            }
            File parent = file.getParentFile();
            parent.mkdirs();
            FileOutputStream fos = new FileOutputStream(file);
            try {
                this.copy(jis, fos);
            }
            catch (Throwable throwable) {
                var7_7 = null;
                fos.close();
                throw throwable;
            }
            {
                var7_7 = null;
                fos.close();
                continue;
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties loadProperties(String resourceName, PrintStream err) {
        InputStream is = this.getResourceAsStream(resourceName);
        Properties props = new Properties();
        try {
            try {
                props.load(is);
            }
            catch (IOException e) {
                e.printStackTrace(err);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace(err);
            }
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (IOException e) {
            e.printStackTrace(err);
            return props;
        }
        is.close();
        return props;
    }
}

