/*
 * Copyright (c) 2017, 2021, Oracle and/or its affiliates.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2.0, as
 * published by the Free Software Foundation.
 *
 * This program is also distributed with certain software (including
 * but not limited to OpenSSL) that is licensed under separate terms,
 * as designated in a particular file or component or in included license
 * documentation.  The authors of MySQL hereby grant you an
 * additional permission to link the program and your derivative works
 * with the separately licensed software that they have included with
 * MySQL.
 *
 * Without limiting anything contained in the foregoing, this file,
 * which is part of MySQL Connector/Node.js, is also subject to the
 * Universal FOSS Exception, version 1.0, a copy of which can be found at
 * http://oss.oracle.com/licenses/universal-foss-exception.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License, version 2.0, for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
 */

/**
 * @fileoverview
 * @enhanceable
 * @suppress {messageConventions} JS Compiler reports an error if a variable or
 *     field starts with 'MSG_' and isn't a translatable message.
 * @public
 */
// GENERATED CODE -- DO NOT EDIT!

var jspb = require('google-protobuf');
var goog = jspb;
var global = Function('return this')();

var mysqlx_pb = require('./mysqlx_pb.js');
goog.exportSymbol('proto.Mysqlx.Expect.Close', null, global);
goog.exportSymbol('proto.Mysqlx.Expect.Open', null, global);
goog.exportSymbol('proto.Mysqlx.Expect.Open.Condition', null, global);
goog.exportSymbol('proto.Mysqlx.Expect.Open.Condition.ConditionOperation', null, global);
goog.exportSymbol('proto.Mysqlx.Expect.Open.Condition.Key', null, global);
goog.exportSymbol('proto.Mysqlx.Expect.Open.CtxOperation', null, global);

/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Expect.Open = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.Mysqlx.Expect.Open.repeatedFields_, null);
};
goog.inherits(proto.Mysqlx.Expect.Open, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  proto.Mysqlx.Expect.Open.displayName = 'proto.Mysqlx.Expect.Open';
}
/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.Mysqlx.Expect.Open.repeatedFields_ = [2];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto suitable for use in Soy templates.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     com.google.apps.jspb.JsClassTemplate.JS_RESERVED_WORDS.
 * @param {boolean=} opt_includeInstance Whether to include the JSPB instance
 *     for transitional soy proto support: http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Expect.Open.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Expect.Open.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Whether to include the JSPB
 *     instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Expect.Open} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Expect.Open.toObject = function(includeInstance, msg) {
  var f, obj = {
    op: jspb.Message.getFieldWithDefault(msg, 1, 0),
    condList: jspb.Message.toObjectList(msg.getCondList(),
    proto.Mysqlx.Expect.Open.Condition.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Expect.Open}
 */
proto.Mysqlx.Expect.Open.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Expect.Open;
  return proto.Mysqlx.Expect.Open.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Expect.Open} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Expect.Open}
 */
proto.Mysqlx.Expect.Open.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {!proto.Mysqlx.Expect.Open.CtxOperation} */ (reader.readEnum());
      msg.setOp(value);
      break;
    case 2:
      var value = new proto.Mysqlx.Expect.Open.Condition;
      reader.readMessage(value,proto.Mysqlx.Expect.Open.Condition.deserializeBinaryFromReader);
      msg.addCond(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Expect.Open.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Expect.Open.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Expect.Open} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Expect.Open.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = /** @type {!proto.Mysqlx.Expect.Open.CtxOperation} */ (jspb.Message.getField(message, 1));
  if (f != null) {
    writer.writeEnum(
      1,
      f
    );
  }
  f = message.getCondList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      2,
      f,
      proto.Mysqlx.Expect.Open.Condition.serializeBinaryToWriter
    );
  }
};


/**
 * @enum {number}
 */
proto.Mysqlx.Expect.Open.CtxOperation = {
  EXPECT_CTX_COPY_PREV: 0,
  EXPECT_CTX_EMPTY: 1
};


/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Expect.Open.Condition = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Mysqlx.Expect.Open.Condition, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  proto.Mysqlx.Expect.Open.Condition.displayName = 'proto.Mysqlx.Expect.Open.Condition';
}


if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto suitable for use in Soy templates.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     com.google.apps.jspb.JsClassTemplate.JS_RESERVED_WORDS.
 * @param {boolean=} opt_includeInstance Whether to include the JSPB instance
 *     for transitional soy proto support: http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Expect.Open.Condition.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Expect.Open.Condition.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Whether to include the JSPB
 *     instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Expect.Open.Condition} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Expect.Open.Condition.toObject = function(includeInstance, msg) {
  var f, obj = {
    conditionKey: jspb.Message.getField(msg, 1),
    conditionValue: msg.getConditionValue_asB64(),
    op: jspb.Message.getFieldWithDefault(msg, 3, 0)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Expect.Open.Condition}
 */
proto.Mysqlx.Expect.Open.Condition.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Expect.Open.Condition;
  return proto.Mysqlx.Expect.Open.Condition.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Expect.Open.Condition} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Expect.Open.Condition}
 */
proto.Mysqlx.Expect.Open.Condition.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {number} */ (reader.readUint32());
      msg.setConditionKey(value);
      break;
    case 2:
      var value = /** @type {!Uint8Array} */ (reader.readBytes());
      msg.setConditionValue(value);
      break;
    case 3:
      var value = /** @type {!proto.Mysqlx.Expect.Open.Condition.ConditionOperation} */ (reader.readEnum());
      msg.setOp(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Expect.Open.Condition.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Expect.Open.Condition.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Expect.Open.Condition} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Expect.Open.Condition.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = /** @type {number} */ (jspb.Message.getField(message, 1));
  if (f != null) {
    writer.writeUint32(
      1,
      f
    );
  }
  f = /** @type {!(string|Uint8Array)} */ (jspb.Message.getField(message, 2));
  if (f != null) {
    writer.writeBytes(
      2,
      f
    );
  }
  f = /** @type {!proto.Mysqlx.Expect.Open.Condition.ConditionOperation} */ (jspb.Message.getField(message, 3));
  if (f != null) {
    writer.writeEnum(
      3,
      f
    );
  }
};


/**
 * @enum {number}
 */
proto.Mysqlx.Expect.Open.Condition.Key = {
  EXPECT_NO_ERROR: 1,
  EXPECT_FIELD_EXIST: 2,
  EXPECT_DOCID_GENERATED: 3
};

/**
 * @enum {number}
 */
proto.Mysqlx.Expect.Open.Condition.ConditionOperation = {
  EXPECT_OP_SET: 0,
  EXPECT_OP_UNSET: 1
};

/**
 * required uint32 condition_key = 1;
 * @return {number}
 */
proto.Mysqlx.Expect.Open.Condition.prototype.getConditionKey = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 1, 0));
};


/** @param {number} value */
proto.Mysqlx.Expect.Open.Condition.prototype.setConditionKey = function(value) {
  jspb.Message.setField(this, 1, value);
};


proto.Mysqlx.Expect.Open.Condition.prototype.clearConditionKey = function() {
  jspb.Message.setField(this, 1, undefined);
};


/**
 * Returns whether this field is set.
 * @return {!boolean}
 */
proto.Mysqlx.Expect.Open.Condition.prototype.hasConditionKey = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * optional bytes condition_value = 2;
 * @return {!(string|Uint8Array)}
 */
proto.Mysqlx.Expect.Open.Condition.prototype.getConditionValue = function() {
  return /** @type {!(string|Uint8Array)} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * optional bytes condition_value = 2;
 * This is a type-conversion wrapper around `getConditionValue()`
 * @return {string}
 */
proto.Mysqlx.Expect.Open.Condition.prototype.getConditionValue_asB64 = function() {
  return /** @type {string} */ (jspb.Message.bytesAsB64(
      this.getConditionValue()));
};


/**
 * optional bytes condition_value = 2;
 * Note that Uint8Array is not supported on all browsers.
 * @see http://caniuse.com/Uint8Array
 * This is a type-conversion wrapper around `getConditionValue()`
 * @return {!Uint8Array}
 */
proto.Mysqlx.Expect.Open.Condition.prototype.getConditionValue_asU8 = function() {
  return /** @type {!Uint8Array} */ (jspb.Message.bytesAsU8(
      this.getConditionValue()));
};


/** @param {!(string|Uint8Array)} value */
proto.Mysqlx.Expect.Open.Condition.prototype.setConditionValue = function(value) {
  jspb.Message.setField(this, 2, value);
};


proto.Mysqlx.Expect.Open.Condition.prototype.clearConditionValue = function() {
  jspb.Message.setField(this, 2, undefined);
};


/**
 * Returns whether this field is set.
 * @return {!boolean}
 */
proto.Mysqlx.Expect.Open.Condition.prototype.hasConditionValue = function() {
  return jspb.Message.getField(this, 2) != null;
};


/**
 * optional ConditionOperation op = 3;
 * @return {!proto.Mysqlx.Expect.Open.Condition.ConditionOperation}
 */
proto.Mysqlx.Expect.Open.Condition.prototype.getOp = function() {
  return /** @type {!proto.Mysqlx.Expect.Open.Condition.ConditionOperation} */ (jspb.Message.getFieldWithDefault(this, 3, 0));
};


/** @param {!proto.Mysqlx.Expect.Open.Condition.ConditionOperation} value */
proto.Mysqlx.Expect.Open.Condition.prototype.setOp = function(value) {
  jspb.Message.setField(this, 3, value);
};


proto.Mysqlx.Expect.Open.Condition.prototype.clearOp = function() {
  jspb.Message.setField(this, 3, undefined);
};


/**
 * Returns whether this field is set.
 * @return {!boolean}
 */
proto.Mysqlx.Expect.Open.Condition.prototype.hasOp = function() {
  return jspb.Message.getField(this, 3) != null;
};


/**
 * optional CtxOperation op = 1;
 * @return {!proto.Mysqlx.Expect.Open.CtxOperation}
 */
proto.Mysqlx.Expect.Open.prototype.getOp = function() {
  return /** @type {!proto.Mysqlx.Expect.Open.CtxOperation} */ (jspb.Message.getFieldWithDefault(this, 1, 0));
};


/** @param {!proto.Mysqlx.Expect.Open.CtxOperation} value */
proto.Mysqlx.Expect.Open.prototype.setOp = function(value) {
  jspb.Message.setField(this, 1, value);
};


proto.Mysqlx.Expect.Open.prototype.clearOp = function() {
  jspb.Message.setField(this, 1, undefined);
};


/**
 * Returns whether this field is set.
 * @return {!boolean}
 */
proto.Mysqlx.Expect.Open.prototype.hasOp = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * repeated Condition cond = 2;
 * @return {!Array.<!proto.Mysqlx.Expect.Open.Condition>}
 */
proto.Mysqlx.Expect.Open.prototype.getCondList = function() {
  return /** @type{!Array.<!proto.Mysqlx.Expect.Open.Condition>} */ (
    jspb.Message.getRepeatedWrapperField(this, proto.Mysqlx.Expect.Open.Condition, 2));
};


/** @param {!Array.<!proto.Mysqlx.Expect.Open.Condition>} value */
proto.Mysqlx.Expect.Open.prototype.setCondList = function(value) {
  jspb.Message.setRepeatedWrapperField(this, 2, value);
};


/**
 * @param {!proto.Mysqlx.Expect.Open.Condition=} opt_value
 * @param {number=} opt_index
 * @return {!proto.Mysqlx.Expect.Open.Condition}
 */
proto.Mysqlx.Expect.Open.prototype.addCond = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 2, opt_value, proto.Mysqlx.Expect.Open.Condition, opt_index);
};


proto.Mysqlx.Expect.Open.prototype.clearCondList = function() {
  this.setCondList([]);
};



/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Expect.Close = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Mysqlx.Expect.Close, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  proto.Mysqlx.Expect.Close.displayName = 'proto.Mysqlx.Expect.Close';
}


if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto suitable for use in Soy templates.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     com.google.apps.jspb.JsClassTemplate.JS_RESERVED_WORDS.
 * @param {boolean=} opt_includeInstance Whether to include the JSPB instance
 *     for transitional soy proto support: http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Expect.Close.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Expect.Close.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Whether to include the JSPB
 *     instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Expect.Close} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Expect.Close.toObject = function(includeInstance, msg) {
  var f, obj = {

  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Expect.Close}
 */
proto.Mysqlx.Expect.Close.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Expect.Close;
  return proto.Mysqlx.Expect.Close.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Expect.Close} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Expect.Close}
 */
proto.Mysqlx.Expect.Close.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Expect.Close.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Expect.Close.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Expect.Close} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Expect.Close.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
};


goog.object.extend(exports, proto.Mysqlx.Expect);
