/*
 * Copyright (c) 2017, 2022, Oracle and/or its affiliates.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2.0, as
 * published by the Free Software Foundation.
 *
 * This program is also distributed with certain software (including
 * but not limited to OpenSSL) that is licensed under separate terms,
 * as designated in a particular file or component or in included license
 * documentation.  The authors of MySQL hereby grant you an
 * additional permission to link the program and your derivative works
 * with the separately licensed software that they have included with
 * MySQL.
 *
 * Without limiting anything contained in the foregoing, this file,
 * which is part of MySQL Connector/Node.js, is also subject to the
 * Universal FOSS Exception, version 1.0, a copy of which can be found at
 * http://oss.oracle.com/licenses/universal-foss-exception.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License, version 2.0, for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
 */

// source: mysqlx_connection.proto
/**
 * @fileoverview
 * @enhanceable
 * @suppress {messageConventions} JS Compiler reports an error if a variable or
 *     field starts with 'MSG_' and isn't a translatable message.
 * @public
 */
// GENERATED CODE -- DO NOT EDIT!

var jspb = require('google-protobuf');
var goog = jspb;
var global = Function('return this')();

var mysqlx_datatypes_pb = require('./mysqlx_datatypes_pb.js');
goog.object.extend(proto, mysqlx_datatypes_pb);
var mysqlx_pb = require('./mysqlx_pb.js');
goog.object.extend(proto, mysqlx_pb);
goog.exportSymbol('proto.Mysqlx.Connection.Capabilities', null, global);
goog.exportSymbol('proto.Mysqlx.Connection.CapabilitiesGet', null, global);
goog.exportSymbol('proto.Mysqlx.Connection.CapabilitiesSet', null, global);
goog.exportSymbol('proto.Mysqlx.Connection.Capability', null, global);
goog.exportSymbol('proto.Mysqlx.Connection.Close', null, global);
goog.exportSymbol('proto.Mysqlx.Connection.Compression', null, global);
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Connection.Capability = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Mysqlx.Connection.Capability, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Mysqlx.Connection.Capability.displayName = 'proto.Mysqlx.Connection.Capability';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Connection.Capabilities = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.Mysqlx.Connection.Capabilities.repeatedFields_, null);
};
goog.inherits(proto.Mysqlx.Connection.Capabilities, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Mysqlx.Connection.Capabilities.displayName = 'proto.Mysqlx.Connection.Capabilities';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Connection.CapabilitiesGet = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Mysqlx.Connection.CapabilitiesGet, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Mysqlx.Connection.CapabilitiesGet.displayName = 'proto.Mysqlx.Connection.CapabilitiesGet';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Connection.CapabilitiesSet = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Mysqlx.Connection.CapabilitiesSet, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Mysqlx.Connection.CapabilitiesSet.displayName = 'proto.Mysqlx.Connection.CapabilitiesSet';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Connection.Close = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Mysqlx.Connection.Close, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Mysqlx.Connection.Close.displayName = 'proto.Mysqlx.Connection.Close';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Connection.Compression = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Mysqlx.Connection.Compression, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Mysqlx.Connection.Compression.displayName = 'proto.Mysqlx.Connection.Compression';
}



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Connection.Capability.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Connection.Capability.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Connection.Capability} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Connection.Capability.toObject = function(includeInstance, msg) {
  var f, obj = {
    name: (f = jspb.Message.getField(msg, 1)) == null ? undefined : f,
    value: (f = msg.getValue()) && mysqlx_datatypes_pb.Any.toObject(includeInstance, f)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Connection.Capability}
 */
proto.Mysqlx.Connection.Capability.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Connection.Capability;
  return proto.Mysqlx.Connection.Capability.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Connection.Capability} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Connection.Capability}
 */
proto.Mysqlx.Connection.Capability.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setName(value);
      break;
    case 2:
      var value = new mysqlx_datatypes_pb.Any;
      reader.readMessage(value,mysqlx_datatypes_pb.Any.deserializeBinaryFromReader);
      msg.setValue(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Connection.Capability.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Connection.Capability.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Connection.Capability} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Connection.Capability.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = /** @type {string} */ (jspb.Message.getField(message, 1));
  if (f != null) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getValue();
  if (f != null) {
    writer.writeMessage(
      2,
      f,
      mysqlx_datatypes_pb.Any.serializeBinaryToWriter
    );
  }
};


/**
 * required string name = 1;
 * @return {string}
 */
proto.Mysqlx.Connection.Capability.prototype.getName = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Mysqlx.Connection.Capability} returns this
 */
proto.Mysqlx.Connection.Capability.prototype.setName = function(value) {
  return jspb.Message.setField(this, 1, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Connection.Capability} returns this
 */
proto.Mysqlx.Connection.Capability.prototype.clearName = function() {
  return jspb.Message.setField(this, 1, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Connection.Capability.prototype.hasName = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * required Mysqlx.Datatypes.Any value = 2;
 * @return {!proto.Mysqlx.Datatypes.Any}
 */
proto.Mysqlx.Connection.Capability.prototype.getValue = function() {
  return /** @type{!proto.Mysqlx.Datatypes.Any} */ (
    jspb.Message.getWrapperField(this, mysqlx_datatypes_pb.Any, 2, 1));
};


/**
 * @param {!proto.Mysqlx.Datatypes.Any} value
 * @return {!proto.Mysqlx.Connection.Capability} returns this
*/
proto.Mysqlx.Connection.Capability.prototype.setValue = function(value) {
  return jspb.Message.setWrapperField(this, 2, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Connection.Capability} returns this
 */
proto.Mysqlx.Connection.Capability.prototype.clearValue = function() {
  return jspb.Message.setField(this, 2, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Connection.Capability.prototype.hasValue = function() {
  return jspb.Message.getField(this, 2) != null;
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.Mysqlx.Connection.Capabilities.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Connection.Capabilities.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Connection.Capabilities.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Connection.Capabilities} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Connection.Capabilities.toObject = function(includeInstance, msg) {
  var f, obj = {
    capabilitiesList: jspb.Message.toObjectList(msg.getCapabilitiesList(),
    proto.Mysqlx.Connection.Capability.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Connection.Capabilities}
 */
proto.Mysqlx.Connection.Capabilities.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Connection.Capabilities;
  return proto.Mysqlx.Connection.Capabilities.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Connection.Capabilities} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Connection.Capabilities}
 */
proto.Mysqlx.Connection.Capabilities.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new proto.Mysqlx.Connection.Capability;
      reader.readMessage(value,proto.Mysqlx.Connection.Capability.deserializeBinaryFromReader);
      msg.addCapabilities(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Connection.Capabilities.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Connection.Capabilities.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Connection.Capabilities} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Connection.Capabilities.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getCapabilitiesList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      proto.Mysqlx.Connection.Capability.serializeBinaryToWriter
    );
  }
};


/**
 * repeated Capability capabilities = 1;
 * @return {!Array<!proto.Mysqlx.Connection.Capability>}
 */
proto.Mysqlx.Connection.Capabilities.prototype.getCapabilitiesList = function() {
  return /** @type{!Array<!proto.Mysqlx.Connection.Capability>} */ (
    jspb.Message.getRepeatedWrapperField(this, proto.Mysqlx.Connection.Capability, 1));
};


/**
 * @param {!Array<!proto.Mysqlx.Connection.Capability>} value
 * @return {!proto.Mysqlx.Connection.Capabilities} returns this
*/
proto.Mysqlx.Connection.Capabilities.prototype.setCapabilitiesList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.Mysqlx.Connection.Capability=} opt_value
 * @param {number=} opt_index
 * @return {!proto.Mysqlx.Connection.Capability}
 */
proto.Mysqlx.Connection.Capabilities.prototype.addCapabilities = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.Mysqlx.Connection.Capability, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.Mysqlx.Connection.Capabilities} returns this
 */
proto.Mysqlx.Connection.Capabilities.prototype.clearCapabilitiesList = function() {
  return this.setCapabilitiesList([]);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Connection.CapabilitiesGet.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Connection.CapabilitiesGet.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Connection.CapabilitiesGet} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Connection.CapabilitiesGet.toObject = function(includeInstance, msg) {
  var f, obj = {

  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Connection.CapabilitiesGet}
 */
proto.Mysqlx.Connection.CapabilitiesGet.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Connection.CapabilitiesGet;
  return proto.Mysqlx.Connection.CapabilitiesGet.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Connection.CapabilitiesGet} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Connection.CapabilitiesGet}
 */
proto.Mysqlx.Connection.CapabilitiesGet.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Connection.CapabilitiesGet.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Connection.CapabilitiesGet.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Connection.CapabilitiesGet} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Connection.CapabilitiesGet.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Connection.CapabilitiesSet.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Connection.CapabilitiesSet.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Connection.CapabilitiesSet} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Connection.CapabilitiesSet.toObject = function(includeInstance, msg) {
  var f, obj = {
    capabilities: (f = msg.getCapabilities()) && proto.Mysqlx.Connection.Capabilities.toObject(includeInstance, f)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Connection.CapabilitiesSet}
 */
proto.Mysqlx.Connection.CapabilitiesSet.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Connection.CapabilitiesSet;
  return proto.Mysqlx.Connection.CapabilitiesSet.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Connection.CapabilitiesSet} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Connection.CapabilitiesSet}
 */
proto.Mysqlx.Connection.CapabilitiesSet.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new proto.Mysqlx.Connection.Capabilities;
      reader.readMessage(value,proto.Mysqlx.Connection.Capabilities.deserializeBinaryFromReader);
      msg.setCapabilities(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Connection.CapabilitiesSet.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Connection.CapabilitiesSet.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Connection.CapabilitiesSet} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Connection.CapabilitiesSet.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getCapabilities();
  if (f != null) {
    writer.writeMessage(
      1,
      f,
      proto.Mysqlx.Connection.Capabilities.serializeBinaryToWriter
    );
  }
};


/**
 * required Capabilities capabilities = 1;
 * @return {!proto.Mysqlx.Connection.Capabilities}
 */
proto.Mysqlx.Connection.CapabilitiesSet.prototype.getCapabilities = function() {
  return /** @type{!proto.Mysqlx.Connection.Capabilities} */ (
    jspb.Message.getWrapperField(this, proto.Mysqlx.Connection.Capabilities, 1, 1));
};


/**
 * @param {!proto.Mysqlx.Connection.Capabilities} value
 * @return {!proto.Mysqlx.Connection.CapabilitiesSet} returns this
*/
proto.Mysqlx.Connection.CapabilitiesSet.prototype.setCapabilities = function(value) {
  return jspb.Message.setWrapperField(this, 1, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Connection.CapabilitiesSet} returns this
 */
proto.Mysqlx.Connection.CapabilitiesSet.prototype.clearCapabilities = function() {
  return jspb.Message.setField(this, 1, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Connection.CapabilitiesSet.prototype.hasCapabilities = function() {
  return jspb.Message.getField(this, 1) != null;
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Connection.Close.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Connection.Close.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Connection.Close} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Connection.Close.toObject = function(includeInstance, msg) {
  var f, obj = {

  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Connection.Close}
 */
proto.Mysqlx.Connection.Close.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Connection.Close;
  return proto.Mysqlx.Connection.Close.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Connection.Close} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Connection.Close}
 */
proto.Mysqlx.Connection.Close.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Connection.Close.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Connection.Close.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Connection.Close} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Connection.Close.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Connection.Compression.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Connection.Compression.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Connection.Compression} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Connection.Compression.toObject = function(includeInstance, msg) {
  var f, obj = {
    uncompressedSize: (f = jspb.Message.getField(msg, 1)) == null ? undefined : f,
    serverMessages: (f = jspb.Message.getField(msg, 2)) == null ? undefined : f,
    clientMessages: (f = jspb.Message.getField(msg, 3)) == null ? undefined : f,
    payload: msg.getPayload_asB64()
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Connection.Compression}
 */
proto.Mysqlx.Connection.Compression.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Connection.Compression;
  return proto.Mysqlx.Connection.Compression.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Connection.Compression} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Connection.Compression}
 */
proto.Mysqlx.Connection.Compression.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {number} */ (reader.readUint64());
      msg.setUncompressedSize(value);
      break;
    case 2:
      var value = /** @type {!proto.Mysqlx.ServerMessages.Type} */ (reader.readEnum());
      msg.setServerMessages(value);
      break;
    case 3:
      var value = /** @type {!proto.Mysqlx.ClientMessages.Type} */ (reader.readEnum());
      msg.setClientMessages(value);
      break;
    case 4:
      var value = /** @type {!Uint8Array} */ (reader.readBytes());
      msg.setPayload(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Connection.Compression.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Connection.Compression.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Connection.Compression} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Connection.Compression.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = /** @type {number} */ (jspb.Message.getField(message, 1));
  if (f != null) {
    writer.writeUint64(
      1,
      f
    );
  }
  f = /** @type {!proto.Mysqlx.ServerMessages.Type} */ (jspb.Message.getField(message, 2));
  if (f != null) {
    writer.writeEnum(
      2,
      f
    );
  }
  f = /** @type {!proto.Mysqlx.ClientMessages.Type} */ (jspb.Message.getField(message, 3));
  if (f != null) {
    writer.writeEnum(
      3,
      f
    );
  }
  f = /** @type {!(string|Uint8Array)} */ (jspb.Message.getField(message, 4));
  if (f != null) {
    writer.writeBytes(
      4,
      f
    );
  }
};


/**
 * optional uint64 uncompressed_size = 1;
 * @return {number}
 */
proto.Mysqlx.Connection.Compression.prototype.getUncompressedSize = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 1, 0));
};


/**
 * @param {number} value
 * @return {!proto.Mysqlx.Connection.Compression} returns this
 */
proto.Mysqlx.Connection.Compression.prototype.setUncompressedSize = function(value) {
  return jspb.Message.setField(this, 1, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Connection.Compression} returns this
 */
proto.Mysqlx.Connection.Compression.prototype.clearUncompressedSize = function() {
  return jspb.Message.setField(this, 1, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Connection.Compression.prototype.hasUncompressedSize = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * optional Mysqlx.ServerMessages.Type server_messages = 2;
 * @return {!proto.Mysqlx.ServerMessages.Type}
 */
proto.Mysqlx.Connection.Compression.prototype.getServerMessages = function() {
  return /** @type {!proto.Mysqlx.ServerMessages.Type} */ (jspb.Message.getFieldWithDefault(this, 2, 0));
};


/**
 * @param {!proto.Mysqlx.ServerMessages.Type} value
 * @return {!proto.Mysqlx.Connection.Compression} returns this
 */
proto.Mysqlx.Connection.Compression.prototype.setServerMessages = function(value) {
  return jspb.Message.setField(this, 2, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Connection.Compression} returns this
 */
proto.Mysqlx.Connection.Compression.prototype.clearServerMessages = function() {
  return jspb.Message.setField(this, 2, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Connection.Compression.prototype.hasServerMessages = function() {
  return jspb.Message.getField(this, 2) != null;
};


/**
 * optional Mysqlx.ClientMessages.Type client_messages = 3;
 * @return {!proto.Mysqlx.ClientMessages.Type}
 */
proto.Mysqlx.Connection.Compression.prototype.getClientMessages = function() {
  return /** @type {!proto.Mysqlx.ClientMessages.Type} */ (jspb.Message.getFieldWithDefault(this, 3, 1));
};


/**
 * @param {!proto.Mysqlx.ClientMessages.Type} value
 * @return {!proto.Mysqlx.Connection.Compression} returns this
 */
proto.Mysqlx.Connection.Compression.prototype.setClientMessages = function(value) {
  return jspb.Message.setField(this, 3, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Connection.Compression} returns this
 */
proto.Mysqlx.Connection.Compression.prototype.clearClientMessages = function() {
  return jspb.Message.setField(this, 3, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Connection.Compression.prototype.hasClientMessages = function() {
  return jspb.Message.getField(this, 3) != null;
};


/**
 * required bytes payload = 4;
 * @return {string}
 */
proto.Mysqlx.Connection.Compression.prototype.getPayload = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 4, ""));
};


/**
 * required bytes payload = 4;
 * This is a type-conversion wrapper around `getPayload()`
 * @return {string}
 */
proto.Mysqlx.Connection.Compression.prototype.getPayload_asB64 = function() {
  return /** @type {string} */ (jspb.Message.bytesAsB64(
      this.getPayload()));
};


/**
 * required bytes payload = 4;
 * Note that Uint8Array is not supported on all browsers.
 * @see http://caniuse.com/Uint8Array
 * This is a type-conversion wrapper around `getPayload()`
 * @return {!Uint8Array}
 */
proto.Mysqlx.Connection.Compression.prototype.getPayload_asU8 = function() {
  return /** @type {!Uint8Array} */ (jspb.Message.bytesAsU8(
      this.getPayload()));
};


/**
 * @param {!(string|Uint8Array)} value
 * @return {!proto.Mysqlx.Connection.Compression} returns this
 */
proto.Mysqlx.Connection.Compression.prototype.setPayload = function(value) {
  return jspb.Message.setField(this, 4, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Connection.Compression} returns this
 */
proto.Mysqlx.Connection.Compression.prototype.clearPayload = function() {
  return jspb.Message.setField(this, 4, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Connection.Compression.prototype.hasPayload = function() {
  return jspb.Message.getField(this, 4) != null;
};


goog.object.extend(exports, proto.Mysqlx.Connection);
